/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the <code>Opportunity</code> lifecycle's details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycle implements SdkPojo, Serializable, ToCopyableBuilder<LifeCycle.Builder, LifeCycle> {
    private static final SdkField<String> CLOSED_LOST_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClosedLostReason").getter(getter(LifeCycle::closedLostReasonAsString))
            .setter(setter(Builder::closedLostReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClosedLostReason").build()).build();

    private static final SdkField<String> NEXT_STEPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextSteps").getter(getter(LifeCycle::nextSteps)).setter(setter(Builder::nextSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSteps").build()).build();

    private static final SdkField<List<NextStepsHistory>> NEXT_STEPS_HISTORY_FIELD = SdkField
            .<List<NextStepsHistory>> builder(MarshallingType.LIST)
            .memberName("NextStepsHistory")
            .getter(getter(LifeCycle::nextStepsHistory))
            .setter(setter(Builder::nextStepsHistory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextStepsHistory").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NextStepsHistory> builder(MarshallingType.SDK_POJO)
                                            .constructor(NextStepsHistory::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REVIEW_COMMENTS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewComments").getter(getter(LifeCycle::reviewComments)).setter(setter(Builder::reviewComments))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewComments").build()).build();

    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewStatus").getter(getter(LifeCycle::reviewStatusAsString)).setter(setter(Builder::reviewStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()).build();

    private static final SdkField<String> REVIEW_STATUS_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewStatusReason").getter(getter(LifeCycle::reviewStatusReason))
            .setter(setter(Builder::reviewStatusReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatusReason").build())
            .build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(LifeCycle::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final SdkField<String> TARGET_CLOSE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCloseDate").getter(getter(LifeCycle::targetCloseDate)).setter(setter(Builder::targetCloseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCloseDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOSED_LOST_REASON_FIELD,
            NEXT_STEPS_FIELD, NEXT_STEPS_HISTORY_FIELD, REVIEW_COMMENTS_FIELD, REVIEW_STATUS_FIELD, REVIEW_STATUS_REASON_FIELD,
            STAGE_FIELD, TARGET_CLOSE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String closedLostReason;

    private final String nextSteps;

    private final List<NextStepsHistory> nextStepsHistory;

    private final String reviewComments;

    private final String reviewStatus;

    private final String reviewStatusReason;

    private final String stage;

    private final String targetCloseDate;

    private LifeCycle(BuilderImpl builder) {
        this.closedLostReason = builder.closedLostReason;
        this.nextSteps = builder.nextSteps;
        this.nextStepsHistory = builder.nextStepsHistory;
        this.reviewComments = builder.reviewComments;
        this.reviewStatus = builder.reviewStatus;
        this.reviewStatusReason = builder.reviewStatusReason;
        this.stage = builder.stage;
        this.targetCloseDate = builder.targetCloseDate;
    }

    /**
     * <p>
     * Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an appropriate
     * reason code, you communicate the context for closing the <code>Opportunity</code>, and aid in accurate reports
     * and analysis of opportunity outcomes. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Customer Deficiency: The customer lacked necessary resources or capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delay/Cancellation of Project: The project was delayed or canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—Google: The opportunity was lost to Google.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—VMWare: The opportunity was lost to VMWare.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
     * </p>
     * </li>
     * <li>
     * <p>
     * No Opportunity: There was no opportunity to pursue.
     * </p>
     * </li>
     * <li>
     * <p>
     * On Premises Deployment: The customer chose an on-premises solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Partner Gap: The partner lacked necessary resources or capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * Price: The price was not competitive or acceptable to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * Security/Compliance: Security or compliance issues prevented progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Technical Limitations: Technical limitations prevented progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer Experience: Issues related to the customer's experience impacted the decision.
     * </p>
     * </li>
     * <li>
     * <p>
     * Other: Any reason not covered by the other values.
     * </p>
     * </li>
     * <li>
     * <p>
     * People/Relationship/Governance: Issues related to people, relationships, or governance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Product/Technology: Issues related to the product or technology.
     * </p>
     * </li>
     * <li>
     * <p>
     * Financial/Commercial: Financial or commercial issues impacted the decision.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #closedLostReason}
     * will return {@link ClosedLostReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #closedLostReasonAsString}.
     * </p>
     * 
     * @return Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an
     *         appropriate reason code, you communicate the context for closing the <code>Opportunity</code>, and aid in
     *         accurate reports and analysis of opportunity outcomes. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Customer Deficiency: The customer lacked necessary resources or capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delay/Cancellation of Project: The project was delayed or canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—Google: The opportunity was lost to Google.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—VMWare: The opportunity was lost to VMWare.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No Opportunity: There was no opportunity to pursue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         On Premises Deployment: The customer chose an on-premises solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Partner Gap: The partner lacked necessary resources or capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Price: The price was not competitive or acceptable to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Security/Compliance: Security or compliance issues prevented progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Technical Limitations: Technical limitations prevented progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer Experience: Issues related to the customer's experience impacted the decision.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Other: Any reason not covered by the other values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         People/Relationship/Governance: Issues related to people, relationships, or governance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Product/Technology: Issues related to the product or technology.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Financial/Commercial: Financial or commercial issues impacted the decision.
     *         </p>
     *         </li>
     * @see ClosedLostReason
     */
    public final ClosedLostReason closedLostReason() {
        return ClosedLostReason.fromValue(closedLostReason);
    }

    /**
     * <p>
     * Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an appropriate
     * reason code, you communicate the context for closing the <code>Opportunity</code>, and aid in accurate reports
     * and analysis of opportunity outcomes. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Customer Deficiency: The customer lacked necessary resources or capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * Delay/Cancellation of Project: The project was delayed or canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—Google: The opportunity was lost to Google.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—VMWare: The opportunity was lost to VMWare.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
     * </p>
     * </li>
     * <li>
     * <p>
     * No Opportunity: There was no opportunity to pursue.
     * </p>
     * </li>
     * <li>
     * <p>
     * On Premises Deployment: The customer chose an on-premises solution.
     * </p>
     * </li>
     * <li>
     * <p>
     * Partner Gap: The partner lacked necessary resources or capabilities.
     * </p>
     * </li>
     * <li>
     * <p>
     * Price: The price was not competitive or acceptable to the customer.
     * </p>
     * </li>
     * <li>
     * <p>
     * Security/Compliance: Security or compliance issues prevented progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Technical Limitations: Technical limitations prevented progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer Experience: Issues related to the customer's experience impacted the decision.
     * </p>
     * </li>
     * <li>
     * <p>
     * Other: Any reason not covered by the other values.
     * </p>
     * </li>
     * <li>
     * <p>
     * People/Relationship/Governance: Issues related to people, relationships, or governance.
     * </p>
     * </li>
     * <li>
     * <p>
     * Product/Technology: Issues related to the product or technology.
     * </p>
     * </li>
     * <li>
     * <p>
     * Financial/Commercial: Financial or commercial issues impacted the decision.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #closedLostReason}
     * will return {@link ClosedLostReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #closedLostReasonAsString}.
     * </p>
     * 
     * @return Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an
     *         appropriate reason code, you communicate the context for closing the <code>Opportunity</code>, and aid in
     *         accurate reports and analysis of opportunity outcomes. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Customer Deficiency: The customer lacked necessary resources or capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Delay/Cancellation of Project: The project was delayed or canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—Google: The opportunity was lost to Google.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—VMWare: The opportunity was lost to VMWare.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         No Opportunity: There was no opportunity to pursue.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         On Premises Deployment: The customer chose an on-premises solution.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Partner Gap: The partner lacked necessary resources or capabilities.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Price: The price was not competitive or acceptable to the customer.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Security/Compliance: Security or compliance issues prevented progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Technical Limitations: Technical limitations prevented progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer Experience: Issues related to the customer's experience impacted the decision.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Other: Any reason not covered by the other values.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         People/Relationship/Governance: Issues related to people, relationships, or governance.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Product/Technology: Issues related to the product or technology.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Financial/Commercial: Financial or commercial issues impacted the decision.
     *         </p>
     *         </li>
     * @see ClosedLostReason
     */
    public final String closedLostReasonAsString() {
        return closedLostReason;
    }

    /**
     * <p>
     * Specifies the upcoming actions or tasks for the <code>Opportunity</code>. Use this field to communicate with
     * Amazon Web Services about the next actions required for the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the upcoming actions or tasks for the <code>Opportunity</code>. Use this field to communicate
     *         with Amazon Web Services about the next actions required for the <code>Opportunity</code>.
     */
    public final String nextSteps() {
        return nextSteps;
    }

    /**
     * For responses, this returns true if the service returned a value for the NextStepsHistory property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNextStepsHistory() {
        return nextStepsHistory != null && !(nextStepsHistory instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Captures a chronological record of the next steps or actions planned or taken for the current opportunity, along
     * with the timestamp.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNextStepsHistory} method.
     * </p>
     * 
     * @return Captures a chronological record of the next steps or actions planned or taken for the current
     *         opportunity, along with the timestamp.
     */
    public final List<NextStepsHistory> nextStepsHistory() {
        return nextStepsHistory;
    }

    /**
     * <p>
     * Indicates why an opportunity was sent back for further details. Partners must take corrective action based on the
     * <code>ReviewComments</code>.
     * </p>
     * 
     * @return Indicates why an opportunity was sent back for further details. Partners must take corrective action
     *         based on the <code>ReviewComments</code>.
     */
    public final String reviewComments() {
        return reviewComments;
    }

    /**
     * <p>
     * Indicates the review status of an opportunity referred by a partner. This field is read-only and only applicable
     * for partner referrals. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending Submission: Not submitted for validation (editable).
     * </p>
     * </li>
     * <li>
     * <p>
     * Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
     * </p>
     * </li>
     * <li>
     * <p>
     * In Review: Amazon Web Services is validating (read-only).
     * </p>
     * </li>
     * <li>
     * <p>
     * Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use the
     * <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all required changes
     * are made. Only the following fields are editable when the <code>Lifecycle.ReviewStatus</code> is
     * <code>Action Required</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Customer.Account.Address.City
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.CountryCode
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.PostalCode
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.StateOrRegion
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.StreetAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.WebsiteUrl
     * </p>
     * </li>
     * <li>
     * <p>
     * LifeCycle.TargetCloseDate
     * </p>
     * </li>
     * <li>
     * <p>
     * Project.ExpectedMonthlyAWSRevenue.Amount
     * </p>
     * </li>
     * <li>
     * <p>
     * Project.ExpectedMonthlyAWSRevenue.CurrencyCode
     * </p>
     * </li>
     * <li>
     * <p>
     * Project.CustomerBusinessProblem
     * </p>
     * </li>
     * <li>
     * <p>
     * PartnerOpportunityIdentifier
     * </p>
     * </li>
     * </ul>
     * <p>
     * After updates, the opportunity re-enters the validation phase. This process repeats until all issues are
     * resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to <code>Approved</code> or
     * <code>Rejected</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
     * </p>
     * </li>
     * <li>
     * <p>
     * Rejected: Disqualified (read-only).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reviewStatus} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reviewStatusAsString}.
     * </p>
     * 
     * @return Indicates the review status of an opportunity referred by a partner. This field is read-only and only
     *         applicable for partner referrals. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending Submission: Not submitted for validation (editable).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Review: Amazon Web Services is validating (read-only).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use the
     *         <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all required
     *         changes are made. Only the following fields are editable when the <code>Lifecycle.ReviewStatus</code> is
     *         <code>Action Required</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Customer.Account.Address.City
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.CountryCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.PostalCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.StateOrRegion
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.StreetAddress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.WebsiteUrl
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LifeCycle.TargetCloseDate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Project.ExpectedMonthlyAWSRevenue.Amount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Project.ExpectedMonthlyAWSRevenue.CurrencyCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Project.CustomerBusinessProblem
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PartnerOpportunityIdentifier
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After updates, the opportunity re-enters the validation phase. This process repeats until all issues are
     *         resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to <code>Approved</code> or
     *         <code>Rejected</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rejected: Disqualified (read-only).
     *         </p>
     *         </li>
     * @see ReviewStatus
     */
    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(reviewStatus);
    }

    /**
     * <p>
     * Indicates the review status of an opportunity referred by a partner. This field is read-only and only applicable
     * for partner referrals. The possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Pending Submission: Not submitted for validation (editable).
     * </p>
     * </li>
     * <li>
     * <p>
     * Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
     * </p>
     * </li>
     * <li>
     * <p>
     * In Review: Amazon Web Services is validating (read-only).
     * </p>
     * </li>
     * <li>
     * <p>
     * Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use the
     * <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all required changes
     * are made. Only the following fields are editable when the <code>Lifecycle.ReviewStatus</code> is
     * <code>Action Required</code>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Customer.Account.Address.City
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.CountryCode
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.PostalCode
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.StateOrRegion
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.Address.StreetAddress
     * </p>
     * </li>
     * <li>
     * <p>
     * Customer.Account.WebsiteUrl
     * </p>
     * </li>
     * <li>
     * <p>
     * LifeCycle.TargetCloseDate
     * </p>
     * </li>
     * <li>
     * <p>
     * Project.ExpectedMonthlyAWSRevenue.Amount
     * </p>
     * </li>
     * <li>
     * <p>
     * Project.ExpectedMonthlyAWSRevenue.CurrencyCode
     * </p>
     * </li>
     * <li>
     * <p>
     * Project.CustomerBusinessProblem
     * </p>
     * </li>
     * <li>
     * <p>
     * PartnerOpportunityIdentifier
     * </p>
     * </li>
     * </ul>
     * <p>
     * After updates, the opportunity re-enters the validation phase. This process repeats until all issues are
     * resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to <code>Approved</code> or
     * <code>Rejected</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
     * </p>
     * </li>
     * <li>
     * <p>
     * Rejected: Disqualified (read-only).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reviewStatus} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reviewStatusAsString}.
     * </p>
     * 
     * @return Indicates the review status of an opportunity referred by a partner. This field is read-only and only
     *         applicable for partner referrals. The possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         Pending Submission: Not submitted for validation (editable).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         In Review: Amazon Web Services is validating (read-only).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use the
     *         <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all required
     *         changes are made. Only the following fields are editable when the <code>Lifecycle.ReviewStatus</code> is
     *         <code>Action Required</code>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Customer.Account.Address.City
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.CountryCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.PostalCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.StateOrRegion
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.Address.StreetAddress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Customer.Account.WebsiteUrl
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         LifeCycle.TargetCloseDate
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Project.ExpectedMonthlyAWSRevenue.Amount
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Project.ExpectedMonthlyAWSRevenue.CurrencyCode
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Project.CustomerBusinessProblem
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         PartnerOpportunityIdentifier
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         After updates, the opportunity re-enters the validation phase. This process repeats until all issues are
     *         resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to <code>Approved</code> or
     *         <code>Rejected</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Rejected: Disqualified (read-only).
     *         </p>
     *         </li>
     * @see ReviewStatus
     */
    public final String reviewStatusAsString() {
        return reviewStatus;
    }

    /**
     * <p>
     * Indicates the reason a decision was made during the opportunity review process. This field combines the reasons
     * for both disqualified and action required statuses, and provide clarity for why an opportunity was disqualified
     * or requires further action.
     * </p>
     * 
     * @return Indicates the reason a decision was made during the opportunity review process. This field combines the
     *         reasons for both disqualified and action required statuses, and provide clarity for why an opportunity
     *         was disqualified or requires further action.
     */
    public final String reviewStatusReason() {
        return reviewStatusReason;
    }

    /**
     * <p>
     * Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web Services stages
     * from the current stage in the partner CRM. This field provides a translated value of the stage, and offers
     * insight into the <code>Opportunity</code>'s progression in the sales cycle, according to Amazon Web Services
     * definitions.
     * </p>
     * <note>
     * <p>
     * A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before submission.
     * Opportunities that were closed/lost before submission aren't suitable for submission.
     * </p>
     * </note>
     * <p>
     * The descriptions of each sales stage are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the end customer
     * through a lead) or latent (Your account team believes it exists based on research, account plans, sales plays).
     * </p>
     * </li>
     * <li>
     * <p>
     * Qualified: Your account team engaged with the customer to discuss viability and requirements. The customer agreed
     * that the opportunity is real, of interest, and may solve business/technical needs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Technical Validation: All parties understand the implementation plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * Business Validation: Pricing was proposed, and all parties agree to the steps to close.
     * </p>
     * </li>
     * <li>
     * <p>
     * Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launched: The workload is complete, and Amazon Web Services has started billing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Closed Lost: The opportunity is lost, and there are no steps to move forward.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web Services
     *         stages from the current stage in the partner CRM. This field provides a translated value of the stage,
     *         and offers insight into the <code>Opportunity</code>'s progression in the sales cycle, according to
     *         Amazon Web Services definitions.</p> <note>
     *         <p>
     *         A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before submission.
     *         Opportunities that were closed/lost before submission aren't suitable for submission.
     *         </p>
     *         </note>
     *         <p>
     *         The descriptions of each sales stage are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the end
     *         customer through a lead) or latent (Your account team believes it exists based on research, account
     *         plans, sales plays).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Qualified: Your account team engaged with the customer to discuss viability and requirements. The
     *         customer agreed that the opportunity is real, of interest, and may solve business/technical needs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Technical Validation: All parties understand the implementation plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Business Validation: Pricing was proposed, and all parties agree to the steps to close.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Launched: The workload is complete, and Amazon Web Services has started billing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Closed Lost: The opportunity is lost, and there are no steps to move forward.
     *         </p>
     *         </li>
     * @see Stage
     */
    public final Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web Services stages
     * from the current stage in the partner CRM. This field provides a translated value of the stage, and offers
     * insight into the <code>Opportunity</code>'s progression in the sales cycle, according to Amazon Web Services
     * definitions.
     * </p>
     * <note>
     * <p>
     * A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before submission.
     * Opportunities that were closed/lost before submission aren't suitable for submission.
     * </p>
     * </note>
     * <p>
     * The descriptions of each sales stage are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the end customer
     * through a lead) or latent (Your account team believes it exists based on research, account plans, sales plays).
     * </p>
     * </li>
     * <li>
     * <p>
     * Qualified: Your account team engaged with the customer to discuss viability and requirements. The customer agreed
     * that the opportunity is real, of interest, and may solve business/technical needs.
     * </p>
     * </li>
     * <li>
     * <p>
     * Technical Validation: All parties understand the implementation plan.
     * </p>
     * </li>
     * <li>
     * <p>
     * Business Validation: Pricing was proposed, and all parties agree to the steps to close.
     * </p>
     * </li>
     * <li>
     * <p>
     * Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Launched: The workload is complete, and Amazon Web Services has started billing.
     * </p>
     * </li>
     * <li>
     * <p>
     * Closed Lost: The opportunity is lost, and there are no steps to move forward.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web Services
     *         stages from the current stage in the partner CRM. This field provides a translated value of the stage,
     *         and offers insight into the <code>Opportunity</code>'s progression in the sales cycle, according to
     *         Amazon Web Services definitions.</p> <note>
     *         <p>
     *         A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before submission.
     *         Opportunities that were closed/lost before submission aren't suitable for submission.
     *         </p>
     *         </note>
     *         <p>
     *         The descriptions of each sales stage are:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the end
     *         customer through a lead) or latent (Your account team believes it exists based on research, account
     *         plans, sales plays).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Qualified: Your account team engaged with the customer to discuss viability and requirements. The
     *         customer agreed that the opportunity is real, of interest, and may solve business/technical needs.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Technical Validation: All parties understand the implementation plan.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Business Validation: Pricing was proposed, and all parties agree to the steps to close.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Launched: The workload is complete, and Amazon Web Services has started billing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Closed Lost: The opportunity is lost, and there are no steps to move forward.
     *         </p>
     *         </li>
     * @see Stage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * Specifies the date when Amazon Web Services expects to start significant billing, when the project finishes, and
     * when it moves into production. This field informs the Amazon Web Services seller about when the opportunity
     * launches and starts to incur Amazon Web Services usage.
     * </p>
     * <p>
     * Ensure the <code>Target Close Date</code> isn't in the past.
     * </p>
     * 
     * @return Specifies the date when Amazon Web Services expects to start significant billing, when the project
     *         finishes, and when it moves into production. This field informs the Amazon Web Services seller about when
     *         the opportunity launches and starts to incur Amazon Web Services usage.</p>
     *         <p>
     *         Ensure the <code>Target Close Date</code> isn't in the past.
     */
    public final String targetCloseDate() {
        return targetCloseDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(closedLostReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nextSteps());
        hashCode = 31 * hashCode + Objects.hashCode(hasNextStepsHistory() ? nextStepsHistory() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reviewComments());
        hashCode = 31 * hashCode + Objects.hashCode(reviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(reviewStatusReason());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetCloseDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycle)) {
            return false;
        }
        LifeCycle other = (LifeCycle) obj;
        return Objects.equals(closedLostReasonAsString(), other.closedLostReasonAsString())
                && Objects.equals(nextSteps(), other.nextSteps()) && hasNextStepsHistory() == other.hasNextStepsHistory()
                && Objects.equals(nextStepsHistory(), other.nextStepsHistory())
                && Objects.equals(reviewComments(), other.reviewComments())
                && Objects.equals(reviewStatusAsString(), other.reviewStatusAsString())
                && Objects.equals(reviewStatusReason(), other.reviewStatusReason())
                && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(targetCloseDate(), other.targetCloseDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycle").add("ClosedLostReason", closedLostReasonAsString())
                .add("NextSteps", nextSteps() == null ? null : "*** Sensitive Data Redacted ***")
                .add("NextStepsHistory", hasNextStepsHistory() ? nextStepsHistory() : null)
                .add("ReviewComments", reviewComments()).add("ReviewStatus", reviewStatusAsString())
                .add("ReviewStatusReason", reviewStatusReason()).add("Stage", stageAsString())
                .add("TargetCloseDate", targetCloseDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ClosedLostReason":
            return Optional.ofNullable(clazz.cast(closedLostReasonAsString()));
        case "NextSteps":
            return Optional.ofNullable(clazz.cast(nextSteps()));
        case "NextStepsHistory":
            return Optional.ofNullable(clazz.cast(nextStepsHistory()));
        case "ReviewComments":
            return Optional.ofNullable(clazz.cast(reviewComments()));
        case "ReviewStatus":
            return Optional.ofNullable(clazz.cast(reviewStatusAsString()));
        case "ReviewStatusReason":
            return Optional.ofNullable(clazz.cast(reviewStatusReason()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "TargetCloseDate":
            return Optional.ofNullable(clazz.cast(targetCloseDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ClosedLostReason", CLOSED_LOST_REASON_FIELD);
        map.put("NextSteps", NEXT_STEPS_FIELD);
        map.put("NextStepsHistory", NEXT_STEPS_HISTORY_FIELD);
        map.put("ReviewComments", REVIEW_COMMENTS_FIELD);
        map.put("ReviewStatus", REVIEW_STATUS_FIELD);
        map.put("ReviewStatusReason", REVIEW_STATUS_REASON_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("TargetCloseDate", TARGET_CLOSE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifeCycle, T> g) {
        return obj -> g.apply((LifeCycle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycle> {
        /**
         * <p>
         * Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an appropriate
         * reason code, you communicate the context for closing the <code>Opportunity</code>, and aid in accurate
         * reports and analysis of opportunity outcomes. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Customer Deficiency: The customer lacked necessary resources or capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delay/Cancellation of Project: The project was delayed or canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—Google: The opportunity was lost to Google.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—VMWare: The opportunity was lost to VMWare.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
         * </p>
         * </li>
         * <li>
         * <p>
         * No Opportunity: There was no opportunity to pursue.
         * </p>
         * </li>
         * <li>
         * <p>
         * On Premises Deployment: The customer chose an on-premises solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Partner Gap: The partner lacked necessary resources or capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * Price: The price was not competitive or acceptable to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * Security/Compliance: Security or compliance issues prevented progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Technical Limitations: Technical limitations prevented progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer Experience: Issues related to the customer's experience impacted the decision.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Any reason not covered by the other values.
         * </p>
         * </li>
         * <li>
         * <p>
         * People/Relationship/Governance: Issues related to people, relationships, or governance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Product/Technology: Issues related to the product or technology.
         * </p>
         * </li>
         * <li>
         * <p>
         * Financial/Commercial: Financial or commercial issues impacted the decision.
         * </p>
         * </li>
         * </ul>
         * 
         * @param closedLostReason
         *        Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an
         *        appropriate reason code, you communicate the context for closing the <code>Opportunity</code>, and aid
         *        in accurate reports and analysis of opportunity outcomes. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Customer Deficiency: The customer lacked necessary resources or capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delay/Cancellation of Project: The project was delayed or canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—Google: The opportunity was lost to Google.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—VMWare: The opportunity was lost to VMWare.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No Opportunity: There was no opportunity to pursue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        On Premises Deployment: The customer chose an on-premises solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Partner Gap: The partner lacked necessary resources or capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Price: The price was not competitive or acceptable to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Security/Compliance: Security or compliance issues prevented progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Technical Limitations: Technical limitations prevented progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer Experience: Issues related to the customer's experience impacted the decision.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Any reason not covered by the other values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        People/Relationship/Governance: Issues related to people, relationships, or governance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Product/Technology: Issues related to the product or technology.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Financial/Commercial: Financial or commercial issues impacted the decision.
         *        </p>
         *        </li>
         * @see ClosedLostReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClosedLostReason
         */
        Builder closedLostReason(String closedLostReason);

        /**
         * <p>
         * Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an appropriate
         * reason code, you communicate the context for closing the <code>Opportunity</code>, and aid in accurate
         * reports and analysis of opportunity outcomes. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Customer Deficiency: The customer lacked necessary resources or capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * Delay/Cancellation of Project: The project was delayed or canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—Google: The opportunity was lost to Google.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—VMWare: The opportunity was lost to VMWare.
         * </p>
         * </li>
         * <li>
         * <p>
         * Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
         * </p>
         * </li>
         * <li>
         * <p>
         * No Opportunity: There was no opportunity to pursue.
         * </p>
         * </li>
         * <li>
         * <p>
         * On Premises Deployment: The customer chose an on-premises solution.
         * </p>
         * </li>
         * <li>
         * <p>
         * Partner Gap: The partner lacked necessary resources or capabilities.
         * </p>
         * </li>
         * <li>
         * <p>
         * Price: The price was not competitive or acceptable to the customer.
         * </p>
         * </li>
         * <li>
         * <p>
         * Security/Compliance: Security or compliance issues prevented progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Technical Limitations: Technical limitations prevented progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer Experience: Issues related to the customer's experience impacted the decision.
         * </p>
         * </li>
         * <li>
         * <p>
         * Other: Any reason not covered by the other values.
         * </p>
         * </li>
         * <li>
         * <p>
         * People/Relationship/Governance: Issues related to people, relationships, or governance.
         * </p>
         * </li>
         * <li>
         * <p>
         * Product/Technology: Issues related to the product or technology.
         * </p>
         * </li>
         * <li>
         * <p>
         * Financial/Commercial: Financial or commercial issues impacted the decision.
         * </p>
         * </li>
         * </ul>
         * 
         * @param closedLostReason
         *        Specifies the reason code when an opportunity is marked as <i>Closed Lost</i>. When you select an
         *        appropriate reason code, you communicate the context for closing the <code>Opportunity</code>, and aid
         *        in accurate reports and analysis of opportunity outcomes. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Customer Deficiency: The customer lacked necessary resources or capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Delay/Cancellation of Project: The project was delayed or canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Legal/Tax/Regulatory: Legal, tax, or regulatory issues prevented progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—Google: The opportunity was lost to Google.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—Microsoft: The opportunity was lost to Microsoft.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—SoftLayer: The opportunity was lost to SoftLayer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—VMWare: The opportunity was lost to VMWare.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Lost to Competitor—Other: The opportunity was lost to a competitor not listed above.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        No Opportunity: There was no opportunity to pursue.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        On Premises Deployment: The customer chose an on-premises solution.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Partner Gap: The partner lacked necessary resources or capabilities.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Price: The price was not competitive or acceptable to the customer.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Security/Compliance: Security or compliance issues prevented progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Technical Limitations: Technical limitations prevented progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer Experience: Issues related to the customer's experience impacted the decision.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Other: Any reason not covered by the other values.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        People/Relationship/Governance: Issues related to people, relationships, or governance.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Product/Technology: Issues related to the product or technology.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Financial/Commercial: Financial or commercial issues impacted the decision.
         *        </p>
         *        </li>
         * @see ClosedLostReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ClosedLostReason
         */
        Builder closedLostReason(ClosedLostReason closedLostReason);

        /**
         * <p>
         * Specifies the upcoming actions or tasks for the <code>Opportunity</code>. Use this field to communicate with
         * Amazon Web Services about the next actions required for the <code>Opportunity</code>.
         * </p>
         * 
         * @param nextSteps
         *        Specifies the upcoming actions or tasks for the <code>Opportunity</code>. Use this field to
         *        communicate with Amazon Web Services about the next actions required for the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSteps(String nextSteps);

        /**
         * <p>
         * Captures a chronological record of the next steps or actions planned or taken for the current opportunity,
         * along with the timestamp.
         * </p>
         * 
         * @param nextStepsHistory
         *        Captures a chronological record of the next steps or actions planned or taken for the current
         *        opportunity, along with the timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStepsHistory(Collection<NextStepsHistory> nextStepsHistory);

        /**
         * <p>
         * Captures a chronological record of the next steps or actions planned or taken for the current opportunity,
         * along with the timestamp.
         * </p>
         * 
         * @param nextStepsHistory
         *        Captures a chronological record of the next steps or actions planned or taken for the current
         *        opportunity, along with the timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextStepsHistory(NextStepsHistory... nextStepsHistory);

        /**
         * <p>
         * Captures a chronological record of the next steps or actions planned or taken for the current opportunity,
         * along with the timestamp.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.NextStepsHistory.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.NextStepsHistory#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.NextStepsHistory.Builder#build()} is
         * called immediately and its result is passed to {@link #nextStepsHistory(List<NextStepsHistory>)}.
         * 
         * @param nextStepsHistory
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.NextStepsHistory.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #nextStepsHistory(java.util.Collection<NextStepsHistory>)
         */
        Builder nextStepsHistory(Consumer<NextStepsHistory.Builder>... nextStepsHistory);

        /**
         * <p>
         * Indicates why an opportunity was sent back for further details. Partners must take corrective action based on
         * the <code>ReviewComments</code>.
         * </p>
         * 
         * @param reviewComments
         *        Indicates why an opportunity was sent back for further details. Partners must take corrective action
         *        based on the <code>ReviewComments</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewComments(String reviewComments);

        /**
         * <p>
         * Indicates the review status of an opportunity referred by a partner. This field is read-only and only
         * applicable for partner referrals. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Submission: Not submitted for validation (editable).
         * </p>
         * </li>
         * <li>
         * <p>
         * Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
         * </p>
         * </li>
         * <li>
         * <p>
         * In Review: Amazon Web Services is validating (read-only).
         * </p>
         * </li>
         * <li>
         * <p>
         * Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use the
         * <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all required
         * changes are made. Only the following fields are editable when the <code>Lifecycle.ReviewStatus</code> is
         * <code>Action Required</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Customer.Account.Address.City
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.CountryCode
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.PostalCode
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.StateOrRegion
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.StreetAddress
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.WebsiteUrl
         * </p>
         * </li>
         * <li>
         * <p>
         * LifeCycle.TargetCloseDate
         * </p>
         * </li>
         * <li>
         * <p>
         * Project.ExpectedMonthlyAWSRevenue.Amount
         * </p>
         * </li>
         * <li>
         * <p>
         * Project.ExpectedMonthlyAWSRevenue.CurrencyCode
         * </p>
         * </li>
         * <li>
         * <p>
         * Project.CustomerBusinessProblem
         * </p>
         * </li>
         * <li>
         * <p>
         * PartnerOpportunityIdentifier
         * </p>
         * </li>
         * </ul>
         * <p>
         * After updates, the opportunity re-enters the validation phase. This process repeats until all issues are
         * resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to <code>Approved</code> or
         * <code>Rejected</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
         * </p>
         * </li>
         * <li>
         * <p>
         * Rejected: Disqualified (read-only).
         * </p>
         * </li>
         * </ul>
         * 
         * @param reviewStatus
         *        Indicates the review status of an opportunity referred by a partner. This field is read-only and only
         *        applicable for partner referrals. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Submission: Not submitted for validation (editable).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Review: Amazon Web Services is validating (read-only).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use
         *        the <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all
         *        required changes are made. Only the following fields are editable when the
         *        <code>Lifecycle.ReviewStatus</code> is <code>Action Required</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Customer.Account.Address.City
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.CountryCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.PostalCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.StateOrRegion
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.StreetAddress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.WebsiteUrl
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LifeCycle.TargetCloseDate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Project.ExpectedMonthlyAWSRevenue.Amount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Project.ExpectedMonthlyAWSRevenue.CurrencyCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Project.CustomerBusinessProblem
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PartnerOpportunityIdentifier
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After updates, the opportunity re-enters the validation phase. This process repeats until all issues
         *        are resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to
         *        <code>Approved</code> or <code>Rejected</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rejected: Disqualified (read-only).
         *        </p>
         *        </li>
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder reviewStatus(String reviewStatus);

        /**
         * <p>
         * Indicates the review status of an opportunity referred by a partner. This field is read-only and only
         * applicable for partner referrals. The possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Pending Submission: Not submitted for validation (editable).
         * </p>
         * </li>
         * <li>
         * <p>
         * Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
         * </p>
         * </li>
         * <li>
         * <p>
         * In Review: Amazon Web Services is validating (read-only).
         * </p>
         * </li>
         * <li>
         * <p>
         * Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use the
         * <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all required
         * changes are made. Only the following fields are editable when the <code>Lifecycle.ReviewStatus</code> is
         * <code>Action Required</code>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Customer.Account.Address.City
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.CountryCode
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.PostalCode
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.StateOrRegion
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.Address.StreetAddress
         * </p>
         * </li>
         * <li>
         * <p>
         * Customer.Account.WebsiteUrl
         * </p>
         * </li>
         * <li>
         * <p>
         * LifeCycle.TargetCloseDate
         * </p>
         * </li>
         * <li>
         * <p>
         * Project.ExpectedMonthlyAWSRevenue.Amount
         * </p>
         * </li>
         * <li>
         * <p>
         * Project.ExpectedMonthlyAWSRevenue.CurrencyCode
         * </p>
         * </li>
         * <li>
         * <p>
         * Project.CustomerBusinessProblem
         * </p>
         * </li>
         * <li>
         * <p>
         * PartnerOpportunityIdentifier
         * </p>
         * </li>
         * </ul>
         * <p>
         * After updates, the opportunity re-enters the validation phase. This process repeats until all issues are
         * resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to <code>Approved</code> or
         * <code>Rejected</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
         * </p>
         * </li>
         * <li>
         * <p>
         * Rejected: Disqualified (read-only).
         * </p>
         * </li>
         * </ul>
         * 
         * @param reviewStatus
         *        Indicates the review status of an opportunity referred by a partner. This field is read-only and only
         *        applicable for partner referrals. The possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        Pending Submission: Not submitted for validation (editable).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Submitted: Submitted for validation, and Amazon Web Services hasn't reviewed it (read-only).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        In Review: Amazon Web Services is validating (read-only).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Action Required: Issues that Amazon Web Services highlights need to be addressed. Partners should use
         *        the <code>UpdateOpportunity</code> API action to update the opportunity and helps to ensure that all
         *        required changes are made. Only the following fields are editable when the
         *        <code>Lifecycle.ReviewStatus</code> is <code>Action Required</code>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Customer.Account.Address.City
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.CountryCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.PostalCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.StateOrRegion
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.Address.StreetAddress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Customer.Account.WebsiteUrl
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        LifeCycle.TargetCloseDate
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Project.ExpectedMonthlyAWSRevenue.Amount
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Project.ExpectedMonthlyAWSRevenue.CurrencyCode
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Project.CustomerBusinessProblem
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        PartnerOpportunityIdentifier
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        After updates, the opportunity re-enters the validation phase. This process repeats until all issues
         *        are resolved, and the opportunity's <code>Lifecycle.ReviewStatus</code> is set to
         *        <code>Approved</code> or <code>Rejected</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Approved: Validated and converted into the Amazon Web Services seller's pipeline (editable).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Rejected: Disqualified (read-only).
         *        </p>
         *        </li>
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder reviewStatus(ReviewStatus reviewStatus);

        /**
         * <p>
         * Indicates the reason a decision was made during the opportunity review process. This field combines the
         * reasons for both disqualified and action required statuses, and provide clarity for why an opportunity was
         * disqualified or requires further action.
         * </p>
         * 
         * @param reviewStatusReason
         *        Indicates the reason a decision was made during the opportunity review process. This field combines
         *        the reasons for both disqualified and action required statuses, and provide clarity for why an
         *        opportunity was disqualified or requires further action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reviewStatusReason(String reviewStatusReason);

        /**
         * <p>
         * Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web Services
         * stages from the current stage in the partner CRM. This field provides a translated value of the stage, and
         * offers insight into the <code>Opportunity</code>'s progression in the sales cycle, according to Amazon Web
         * Services definitions.
         * </p>
         * <note>
         * <p>
         * A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before submission.
         * Opportunities that were closed/lost before submission aren't suitable for submission.
         * </p>
         * </note>
         * <p>
         * The descriptions of each sales stage are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the end
         * customer through a lead) or latent (Your account team believes it exists based on research, account plans,
         * sales plays).
         * </p>
         * </li>
         * <li>
         * <p>
         * Qualified: Your account team engaged with the customer to discuss viability and requirements. The customer
         * agreed that the opportunity is real, of interest, and may solve business/technical needs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Technical Validation: All parties understand the implementation plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * Business Validation: Pricing was proposed, and all parties agree to the steps to close.
         * </p>
         * </li>
         * <li>
         * <p>
         * Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Launched: The workload is complete, and Amazon Web Services has started billing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Closed Lost: The opportunity is lost, and there are no steps to move forward.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stage
         *        Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web
         *        Services stages from the current stage in the partner CRM. This field provides a translated value of
         *        the stage, and offers insight into the <code>Opportunity</code>'s progression in the sales cycle,
         *        according to Amazon Web Services definitions.</p> <note>
         *        <p>
         *        A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before
         *        submission. Opportunities that were closed/lost before submission aren't suitable for submission.
         *        </p>
         *        </note>
         *        <p>
         *        The descriptions of each sales stage are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the
         *        end customer through a lead) or latent (Your account team believes it exists based on research,
         *        account plans, sales plays).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Qualified: Your account team engaged with the customer to discuss viability and requirements. The
         *        customer agreed that the opportunity is real, of interest, and may solve business/technical needs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Technical Validation: All parties understand the implementation plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Business Validation: Pricing was proposed, and all parties agree to the steps to close.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Launched: The workload is complete, and Amazon Web Services has started billing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Closed Lost: The opportunity is lost, and there are no steps to move forward.
         *        </p>
         *        </li>
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web Services
         * stages from the current stage in the partner CRM. This field provides a translated value of the stage, and
         * offers insight into the <code>Opportunity</code>'s progression in the sales cycle, according to Amazon Web
         * Services definitions.
         * </p>
         * <note>
         * <p>
         * A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before submission.
         * Opportunities that were closed/lost before submission aren't suitable for submission.
         * </p>
         * </note>
         * <p>
         * The descriptions of each sales stage are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the end
         * customer through a lead) or latent (Your account team believes it exists based on research, account plans,
         * sales plays).
         * </p>
         * </li>
         * <li>
         * <p>
         * Qualified: Your account team engaged with the customer to discuss viability and requirements. The customer
         * agreed that the opportunity is real, of interest, and may solve business/technical needs.
         * </p>
         * </li>
         * <li>
         * <p>
         * Technical Validation: All parties understand the implementation plan.
         * </p>
         * </li>
         * <li>
         * <p>
         * Business Validation: Pricing was proposed, and all parties agree to the steps to close.
         * </p>
         * </li>
         * <li>
         * <p>
         * Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Launched: The workload is complete, and Amazon Web Services has started billing.
         * </p>
         * </li>
         * <li>
         * <p>
         * Closed Lost: The opportunity is lost, and there are no steps to move forward.
         * </p>
         * </li>
         * </ul>
         * 
         * @param stage
         *        Specifies the current stage of the <code>Opportunity</code>'s lifecycle as it maps to Amazon Web
         *        Services stages from the current stage in the partner CRM. This field provides a translated value of
         *        the stage, and offers insight into the <code>Opportunity</code>'s progression in the sales cycle,
         *        according to Amazon Web Services definitions.</p> <note>
         *        <p>
         *        A lead and a prospect must be further matured to a <code>Qualified</code> opportunity before
         *        submission. Opportunities that were closed/lost before submission aren't suitable for submission.
         *        </p>
         *        </note>
         *        <p>
         *        The descriptions of each sales stage are:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        Prospect: Amazon Web Services identifies the opportunity. It can be active (Comes directly from the
         *        end customer through a lead) or latent (Your account team believes it exists based on research,
         *        account plans, sales plays).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Qualified: Your account team engaged with the customer to discuss viability and requirements. The
         *        customer agreed that the opportunity is real, of interest, and may solve business/technical needs.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Technical Validation: All parties understand the implementation plan.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Business Validation: Pricing was proposed, and all parties agree to the steps to close.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Committed: The customer signed the contract, but Amazon Web Services hasn't started billing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Launched: The workload is complete, and Amazon Web Services has started billing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Closed Lost: The opportunity is lost, and there are no steps to move forward.
         *        </p>
         *        </li>
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * Specifies the date when Amazon Web Services expects to start significant billing, when the project finishes,
         * and when it moves into production. This field informs the Amazon Web Services seller about when the
         * opportunity launches and starts to incur Amazon Web Services usage.
         * </p>
         * <p>
         * Ensure the <code>Target Close Date</code> isn't in the past.
         * </p>
         * 
         * @param targetCloseDate
         *        Specifies the date when Amazon Web Services expects to start significant billing, when the project
         *        finishes, and when it moves into production. This field informs the Amazon Web Services seller about
         *        when the opportunity launches and starts to incur Amazon Web Services usage.</p>
         *        <p>
         *        Ensure the <code>Target Close Date</code> isn't in the past.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCloseDate(String targetCloseDate);
    }

    static final class BuilderImpl implements Builder {
        private String closedLostReason;

        private String nextSteps;

        private List<NextStepsHistory> nextStepsHistory = DefaultSdkAutoConstructList.getInstance();

        private String reviewComments;

        private String reviewStatus;

        private String reviewStatusReason;

        private String stage;

        private String targetCloseDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycle model) {
            closedLostReason(model.closedLostReason);
            nextSteps(model.nextSteps);
            nextStepsHistory(model.nextStepsHistory);
            reviewComments(model.reviewComments);
            reviewStatus(model.reviewStatus);
            reviewStatusReason(model.reviewStatusReason);
            stage(model.stage);
            targetCloseDate(model.targetCloseDate);
        }

        public final String getClosedLostReason() {
            return closedLostReason;
        }

        public final void setClosedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
        }

        @Override
        public final Builder closedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
            return this;
        }

        @Override
        public final Builder closedLostReason(ClosedLostReason closedLostReason) {
            this.closedLostReason(closedLostReason == null ? null : closedLostReason.toString());
            return this;
        }

        public final String getNextSteps() {
            return nextSteps;
        }

        public final void setNextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
        }

        @Override
        public final Builder nextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
            return this;
        }

        public final List<NextStepsHistory.Builder> getNextStepsHistory() {
            List<NextStepsHistory.Builder> result = LifeCycleNextStepsHistoryListCopier.copyToBuilder(this.nextStepsHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNextStepsHistory(Collection<NextStepsHistory.BuilderImpl> nextStepsHistory) {
            this.nextStepsHistory = LifeCycleNextStepsHistoryListCopier.copyFromBuilder(nextStepsHistory);
        }

        @Override
        public final Builder nextStepsHistory(Collection<NextStepsHistory> nextStepsHistory) {
            this.nextStepsHistory = LifeCycleNextStepsHistoryListCopier.copy(nextStepsHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(NextStepsHistory... nextStepsHistory) {
            nextStepsHistory(Arrays.asList(nextStepsHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(Consumer<NextStepsHistory.Builder>... nextStepsHistory) {
            nextStepsHistory(Stream.of(nextStepsHistory).map(c -> NextStepsHistory.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReviewComments() {
            return reviewComments;
        }

        public final void setReviewComments(String reviewComments) {
            this.reviewComments = reviewComments;
        }

        @Override
        public final Builder reviewComments(String reviewComments) {
            this.reviewComments = reviewComments;
            return this;
        }

        public final String getReviewStatus() {
            return reviewStatus;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final String getReviewStatusReason() {
            return reviewStatusReason;
        }

        public final void setReviewStatusReason(String reviewStatusReason) {
            this.reviewStatusReason = reviewStatusReason;
        }

        @Override
        public final Builder reviewStatusReason(String reviewStatusReason) {
            this.reviewStatusReason = reviewStatusReason;
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getTargetCloseDate() {
            return targetCloseDate;
        }

        public final void setTargetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
        }

        @Override
        public final Builder targetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
            return this;
        }

        @Override
        public LifeCycle build() {
            return new LifeCycle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
