/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides the lifecycle view of an opportunity resource shared through a snapshot.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifeCycleForView implements SdkPojo, Serializable,
        ToCopyableBuilder<LifeCycleForView.Builder, LifeCycleForView> {
    private static final SdkField<String> NEXT_STEPS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextSteps").getter(getter(LifeCycleForView::nextSteps)).setter(setter(Builder::nextSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSteps").build()).build();

    private static final SdkField<String> REVIEW_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ReviewStatus").getter(getter(LifeCycleForView::reviewStatusAsString))
            .setter(setter(Builder::reviewStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReviewStatus").build()).build();

    private static final SdkField<String> STAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Stage")
            .getter(getter(LifeCycleForView::stageAsString)).setter(setter(Builder::stage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()).build();

    private static final SdkField<String> TARGET_CLOSE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCloseDate").getter(getter(LifeCycleForView::targetCloseDate))
            .setter(setter(Builder::targetCloseDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCloseDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_STEPS_FIELD,
            REVIEW_STATUS_FIELD, STAGE_FIELD, TARGET_CLOSE_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nextSteps;

    private final String reviewStatus;

    private final String stage;

    private final String targetCloseDate;

    private LifeCycleForView(BuilderImpl builder) {
        this.nextSteps = builder.nextSteps;
        this.reviewStatus = builder.reviewStatus;
        this.stage = builder.stage;
        this.targetCloseDate = builder.targetCloseDate;
    }

    /**
     * <p>
     * Describes the next steps for the opportunity shared through a snapshot.
     * </p>
     * 
     * @return Describes the next steps for the opportunity shared through a snapshot.
     */
    public final String nextSteps() {
        return nextSteps;
    }

    /**
     * <p>
     * Defines the approval status of the opportunity shared through a snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reviewStatus} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reviewStatusAsString}.
     * </p>
     * 
     * @return Defines the approval status of the opportunity shared through a snapshot.
     * @see ReviewStatus
     */
    public final ReviewStatus reviewStatus() {
        return ReviewStatus.fromValue(reviewStatus);
    }

    /**
     * <p>
     * Defines the approval status of the opportunity shared through a snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reviewStatus} will
     * return {@link ReviewStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #reviewStatusAsString}.
     * </p>
     * 
     * @return Defines the approval status of the opportunity shared through a snapshot.
     * @see ReviewStatus
     */
    public final String reviewStatusAsString() {
        return reviewStatus;
    }

    /**
     * <p>
     * Defines the current stage of the opportunity shared through a snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Defines the current stage of the opportunity shared through a snapshot.
     * @see Stage
     */
    public final Stage stage() {
        return Stage.fromValue(stage);
    }

    /**
     * <p>
     * Defines the current stage of the opportunity shared through a snapshot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stage} will return
     * {@link Stage#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stageAsString}.
     * </p>
     * 
     * @return Defines the current stage of the opportunity shared through a snapshot.
     * @see Stage
     */
    public final String stageAsString() {
        return stage;
    }

    /**
     * <p>
     * The projected launch date of the opportunity shared through a snapshot.
     * </p>
     * 
     * @return The projected launch date of the opportunity shared through a snapshot.
     */
    public final String targetCloseDate() {
        return targetCloseDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nextSteps());
        hashCode = 31 * hashCode + Objects.hashCode(reviewStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetCloseDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifeCycleForView)) {
            return false;
        }
        LifeCycleForView other = (LifeCycleForView) obj;
        return Objects.equals(nextSteps(), other.nextSteps())
                && Objects.equals(reviewStatusAsString(), other.reviewStatusAsString())
                && Objects.equals(stageAsString(), other.stageAsString())
                && Objects.equals(targetCloseDate(), other.targetCloseDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifeCycleForView")
                .add("NextSteps", nextSteps() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ReviewStatus", reviewStatusAsString()).add("Stage", stageAsString())
                .add("TargetCloseDate", targetCloseDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextSteps":
            return Optional.ofNullable(clazz.cast(nextSteps()));
        case "ReviewStatus":
            return Optional.ofNullable(clazz.cast(reviewStatusAsString()));
        case "Stage":
            return Optional.ofNullable(clazz.cast(stageAsString()));
        case "TargetCloseDate":
            return Optional.ofNullable(clazz.cast(targetCloseDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextSteps", NEXT_STEPS_FIELD);
        map.put("ReviewStatus", REVIEW_STATUS_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("TargetCloseDate", TARGET_CLOSE_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifeCycleForView, T> g) {
        return obj -> g.apply((LifeCycleForView) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifeCycleForView> {
        /**
         * <p>
         * Describes the next steps for the opportunity shared through a snapshot.
         * </p>
         * 
         * @param nextSteps
         *        Describes the next steps for the opportunity shared through a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextSteps(String nextSteps);

        /**
         * <p>
         * Defines the approval status of the opportunity shared through a snapshot.
         * </p>
         * 
         * @param reviewStatus
         *        Defines the approval status of the opportunity shared through a snapshot.
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder reviewStatus(String reviewStatus);

        /**
         * <p>
         * Defines the approval status of the opportunity shared through a snapshot.
         * </p>
         * 
         * @param reviewStatus
         *        Defines the approval status of the opportunity shared through a snapshot.
         * @see ReviewStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ReviewStatus
         */
        Builder reviewStatus(ReviewStatus reviewStatus);

        /**
         * <p>
         * Defines the current stage of the opportunity shared through a snapshot.
         * </p>
         * 
         * @param stage
         *        Defines the current stage of the opportunity shared through a snapshot.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(String stage);

        /**
         * <p>
         * Defines the current stage of the opportunity shared through a snapshot.
         * </p>
         * 
         * @param stage
         *        Defines the current stage of the opportunity shared through a snapshot.
         * @see Stage
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Stage
         */
        Builder stage(Stage stage);

        /**
         * <p>
         * The projected launch date of the opportunity shared through a snapshot.
         * </p>
         * 
         * @param targetCloseDate
         *        The projected launch date of the opportunity shared through a snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCloseDate(String targetCloseDate);
    }

    static final class BuilderImpl implements Builder {
        private String nextSteps;

        private String reviewStatus;

        private String stage;

        private String targetCloseDate;

        private BuilderImpl() {
        }

        private BuilderImpl(LifeCycleForView model) {
            nextSteps(model.nextSteps);
            reviewStatus(model.reviewStatus);
            stage(model.stage);
            targetCloseDate(model.targetCloseDate);
        }

        public final String getNextSteps() {
            return nextSteps;
        }

        public final void setNextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
        }

        @Override
        public final Builder nextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
            return this;
        }

        public final String getReviewStatus() {
            return reviewStatus;
        }

        public final void setReviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
        }

        @Override
        public final Builder reviewStatus(String reviewStatus) {
            this.reviewStatus = reviewStatus;
            return this;
        }

        @Override
        public final Builder reviewStatus(ReviewStatus reviewStatus) {
            this.reviewStatus(reviewStatus == null ? null : reviewStatus.toString());
            return this;
        }

        public final String getStage() {
            return stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(Stage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getTargetCloseDate() {
            return targetCloseDate;
        }

        public final void setTargetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
        }

        @Override
        public final Builder targetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
            return this;
        }

        @Override
        public LifeCycleForView build() {
            return new LifeCycleForView(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
