/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementByAcceptingInvitationTasksResponse extends PartnerCentralSellingResponse
        implements
        ToCopyableBuilder<ListEngagementByAcceptingInvitationTasksResponse.Builder, ListEngagementByAcceptingInvitationTasksResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementByAcceptingInvitationTasksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ListEngagementByAcceptingInvitationTaskSummary>> TASK_SUMMARIES_FIELD = SdkField
            .<List<ListEngagementByAcceptingInvitationTaskSummary>> builder(MarshallingType.LIST)
            .memberName("TaskSummaries")
            .getter(getter(ListEngagementByAcceptingInvitationTasksResponse::taskSummaries))
            .setter(setter(Builder::taskSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ListEngagementByAcceptingInvitationTaskSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ListEngagementByAcceptingInvitationTaskSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            TASK_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries;

    private ListEngagementByAcceptingInvitationTasksResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.taskSummaries = builder.taskSummaries;
    }

    /**
     * <p>
     * A token used for pagination to retrieve the next page of results.If there are more results available, this field
     * will contain a token that can be used in a subsequent API call to retrieve the next page. If there are no more
     * results, this field will be null or an empty string.
     * </p>
     * 
     * @return A token used for pagination to retrieve the next page of results.If there are more results available,
     *         this field will contain a token that can be used in a subsequent API call to retrieve the next page. If
     *         there are no more results, this field will be null or an empty string.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskSummaries property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskSummaries() {
        return taskSummaries != null && !(taskSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task that
     * matches the specified filters. The array may be empty if no tasks match the criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskSummaries} method.
     * </p>
     * 
     * @return An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task
     *         that matches the specified filters. The array may be empty if no tasks match the criteria.
     */
    public final List<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries() {
        return taskSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskSummaries() ? taskSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementByAcceptingInvitationTasksResponse)) {
            return false;
        }
        ListEngagementByAcceptingInvitationTasksResponse other = (ListEngagementByAcceptingInvitationTasksResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasTaskSummaries() == other.hasTaskSummaries()
                && Objects.equals(taskSummaries(), other.taskSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementByAcceptingInvitationTasksResponse").add("NextToken", nextToken())
                .add("TaskSummaries", hasTaskSummaries() ? taskSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "TaskSummaries":
            return Optional.ofNullable(clazz.cast(taskSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("TaskSummaries", TASK_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementByAcceptingInvitationTasksResponse, T> g) {
        return obj -> g.apply((ListEngagementByAcceptingInvitationTasksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementByAcceptingInvitationTasksResponse> {
        /**
         * <p>
         * A token used for pagination to retrieve the next page of results.If there are more results available, this
         * field will contain a token that can be used in a subsequent API call to retrieve the next page. If there are
         * no more results, this field will be null or an empty string.
         * </p>
         * 
         * @param nextToken
         *        A token used for pagination to retrieve the next page of results.If there are more results available,
         *        this field will contain a token that can be used in a subsequent API call to retrieve the next page.
         *        If there are no more results, this field will be null or an empty string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task that
         * matches the specified filters. The array may be empty if no tasks match the criteria.
         * </p>
         * 
         * @param taskSummaries
         *        An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task
         *        that matches the specified filters. The array may be empty if no tasks match the criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSummaries(Collection<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries);

        /**
         * <p>
         * An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task that
         * matches the specified filters. The array may be empty if no tasks match the criteria.
         * </p>
         * 
         * @param taskSummaries
         *        An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task
         *        that matches the specified filters. The array may be empty if no tasks match the criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskSummaries(ListEngagementByAcceptingInvitationTaskSummary... taskSummaries);

        /**
         * <p>
         * An array of <code>EngagementByAcceptingInvitationTaskSummary</code> objects, each representing a task that
         * matches the specified filters. The array may be empty if no tasks match the criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #taskSummaries(List<ListEngagementByAcceptingInvitationTaskSummary>)}.
         * 
         * @param taskSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTaskSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #taskSummaries(java.util.Collection<ListEngagementByAcceptingInvitationTaskSummary>)
         */
        Builder taskSummaries(Consumer<ListEngagementByAcceptingInvitationTaskSummary.Builder>... taskSummaries);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementByAcceptingInvitationTasksResponse model) {
            super(model);
            nextToken(model.nextToken);
            taskSummaries(model.taskSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ListEngagementByAcceptingInvitationTaskSummary.Builder> getTaskSummaries() {
            List<ListEngagementByAcceptingInvitationTaskSummary.Builder> result = ListEngagementByAcceptingInvitationTaskSummariesCopier
                    .copyToBuilder(this.taskSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTaskSummaries(Collection<ListEngagementByAcceptingInvitationTaskSummary.BuilderImpl> taskSummaries) {
            this.taskSummaries = ListEngagementByAcceptingInvitationTaskSummariesCopier.copyFromBuilder(taskSummaries);
        }

        @Override
        public final Builder taskSummaries(Collection<ListEngagementByAcceptingInvitationTaskSummary> taskSummaries) {
            this.taskSummaries = ListEngagementByAcceptingInvitationTaskSummariesCopier.copy(taskSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSummaries(ListEngagementByAcceptingInvitationTaskSummary... taskSummaries) {
            taskSummaries(Arrays.asList(taskSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskSummaries(Consumer<ListEngagementByAcceptingInvitationTaskSummary.Builder>... taskSummaries) {
            taskSummaries(Stream.of(taskSummaries)
                    .map(c -> ListEngagementByAcceptingInvitationTaskSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEngagementByAcceptingInvitationTasksResponse build() {
            return new ListEngagementByAcceptingInvitationTasksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
