/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementFromOpportunityTasksRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<ListEngagementFromOpportunityTasksRequest.Builder, ListEngagementFromOpportunityTasksRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListEngagementFromOpportunityTasksRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EngagementIdentifier")
            .getter(getter(ListEngagementFromOpportunityTasksRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEngagementFromOpportunityTasksRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementFromOpportunityTasksRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> OPPORTUNITY_IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OpportunityIdentifier")
            .getter(getter(ListEngagementFromOpportunityTasksRequest::opportunityIdentifier))
            .setter(setter(Builder::opportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityIdentifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ListTasksSortBase> SORT_FIELD = SdkField.<ListTasksSortBase> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(ListEngagementFromOpportunityTasksRequest::sort)).setter(setter(Builder::sort))
            .constructor(ListTasksSortBase::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<List<String>> TASK_IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TaskIdentifier")
            .getter(getter(ListEngagementFromOpportunityTasksRequest::taskIdentifier))
            .setter(setter(Builder::taskIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskIdentifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> TASK_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("TaskStatus")
            .getter(getter(ListEngagementFromOpportunityTasksRequest::taskStatusAsStrings))
            .setter(setter(Builder::taskStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TaskStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            ENGAGEMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, OPPORTUNITY_IDENTIFIER_FIELD, SORT_FIELD,
            TASK_IDENTIFIER_FIELD, TASK_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> engagementIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> opportunityIdentifier;

    private final ListTasksSortBase sort;

    private final List<String> taskIdentifier;

    private final List<String> taskStatus;

    private ListEngagementFromOpportunityTasksRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.opportunityIdentifier = builder.opportunityIdentifier;
        this.sort = builder.sort;
        this.taskIdentifier = builder.taskIdentifier;
        this.taskStatus = builder.taskStatus;
    }

    /**
     * <p>
     * Specifies the catalog related to the request. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS: Retrieves the request from the production AWS environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sandbox: Retrieves the request from a sandbox environment used for testing or development purposes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the catalog related to the request. Valid values are: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         AWS: Retrieves the request from the production AWS environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Sandbox: Retrieves the request from a sandbox environment used for testing or development purposes.
     *         </p>
     *         </li>
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngagementIdentifier property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngagementIdentifier() {
        return engagementIdentifier != null && !(engagementIdentifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters tasks by the identifiers of the engagements they created or are associated with.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagementIdentifier} method.
     * </p>
     * 
     * @return Filters tasks by the identifiers of the engagements they created or are associated with.
     */
    public final List<String> engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * <p>
     * Specifies the maximum number of results to return in a single page of the response.Use this parameter to control
     * the number of items returned in each request, which can be useful for performance tuning and managing large
     * result sets.
     * </p>
     * 
     * @return Specifies the maximum number of results to return in a single page of the response.Use this parameter to
     *         control the number of items returned in each request, which can be useful for performance tuning and
     *         managing large result sets.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for requesting the next page of results. This value is obtained from the NextToken field in the
     * response of a previous call to this API. Use this parameter for pagination when the result set spans multiple
     * pages.
     * </p>
     * 
     * @return The token for requesting the next page of results. This value is obtained from the NextToken field in the
     *         response of a previous call to this API. Use this parameter for pagination when the result set spans
     *         multiple pages.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpportunityIdentifier property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasOpportunityIdentifier() {
        return opportunityIdentifier != null && !(opportunityIdentifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The identifier of the original opportunity associated with this task.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpportunityIdentifier} method.
     * </p>
     * 
     * @return The identifier of the original opportunity associated with this task.
     */
    public final List<String> opportunityIdentifier() {
        return opportunityIdentifier;
    }

    /**
     * <p>
     * Specifies the sorting criteria for the returned results. This allows you to order the tasks based on specific
     * attributes.
     * </p>
     * 
     * @return Specifies the sorting criteria for the returned results. This allows you to order the tasks based on
     *         specific attributes.
     */
    public final ListTasksSortBase sort() {
        return sort;
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskIdentifier property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskIdentifier() {
        return taskIdentifier != null && !(taskIdentifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters tasks by their unique identifiers. Use this when you want to retrieve information about specific tasks.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskIdentifier} method.
     * </p>
     * 
     * @return Filters tasks by their unique identifiers. Use this when you want to retrieve information about specific
     *         tasks.
     */
    public final List<String> taskIdentifier() {
        return taskIdentifier;
    }

    /**
     * <p>
     * Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskStatus} method.
     * </p>
     * 
     * @return Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
     */
    public final List<TaskStatus> taskStatus() {
        return TaskStatusesCopier.copyStringToEnum(taskStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskStatus property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTaskStatus() {
        return taskStatus != null && !(taskStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskStatus} method.
     * </p>
     * 
     * @return Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
     */
    public final List<String> taskStatusAsStrings() {
        return taskStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagementIdentifier() ? engagementIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpportunityIdentifier() ? opportunityIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskIdentifier() ? taskIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskStatus() ? taskStatusAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementFromOpportunityTasksRequest)) {
            return false;
        }
        ListEngagementFromOpportunityTasksRequest other = (ListEngagementFromOpportunityTasksRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasEngagementIdentifier() == other.hasEngagementIdentifier()
                && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasOpportunityIdentifier() == other.hasOpportunityIdentifier()
                && Objects.equals(opportunityIdentifier(), other.opportunityIdentifier()) && Objects.equals(sort(), other.sort())
                && hasTaskIdentifier() == other.hasTaskIdentifier() && Objects.equals(taskIdentifier(), other.taskIdentifier())
                && hasTaskStatus() == other.hasTaskStatus() && Objects.equals(taskStatusAsStrings(), other.taskStatusAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementFromOpportunityTasksRequest").add("Catalog", catalog())
                .add("EngagementIdentifier", hasEngagementIdentifier() ? engagementIdentifier() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("OpportunityIdentifier", hasOpportunityIdentifier() ? opportunityIdentifier() : null).add("Sort", sort())
                .add("TaskIdentifier", hasTaskIdentifier() ? taskIdentifier() : null)
                .add("TaskStatus", hasTaskStatus() ? taskStatusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(opportunityIdentifier()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "TaskIdentifier":
            return Optional.ofNullable(clazz.cast(taskIdentifier()));
        case "TaskStatus":
            return Optional.ofNullable(clazz.cast(taskStatusAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OpportunityIdentifier", OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("TaskIdentifier", TASK_IDENTIFIER_FIELD);
        map.put("TaskStatus", TASK_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementFromOpportunityTasksRequest, T> g) {
        return obj -> g.apply((ListEngagementFromOpportunityTasksRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementFromOpportunityTasksRequest> {
        /**
         * <p>
         * Specifies the catalog related to the request. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AWS: Retrieves the request from the production AWS environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Sandbox: Retrieves the request from a sandbox environment used for testing or development purposes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param catalog
         *        Specifies the catalog related to the request. Valid values are: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        AWS: Retrieves the request from the production AWS environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sandbox: Retrieves the request from a sandbox environment used for testing or development purposes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Filters tasks by the identifiers of the engagements they created or are associated with.
         * </p>
         * 
         * @param engagementIdentifier
         *        Filters tasks by the identifiers of the engagements they created or are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(Collection<String> engagementIdentifier);

        /**
         * <p>
         * Filters tasks by the identifiers of the engagements they created or are associated with.
         * </p>
         * 
         * @param engagementIdentifier
         *        Filters tasks by the identifiers of the engagements they created or are associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String... engagementIdentifier);

        /**
         * <p>
         * Specifies the maximum number of results to return in a single page of the response.Use this parameter to
         * control the number of items returned in each request, which can be useful for performance tuning and managing
         * large result sets.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of results to return in a single page of the response.Use this parameter
         *        to control the number of items returned in each request, which can be useful for performance tuning
         *        and managing large result sets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for requesting the next page of results. This value is obtained from the NextToken field in the
         * response of a previous call to this API. Use this parameter for pagination when the result set spans multiple
         * pages.
         * </p>
         * 
         * @param nextToken
         *        The token for requesting the next page of results. This value is obtained from the NextToken field in
         *        the response of a previous call to this API. Use this parameter for pagination when the result set
         *        spans multiple pages.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The identifier of the original opportunity associated with this task.
         * </p>
         * 
         * @param opportunityIdentifier
         *        The identifier of the original opportunity associated with this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityIdentifier(Collection<String> opportunityIdentifier);

        /**
         * <p>
         * The identifier of the original opportunity associated with this task.
         * </p>
         * 
         * @param opportunityIdentifier
         *        The identifier of the original opportunity associated with this task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityIdentifier(String... opportunityIdentifier);

        /**
         * <p>
         * Specifies the sorting criteria for the returned results. This allows you to order the tasks based on specific
         * attributes.
         * </p>
         * 
         * @param sort
         *        Specifies the sorting criteria for the returned results. This allows you to order the tasks based on
         *        specific attributes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(ListTasksSortBase sort);

        /**
         * <p>
         * Specifies the sorting criteria for the returned results. This allows you to order the tasks based on specific
         * attributes.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListTasksSortBase.Builder} avoiding the
         * need to create one manually via {@link ListTasksSortBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListTasksSortBase.Builder#build()} is called immediately and its
         * result is passed to {@link #sort(ListTasksSortBase)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link ListTasksSortBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(ListTasksSortBase)
         */
        default Builder sort(Consumer<ListTasksSortBase.Builder> sort) {
            return sort(ListTasksSortBase.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * Filters tasks by their unique identifiers. Use this when you want to retrieve information about specific
         * tasks.
         * </p>
         * 
         * @param taskIdentifier
         *        Filters tasks by their unique identifiers. Use this when you want to retrieve information about
         *        specific tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIdentifier(Collection<String> taskIdentifier);

        /**
         * <p>
         * Filters tasks by their unique identifiers. Use this when you want to retrieve information about specific
         * tasks.
         * </p>
         * 
         * @param taskIdentifier
         *        Filters tasks by their unique identifiers. Use this when you want to retrieve information about
         *        specific tasks.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskIdentifier(String... taskIdentifier);

        /**
         * <p>
         * Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * </p>
         * 
         * @param taskStatus
         *        Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatusWithStrings(Collection<String> taskStatus);

        /**
         * <p>
         * Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * </p>
         * 
         * @param taskStatus
         *        Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatusWithStrings(String... taskStatus);

        /**
         * <p>
         * Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * </p>
         * 
         * @param taskStatus
         *        Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatus(Collection<TaskStatus> taskStatus);

        /**
         * <p>
         * Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * </p>
         * 
         * @param taskStatus
         *        Filters the tasks based on their current status. This allows you to focus on tasks in specific states.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskStatus(TaskStatus... taskStatus);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private List<String> opportunityIdentifier = DefaultSdkAutoConstructList.getInstance();

        private ListTasksSortBase sort;

        private List<String> taskIdentifier = DefaultSdkAutoConstructList.getInstance();

        private List<String> taskStatus = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementFromOpportunityTasksRequest model) {
            super(model);
            catalog(model.catalog);
            engagementIdentifier(model.engagementIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            opportunityIdentifier(model.opportunityIdentifier);
            sort(model.sort);
            taskIdentifier(model.taskIdentifier);
            taskStatusWithStrings(model.taskStatus);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String... engagementIdentifier) {
            engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getOpportunityIdentifier() {
            if (opportunityIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return opportunityIdentifier;
        }

        public final void setOpportunityIdentifier(Collection<String> opportunityIdentifier) {
            this.opportunityIdentifier = OpportunityIdentifiersCopier.copy(opportunityIdentifier);
        }

        @Override
        public final Builder opportunityIdentifier(Collection<String> opportunityIdentifier) {
            this.opportunityIdentifier = OpportunityIdentifiersCopier.copy(opportunityIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityIdentifier(String... opportunityIdentifier) {
            opportunityIdentifier(Arrays.asList(opportunityIdentifier));
            return this;
        }

        public final ListTasksSortBase.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(ListTasksSortBase.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListTasksSortBase sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getTaskIdentifier() {
            if (taskIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return taskIdentifier;
        }

        public final void setTaskIdentifier(Collection<String> taskIdentifier) {
            this.taskIdentifier = TaskIdentifiersCopier.copy(taskIdentifier);
        }

        @Override
        public final Builder taskIdentifier(Collection<String> taskIdentifier) {
            this.taskIdentifier = TaskIdentifiersCopier.copy(taskIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskIdentifier(String... taskIdentifier) {
            taskIdentifier(Arrays.asList(taskIdentifier));
            return this;
        }

        public final Collection<String> getTaskStatus() {
            if (taskStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return taskStatus;
        }

        public final void setTaskStatus(Collection<String> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copy(taskStatus);
        }

        @Override
        public final Builder taskStatusWithStrings(Collection<String> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copy(taskStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskStatusWithStrings(String... taskStatus) {
            taskStatusWithStrings(Arrays.asList(taskStatus));
            return this;
        }

        @Override
        public final Builder taskStatus(Collection<TaskStatus> taskStatus) {
            this.taskStatus = TaskStatusesCopier.copyEnumToString(taskStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder taskStatus(TaskStatus... taskStatus) {
            taskStatus(Arrays.asList(taskStatus));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementFromOpportunityTasksRequest build() {
            return new ListEngagementFromOpportunityTasksRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
