/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementMembersResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListEngagementMembersResponse.Builder, ListEngagementMembersResponse> {
    private static final SdkField<List<EngagementMember>> ENGAGEMENT_MEMBER_LIST_FIELD = SdkField
            .<List<EngagementMember>> builder(MarshallingType.LIST)
            .memberName("EngagementMemberList")
            .getter(getter(ListEngagementMembersResponse::engagementMemberList))
            .setter(setter(Builder::engagementMemberList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementMemberList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngagementMember> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngagementMember::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_MEMBER_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EngagementMember> engagementMemberList;

    private final String nextToken;

    private ListEngagementMembersResponse(BuilderImpl builder) {
        super(builder);
        this.engagementMemberList = builder.engagementMemberList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngagementMemberList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngagementMemberList() {
        return engagementMemberList != null && !(engagementMemberList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of engagement members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagementMemberList} method.
     * </p>
     * 
     * @return Provides a list of engagement members.
     */
    public final List<EngagementMember> engagementMemberList() {
        return engagementMemberList;
    }

    /**
     * <p>
     * A pagination token used to retrieve the next set of results. If there are more results available than can be
     * returned in a single response, this token will be present. Use this token in a subsequent request to retrieve the
     * next page of results. If there are no more results, this value will be null.
     * </p>
     * 
     * @return A pagination token used to retrieve the next set of results. If there are more results available than can
     *         be returned in a single response, this token will be present. Use this token in a subsequent request to
     *         retrieve the next page of results. If there are no more results, this value will be null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagementMemberList() ? engagementMemberList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementMembersResponse)) {
            return false;
        }
        ListEngagementMembersResponse other = (ListEngagementMembersResponse) obj;
        return hasEngagementMemberList() == other.hasEngagementMemberList()
                && Objects.equals(engagementMemberList(), other.engagementMemberList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementMembersResponse")
                .add("EngagementMemberList", hasEngagementMemberList() ? engagementMemberList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementMemberList":
            return Optional.ofNullable(clazz.cast(engagementMemberList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngagementMemberList", ENGAGEMENT_MEMBER_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementMembersResponse, T> g) {
        return obj -> g.apply((ListEngagementMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementMembersResponse> {
        /**
         * <p>
         * Provides a list of engagement members.
         * </p>
         * 
         * @param engagementMemberList
         *        Provides a list of engagement members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementMemberList(Collection<EngagementMember> engagementMemberList);

        /**
         * <p>
         * Provides a list of engagement members.
         * </p>
         * 
         * @param engagementMemberList
         *        Provides a list of engagement members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementMemberList(EngagementMember... engagementMemberList);

        /**
         * <p>
         * Provides a list of engagement members.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMember.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMember#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMember.Builder#build()} is
         * called immediately and its result is passed to {@link #engagementMemberList(List<EngagementMember>)}.
         * 
         * @param engagementMemberList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementMember.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engagementMemberList(java.util.Collection<EngagementMember>)
         */
        Builder engagementMemberList(Consumer<EngagementMember.Builder>... engagementMemberList);

        /**
         * <p>
         * A pagination token used to retrieve the next set of results. If there are more results available than can be
         * returned in a single response, this token will be present. Use this token in a subsequent request to retrieve
         * the next page of results. If there are no more results, this value will be null.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to retrieve the next set of results. If there are more results available than
         *        can be returned in a single response, this token will be present. Use this token in a subsequent
         *        request to retrieve the next page of results. If there are no more results, this value will be null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private List<EngagementMember> engagementMemberList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementMembersResponse model) {
            super(model);
            engagementMemberList(model.engagementMemberList);
            nextToken(model.nextToken);
        }

        public final List<EngagementMember.Builder> getEngagementMemberList() {
            List<EngagementMember.Builder> result = EngagementMembersCopier.copyToBuilder(this.engagementMemberList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngagementMemberList(Collection<EngagementMember.BuilderImpl> engagementMemberList) {
            this.engagementMemberList = EngagementMembersCopier.copyFromBuilder(engagementMemberList);
        }

        @Override
        public final Builder engagementMemberList(Collection<EngagementMember> engagementMemberList) {
            this.engagementMemberList = EngagementMembersCopier.copy(engagementMemberList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementMemberList(EngagementMember... engagementMemberList) {
            engagementMemberList(Arrays.asList(engagementMemberList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementMemberList(Consumer<EngagementMember.Builder>... engagementMemberList) {
            engagementMemberList(Stream.of(engagementMemberList).map(c -> EngagementMember.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEngagementMembersResponse build() {
            return new ListEngagementMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
