/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementsResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListEngagementsResponse.Builder, ListEngagementsResponse> {
    private static final SdkField<List<EngagementSummary>> ENGAGEMENT_SUMMARY_LIST_FIELD = SdkField
            .<List<EngagementSummary>> builder(MarshallingType.LIST)
            .memberName("EngagementSummaryList")
            .getter(getter(ListEngagementsResponse::engagementSummaryList))
            .setter(setter(Builder::engagementSummaryList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementSummaryList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngagementSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngagementSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENGAGEMENT_SUMMARY_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EngagementSummary> engagementSummaryList;

    private final String nextToken;

    private ListEngagementsResponse(BuilderImpl builder) {
        super(builder);
        this.engagementSummaryList = builder.engagementSummaryList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngagementSummaryList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasEngagementSummaryList() {
        return engagementSummaryList != null && !(engagementSummaryList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of engagement summary objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagementSummaryList} method.
     * </p>
     * 
     * @return An array of engagement summary objects.
     */
    public final List<EngagementSummary> engagementSummaryList() {
        return engagementSummaryList;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. This field will be null if there are no more results.
     * </p>
     * 
     * @return The token to retrieve the next set of results. This field will be null if there are no more results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagementSummaryList() ? engagementSummaryList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsResponse)) {
            return false;
        }
        ListEngagementsResponse other = (ListEngagementsResponse) obj;
        return hasEngagementSummaryList() == other.hasEngagementSummaryList()
                && Objects.equals(engagementSummaryList(), other.engagementSummaryList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementsResponse")
                .add("EngagementSummaryList", hasEngagementSummaryList() ? engagementSummaryList() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementSummaryList":
            return Optional.ofNullable(clazz.cast(engagementSummaryList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngagementSummaryList", ENGAGEMENT_SUMMARY_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsResponse, T> g) {
        return obj -> g.apply((ListEngagementsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementsResponse> {
        /**
         * <p>
         * An array of engagement summary objects.
         * </p>
         * 
         * @param engagementSummaryList
         *        An array of engagement summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementSummaryList(Collection<EngagementSummary> engagementSummaryList);

        /**
         * <p>
         * An array of engagement summary objects.
         * </p>
         * 
         * @param engagementSummaryList
         *        An array of engagement summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementSummaryList(EngagementSummary... engagementSummaryList);

        /**
         * <p>
         * An array of engagement summary objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #engagementSummaryList(List<EngagementSummary>)}.
         * 
         * @param engagementSummaryList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engagementSummaryList(java.util.Collection<EngagementSummary>)
         */
        Builder engagementSummaryList(Consumer<EngagementSummary.Builder>... engagementSummaryList);

        /**
         * <p>
         * The token to retrieve the next set of results. This field will be null if there are no more results.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. This field will be null if there are no more results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private List<EngagementSummary> engagementSummaryList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsResponse model) {
            super(model);
            engagementSummaryList(model.engagementSummaryList);
            nextToken(model.nextToken);
        }

        public final List<EngagementSummary.Builder> getEngagementSummaryList() {
            List<EngagementSummary.Builder> result = EngagementSummaryListCopier.copyToBuilder(this.engagementSummaryList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngagementSummaryList(Collection<EngagementSummary.BuilderImpl> engagementSummaryList) {
            this.engagementSummaryList = EngagementSummaryListCopier.copyFromBuilder(engagementSummaryList);
        }

        @Override
        public final Builder engagementSummaryList(Collection<EngagementSummary> engagementSummaryList) {
            this.engagementSummaryList = EngagementSummaryListCopier.copy(engagementSummaryList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementSummaryList(EngagementSummary... engagementSummaryList) {
            engagementSummaryList(Arrays.asList(engagementSummaryList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementSummaryList(Consumer<EngagementSummary.Builder>... engagementSummaryList) {
            engagementSummaryList(Stream.of(engagementSummaryList).map(c -> EngagementSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEngagementsResponse build() {
            return new ListEngagementsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
