/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpportunitiesRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<ListOpportunitiesRequest.Builder, ListOpportunitiesRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListOpportunitiesRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> CUSTOMER_COMPANY_NAME_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CustomerCompanyName")
            .getter(getter(ListOpportunitiesRequest::customerCompanyName))
            .setter(setter(Builder::customerCompanyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerCompanyName").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Identifier")
            .getter(getter(ListOpportunitiesRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<LastModifiedDate> LAST_MODIFIED_DATE_FIELD = SdkField
            .<LastModifiedDate> builder(MarshallingType.SDK_POJO).memberName("LastModifiedDate")
            .getter(getter(ListOpportunitiesRequest::lastModifiedDate)).setter(setter(Builder::lastModifiedDate))
            .constructor(LastModifiedDate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()).build();

    private static final SdkField<List<String>> LIFE_CYCLE_REVIEW_STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LifeCycleReviewStatus")
            .getter(getter(ListOpportunitiesRequest::lifeCycleReviewStatusAsStrings))
            .setter(setter(Builder::lifeCycleReviewStatusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleReviewStatus").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> LIFE_CYCLE_STAGE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("LifeCycleStage")
            .getter(getter(ListOpportunitiesRequest::lifeCycleStageAsStrings))
            .setter(setter(Builder::lifeCycleStageWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleStage").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListOpportunitiesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOpportunitiesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<OpportunitySort> SORT_FIELD = SdkField.<OpportunitySort> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(ListOpportunitiesRequest::sort)).setter(setter(Builder::sort))
            .constructor(OpportunitySort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CUSTOMER_COMPANY_NAME_FIELD, IDENTIFIER_FIELD, LAST_MODIFIED_DATE_FIELD, LIFE_CYCLE_REVIEW_STATUS_FIELD,
            LIFE_CYCLE_STAGE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> customerCompanyName;

    private final List<String> identifier;

    private final LastModifiedDate lastModifiedDate;

    private final List<String> lifeCycleReviewStatus;

    private final List<String> lifeCycleStage;

    private final Integer maxResults;

    private final String nextToken;

    private final OpportunitySort sort;

    private ListOpportunitiesRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.customerCompanyName = builder.customerCompanyName;
        this.identifier = builder.identifier;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lifeCycleReviewStatus = builder.lifeCycleReviewStatus;
        this.lifeCycleStage = builder.lifeCycleStage;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    /**
     * <p>
     * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
     * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunities are listed
     * in. Use <code>AWS</code> for listing real opportunities in the Amazon Web Services catalog, and
     * <code>Sandbox</code> for testing in secure, isolated environments.
     * </p>
     * 
     * @return Specifies the catalog associated with the request. This field takes a string value from a predefined
     *         list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the
     *         opportunities are listed in. Use <code>AWS</code> for listing real opportunities in the Amazon Web
     *         Services catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomerCompanyName property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomerCompanyName() {
        return customerCompanyName != null && !(customerCompanyName instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the opportunities based on the customer's company name. This allows partners to search for opportunities
     * associated with a specific customer by matching the provided company name string.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomerCompanyName} method.
     * </p>
     * 
     * @return Filters the opportunities based on the customer's company name. This allows partners to search for
     *         opportunities associated with a specific customer by matching the provided company name string.
     */
    public final List<String> customerCompanyName() {
        return customerCompanyName;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identifier property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentifier() {
        return identifier != null && !(identifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the opportunities based on the opportunity identifier. This allows partners to retrieve specific
     * opportunities by providing their unique identifiers, ensuring precise results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentifier} method.
     * </p>
     * 
     * @return Filters the opportunities based on the opportunity identifier. This allows partners to retrieve specific
     *         opportunities by providing their unique identifiers, ensuring precise results.
     */
    public final List<String> identifier() {
        return identifier;
    }

    /**
     * <p>
     * Filters the opportunities based on their last modified date. This filter helps retrieve opportunities that were
     * updated after the specified date, allowing partners to track recent changes or updates.
     * </p>
     * 
     * @return Filters the opportunities based on their last modified date. This filter helps retrieve opportunities
     *         that were updated after the specified date, allowing partners to track recent changes or updates.
     */
    public final LastModifiedDate lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
     * opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
     * <code>Action Required</code>, or <code>Approved</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleReviewStatus} method.
     * </p>
     * 
     * @return Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
     *         opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
     *         <code>Action Required</code>, or <code>Approved</code>.
     */
    public final List<ReviewStatus> lifeCycleReviewStatus() {
        return ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copyStringToEnum(lifeCycleReviewStatus);
    }

    /**
     * For responses, this returns true if the service returned a value for the LifeCycleReviewStatus property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasLifeCycleReviewStatus() {
        return lifeCycleReviewStatus != null && !(lifeCycleReviewStatus instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
     * opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
     * <code>Action Required</code>, or <code>Approved</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleReviewStatus} method.
     * </p>
     * 
     * @return Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
     *         opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
     *         <code>Action Required</code>, or <code>Approved</code>.
     */
    public final List<String> lifeCycleReviewStatusAsStrings() {
        return lifeCycleReviewStatus;
    }

    /**
     * <p>
     * Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve opportunities
     * at various stages in the sales cycle, such as <code>Qualified</code>, <code>Technical Validation</code>,
     * <code>Business Validation</code>, or <code>Closed Won</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleStage} method.
     * </p>
     * 
     * @return Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
     *         opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
     *         <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
     */
    public final List<Stage> lifeCycleStage() {
        return ListOpportunitiesRequestLifeCycleStageListCopier.copyStringToEnum(lifeCycleStage);
    }

    /**
     * For responses, this returns true if the service returned a value for the LifeCycleStage property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasLifeCycleStage() {
        return lifeCycleStage != null && !(lifeCycleStage instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve opportunities
     * at various stages in the sales cycle, such as <code>Qualified</code>, <code>Technical Validation</code>,
     * <code>Business Validation</code>, or <code>Closed Won</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasLifeCycleStage} method.
     * </p>
     * 
     * @return Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
     *         opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
     *         <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
     */
    public final List<String> lifeCycleStageAsStrings() {
        return lifeCycleStage;
    }

    /**
     * <p>
     * Specifies the maximum number of results to return in a single call. This limits the number of opportunities
     * returned in the response to avoid providing too many results at once.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return Specifies the maximum number of results to return in a single call. This limits the number of
     *         opportunities returned in the response to avoid providing too many results at once.</p>
     *         <p>
     *         Default: 20
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in the
     * response only if there are additional result pages available.
     * </p>
     * 
     * @return A pagination token used to retrieve the next set of results in subsequent calls. This token is included
     *         in the response only if there are additional result pages available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * An object that specifies how the response is sorted. The default <code>Sort.SortBy</code> value is
     * <code>LastModifiedDate</code>.
     * </p>
     * 
     * @return An object that specifies how the response is sorted. The default <code>Sort.SortBy</code> value is
     *         <code>LastModifiedDate</code>.
     */
    public final OpportunitySort sort() {
        return sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomerCompanyName() ? customerCompanyName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifier() ? identifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(hasLifeCycleReviewStatus() ? lifeCycleReviewStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasLifeCycleStage() ? lifeCycleStageAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpportunitiesRequest)) {
            return false;
        }
        ListOpportunitiesRequest other = (ListOpportunitiesRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasCustomerCompanyName() == other.hasCustomerCompanyName()
                && Objects.equals(customerCompanyName(), other.customerCompanyName()) && hasIdentifier() == other.hasIdentifier()
                && Objects.equals(identifier(), other.identifier())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && hasLifeCycleReviewStatus() == other.hasLifeCycleReviewStatus()
                && Objects.equals(lifeCycleReviewStatusAsStrings(), other.lifeCycleReviewStatusAsStrings())
                && hasLifeCycleStage() == other.hasLifeCycleStage()
                && Objects.equals(lifeCycleStageAsStrings(), other.lifeCycleStageAsStrings())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sort(), other.sort());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpportunitiesRequest").add("Catalog", catalog())
                .add("CustomerCompanyName", hasCustomerCompanyName() ? customerCompanyName() : null)
                .add("Identifier", hasIdentifier() ? identifier() : null).add("LastModifiedDate", lastModifiedDate())
                .add("LifeCycleReviewStatus", hasLifeCycleReviewStatus() ? lifeCycleReviewStatusAsStrings() : null)
                .add("LifeCycleStage", hasLifeCycleStage() ? lifeCycleStageAsStrings() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Sort", sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "CustomerCompanyName":
            return Optional.ofNullable(clazz.cast(customerCompanyName()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LifeCycleReviewStatus":
            return Optional.ofNullable(clazz.cast(lifeCycleReviewStatusAsStrings()));
        case "LifeCycleStage":
            return Optional.ofNullable(clazz.cast(lifeCycleStageAsStrings()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("CustomerCompanyName", CUSTOMER_COMPANY_NAME_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LifeCycleReviewStatus", LIFE_CYCLE_REVIEW_STATUS_FIELD);
        map.put("LifeCycleStage", LIFE_CYCLE_STAGE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpportunitiesRequest, T> g) {
        return obj -> g.apply((ListOpportunitiesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOpportunitiesRequest> {
        /**
         * <p>
         * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
         * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the opportunities are
         * listed in. Use <code>AWS</code> for listing real opportunities in the Amazon Web Services catalog, and
         * <code>Sandbox</code> for testing in secure, isolated environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the request. This field takes a string value from a predefined
         *        list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the
         *        opportunities are listed in. Use <code>AWS</code> for listing real opportunities in the Amazon Web
         *        Services catalog, and <code>Sandbox</code> for testing in secure, isolated environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Filters the opportunities based on the customer's company name. This allows partners to search for
         * opportunities associated with a specific customer by matching the provided company name string.
         * </p>
         * 
         * @param customerCompanyName
         *        Filters the opportunities based on the customer's company name. This allows partners to search for
         *        opportunities associated with a specific customer by matching the provided company name string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerCompanyName(Collection<String> customerCompanyName);

        /**
         * <p>
         * Filters the opportunities based on the customer's company name. This allows partners to search for
         * opportunities associated with a specific customer by matching the provided company name string.
         * </p>
         * 
         * @param customerCompanyName
         *        Filters the opportunities based on the customer's company name. This allows partners to search for
         *        opportunities associated with a specific customer by matching the provided company name string.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerCompanyName(String... customerCompanyName);

        /**
         * <p>
         * Filters the opportunities based on the opportunity identifier. This allows partners to retrieve specific
         * opportunities by providing their unique identifiers, ensuring precise results.
         * </p>
         * 
         * @param identifier
         *        Filters the opportunities based on the opportunity identifier. This allows partners to retrieve
         *        specific opportunities by providing their unique identifiers, ensuring precise results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(Collection<String> identifier);

        /**
         * <p>
         * Filters the opportunities based on the opportunity identifier. This allows partners to retrieve specific
         * opportunities by providing their unique identifiers, ensuring precise results.
         * </p>
         * 
         * @param identifier
         *        Filters the opportunities based on the opportunity identifier. This allows partners to retrieve
         *        specific opportunities by providing their unique identifiers, ensuring precise results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String... identifier);

        /**
         * <p>
         * Filters the opportunities based on their last modified date. This filter helps retrieve opportunities that
         * were updated after the specified date, allowing partners to track recent changes or updates.
         * </p>
         * 
         * @param lastModifiedDate
         *        Filters the opportunities based on their last modified date. This filter helps retrieve opportunities
         *        that were updated after the specified date, allowing partners to track recent changes or updates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(LastModifiedDate lastModifiedDate);

        /**
         * <p>
         * Filters the opportunities based on their last modified date. This filter helps retrieve opportunities that
         * were updated after the specified date, allowing partners to track recent changes or updates.
         * </p>
         * This is a convenience method that creates an instance of the {@link LastModifiedDate.Builder} avoiding the
         * need to create one manually via {@link LastModifiedDate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LastModifiedDate.Builder#build()} is called immediately and its
         * result is passed to {@link #lastModifiedDate(LastModifiedDate)}.
         * 
         * @param lastModifiedDate
         *        a consumer that will call methods on {@link LastModifiedDate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lastModifiedDate(LastModifiedDate)
         */
        default Builder lastModifiedDate(Consumer<LastModifiedDate.Builder> lastModifiedDate) {
            return lastModifiedDate(LastModifiedDate.builder().applyMutation(lastModifiedDate).build());
        }

        /**
         * <p>
         * Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
         * opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         * <code>Action Required</code>, or <code>Approved</code>.
         * </p>
         * 
         * @param lifeCycleReviewStatus
         *        Filters the opportunities based on their current lifecycle approval status. Use this filter to
         *        retrieve opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         *        <code>Action Required</code>, or <code>Approved</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleReviewStatusWithStrings(Collection<String> lifeCycleReviewStatus);

        /**
         * <p>
         * Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
         * opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         * <code>Action Required</code>, or <code>Approved</code>.
         * </p>
         * 
         * @param lifeCycleReviewStatus
         *        Filters the opportunities based on their current lifecycle approval status. Use this filter to
         *        retrieve opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         *        <code>Action Required</code>, or <code>Approved</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleReviewStatusWithStrings(String... lifeCycleReviewStatus);

        /**
         * <p>
         * Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
         * opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         * <code>Action Required</code>, or <code>Approved</code>.
         * </p>
         * 
         * @param lifeCycleReviewStatus
         *        Filters the opportunities based on their current lifecycle approval status. Use this filter to
         *        retrieve opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         *        <code>Action Required</code>, or <code>Approved</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleReviewStatus(Collection<ReviewStatus> lifeCycleReviewStatus);

        /**
         * <p>
         * Filters the opportunities based on their current lifecycle approval status. Use this filter to retrieve
         * opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         * <code>Action Required</code>, or <code>Approved</code>.
         * </p>
         * 
         * @param lifeCycleReviewStatus
         *        Filters the opportunities based on their current lifecycle approval status. Use this filter to
         *        retrieve opportunities with statuses such as <code>Pending Submission</code>, <code>In Review</code>,
         *        <code>Action Required</code>, or <code>Approved</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleReviewStatus(ReviewStatus... lifeCycleReviewStatus);

        /**
         * <p>
         * Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         * opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         * <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * </p>
         * 
         * @param lifeCycleStage
         *        Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         *        opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         *        <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStageWithStrings(Collection<String> lifeCycleStage);

        /**
         * <p>
         * Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         * opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         * <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * </p>
         * 
         * @param lifeCycleStage
         *        Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         *        opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         *        <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStageWithStrings(String... lifeCycleStage);

        /**
         * <p>
         * Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         * opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         * <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * </p>
         * 
         * @param lifeCycleStage
         *        Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         *        opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         *        <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStage(Collection<Stage> lifeCycleStage);

        /**
         * <p>
         * Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         * opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         * <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * </p>
         * 
         * @param lifeCycleStage
         *        Filters the opportunities based on their lifecycle stage. This filter allows partners to retrieve
         *        opportunities at various stages in the sales cycle, such as <code>Qualified</code>,
         *        <code>Technical Validation</code>, <code>Business Validation</code>, or <code>Closed Won</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycleStage(Stage... lifeCycleStage);

        /**
         * <p>
         * Specifies the maximum number of results to return in a single call. This limits the number of opportunities
         * returned in the response to avoid providing too many results at once.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of results to return in a single call. This limits the number of
         *        opportunities returned in the response to avoid providing too many results at once.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in
         * the response only if there are additional result pages available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to retrieve the next set of results in subsequent calls. This token is
         *        included in the response only if there are additional result pages available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An object that specifies how the response is sorted. The default <code>Sort.SortBy</code> value is
         * <code>LastModifiedDate</code>.
         * </p>
         * 
         * @param sort
         *        An object that specifies how the response is sorted. The default <code>Sort.SortBy</code> value is
         *        <code>LastModifiedDate</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(OpportunitySort sort);

        /**
         * <p>
         * An object that specifies how the response is sorted. The default <code>Sort.SortBy</code> value is
         * <code>LastModifiedDate</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link OpportunitySort.Builder} avoiding the
         * need to create one manually via {@link OpportunitySort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpportunitySort.Builder#build()} is called immediately and its
         * result is passed to {@link #sort(OpportunitySort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link OpportunitySort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(OpportunitySort)
         */
        default Builder sort(Consumer<OpportunitySort.Builder> sort) {
            return sort(OpportunitySort.builder().applyMutation(sort).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<String> customerCompanyName = DefaultSdkAutoConstructList.getInstance();

        private List<String> identifier = DefaultSdkAutoConstructList.getInstance();

        private LastModifiedDate lastModifiedDate;

        private List<String> lifeCycleReviewStatus = DefaultSdkAutoConstructList.getInstance();

        private List<String> lifeCycleStage = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private OpportunitySort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpportunitiesRequest model) {
            super(model);
            catalog(model.catalog);
            customerCompanyName(model.customerCompanyName);
            identifier(model.identifier);
            lastModifiedDate(model.lastModifiedDate);
            lifeCycleReviewStatusWithStrings(model.lifeCycleReviewStatus);
            lifeCycleStageWithStrings(model.lifeCycleStage);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sort(model.sort);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCustomerCompanyName() {
            if (customerCompanyName instanceof SdkAutoConstructList) {
                return null;
            }
            return customerCompanyName;
        }

        public final void setCustomerCompanyName(Collection<String> customerCompanyName) {
            this.customerCompanyName = ListOpportunitiesRequestCustomerCompanyNameListCopier.copy(customerCompanyName);
        }

        @Override
        public final Builder customerCompanyName(Collection<String> customerCompanyName) {
            this.customerCompanyName = ListOpportunitiesRequestCustomerCompanyNameListCopier.copy(customerCompanyName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerCompanyName(String... customerCompanyName) {
            customerCompanyName(Arrays.asList(customerCompanyName));
            return this;
        }

        public final Collection<String> getIdentifier() {
            if (identifier instanceof SdkAutoConstructList) {
                return null;
            }
            return identifier;
        }

        public final void setIdentifier(Collection<String> identifier) {
            this.identifier = ListOpportunitiesRequestIdentifierListCopier.copy(identifier);
        }

        @Override
        public final Builder identifier(Collection<String> identifier) {
            this.identifier = ListOpportunitiesRequestIdentifierListCopier.copy(identifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifier(String... identifier) {
            identifier(Arrays.asList(identifier));
            return this;
        }

        public final LastModifiedDate.Builder getLastModifiedDate() {
            return lastModifiedDate != null ? lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(LastModifiedDate.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(LastModifiedDate lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Collection<String> getLifeCycleReviewStatus() {
            if (lifeCycleReviewStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return lifeCycleReviewStatus;
        }

        public final void setLifeCycleReviewStatus(Collection<String> lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus = ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copy(lifeCycleReviewStatus);
        }

        @Override
        public final Builder lifeCycleReviewStatusWithStrings(Collection<String> lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus = ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copy(lifeCycleReviewStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleReviewStatusWithStrings(String... lifeCycleReviewStatus) {
            lifeCycleReviewStatusWithStrings(Arrays.asList(lifeCycleReviewStatus));
            return this;
        }

        @Override
        public final Builder lifeCycleReviewStatus(Collection<ReviewStatus> lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus = ListOpportunitiesRequestLifeCycleReviewStatusListCopier
                    .copyEnumToString(lifeCycleReviewStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleReviewStatus(ReviewStatus... lifeCycleReviewStatus) {
            lifeCycleReviewStatus(Arrays.asList(lifeCycleReviewStatus));
            return this;
        }

        public final Collection<String> getLifeCycleStage() {
            if (lifeCycleStage instanceof SdkAutoConstructList) {
                return null;
            }
            return lifeCycleStage;
        }

        public final void setLifeCycleStage(Collection<String> lifeCycleStage) {
            this.lifeCycleStage = ListOpportunitiesRequestLifeCycleStageListCopier.copy(lifeCycleStage);
        }

        @Override
        public final Builder lifeCycleStageWithStrings(Collection<String> lifeCycleStage) {
            this.lifeCycleStage = ListOpportunitiesRequestLifeCycleStageListCopier.copy(lifeCycleStage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStageWithStrings(String... lifeCycleStage) {
            lifeCycleStageWithStrings(Arrays.asList(lifeCycleStage));
            return this;
        }

        @Override
        public final Builder lifeCycleStage(Collection<Stage> lifeCycleStage) {
            this.lifeCycleStage = ListOpportunitiesRequestLifeCycleStageListCopier.copyEnumToString(lifeCycleStage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStage(Stage... lifeCycleStage) {
            lifeCycleStage(Arrays.asList(lifeCycleStage));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final OpportunitySort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(OpportunitySort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(OpportunitySort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOpportunitiesRequest build() {
            return new ListOpportunitiesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
