/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListOpportunitiesResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListOpportunitiesResponse.Builder, ListOpportunitiesResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListOpportunitiesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<OpportunitySummary>> OPPORTUNITY_SUMMARIES_FIELD = SdkField
            .<List<OpportunitySummary>> builder(MarshallingType.LIST)
            .memberName("OpportunitySummaries")
            .getter(getter(ListOpportunitiesResponse::opportunitySummaries))
            .setter(setter(Builder::opportunitySummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunitySummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<OpportunitySummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(OpportunitySummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            OPPORTUNITY_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<OpportunitySummary> opportunitySummaries;

    private ListOpportunitiesResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.opportunitySummaries = builder.opportunitySummaries;
    }

    /**
     * <p>
     * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in the
     * response only if there are additional result pages available.
     * </p>
     * 
     * @return A pagination token used to retrieve the next set of results in subsequent calls. This token is included
     *         in the response only if there are additional result pages available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpportunitySummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOpportunitySummaries() {
        return opportunitySummaries != null && !(opportunitySummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that contains minimal details for opportunities that match the request criteria. This summary view
     * provides a quick overview of relevant opportunities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpportunitySummaries} method.
     * </p>
     * 
     * @return An array that contains minimal details for opportunities that match the request criteria. This summary
     *         view provides a quick overview of relevant opportunities.
     */
    public final List<OpportunitySummary> opportunitySummaries() {
        return opportunitySummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpportunitySummaries() ? opportunitySummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpportunitiesResponse)) {
            return false;
        }
        ListOpportunitiesResponse other = (ListOpportunitiesResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasOpportunitySummaries() == other.hasOpportunitySummaries()
                && Objects.equals(opportunitySummaries(), other.opportunitySummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListOpportunitiesResponse").add("NextToken", nextToken())
                .add("OpportunitySummaries", hasOpportunitySummaries() ? opportunitySummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "OpportunitySummaries":
            return Optional.ofNullable(clazz.cast(opportunitySummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("OpportunitySummaries", OPPORTUNITY_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpportunitiesResponse, T> g) {
        return obj -> g.apply((ListOpportunitiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListOpportunitiesResponse> {
        /**
         * <p>
         * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in
         * the response only if there are additional result pages available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to retrieve the next set of results in subsequent calls. This token is
         *        included in the response only if there are additional result pages available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array that contains minimal details for opportunities that match the request criteria. This summary view
         * provides a quick overview of relevant opportunities.
         * </p>
         * 
         * @param opportunitySummaries
         *        An array that contains minimal details for opportunities that match the request criteria. This summary
         *        view provides a quick overview of relevant opportunities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunitySummaries(Collection<OpportunitySummary> opportunitySummaries);

        /**
         * <p>
         * An array that contains minimal details for opportunities that match the request criteria. This summary view
         * provides a quick overview of relevant opportunities.
         * </p>
         * 
         * @param opportunitySummaries
         *        An array that contains minimal details for opportunities that match the request criteria. This summary
         *        view provides a quick overview of relevant opportunities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunitySummaries(OpportunitySummary... opportunitySummaries);

        /**
         * <p>
         * An array that contains minimal details for opportunities that match the request criteria. This summary view
         * provides a quick overview of relevant opportunities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary.Builder#build()} is
         * called immediately and its result is passed to {@link #opportunitySummaries(List<OpportunitySummary>)}.
         * 
         * @param opportunitySummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.OpportunitySummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opportunitySummaries(java.util.Collection<OpportunitySummary>)
         */
        Builder opportunitySummaries(Consumer<OpportunitySummary.Builder>... opportunitySummaries);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<OpportunitySummary> opportunitySummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpportunitiesResponse model) {
            super(model);
            nextToken(model.nextToken);
            opportunitySummaries(model.opportunitySummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OpportunitySummary.Builder> getOpportunitySummaries() {
            List<OpportunitySummary.Builder> result = OpportunitySummariesCopier.copyToBuilder(this.opportunitySummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunitySummaries(Collection<OpportunitySummary.BuilderImpl> opportunitySummaries) {
            this.opportunitySummaries = OpportunitySummariesCopier.copyFromBuilder(opportunitySummaries);
        }

        @Override
        public final Builder opportunitySummaries(Collection<OpportunitySummary> opportunitySummaries) {
            this.opportunitySummaries = OpportunitySummariesCopier.copy(opportunitySummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunitySummaries(OpportunitySummary... opportunitySummaries) {
            opportunitySummaries(Arrays.asList(opportunitySummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunitySummaries(Consumer<OpportunitySummary.Builder>... opportunitySummaries) {
            opportunitySummaries(Stream.of(opportunitySummaries).map(c -> OpportunitySummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListOpportunitiesResponse build() {
            return new ListOpportunitiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
