/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceSnapshotJobsRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<ListResourceSnapshotJobsRequest.Builder, ListResourceSnapshotJobsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListResourceSnapshotJobsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementIdentifier").getter(getter(ListResourceSnapshotJobsRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListResourceSnapshotJobsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceSnapshotJobsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<SortObject> SORT_FIELD = SdkField.<SortObject> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(ListResourceSnapshotJobsRequest::sort)).setter(setter(Builder::sort))
            .constructor(SortObject::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ListResourceSnapshotJobsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            ENGAGEMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String engagementIdentifier;

    private final Integer maxResults;

    private final String nextToken;

    private final SortObject sort;

    private final String status;

    private ListResourceSnapshotJobsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies the catalog related to the request.
     * </p>
     * 
     * @return Specifies the catalog related to the request.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The identifier of the engagement to filter the response.
     * </p>
     * 
     * @return The identifier of the engagement to filter the response.
     */
    public final String engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call. If omitted, defaults to 50.
     * </p>
     * 
     * @return The maximum number of results to return in a single call. If omitted, defaults to 50.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results.
     * </p>
     * 
     * @return The token for the next set of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Configures the sorting of the response. If omitted, results are sorted by <code>CreatedDate</code> in descending
     * order.
     * </p>
     * 
     * @return Configures the sorting of the response. If omitted, results are sorted by <code>CreatedDate</code> in
     *         descending order.
     */
    public final SortObject sort() {
        return sort;
    }

    /**
     * <p>
     * The status of the jobs to filter the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the jobs to filter the response.
     * @see ResourceSnapshotJobStatus
     */
    public final ResourceSnapshotJobStatus status() {
        return ResourceSnapshotJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the jobs to filter the response.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the jobs to filter the response.
     * @see ResourceSnapshotJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSnapshotJobsRequest)) {
            return false;
        }
        ListResourceSnapshotJobsRequest other = (ListResourceSnapshotJobsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(sort(), other.sort()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceSnapshotJobsRequest").add("Catalog", catalog())
                .add("EngagementIdentifier", engagementIdentifier()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Sort", sort()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSnapshotJobsRequest, T> g) {
        return obj -> g.apply((ListResourceSnapshotJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceSnapshotJobsRequest> {
        /**
         * <p>
         * Specifies the catalog related to the request.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog related to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The identifier of the engagement to filter the response.
         * </p>
         * 
         * @param engagementIdentifier
         *        The identifier of the engagement to filter the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String engagementIdentifier);

        /**
         * <p>
         * The maximum number of results to return in a single call. If omitted, defaults to 50.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call. If omitted, defaults to 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Configures the sorting of the response. If omitted, results are sorted by <code>CreatedDate</code> in
         * descending order.
         * </p>
         * 
         * @param sort
         *        Configures the sorting of the response. If omitted, results are sorted by <code>CreatedDate</code> in
         *        descending order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(SortObject sort);

        /**
         * <p>
         * Configures the sorting of the response. If omitted, results are sorted by <code>CreatedDate</code> in
         * descending order.
         * </p>
         * This is a convenience method that creates an instance of the {@link SortObject.Builder} avoiding the need to
         * create one manually via {@link SortObject#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SortObject.Builder#build()} is called immediately and its result
         * is passed to {@link #sort(SortObject)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link SortObject.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(SortObject)
         */
        default Builder sort(Consumer<SortObject.Builder> sort) {
            return sort(SortObject.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The status of the jobs to filter the response.
         * </p>
         * 
         * @param status
         *        The status of the jobs to filter the response.
         * @see ResourceSnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSnapshotJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the jobs to filter the response.
         * </p>
         * 
         * @param status
         *        The status of the jobs to filter the response.
         * @see ResourceSnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSnapshotJobStatus
         */
        Builder status(ResourceSnapshotJobStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String engagementIdentifier;

        private Integer maxResults;

        private String nextToken;

        private SortObject sort;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSnapshotJobsRequest model) {
            super(model);
            catalog(model.catalog);
            engagementIdentifier(model.engagementIdentifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sort(model.sort);
            status(model.status);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEngagementIdentifier() {
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SortObject.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(SortObject.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SortObject sort) {
            this.sort = sort;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSnapshotJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListResourceSnapshotJobsRequest build() {
            return new ListResourceSnapshotJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
