/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListResourceSnapshotsResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListResourceSnapshotsResponse.Builder, ListResourceSnapshotsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListResourceSnapshotsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<ResourceSnapshotSummary>> RESOURCE_SNAPSHOT_SUMMARIES_FIELD = SdkField
            .<List<ResourceSnapshotSummary>> builder(MarshallingType.LIST)
            .memberName("ResourceSnapshotSummaries")
            .getter(getter(ListResourceSnapshotsResponse::resourceSnapshotSummaries))
            .setter(setter(Builder::resourceSnapshotSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourceSnapshotSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourceSnapshotSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            RESOURCE_SNAPSHOT_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<ResourceSnapshotSummary> resourceSnapshotSummaries;

    private ListResourceSnapshotsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.resourceSnapshotSummaries = builder.resourceSnapshotSummaries;
    }

    /**
     * <p>
     * The token to retrieve the next set of results. If there are no additional results, this value is null.
     * </p>
     * 
     * @return The token to retrieve the next set of results. If there are no additional results, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceSnapshotSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceSnapshotSummaries() {
        return resourceSnapshotSummaries != null && !(resourceSnapshotSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of resource snapshot summary objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceSnapshotSummaries} method.
     * </p>
     * 
     * @return An array of resource snapshot summary objects.
     */
    public final List<ResourceSnapshotSummary> resourceSnapshotSummaries() {
        return resourceSnapshotSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceSnapshotSummaries() ? resourceSnapshotSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListResourceSnapshotsResponse)) {
            return false;
        }
        ListResourceSnapshotsResponse other = (ListResourceSnapshotsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasResourceSnapshotSummaries() == other.hasResourceSnapshotSummaries()
                && Objects.equals(resourceSnapshotSummaries(), other.resourceSnapshotSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListResourceSnapshotsResponse").add("NextToken", nextToken())
                .add("ResourceSnapshotSummaries", hasResourceSnapshotSummaries() ? resourceSnapshotSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "ResourceSnapshotSummaries":
            return Optional.ofNullable(clazz.cast(resourceSnapshotSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("ResourceSnapshotSummaries", RESOURCE_SNAPSHOT_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListResourceSnapshotsResponse, T> g) {
        return obj -> g.apply((ListResourceSnapshotsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListResourceSnapshotsResponse> {
        /**
         * <p>
         * The token to retrieve the next set of results. If there are no additional results, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The token to retrieve the next set of results. If there are no additional results, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of resource snapshot summary objects.
         * </p>
         * 
         * @param resourceSnapshotSummaries
         *        An array of resource snapshot summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotSummaries(Collection<ResourceSnapshotSummary> resourceSnapshotSummaries);

        /**
         * <p>
         * An array of resource snapshot summary objects.
         * </p>
         * 
         * @param resourceSnapshotSummaries
         *        An array of resource snapshot summary objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotSummaries(ResourceSnapshotSummary... resourceSnapshotSummaries);

        /**
         * <p>
         * An array of resource snapshot summary objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #resourceSnapshotSummaries(List<ResourceSnapshotSummary>)}.
         * 
         * @param resourceSnapshotSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ResourceSnapshotSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceSnapshotSummaries(java.util.Collection<ResourceSnapshotSummary>)
         */
        Builder resourceSnapshotSummaries(Consumer<ResourceSnapshotSummary.Builder>... resourceSnapshotSummaries);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<ResourceSnapshotSummary> resourceSnapshotSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListResourceSnapshotsResponse model) {
            super(model);
            nextToken(model.nextToken);
            resourceSnapshotSummaries(model.resourceSnapshotSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<ResourceSnapshotSummary.Builder> getResourceSnapshotSummaries() {
            List<ResourceSnapshotSummary.Builder> result = ResourceSnapshotSummaryListCopier
                    .copyToBuilder(this.resourceSnapshotSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceSnapshotSummaries(Collection<ResourceSnapshotSummary.BuilderImpl> resourceSnapshotSummaries) {
            this.resourceSnapshotSummaries = ResourceSnapshotSummaryListCopier.copyFromBuilder(resourceSnapshotSummaries);
        }

        @Override
        public final Builder resourceSnapshotSummaries(Collection<ResourceSnapshotSummary> resourceSnapshotSummaries) {
            this.resourceSnapshotSummaries = ResourceSnapshotSummaryListCopier.copy(resourceSnapshotSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotSummaries(ResourceSnapshotSummary... resourceSnapshotSummaries) {
            resourceSnapshotSummaries(Arrays.asList(resourceSnapshotSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceSnapshotSummaries(Consumer<ResourceSnapshotSummary.Builder>... resourceSnapshotSummaries) {
            resourceSnapshotSummaries(Stream.of(resourceSnapshotSummaries)
                    .map(c -> ResourceSnapshotSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListResourceSnapshotsResponse build() {
            return new ListResourceSnapshotsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
