/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolutionsRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<ListSolutionsRequest.Builder, ListSolutionsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListSolutionsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> CATEGORY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Category")
            .getter(getter(ListSolutionsRequest::category))
            .setter(setter(Builder::category))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Category").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Identifier")
            .getter(getter(ListSolutionsRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListSolutionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSolutionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<SolutionSort> SORT_FIELD = SdkField.<SolutionSort> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(ListSolutionsRequest::sort)).setter(setter(Builder::sort))
            .constructor(SolutionSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(ListSolutionsRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CATEGORY_FIELD,
            IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> category;

    private final List<String> identifier;

    private final Integer maxResults;

    private final String nextToken;

    private final SolutionSort sort;

    private final List<String> status;

    private ListSolutionsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.category = builder.category;
        this.identifier = builder.identifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
        this.status = builder.status;
    }

    /**
     * <p>
     * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
     * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the solutions are listed in.
     * Use <code>AWS</code> to list solutions in the Amazon Web Services catalog, and <code>Sandbox</code> to list
     * solutions in a secure and isolated testing environment.
     * </p>
     * 
     * @return Specifies the catalog associated with the request. This field takes a string value from a predefined
     *         list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the solutions
     *         are listed in. Use <code>AWS</code> to list solutions in the Amazon Web Services catalog, and
     *         <code>Sandbox</code> to list solutions in a secure and isolated testing environment.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the Category property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCategory() {
        return category != null && !(category instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the solutions based on the category to which they belong. This allows partners to search for solutions
     * within specific categories, such as <code>Software</code>, <code>Consulting</code>, or
     * <code>Managed Services</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCategory} method.
     * </p>
     * 
     * @return Filters the solutions based on the category to which they belong. This allows partners to search for
     *         solutions within specific categories, such as <code>Software</code>, <code>Consulting</code>, or
     *         <code>Managed Services</code>.
     */
    public final List<String> category() {
        return category;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identifier property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentifier() {
        return identifier != null && !(identifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters the solutions based on their unique identifier. Use this filter to retrieve specific solutions by
     * providing the solution's identifier for accurate results.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentifier} method.
     * </p>
     * 
     * @return Filters the solutions based on their unique identifier. Use this filter to retrieve specific solutions by
     *         providing the solution's identifier for accurate results.
     */
    public final List<String> identifier() {
        return identifier;
    }

    /**
     * <p>
     * The maximum number of results returned by a single call. This value must be provided in the next call to retrieve
     * the next set of results.
     * </p>
     * <p>
     * Default: 20
     * </p>
     * 
     * @return The maximum number of results returned by a single call. This value must be provided in the next call to
     *         retrieve the next set of results.</p>
     *         <p>
     *         Default: 20
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in the
     * response only if there are additional result pages available.
     * </p>
     * 
     * @return A pagination token used to retrieve the next set of results in subsequent calls. This token is included
     *         in the response only if there are additional result pages available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Object that configures sorting done on the response. Default <code>Sort.SortBy</code> is <code>Identifier</code>.
     * </p>
     * 
     * @return Object that configures sorting done on the response. Default <code>Sort.SortBy</code> is
     *         <code>Identifier</code>.
     */
    public final SolutionSort sort() {
        return sort;
    }

    /**
     * <p>
     * Filters solutions based on their status. This filter helps partners manage their solution portfolios effectively.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filters solutions based on their status. This filter helps partners manage their solution portfolios
     *         effectively.
     */
    public final List<SolutionStatus> status() {
        return ListSolutionsRequestStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Filters solutions based on their status. This filter helps partners manage their solution portfolios effectively.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Filters solutions based on their status. This filter helps partners manage their solution portfolios
     *         effectively.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasCategory() ? category() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentifier() ? identifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionsRequest)) {
            return false;
        }
        ListSolutionsRequest other = (ListSolutionsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasCategory() == other.hasCategory()
                && Objects.equals(category(), other.category()) && hasIdentifier() == other.hasIdentifier()
                && Objects.equals(identifier(), other.identifier()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sort(), other.sort())
                && hasStatus() == other.hasStatus() && Objects.equals(statusAsStrings(), other.statusAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolutionsRequest").add("Catalog", catalog())
                .add("Category", hasCategory() ? category() : null).add("Identifier", hasIdentifier() ? identifier() : null)
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).add("Sort", sort())
                .add("Status", hasStatus() ? statusAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "Category":
            return Optional.ofNullable(clazz.cast(category()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("Category", CATEGORY_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionsRequest, T> g) {
        return obj -> g.apply((ListSolutionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSolutionsRequest> {
        /**
         * <p>
         * Specifies the catalog associated with the request. This field takes a string value from a predefined list:
         * <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the solutions are listed
         * in. Use <code>AWS</code> to list solutions in the Amazon Web Services catalog, and <code>Sandbox</code> to
         * list solutions in a secure and isolated testing environment.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the request. This field takes a string value from a predefined
         *        list: <code>AWS</code> or <code>Sandbox</code>. The catalog determines which environment the solutions
         *        are listed in. Use <code>AWS</code> to list solutions in the Amazon Web Services catalog, and
         *        <code>Sandbox</code> to list solutions in a secure and isolated testing environment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Filters the solutions based on the category to which they belong. This allows partners to search for
         * solutions within specific categories, such as <code>Software</code>, <code>Consulting</code>, or
         * <code>Managed Services</code>.
         * </p>
         * 
         * @param category
         *        Filters the solutions based on the category to which they belong. This allows partners to search for
         *        solutions within specific categories, such as <code>Software</code>, <code>Consulting</code>, or
         *        <code>Managed Services</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(Collection<String> category);

        /**
         * <p>
         * Filters the solutions based on the category to which they belong. This allows partners to search for
         * solutions within specific categories, such as <code>Software</code>, <code>Consulting</code>, or
         * <code>Managed Services</code>.
         * </p>
         * 
         * @param category
         *        Filters the solutions based on the category to which they belong. This allows partners to search for
         *        solutions within specific categories, such as <code>Software</code>, <code>Consulting</code>, or
         *        <code>Managed Services</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder category(String... category);

        /**
         * <p>
         * Filters the solutions based on their unique identifier. Use this filter to retrieve specific solutions by
         * providing the solution's identifier for accurate results.
         * </p>
         * 
         * @param identifier
         *        Filters the solutions based on their unique identifier. Use this filter to retrieve specific solutions
         *        by providing the solution's identifier for accurate results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(Collection<String> identifier);

        /**
         * <p>
         * Filters the solutions based on their unique identifier. Use this filter to retrieve specific solutions by
         * providing the solution's identifier for accurate results.
         * </p>
         * 
         * @param identifier
         *        Filters the solutions based on their unique identifier. Use this filter to retrieve specific solutions
         *        by providing the solution's identifier for accurate results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String... identifier);

        /**
         * <p>
         * The maximum number of results returned by a single call. This value must be provided in the next call to
         * retrieve the next set of results.
         * </p>
         * <p>
         * Default: 20
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results returned by a single call. This value must be provided in the next call
         *        to retrieve the next set of results.</p>
         *        <p>
         *        Default: 20
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in
         * the response only if there are additional result pages available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to retrieve the next set of results in subsequent calls. This token is
         *        included in the response only if there are additional result pages available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Object that configures sorting done on the response. Default <code>Sort.SortBy</code> is
         * <code>Identifier</code>.
         * </p>
         * 
         * @param sort
         *        Object that configures sorting done on the response. Default <code>Sort.SortBy</code> is
         *        <code>Identifier</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(SolutionSort sort);

        /**
         * <p>
         * Object that configures sorting done on the response. Default <code>Sort.SortBy</code> is
         * <code>Identifier</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link SolutionSort.Builder} avoiding the need
         * to create one manually via {@link SolutionSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SolutionSort.Builder#build()} is called immediately and its
         * result is passed to {@link #sort(SolutionSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link SolutionSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(SolutionSort)
         */
        default Builder sort(Consumer<SolutionSort.Builder> sort) {
            return sort(SolutionSort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * Filters solutions based on their status. This filter helps partners manage their solution portfolios
         * effectively.
         * </p>
         * 
         * @param status
         *        Filters solutions based on their status. This filter helps partners manage their solution portfolios
         *        effectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * Filters solutions based on their status. This filter helps partners manage their solution portfolios
         * effectively.
         * </p>
         * 
         * @param status
         *        Filters solutions based on their status. This filter helps partners manage their solution portfolios
         *        effectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * Filters solutions based on their status. This filter helps partners manage their solution portfolios
         * effectively.
         * </p>
         * 
         * @param status
         *        Filters solutions based on their status. This filter helps partners manage their solution portfolios
         *        effectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<SolutionStatus> status);

        /**
         * <p>
         * Filters solutions based on their status. This filter helps partners manage their solution portfolios
         * effectively.
         * </p>
         * 
         * @param status
         *        Filters solutions based on their status. This filter helps partners manage their solution portfolios
         *        effectively.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(SolutionStatus... status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<String> category = DefaultSdkAutoConstructList.getInstance();

        private List<String> identifier = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private SolutionSort sort;

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionsRequest model) {
            super(model);
            catalog(model.catalog);
            category(model.category);
            identifier(model.identifier);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sort(model.sort);
            statusWithStrings(model.status);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCategory() {
            if (category instanceof SdkAutoConstructList) {
                return null;
            }
            return category;
        }

        public final void setCategory(Collection<String> category) {
            this.category = ListSolutionsRequestCategoryListCopier.copy(category);
        }

        @Override
        public final Builder category(Collection<String> category) {
            this.category = ListSolutionsRequestCategoryListCopier.copy(category);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder category(String... category) {
            category(Arrays.asList(category));
            return this;
        }

        public final Collection<String> getIdentifier() {
            if (identifier instanceof SdkAutoConstructList) {
                return null;
            }
            return identifier;
        }

        public final void setIdentifier(Collection<String> identifier) {
            this.identifier = ListSolutionsRequestIdentifierListCopier.copy(identifier);
        }

        @Override
        public final Builder identifier(Collection<String> identifier) {
            this.identifier = ListSolutionsRequestIdentifierListCopier.copy(identifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifier(String... identifier) {
            identifier(Arrays.asList(identifier));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final SolutionSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(SolutionSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SolutionSort sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = ListSolutionsRequestStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = ListSolutionsRequestStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<SolutionStatus> status) {
            this.status = ListSolutionsRequestStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(SolutionStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListSolutionsRequest build() {
            return new ListSolutionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
