/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSolutionsResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListSolutionsResponse.Builder, ListSolutionsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListSolutionsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<SolutionBase>> SOLUTION_SUMMARIES_FIELD = SdkField
            .<List<SolutionBase>> builder(MarshallingType.LIST)
            .memberName("SolutionSummaries")
            .getter(getter(ListSolutionsResponse::solutionSummaries))
            .setter(setter(Builder::solutionSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SolutionSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SolutionBase> builder(MarshallingType.SDK_POJO)
                                            .constructor(SolutionBase::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SOLUTION_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SolutionBase> solutionSummaries;

    private ListSolutionsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.solutionSummaries = builder.solutionSummaries;
    }

    /**
     * <p>
     * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in the
     * response only if there are additional result pages available.
     * </p>
     * 
     * @return A pagination token used to retrieve the next set of results in subsequent calls. This token is included
     *         in the response only if there are additional result pages available.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SolutionSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSolutionSummaries() {
        return solutionSummaries != null && !(solutionSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array with minimal details for solutions matching the request criteria.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSolutionSummaries} method.
     * </p>
     * 
     * @return An array with minimal details for solutions matching the request criteria.
     */
    public final List<SolutionBase> solutionSummaries() {
        return solutionSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSolutionSummaries() ? solutionSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSolutionsResponse)) {
            return false;
        }
        ListSolutionsResponse other = (ListSolutionsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasSolutionSummaries() == other.hasSolutionSummaries()
                && Objects.equals(solutionSummaries(), other.solutionSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSolutionsResponse").add("NextToken", nextToken())
                .add("SolutionSummaries", hasSolutionSummaries() ? solutionSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "SolutionSummaries":
            return Optional.ofNullable(clazz.cast(solutionSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("SolutionSummaries", SOLUTION_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSolutionsResponse, T> g) {
        return obj -> g.apply((ListSolutionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSolutionsResponse> {
        /**
         * <p>
         * A pagination token used to retrieve the next set of results in subsequent calls. This token is included in
         * the response only if there are additional result pages available.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to retrieve the next set of results in subsequent calls. This token is
         *        included in the response only if there are additional result pages available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array with minimal details for solutions matching the request criteria.
         * </p>
         * 
         * @param solutionSummaries
         *        An array with minimal details for solutions matching the request criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionSummaries(Collection<SolutionBase> solutionSummaries);

        /**
         * <p>
         * An array with minimal details for solutions matching the request criteria.
         * </p>
         * 
         * @param solutionSummaries
         *        An array with minimal details for solutions matching the request criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutionSummaries(SolutionBase... solutionSummaries);

        /**
         * <p>
         * An array with minimal details for solutions matching the request criteria.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.SolutionBase.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.SolutionBase#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.SolutionBase.Builder#build()} is called
         * immediately and its result is passed to {@link #solutionSummaries(List<SolutionBase>)}.
         * 
         * @param solutionSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.SolutionBase.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #solutionSummaries(java.util.Collection<SolutionBase>)
         */
        Builder solutionSummaries(Consumer<SolutionBase.Builder>... solutionSummaries);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SolutionBase> solutionSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSolutionsResponse model) {
            super(model);
            nextToken(model.nextToken);
            solutionSummaries(model.solutionSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SolutionBase.Builder> getSolutionSummaries() {
            List<SolutionBase.Builder> result = SolutionListCopier.copyToBuilder(this.solutionSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSolutionSummaries(Collection<SolutionBase.BuilderImpl> solutionSummaries) {
            this.solutionSummaries = SolutionListCopier.copyFromBuilder(solutionSummaries);
        }

        @Override
        public final Builder solutionSummaries(Collection<SolutionBase> solutionSummaries) {
            this.solutionSummaries = SolutionListCopier.copy(solutionSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionSummaries(SolutionBase... solutionSummaries) {
            solutionSummaries(Arrays.asList(solutionSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutionSummaries(Consumer<SolutionBase.Builder>... solutionSummaries) {
            solutionSummaries(Stream.of(solutionSummaries).map(c -> SolutionBase.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSolutionsResponse build() {
            return new ListSolutionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
