/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines sorting options for retrieving Engagement Invitations. Sorting can be done based on various criteria like the
 * invitation date or status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpportunityEngagementInvitationSort implements SdkPojo, Serializable,
        ToCopyableBuilder<OpportunityEngagementInvitationSort.Builder, OpportunityEngagementInvitationSort> {
    private static final SdkField<String> SORT_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("SortBy")
            .getter(getter(OpportunityEngagementInvitationSort::sortByAsString)).setter(setter(Builder::sortBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortBy").build()).build();

    private static final SdkField<String> SORT_ORDER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SortOrder").getter(getter(OpportunityEngagementInvitationSort::sortOrderAsString))
            .setter(setter(Builder::sortOrder))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SortOrder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SORT_BY_FIELD,
            SORT_ORDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sortBy;

    private final String sortOrder;

    private OpportunityEngagementInvitationSort(BuilderImpl builder) {
        this.sortBy = builder.sortBy;
        this.sortOrder = builder.sortOrder;
    }

    /**
     * <p>
     * Specifies the field by which the Engagement Invitations are sorted. Common values include
     * <code>InvitationDate</code> and <code>Status</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link OpportunityEngagementInvitationSortName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the field by which the Engagement Invitations are sorted. Common values include
     *         <code>InvitationDate</code> and <code>Status</code>.
     * @see OpportunityEngagementInvitationSortName
     */
    public final OpportunityEngagementInvitationSortName sortBy() {
        return OpportunityEngagementInvitationSortName.fromValue(sortBy);
    }

    /**
     * <p>
     * Specifies the field by which the Engagement Invitations are sorted. Common values include
     * <code>InvitationDate</code> and <code>Status</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortBy} will
     * return {@link OpportunityEngagementInvitationSortName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #sortByAsString}.
     * </p>
     * 
     * @return Specifies the field by which the Engagement Invitations are sorted. Common values include
     *         <code>InvitationDate</code> and <code>Status</code>.
     * @see OpportunityEngagementInvitationSortName
     */
    public final String sortByAsString() {
        return sortBy;
    }

    /**
     * <p>
     * Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code> (ascending)
     * or <code>DESC</code> (descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code>
     *         (ascending) or <code>DESC</code> (descending).
     * @see SortOrder
     */
    public final SortOrder sortOrder() {
        return SortOrder.fromValue(sortOrder);
    }

    /**
     * <p>
     * Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code> (ascending)
     * or <code>DESC</code> (descending).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sortOrder} will
     * return {@link SortOrder#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sortOrderAsString}.
     * </p>
     * 
     * @return Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code>
     *         (ascending) or <code>DESC</code> (descending).
     * @see SortOrder
     */
    public final String sortOrderAsString() {
        return sortOrder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sortByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sortOrderAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunityEngagementInvitationSort)) {
            return false;
        }
        OpportunityEngagementInvitationSort other = (OpportunityEngagementInvitationSort) obj;
        return Objects.equals(sortByAsString(), other.sortByAsString())
                && Objects.equals(sortOrderAsString(), other.sortOrderAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpportunityEngagementInvitationSort").add("SortBy", sortByAsString())
                .add("SortOrder", sortOrderAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SortBy":
            return Optional.ofNullable(clazz.cast(sortByAsString()));
        case "SortOrder":
            return Optional.ofNullable(clazz.cast(sortOrderAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SortBy", SORT_BY_FIELD);
        map.put("SortOrder", SORT_ORDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpportunityEngagementInvitationSort, T> g) {
        return obj -> g.apply((OpportunityEngagementInvitationSort) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpportunityEngagementInvitationSort> {
        /**
         * <p>
         * Specifies the field by which the Engagement Invitations are sorted. Common values include
         * <code>InvitationDate</code> and <code>Status</code>.
         * </p>
         * 
         * @param sortBy
         *        Specifies the field by which the Engagement Invitations are sorted. Common values include
         *        <code>InvitationDate</code> and <code>Status</code>.
         * @see OpportunityEngagementInvitationSortName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityEngagementInvitationSortName
         */
        Builder sortBy(String sortBy);

        /**
         * <p>
         * Specifies the field by which the Engagement Invitations are sorted. Common values include
         * <code>InvitationDate</code> and <code>Status</code>.
         * </p>
         * 
         * @param sortBy
         *        Specifies the field by which the Engagement Invitations are sorted. Common values include
         *        <code>InvitationDate</code> and <code>Status</code>.
         * @see OpportunityEngagementInvitationSortName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityEngagementInvitationSortName
         */
        Builder sortBy(OpportunityEngagementInvitationSortName sortBy);

        /**
         * <p>
         * Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code>
         * (ascending) or <code>DESC</code> (descending).
         * </p>
         * 
         * @param sortOrder
         *        Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code>
         *        (ascending) or <code>DESC</code> (descending).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(String sortOrder);

        /**
         * <p>
         * Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code>
         * (ascending) or <code>DESC</code> (descending).
         * </p>
         * 
         * @param sortOrder
         *        Defines the order in which the Engagement Invitations are sorted. The values can be <code>ASC</code>
         *        (ascending) or <code>DESC</code> (descending).
         * @see SortOrder
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SortOrder
         */
        Builder sortOrder(SortOrder sortOrder);
    }

    static final class BuilderImpl implements Builder {
        private String sortBy;

        private String sortOrder;

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunityEngagementInvitationSort model) {
            sortBy(model.sortBy);
            sortOrder(model.sortOrder);
        }

        public final String getSortBy() {
            return sortBy;
        }

        public final void setSortBy(String sortBy) {
            this.sortBy = sortBy;
        }

        @Override
        public final Builder sortBy(String sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        @Override
        public final Builder sortBy(OpportunityEngagementInvitationSortName sortBy) {
            this.sortBy(sortBy == null ? null : sortBy.toString());
            return this;
        }

        public final String getSortOrder() {
            return sortOrder;
        }

        public final void setSortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
        }

        @Override
        public final Builder sortOrder(String sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        @Override
        public final Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder(sortOrder == null ? null : sortOrder.toString());
            return this;
        }

        @Override
        public OpportunityEngagementInvitationSort build() {
            return new OpportunityEngagementInvitationSort(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
