/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the data payload of an Engagement Invitation for a specific opportunity. This contains detailed
 * information that partners use to evaluate the engagement.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpportunityInvitationPayload implements SdkPojo, Serializable,
        ToCopyableBuilder<OpportunityInvitationPayload.Builder, OpportunityInvitationPayload> {
    private static final SdkField<EngagementCustomer> CUSTOMER_FIELD = SdkField
            .<EngagementCustomer> builder(MarshallingType.SDK_POJO).memberName("Customer")
            .getter(getter(OpportunityInvitationPayload::customer)).setter(setter(Builder::customer))
            .constructor(EngagementCustomer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<ProjectDetails> PROJECT_FIELD = SdkField.<ProjectDetails> builder(MarshallingType.SDK_POJO)
            .memberName("Project").getter(getter(OpportunityInvitationPayload::project)).setter(setter(Builder::project))
            .constructor(ProjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final SdkField<List<String>> RECEIVER_RESPONSIBILITIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReceiverResponsibilities")
            .getter(getter(OpportunityInvitationPayload::receiverResponsibilitiesAsStrings))
            .setter(setter(Builder::receiverResponsibilitiesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReceiverResponsibilities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<SenderContact>> SENDER_CONTACTS_FIELD = SdkField
            .<List<SenderContact>> builder(MarshallingType.LIST)
            .memberName("SenderContacts")
            .getter(getter(OpportunityInvitationPayload::senderContacts))
            .setter(setter(Builder::senderContacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderContacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SenderContact> builder(MarshallingType.SDK_POJO)
                                            .constructor(SenderContact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_FIELD, PROJECT_FIELD,
            RECEIVER_RESPONSIBILITIES_FIELD, SENDER_CONTACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EngagementCustomer customer;

    private final ProjectDetails project;

    private final List<String> receiverResponsibilities;

    private final List<SenderContact> senderContacts;

    private OpportunityInvitationPayload(BuilderImpl builder) {
        this.customer = builder.customer;
        this.project = builder.project;
        this.receiverResponsibilities = builder.receiverResponsibilities;
        this.senderContacts = builder.senderContacts;
    }

    /**
     * <p>
     * Contains information about the customer related to the opportunity in the Engagement Invitation. This data helps
     * partners understand the customer’s profile and requirements.
     * </p>
     * 
     * @return Contains information about the customer related to the opportunity in the Engagement Invitation. This
     *         data helps partners understand the customer’s profile and requirements.
     */
    public final EngagementCustomer customer() {
        return customer;
    }

    /**
     * <p>
     * Describes the project details associated with the opportunity, including the customer’s needs and the scope of
     * work expected to be performed.
     * </p>
     * 
     * @return Describes the project details associated with the opportunity, including the customer’s needs and the
     *         scope of work expected to be performed.
     */
    public final ProjectDetails project() {
        return project;
    }

    /**
     * <p>
     * Outlines the responsibilities or expectations of the receiver in the context of the invitation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReceiverResponsibilities} method.
     * </p>
     * 
     * @return Outlines the responsibilities or expectations of the receiver in the context of the invitation.
     */
    public final List<ReceiverResponsibility> receiverResponsibilities() {
        return ReceiverResponsibilityListCopier.copyStringToEnum(receiverResponsibilities);
    }

    /**
     * For responses, this returns true if the service returned a value for the ReceiverResponsibilities property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasReceiverResponsibilities() {
        return receiverResponsibilities != null && !(receiverResponsibilities instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Outlines the responsibilities or expectations of the receiver in the context of the invitation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReceiverResponsibilities} method.
     * </p>
     * 
     * @return Outlines the responsibilities or expectations of the receiver in the context of the invitation.
     */
    public final List<String> receiverResponsibilitiesAsStrings() {
        return receiverResponsibilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the SenderContacts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSenderContacts() {
        return senderContacts != null && !(senderContacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the contact details of the AWS representatives involved in sending the Engagement Invitation. These
     * contacts are opportunity stakeholders.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSenderContacts} method.
     * </p>
     * 
     * @return Represents the contact details of the AWS representatives involved in sending the Engagement Invitation.
     *         These contacts are opportunity stakeholders.
     */
    public final List<SenderContact> senderContacts() {
        return senderContacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(hasReceiverResponsibilities() ? receiverResponsibilitiesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSenderContacts() ? senderContacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunityInvitationPayload)) {
            return false;
        }
        OpportunityInvitationPayload other = (OpportunityInvitationPayload) obj;
        return Objects.equals(customer(), other.customer()) && Objects.equals(project(), other.project())
                && hasReceiverResponsibilities() == other.hasReceiverResponsibilities()
                && Objects.equals(receiverResponsibilitiesAsStrings(), other.receiverResponsibilitiesAsStrings())
                && hasSenderContacts() == other.hasSenderContacts() && Objects.equals(senderContacts(), other.senderContacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpportunityInvitationPayload").add("Customer", customer()).add("Project", project())
                .add("ReceiverResponsibilities", hasReceiverResponsibilities() ? receiverResponsibilitiesAsStrings() : null)
                .add("SenderContacts", hasSenderContacts() ? senderContacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        case "ReceiverResponsibilities":
            return Optional.ofNullable(clazz.cast(receiverResponsibilitiesAsStrings()));
        case "SenderContacts":
            return Optional.ofNullable(clazz.cast(senderContacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("ReceiverResponsibilities", RECEIVER_RESPONSIBILITIES_FIELD);
        map.put("SenderContacts", SENDER_CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpportunityInvitationPayload, T> g) {
        return obj -> g.apply((OpportunityInvitationPayload) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpportunityInvitationPayload> {
        /**
         * <p>
         * Contains information about the customer related to the opportunity in the Engagement Invitation. This data
         * helps partners understand the customer’s profile and requirements.
         * </p>
         * 
         * @param customer
         *        Contains information about the customer related to the opportunity in the Engagement Invitation. This
         *        data helps partners understand the customer’s profile and requirements.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(EngagementCustomer customer);

        /**
         * <p>
         * Contains information about the customer related to the opportunity in the Engagement Invitation. This data
         * helps partners understand the customer’s profile and requirements.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngagementCustomer.Builder} avoiding the
         * need to create one manually via {@link EngagementCustomer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngagementCustomer.Builder#build()} is called immediately and its
         * result is passed to {@link #customer(EngagementCustomer)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link EngagementCustomer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(EngagementCustomer)
         */
        default Builder customer(Consumer<EngagementCustomer.Builder> customer) {
            return customer(EngagementCustomer.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * Describes the project details associated with the opportunity, including the customer’s needs and the scope
         * of work expected to be performed.
         * </p>
         * 
         * @param project
         *        Describes the project details associated with the opportunity, including the customer’s needs and the
         *        scope of work expected to be performed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectDetails project);

        /**
         * <p>
         * Describes the project details associated with the opportunity, including the customer’s needs and the scope
         * of work expected to be performed.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectDetails.Builder} avoiding the need
         * to create one manually via {@link ProjectDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #project(ProjectDetails)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectDetails)
         */
        default Builder project(Consumer<ProjectDetails.Builder> project) {
            return project(ProjectDetails.builder().applyMutation(project).build());
        }

        /**
         * <p>
         * Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * </p>
         * 
         * @param receiverResponsibilities
         *        Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverResponsibilitiesWithStrings(Collection<String> receiverResponsibilities);

        /**
         * <p>
         * Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * </p>
         * 
         * @param receiverResponsibilities
         *        Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverResponsibilitiesWithStrings(String... receiverResponsibilities);

        /**
         * <p>
         * Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * </p>
         * 
         * @param receiverResponsibilities
         *        Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverResponsibilities(Collection<ReceiverResponsibility> receiverResponsibilities);

        /**
         * <p>
         * Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * </p>
         * 
         * @param receiverResponsibilities
         *        Outlines the responsibilities or expectations of the receiver in the context of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiverResponsibilities(ReceiverResponsibility... receiverResponsibilities);

        /**
         * <p>
         * Represents the contact details of the AWS representatives involved in sending the Engagement Invitation.
         * These contacts are opportunity stakeholders.
         * </p>
         * 
         * @param senderContacts
         *        Represents the contact details of the AWS representatives involved in sending the Engagement
         *        Invitation. These contacts are opportunity stakeholders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderContacts(Collection<SenderContact> senderContacts);

        /**
         * <p>
         * Represents the contact details of the AWS representatives involved in sending the Engagement Invitation.
         * These contacts are opportunity stakeholders.
         * </p>
         * 
         * @param senderContacts
         *        Represents the contact details of the AWS representatives involved in sending the Engagement
         *        Invitation. These contacts are opportunity stakeholders.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderContacts(SenderContact... senderContacts);

        /**
         * <p>
         * Represents the contact details of the AWS representatives involved in sending the Engagement Invitation.
         * These contacts are opportunity stakeholders.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.SenderContact.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.SenderContact#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.SenderContact.Builder#build()} is called
         * immediately and its result is passed to {@link #senderContacts(List<SenderContact>)}.
         * 
         * @param senderContacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.SenderContact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #senderContacts(java.util.Collection<SenderContact>)
         */
        Builder senderContacts(Consumer<SenderContact.Builder>... senderContacts);
    }

    static final class BuilderImpl implements Builder {
        private EngagementCustomer customer;

        private ProjectDetails project;

        private List<String> receiverResponsibilities = DefaultSdkAutoConstructList.getInstance();

        private List<SenderContact> senderContacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunityInvitationPayload model) {
            customer(model.customer);
            project(model.project);
            receiverResponsibilitiesWithStrings(model.receiverResponsibilities);
            senderContacts(model.senderContacts);
        }

        public final EngagementCustomer.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(EngagementCustomer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(EngagementCustomer customer) {
            this.customer = customer;
            return this;
        }

        public final ProjectDetails.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(ProjectDetails.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectDetails project) {
            this.project = project;
            return this;
        }

        public final Collection<String> getReceiverResponsibilities() {
            if (receiverResponsibilities instanceof SdkAutoConstructList) {
                return null;
            }
            return receiverResponsibilities;
        }

        public final void setReceiverResponsibilities(Collection<String> receiverResponsibilities) {
            this.receiverResponsibilities = ReceiverResponsibilityListCopier.copy(receiverResponsibilities);
        }

        @Override
        public final Builder receiverResponsibilitiesWithStrings(Collection<String> receiverResponsibilities) {
            this.receiverResponsibilities = ReceiverResponsibilityListCopier.copy(receiverResponsibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverResponsibilitiesWithStrings(String... receiverResponsibilities) {
            receiverResponsibilitiesWithStrings(Arrays.asList(receiverResponsibilities));
            return this;
        }

        @Override
        public final Builder receiverResponsibilities(Collection<ReceiverResponsibility> receiverResponsibilities) {
            this.receiverResponsibilities = ReceiverResponsibilityListCopier.copyEnumToString(receiverResponsibilities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder receiverResponsibilities(ReceiverResponsibility... receiverResponsibilities) {
            receiverResponsibilities(Arrays.asList(receiverResponsibilities));
            return this;
        }

        public final List<SenderContact.Builder> getSenderContacts() {
            List<SenderContact.Builder> result = SenderContactListCopier.copyToBuilder(this.senderContacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSenderContacts(Collection<SenderContact.BuilderImpl> senderContacts) {
            this.senderContacts = SenderContactListCopier.copyFromBuilder(senderContacts);
        }

        @Override
        public final Builder senderContacts(Collection<SenderContact> senderContacts) {
            this.senderContacts = SenderContactListCopier.copy(senderContacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderContacts(SenderContact... senderContacts) {
            senderContacts(Arrays.asList(senderContacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderContacts(Consumer<SenderContact.Builder>... senderContacts) {
            senderContacts(Stream.of(senderContacts).map(c -> SenderContact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public OpportunityInvitationPayload build() {
            return new OpportunityInvitationPayload(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
