/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains an <code>Opportunity</code>'s subset of fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpportunitySummary implements SdkPojo, Serializable,
        ToCopyableBuilder<OpportunitySummary.Builder, OpportunitySummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(OpportunitySummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(OpportunitySummary::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<Instant> CREATED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedDate")
            .getter(getter(OpportunitySummary::createdDate))
            .setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<CustomerSummary> CUSTOMER_FIELD = SdkField.<CustomerSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Customer").getter(getter(OpportunitySummary::customer)).setter(setter(Builder::customer))
            .constructor(CustomerSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(OpportunitySummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<Instant> LAST_MODIFIED_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastModifiedDate")
            .getter(getter(OpportunitySummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<LifeCycleSummary> LIFE_CYCLE_FIELD = SdkField
            .<LifeCycleSummary> builder(MarshallingType.SDK_POJO).memberName("LifeCycle")
            .getter(getter(OpportunitySummary::lifeCycle)).setter(setter(Builder::lifeCycle))
            .constructor(LifeCycleSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycle").build()).build();

    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpportunityType").getter(getter(OpportunitySummary::opportunityTypeAsString))
            .setter(setter(Builder::opportunityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()).build();

    private static final SdkField<String> PARTNER_OPPORTUNITY_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("PartnerOpportunityIdentifier")
            .getter(getter(OpportunitySummary::partnerOpportunityIdentifier))
            .setter(setter(Builder::partnerOpportunityIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PartnerOpportunityIdentifier")
                    .build()).build();

    private static final SdkField<ProjectSummary> PROJECT_FIELD = SdkField.<ProjectSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Project").getter(getter(OpportunitySummary::project)).setter(setter(Builder::project))
            .constructor(ProjectSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CATALOG_FIELD,
            CREATED_DATE_FIELD, CUSTOMER_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, LIFE_CYCLE_FIELD, OPPORTUNITY_TYPE_FIELD,
            PARTNER_OPPORTUNITY_IDENTIFIER_FIELD, PROJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String catalog;

    private final Instant createdDate;

    private final CustomerSummary customer;

    private final String id;

    private final Instant lastModifiedDate;

    private final LifeCycleSummary lifeCycle;

    private final String opportunityType;

    private final String partnerOpportunityIdentifier;

    private final ProjectSummary project;

    private OpportunitySummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.catalog = builder.catalog;
        this.createdDate = builder.createdDate;
        this.customer = builder.customer;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lifeCycle = builder.lifeCycle;
        this.opportunityType = builder.opportunityType;
        this.partnerOpportunityIdentifier = builder.partnerOpportunityIdentifier;
        this.project = builder.project;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the opportunity. This globally unique identifier can be used for IAM policies
     * and cross-service references.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the opportunity. This globally unique identifier can be used for IAM
     *         policies and cross-service references.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * Specifies the catalog associated with the opportunity, either <code>AWS</code> or <code>Sandbox</code>. This
     * indicates the environment in which the opportunity is managed.
     * </p>
     * 
     * @return Specifies the catalog associated with the opportunity, either <code>AWS</code> or <code>Sandbox</code>.
     *         This indicates the environment in which the opportunity is managed.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * <code>DateTime</code> when the <code>Opportunity</code> was last created.
     * </p>
     * 
     * @return <code>DateTime</code> when the <code>Opportunity</code> was last created.
     */
    public final Instant createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * An object that contains the <code>Opportunity</code>'s customer details.
     * </p>
     * 
     * @return An object that contains the <code>Opportunity</code>'s customer details.
     */
    public final CustomerSummary customer() {
        return customer;
    }

    /**
     * <p>
     * Read-only, system-generated <code>Opportunity</code> unique identifier.
     * </p>
     * 
     * @return Read-only, system-generated <code>Opportunity</code> unique identifier.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * <code>DateTime</code> when the <code>Opportunity</code> was last modified.
     * </p>
     * 
     * @return <code>DateTime</code> when the <code>Opportunity</code> was last modified.
     */
    public final Instant lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * An object that contains the <code>Opportunity</code>'s lifecycle details.
     * </p>
     * 
     * @return An object that contains the <code>Opportunity</code>'s lifecycle details.
     */
    public final LifeCycleSummary lifeCycle() {
        return lifeCycle;
    }

    /**
     * <p>
     * Specifies opportunity type as a renewal, new, or expansion.
     * </p>
     * <p>
     * Opportunity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * New Opportunity: Represents a new business opportunity with a potential customer that's not previously engaged
     * with your solutions or services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a current
     * customer, ensuring continuity of service.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or subscription,
     * either by adding new services or increasing the volume of existing services for a current customer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opportunityType}
     * will return {@link OpportunityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opportunityTypeAsString}.
     * </p>
     * 
     * @return Specifies opportunity type as a renewal, new, or expansion.</p>
     *         <p>
     *         Opportunity types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         New Opportunity: Represents a new business opportunity with a potential customer that's not previously
     *         engaged with your solutions or services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a
     *         current customer, ensuring continuity of service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or
     *         subscription, either by adding new services or increasing the volume of existing services for a current
     *         customer.
     *         </p>
     *         </li>
     * @see OpportunityType
     */
    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(opportunityType);
    }

    /**
     * <p>
     * Specifies opportunity type as a renewal, new, or expansion.
     * </p>
     * <p>
     * Opportunity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * New Opportunity: Represents a new business opportunity with a potential customer that's not previously engaged
     * with your solutions or services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a current
     * customer, ensuring continuity of service.
     * </p>
     * </li>
     * <li>
     * <p>
     * Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or subscription,
     * either by adding new services or increasing the volume of existing services for a current customer.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opportunityType}
     * will return {@link OpportunityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opportunityTypeAsString}.
     * </p>
     * 
     * @return Specifies opportunity type as a renewal, new, or expansion.</p>
     *         <p>
     *         Opportunity types:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         New Opportunity: Represents a new business opportunity with a potential customer that's not previously
     *         engaged with your solutions or services.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a
     *         current customer, ensuring continuity of service.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or
     *         subscription, either by adding new services or increasing the volume of existing services for a current
     *         customer.
     *         </p>
     *         </li>
     * @see OpportunityType
     */
    public final String opportunityTypeAsString() {
        return opportunityType;
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s unique identifier in the partner's CRM system. This value is essential
     * to track and reconcile because it's included in the outbound payload sent back to the partner. It allows partners
     * to link an opportunity to their CRM.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s unique identifier in the partner's CRM system. This value is
     *         essential to track and reconcile because it's included in the outbound payload sent back to the partner.
     *         It allows partners to link an opportunity to their CRM.
     */
    public final String partnerOpportunityIdentifier() {
        return partnerOpportunityIdentifier;
    }

    /**
     * <p>
     * An object that contains the <code>Opportunity</code>'s project details summary.
     * </p>
     * 
     * @return An object that contains the <code>Opportunity</code>'s project details summary.
     */
    public final ProjectSummary project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(partnerOpportunityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunitySummary)) {
            return false;
        }
        OpportunitySummary other = (OpportunitySummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(createdDate(), other.createdDate()) && Objects.equals(customer(), other.customer())
                && Objects.equals(id(), other.id()) && Objects.equals(lastModifiedDate(), other.lastModifiedDate())
                && Objects.equals(lifeCycle(), other.lifeCycle())
                && Objects.equals(opportunityTypeAsString(), other.opportunityTypeAsString())
                && Objects.equals(partnerOpportunityIdentifier(), other.partnerOpportunityIdentifier())
                && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpportunitySummary").add("Arn", arn()).add("Catalog", catalog())
                .add("CreatedDate", createdDate()).add("Customer", customer()).add("Id", id())
                .add("LastModifiedDate", lastModifiedDate()).add("LifeCycle", lifeCycle())
                .add("OpportunityType", opportunityTypeAsString())
                .add("PartnerOpportunityIdentifier", partnerOpportunityIdentifier()).add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "CreatedDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "LastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "LifeCycle":
            return Optional.ofNullable(clazz.cast(lifeCycle()));
        case "OpportunityType":
            return Optional.ofNullable(clazz.cast(opportunityTypeAsString()));
        case "PartnerOpportunityIdentifier":
            return Optional.ofNullable(clazz.cast(partnerOpportunityIdentifier()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedDate", CREATED_DATE_FIELD);
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Id", ID_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LifeCycle", LIFE_CYCLE_FIELD);
        map.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
        map.put("PartnerOpportunityIdentifier", PARTNER_OPPORTUNITY_IDENTIFIER_FIELD);
        map.put("Project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpportunitySummary, T> g) {
        return obj -> g.apply((OpportunitySummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpportunitySummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the opportunity. This globally unique identifier can be used for IAM
         * policies and cross-service references.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the opportunity. This globally unique identifier can be used for
         *        IAM policies and cross-service references.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * Specifies the catalog associated with the opportunity, either <code>AWS</code> or <code>Sandbox</code>. This
         * indicates the environment in which the opportunity is managed.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog associated with the opportunity, either <code>AWS</code> or <code>Sandbox</code>
         *        . This indicates the environment in which the opportunity is managed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * <code>DateTime</code> when the <code>Opportunity</code> was last created.
         * </p>
         * 
         * @param createdDate
         *        <code>DateTime</code> when the <code>Opportunity</code> was last created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Instant createdDate);

        /**
         * <p>
         * An object that contains the <code>Opportunity</code>'s customer details.
         * </p>
         * 
         * @param customer
         *        An object that contains the <code>Opportunity</code>'s customer details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(CustomerSummary customer);

        /**
         * <p>
         * An object that contains the <code>Opportunity</code>'s customer details.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomerSummary.Builder} avoiding the
         * need to create one manually via {@link CustomerSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #customer(CustomerSummary)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link CustomerSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(CustomerSummary)
         */
        default Builder customer(Consumer<CustomerSummary.Builder> customer) {
            return customer(CustomerSummary.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * Read-only, system-generated <code>Opportunity</code> unique identifier.
         * </p>
         * 
         * @param id
         *        Read-only, system-generated <code>Opportunity</code> unique identifier.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * <code>DateTime</code> when the <code>Opportunity</code> was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        <code>DateTime</code> when the <code>Opportunity</code> was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Instant lastModifiedDate);

        /**
         * <p>
         * An object that contains the <code>Opportunity</code>'s lifecycle details.
         * </p>
         * 
         * @param lifeCycle
         *        An object that contains the <code>Opportunity</code>'s lifecycle details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifeCycle(LifeCycleSummary lifeCycle);

        /**
         * <p>
         * An object that contains the <code>Opportunity</code>'s lifecycle details.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleSummary.Builder} avoiding the
         * need to create one manually via {@link LifeCycleSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #lifeCycle(LifeCycleSummary)}.
         * 
         * @param lifeCycle
         *        a consumer that will call methods on {@link LifeCycleSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifeCycle(LifeCycleSummary)
         */
        default Builder lifeCycle(Consumer<LifeCycleSummary.Builder> lifeCycle) {
            return lifeCycle(LifeCycleSummary.builder().applyMutation(lifeCycle).build());
        }

        /**
         * <p>
         * Specifies opportunity type as a renewal, new, or expansion.
         * </p>
         * <p>
         * Opportunity types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * New Opportunity: Represents a new business opportunity with a potential customer that's not previously
         * engaged with your solutions or services.
         * </p>
         * </li>
         * <li>
         * <p>
         * Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a current
         * customer, ensuring continuity of service.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or subscription,
         * either by adding new services or increasing the volume of existing services for a current customer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param opportunityType
         *        Specifies opportunity type as a renewal, new, or expansion.</p>
         *        <p>
         *        Opportunity types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        New Opportunity: Represents a new business opportunity with a potential customer that's not previously
         *        engaged with your solutions or services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a
         *        current customer, ensuring continuity of service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or
         *        subscription, either by adding new services or increasing the volume of existing services for a
         *        current customer.
         *        </p>
         *        </li>
         * @see OpportunityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityType
         */
        Builder opportunityType(String opportunityType);

        /**
         * <p>
         * Specifies opportunity type as a renewal, new, or expansion.
         * </p>
         * <p>
         * Opportunity types:
         * </p>
         * <ul>
         * <li>
         * <p>
         * New Opportunity: Represents a new business opportunity with a potential customer that's not previously
         * engaged with your solutions or services.
         * </p>
         * </li>
         * <li>
         * <p>
         * Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a current
         * customer, ensuring continuity of service.
         * </p>
         * </li>
         * <li>
         * <p>
         * Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or subscription,
         * either by adding new services or increasing the volume of existing services for a current customer.
         * </p>
         * </li>
         * </ul>
         * 
         * @param opportunityType
         *        Specifies opportunity type as a renewal, new, or expansion.</p>
         *        <p>
         *        Opportunity types:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        New Opportunity: Represents a new business opportunity with a potential customer that's not previously
         *        engaged with your solutions or services.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Renewal Opportunity: Represents an opportunity to renew an existing contract or subscription with a
         *        current customer, ensuring continuity of service.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Expansion Opportunity: Represents an opportunity to expand the scope of an existing contract or
         *        subscription, either by adding new services or increasing the volume of existing services for a
         *        current customer.
         *        </p>
         *        </li>
         * @see OpportunityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityType
         */
        Builder opportunityType(OpportunityType opportunityType);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s unique identifier in the partner's CRM system. This value is
         * essential to track and reconcile because it's included in the outbound payload sent back to the partner. It
         * allows partners to link an opportunity to their CRM.
         * </p>
         * 
         * @param partnerOpportunityIdentifier
         *        Specifies the <code>Opportunity</code>'s unique identifier in the partner's CRM system. This value is
         *        essential to track and reconcile because it's included in the outbound payload sent back to the
         *        partner. It allows partners to link an opportunity to their CRM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier);

        /**
         * <p>
         * An object that contains the <code>Opportunity</code>'s project details summary.
         * </p>
         * 
         * @param project
         *        An object that contains the <code>Opportunity</code>'s project details summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectSummary project);

        /**
         * <p>
         * An object that contains the <code>Opportunity</code>'s project details summary.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectSummary.Builder} avoiding the need
         * to create one manually via {@link ProjectSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #project(ProjectSummary)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectSummary)
         */
        default Builder project(Consumer<ProjectSummary.Builder> project) {
            return project(ProjectSummary.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String catalog;

        private Instant createdDate;

        private CustomerSummary customer;

        private String id;

        private Instant lastModifiedDate;

        private LifeCycleSummary lifeCycle;

        private String opportunityType;

        private String partnerOpportunityIdentifier;

        private ProjectSummary project;

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunitySummary model) {
            arn(model.arn);
            catalog(model.catalog);
            createdDate(model.createdDate);
            customer(model.customer);
            id(model.id);
            lastModifiedDate(model.lastModifiedDate);
            lifeCycle(model.lifeCycle);
            opportunityType(model.opportunityType);
            partnerOpportunityIdentifier(model.partnerOpportunityIdentifier);
            project(model.project);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Instant getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Instant createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Instant createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final CustomerSummary.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(CustomerSummary.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(CustomerSummary customer) {
            this.customer = customer;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Instant lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final LifeCycleSummary.Builder getLifeCycle() {
            return lifeCycle != null ? lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycleSummary.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        public final Builder lifeCycle(LifeCycleSummary lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final String getOpportunityType() {
            return opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final String getPartnerOpportunityIdentifier() {
            return partnerOpportunityIdentifier;
        }

        public final void setPartnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
        }

        @Override
        public final Builder partnerOpportunityIdentifier(String partnerOpportunityIdentifier) {
            this.partnerOpportunityIdentifier = partnerOpportunityIdentifier;
            return this;
        }

        public final ProjectSummary.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(ProjectSummary.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectSummary project) {
            this.project = project;
            return this;
        }

        @Override
        public OpportunitySummary build() {
            return new OpportunitySummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
