/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a comprehensive view of an opportunity summary, including lifecycle information, team details, opportunity
 * type, primary needs from AWS, and associated project information.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpportunitySummaryView implements SdkPojo, Serializable,
        ToCopyableBuilder<OpportunitySummaryView.Builder, OpportunitySummaryView> {
    private static final SdkField<Customer> CUSTOMER_FIELD = SdkField.<Customer> builder(MarshallingType.SDK_POJO)
            .memberName("Customer").getter(getter(OpportunitySummaryView::customer)).setter(setter(Builder::customer))
            .constructor(Customer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<LifeCycleForView> LIFECYCLE_FIELD = SdkField
            .<LifeCycleForView> builder(MarshallingType.SDK_POJO).memberName("Lifecycle")
            .getter(getter(OpportunitySummaryView::lifecycle)).setter(setter(Builder::lifecycle))
            .constructor(LifeCycleForView::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()).build();

    private static final SdkField<List<Contact>> OPPORTUNITY_TEAM_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("OpportunityTeam")
            .getter(getter(OpportunitySummaryView::opportunityTeam))
            .setter(setter(Builder::opportunityTeam))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityTeam").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> OPPORTUNITY_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OpportunityType").getter(getter(OpportunitySummaryView::opportunityTypeAsString))
            .setter(setter(Builder::opportunityType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OpportunityType").build()).build();

    private static final SdkField<List<String>> PRIMARY_NEEDS_FROM_AWS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PrimaryNeedsFromAws")
            .getter(getter(OpportunitySummaryView::primaryNeedsFromAwsAsStrings))
            .setter(setter(Builder::primaryNeedsFromAwsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PrimaryNeedsFromAws").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ProjectView> PROJECT_FIELD = SdkField.<ProjectView> builder(MarshallingType.SDK_POJO)
            .memberName("Project").getter(getter(OpportunitySummaryView::project)).setter(setter(Builder::project))
            .constructor(ProjectView::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final SdkField<RelatedEntityIdentifiers> RELATED_ENTITY_IDENTIFIERS_FIELD = SdkField
            .<RelatedEntityIdentifiers> builder(MarshallingType.SDK_POJO).memberName("RelatedEntityIdentifiers")
            .getter(getter(OpportunitySummaryView::relatedEntityIdentifiers)).setter(setter(Builder::relatedEntityIdentifiers))
            .constructor(RelatedEntityIdentifiers::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RelatedEntityIdentifiers").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_FIELD,
            LIFECYCLE_FIELD, OPPORTUNITY_TEAM_FIELD, OPPORTUNITY_TYPE_FIELD, PRIMARY_NEEDS_FROM_AWS_FIELD, PROJECT_FIELD,
            RELATED_ENTITY_IDENTIFIERS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Customer customer;

    private final LifeCycleForView lifecycle;

    private final List<Contact> opportunityTeam;

    private final String opportunityType;

    private final List<String> primaryNeedsFromAws;

    private final ProjectView project;

    private final RelatedEntityIdentifiers relatedEntityIdentifiers;

    private OpportunitySummaryView(BuilderImpl builder) {
        this.customer = builder.customer;
        this.lifecycle = builder.lifecycle;
        this.opportunityTeam = builder.opportunityTeam;
        this.opportunityType = builder.opportunityType;
        this.primaryNeedsFromAws = builder.primaryNeedsFromAws;
        this.project = builder.project;
        this.relatedEntityIdentifiers = builder.relatedEntityIdentifiers;
    }

    /**
     * Returns the value of the Customer property for this object.
     * 
     * @return The value of the Customer property for this object.
     */
    public final Customer customer() {
        return customer;
    }

    /**
     * <p>
     * Contains information about the opportunity's lifecycle, including its current stage, status, and important dates
     * such as creation and last modification times.
     * </p>
     * 
     * @return Contains information about the opportunity's lifecycle, including its current stage, status, and
     *         important dates such as creation and last modification times.
     */
    public final LifeCycleForView lifecycle() {
        return lifecycle;
    }

    /**
     * For responses, this returns true if the service returned a value for the OpportunityTeam property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasOpportunityTeam() {
        return opportunityTeam != null && !(opportunityTeam instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the internal team handling the opportunity. Specify the members involved in collaborating on an
     * opportunity within the partner's organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOpportunityTeam} method.
     * </p>
     * 
     * @return Represents the internal team handling the opportunity. Specify the members involved in collaborating on
     *         an opportunity within the partner's organization.
     */
    public final List<Contact> opportunityTeam() {
        return opportunityTeam;
    }

    /**
     * <p>
     * Specifies the opportunity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opportunityType}
     * will return {@link OpportunityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opportunityTypeAsString}.
     * </p>
     * 
     * @return Specifies the opportunity type.
     * @see OpportunityType
     */
    public final OpportunityType opportunityType() {
        return OpportunityType.fromValue(opportunityType);
    }

    /**
     * <p>
     * Specifies the opportunity type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #opportunityType}
     * will return {@link OpportunityType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #opportunityTypeAsString}.
     * </p>
     * 
     * @return Specifies the opportunity type.
     * @see OpportunityType
     */
    public final String opportunityTypeAsString() {
        return opportunityType;
    }

    /**
     * <p>
     * Identifies the type of support the partner needs from AWS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryNeedsFromAws} method.
     * </p>
     * 
     * @return Identifies the type of support the partner needs from AWS.
     */
    public final List<PrimaryNeedFromAws> primaryNeedsFromAws() {
        return PrimaryNeedsFromAwsCopier.copyStringToEnum(primaryNeedsFromAws);
    }

    /**
     * For responses, this returns true if the service returned a value for the PrimaryNeedsFromAws property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPrimaryNeedsFromAws() {
        return primaryNeedsFromAws != null && !(primaryNeedsFromAws instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Identifies the type of support the partner needs from AWS.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPrimaryNeedsFromAws} method.
     * </p>
     * 
     * @return Identifies the type of support the partner needs from AWS.
     */
    public final List<String> primaryNeedsFromAwsAsStrings() {
        return primaryNeedsFromAws;
    }

    /**
     * <p>
     * Contains summary information about the project associated with the opportunity, including project name,
     * description, timeline, and other relevant details.
     * </p>
     * 
     * @return Contains summary information about the project associated with the opportunity, including project name,
     *         description, timeline, and other relevant details.
     */
    public final ProjectView project() {
        return project;
    }

    /**
     * Returns the value of the RelatedEntityIdentifiers property for this object.
     * 
     * @return The value of the RelatedEntityIdentifiers property for this object.
     */
    public final RelatedEntityIdentifiers relatedEntityIdentifiers() {
        return relatedEntityIdentifiers;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(hasOpportunityTeam() ? opportunityTeam() : null);
        hashCode = 31 * hashCode + Objects.hashCode(opportunityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPrimaryNeedsFromAws() ? primaryNeedsFromAwsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(project());
        hashCode = 31 * hashCode + Objects.hashCode(relatedEntityIdentifiers());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpportunitySummaryView)) {
            return false;
        }
        OpportunitySummaryView other = (OpportunitySummaryView) obj;
        return Objects.equals(customer(), other.customer()) && Objects.equals(lifecycle(), other.lifecycle())
                && hasOpportunityTeam() == other.hasOpportunityTeam()
                && Objects.equals(opportunityTeam(), other.opportunityTeam())
                && Objects.equals(opportunityTypeAsString(), other.opportunityTypeAsString())
                && hasPrimaryNeedsFromAws() == other.hasPrimaryNeedsFromAws()
                && Objects.equals(primaryNeedsFromAwsAsStrings(), other.primaryNeedsFromAwsAsStrings())
                && Objects.equals(project(), other.project())
                && Objects.equals(relatedEntityIdentifiers(), other.relatedEntityIdentifiers());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpportunitySummaryView").add("Customer", customer()).add("Lifecycle", lifecycle())
                .add("OpportunityTeam", hasOpportunityTeam() ? opportunityTeam() : null)
                .add("OpportunityType", opportunityTypeAsString())
                .add("PrimaryNeedsFromAws", hasPrimaryNeedsFromAws() ? primaryNeedsFromAwsAsStrings() : null)
                .add("Project", project()).add("RelatedEntityIdentifiers", relatedEntityIdentifiers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Lifecycle":
            return Optional.ofNullable(clazz.cast(lifecycle()));
        case "OpportunityTeam":
            return Optional.ofNullable(clazz.cast(opportunityTeam()));
        case "OpportunityType":
            return Optional.ofNullable(clazz.cast(opportunityTypeAsString()));
        case "PrimaryNeedsFromAws":
            return Optional.ofNullable(clazz.cast(primaryNeedsFromAwsAsStrings()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        case "RelatedEntityIdentifiers":
            return Optional.ofNullable(clazz.cast(relatedEntityIdentifiers()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("OpportunityTeam", OPPORTUNITY_TEAM_FIELD);
        map.put("OpportunityType", OPPORTUNITY_TYPE_FIELD);
        map.put("PrimaryNeedsFromAws", PRIMARY_NEEDS_FROM_AWS_FIELD);
        map.put("Project", PROJECT_FIELD);
        map.put("RelatedEntityIdentifiers", RELATED_ENTITY_IDENTIFIERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OpportunitySummaryView, T> g) {
        return obj -> g.apply((OpportunitySummaryView) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpportunitySummaryView> {
        /**
         * Sets the value of the Customer property for this object.
         *
         * @param customer
         *        The new value for the Customer property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(Customer customer);

        /**
         * Sets the value of the Customer property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Customer.Builder} avoiding the need to
         * create one manually via {@link Customer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Customer.Builder#build()} is called immediately and its result is
         * passed to {@link #customer(Customer)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link Customer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(Customer)
         */
        default Builder customer(Consumer<Customer.Builder> customer) {
            return customer(Customer.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * Contains information about the opportunity's lifecycle, including its current stage, status, and important
         * dates such as creation and last modification times.
         * </p>
         * 
         * @param lifecycle
         *        Contains information about the opportunity's lifecycle, including its current stage, status, and
         *        important dates such as creation and last modification times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycle(LifeCycleForView lifecycle);

        /**
         * <p>
         * Contains information about the opportunity's lifecycle, including its current stage, status, and important
         * dates such as creation and last modification times.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifeCycleForView.Builder} avoiding the
         * need to create one manually via {@link LifeCycleForView#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifeCycleForView.Builder#build()} is called immediately and its
         * result is passed to {@link #lifecycle(LifeCycleForView)}.
         * 
         * @param lifecycle
         *        a consumer that will call methods on {@link LifeCycleForView.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecycle(LifeCycleForView)
         */
        default Builder lifecycle(Consumer<LifeCycleForView.Builder> lifecycle) {
            return lifecycle(LifeCycleForView.builder().applyMutation(lifecycle).build());
        }

        /**
         * <p>
         * Represents the internal team handling the opportunity. Specify the members involved in collaborating on an
         * opportunity within the partner's organization.
         * </p>
         * 
         * @param opportunityTeam
         *        Represents the internal team handling the opportunity. Specify the members involved in collaborating
         *        on an opportunity within the partner's organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityTeam(Collection<Contact> opportunityTeam);

        /**
         * <p>
         * Represents the internal team handling the opportunity. Specify the members involved in collaborating on an
         * opportunity within the partner's organization.
         * </p>
         * 
         * @param opportunityTeam
         *        Represents the internal team handling the opportunity. Specify the members involved in collaborating
         *        on an opportunity within the partner's organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder opportunityTeam(Contact... opportunityTeam);

        /**
         * <p>
         * Represents the internal team handling the opportunity. Specify the members involved in collaborating on an
         * opportunity within the partner's organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.partnercentralselling.model.Contact#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #opportunityTeam(List<Contact>)}.
         * 
         * @param opportunityTeam
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #opportunityTeam(java.util.Collection<Contact>)
         */
        Builder opportunityTeam(Consumer<Contact.Builder>... opportunityTeam);

        /**
         * <p>
         * Specifies the opportunity type.
         * </p>
         * 
         * @param opportunityType
         *        Specifies the opportunity type.
         * @see OpportunityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityType
         */
        Builder opportunityType(String opportunityType);

        /**
         * <p>
         * Specifies the opportunity type.
         * </p>
         * 
         * @param opportunityType
         *        Specifies the opportunity type.
         * @see OpportunityType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpportunityType
         */
        Builder opportunityType(OpportunityType opportunityType);

        /**
         * <p>
         * Identifies the type of support the partner needs from AWS.
         * </p>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws);

        /**
         * <p>
         * Identifies the type of support the partner needs from AWS.
         * </p>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAwsWithStrings(String... primaryNeedsFromAws);

        /**
         * <p>
         * Identifies the type of support the partner needs from AWS.
         * </p>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws);

        /**
         * <p>
         * Identifies the type of support the partner needs from AWS.
         * </p>
         * 
         * @param primaryNeedsFromAws
         *        Identifies the type of support the partner needs from AWS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryNeedsFromAws(PrimaryNeedFromAws... primaryNeedsFromAws);

        /**
         * <p>
         * Contains summary information about the project associated with the opportunity, including project name,
         * description, timeline, and other relevant details.
         * </p>
         * 
         * @param project
         *        Contains summary information about the project associated with the opportunity, including project
         *        name, description, timeline, and other relevant details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(ProjectView project);

        /**
         * <p>
         * Contains summary information about the project associated with the opportunity, including project name,
         * description, timeline, and other relevant details.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectView.Builder} avoiding the need to
         * create one manually via {@link ProjectView#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectView.Builder#build()} is called immediately and its result
         * is passed to {@link #project(ProjectView)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link ProjectView.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(ProjectView)
         */
        default Builder project(Consumer<ProjectView.Builder> project) {
            return project(ProjectView.builder().applyMutation(project).build());
        }

        /**
         * Sets the value of the RelatedEntityIdentifiers property for this object.
         *
         * @param relatedEntityIdentifiers
         *        The new value for the RelatedEntityIdentifiers property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder relatedEntityIdentifiers(RelatedEntityIdentifiers relatedEntityIdentifiers);

        /**
         * Sets the value of the RelatedEntityIdentifiers property for this object.
         *
         * This is a convenience method that creates an instance of the {@link RelatedEntityIdentifiers.Builder}
         * avoiding the need to create one manually via {@link RelatedEntityIdentifiers#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RelatedEntityIdentifiers.Builder#build()} is called immediately
         * and its result is passed to {@link #relatedEntityIdentifiers(RelatedEntityIdentifiers)}.
         * 
         * @param relatedEntityIdentifiers
         *        a consumer that will call methods on {@link RelatedEntityIdentifiers.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #relatedEntityIdentifiers(RelatedEntityIdentifiers)
         */
        default Builder relatedEntityIdentifiers(Consumer<RelatedEntityIdentifiers.Builder> relatedEntityIdentifiers) {
            return relatedEntityIdentifiers(RelatedEntityIdentifiers.builder().applyMutation(relatedEntityIdentifiers).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Customer customer;

        private LifeCycleForView lifecycle;

        private List<Contact> opportunityTeam = DefaultSdkAutoConstructList.getInstance();

        private String opportunityType;

        private List<String> primaryNeedsFromAws = DefaultSdkAutoConstructList.getInstance();

        private ProjectView project;

        private RelatedEntityIdentifiers relatedEntityIdentifiers;

        private BuilderImpl() {
        }

        private BuilderImpl(OpportunitySummaryView model) {
            customer(model.customer);
            lifecycle(model.lifecycle);
            opportunityTeam(model.opportunityTeam);
            opportunityType(model.opportunityType);
            primaryNeedsFromAwsWithStrings(model.primaryNeedsFromAws);
            project(model.project);
            relatedEntityIdentifiers(model.relatedEntityIdentifiers);
        }

        public final Customer.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(Customer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(Customer customer) {
            this.customer = customer;
            return this;
        }

        public final LifeCycleForView.Builder getLifecycle() {
            return lifecycle != null ? lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(LifeCycleForView.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(LifeCycleForView lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final List<Contact.Builder> getOpportunityTeam() {
            List<Contact.Builder> result = PartnerOpportunityTeamMembersListCopier.copyToBuilder(this.opportunityTeam);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOpportunityTeam(Collection<Contact.BuilderImpl> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copyFromBuilder(opportunityTeam);
        }

        @Override
        public final Builder opportunityTeam(Collection<Contact> opportunityTeam) {
            this.opportunityTeam = PartnerOpportunityTeamMembersListCopier.copy(opportunityTeam);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Contact... opportunityTeam) {
            opportunityTeam(Arrays.asList(opportunityTeam));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder opportunityTeam(Consumer<Contact.Builder>... opportunityTeam) {
            opportunityTeam(Stream.of(opportunityTeam).map(c -> Contact.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getOpportunityType() {
            return opportunityType;
        }

        public final void setOpportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
        }

        @Override
        public final Builder opportunityType(String opportunityType) {
            this.opportunityType = opportunityType;
            return this;
        }

        @Override
        public final Builder opportunityType(OpportunityType opportunityType) {
            this.opportunityType(opportunityType == null ? null : opportunityType.toString());
            return this;
        }

        public final Collection<String> getPrimaryNeedsFromAws() {
            if (primaryNeedsFromAws instanceof SdkAutoConstructList) {
                return null;
            }
            return primaryNeedsFromAws;
        }

        public final void setPrimaryNeedsFromAws(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
        }

        @Override
        public final Builder primaryNeedsFromAwsWithStrings(Collection<String> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copy(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAwsWithStrings(String... primaryNeedsFromAws) {
            primaryNeedsFromAwsWithStrings(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        @Override
        public final Builder primaryNeedsFromAws(Collection<PrimaryNeedFromAws> primaryNeedsFromAws) {
            this.primaryNeedsFromAws = PrimaryNeedsFromAwsCopier.copyEnumToString(primaryNeedsFromAws);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder primaryNeedsFromAws(PrimaryNeedFromAws... primaryNeedsFromAws) {
            primaryNeedsFromAws(Arrays.asList(primaryNeedsFromAws));
            return this;
        }

        public final ProjectView.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(ProjectView.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectView project) {
            this.project = project;
            return this;
        }

        public final RelatedEntityIdentifiers.Builder getRelatedEntityIdentifiers() {
            return relatedEntityIdentifiers != null ? relatedEntityIdentifiers.toBuilder() : null;
        }

        public final void setRelatedEntityIdentifiers(RelatedEntityIdentifiers.BuilderImpl relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers != null ? relatedEntityIdentifiers.build() : null;
        }

        @Override
        public final Builder relatedEntityIdentifiers(RelatedEntityIdentifiers relatedEntityIdentifiers) {
            this.relatedEntityIdentifiers = relatedEntityIdentifiers;
            return this;
        }

        @Override
        public OpportunitySummaryView build() {
            return new OpportunitySummaryView(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
