/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Tracks the history of next steps associated with the opportunity. This field captures the actions planned for the
 * future and their timeline.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProfileNextStepsHistory implements SdkPojo, Serializable,
        ToCopyableBuilder<ProfileNextStepsHistory.Builder, ProfileNextStepsHistory> {
    private static final SdkField<Instant> TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("Time")
            .getter(getter(ProfileNextStepsHistory::time))
            .setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Time").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ProfileNextStepsHistory::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant time;

    private final String value;

    private ProfileNextStepsHistory(BuilderImpl builder) {
        this.time = builder.time;
        this.value = builder.value;
    }

    /**
     * <p>
     * Indicates the date and time when a particular next step was recorded or planned. This helps in managing the
     * timeline for the opportunity.
     * </p>
     * 
     * @return Indicates the date and time when a particular next step was recorded or planned. This helps in managing
     *         the timeline for the opportunity.
     */
    public final Instant time() {
        return time;
    }

    /**
     * <p>
     * Represents the details of the next step recorded, such as follow-up actions or decisions made. This field helps
     * in tracking progress and ensuring alignment with project goals.
     * </p>
     * 
     * @return Represents the details of the next step recorded, such as follow-up actions or decisions made. This field
     *         helps in tracking progress and ensuring alignment with project goals.
     */
    public final String value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(time());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProfileNextStepsHistory)) {
            return false;
        }
        ProfileNextStepsHistory other = (ProfileNextStepsHistory) obj;
        return Objects.equals(time(), other.time()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProfileNextStepsHistory").add("Time", time()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Time":
            return Optional.ofNullable(clazz.cast(time()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Time", TIME_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProfileNextStepsHistory, T> g) {
        return obj -> g.apply((ProfileNextStepsHistory) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProfileNextStepsHistory> {
        /**
         * <p>
         * Indicates the date and time when a particular next step was recorded or planned. This helps in managing the
         * timeline for the opportunity.
         * </p>
         * 
         * @param time
         *        Indicates the date and time when a particular next step was recorded or planned. This helps in
         *        managing the timeline for the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);

        /**
         * <p>
         * Represents the details of the next step recorded, such as follow-up actions or decisions made. This field
         * helps in tracking progress and ensuring alignment with project goals.
         * </p>
         * 
         * @param value
         *        Represents the details of the next step recorded, such as follow-up actions or decisions made. This
         *        field helps in tracking progress and ensuring alignment with project goals.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);
    }

    static final class BuilderImpl implements Builder {
        private Instant time;

        private String value;

        private BuilderImpl() {
        }

        private BuilderImpl(ProfileNextStepsHistory model) {
            time(model.time);
            value(model.value);
        }

        public final Instant getTime() {
            return time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public ProfileNextStepsHistory build() {
            return new ProfileNextStepsHistory(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
