/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutSellingSystemSettingsRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<PutSellingSystemSettingsRequest.Builder, PutSellingSystemSettingsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(PutSellingSystemSettingsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_ROLE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotJobRoleIdentifier")
            .getter(getter(PutSellingSystemSettingsRequest::resourceSnapshotJobRoleIdentifier))
            .setter(setter(Builder::resourceSnapshotJobRoleIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobRoleIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            RESOURCE_SNAPSHOT_JOB_ROLE_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String resourceSnapshotJobRoleIdentifier;

    private PutSellingSystemSettingsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.resourceSnapshotJobRoleIdentifier = builder.resourceSnapshotJobRoleIdentifier;
    }

    /**
     * <p>
     * Specifies the catalog in which the settings will be updated. Acceptable values include <code>AWS</code> for
     * production and <code>Sandbox</code> for testing environments.
     * </p>
     * 
     * @return Specifies the catalog in which the settings will be updated. Acceptable values include <code>AWS</code>
     *         for production and <code>Sandbox</code> for testing environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Specifies the ARN of the IAM Role used for resource snapshot job executions.
     * </p>
     * 
     * @return Specifies the ARN of the IAM Role used for resource snapshot job executions.
     */
    public final String resourceSnapshotJobRoleIdentifier() {
        return resourceSnapshotJobRoleIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotJobRoleIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSellingSystemSettingsRequest)) {
            return false;
        }
        PutSellingSystemSettingsRequest other = (PutSellingSystemSettingsRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(resourceSnapshotJobRoleIdentifier(), other.resourceSnapshotJobRoleIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutSellingSystemSettingsRequest").add("Catalog", catalog())
                .add("ResourceSnapshotJobRoleIdentifier", resourceSnapshotJobRoleIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ResourceSnapshotJobRoleIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSnapshotJobRoleIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ResourceSnapshotJobRoleIdentifier", RESOURCE_SNAPSHOT_JOB_ROLE_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutSellingSystemSettingsRequest, T> g) {
        return obj -> g.apply((PutSellingSystemSettingsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutSellingSystemSettingsRequest> {
        /**
         * <p>
         * Specifies the catalog in which the settings will be updated. Acceptable values include <code>AWS</code> for
         * production and <code>Sandbox</code> for testing environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which the settings will be updated. Acceptable values include
         *        <code>AWS</code> for production and <code>Sandbox</code> for testing environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Specifies the ARN of the IAM Role used for resource snapshot job executions.
         * </p>
         * 
         * @param resourceSnapshotJobRoleIdentifier
         *        Specifies the ARN of the IAM Role used for resource snapshot job executions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotJobRoleIdentifier(String resourceSnapshotJobRoleIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String resourceSnapshotJobRoleIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSellingSystemSettingsRequest model) {
            super(model);
            catalog(model.catalog);
            resourceSnapshotJobRoleIdentifier(model.resourceSnapshotJobRoleIdentifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getResourceSnapshotJobRoleIdentifier() {
            return resourceSnapshotJobRoleIdentifier;
        }

        public final void setResourceSnapshotJobRoleIdentifier(String resourceSnapshotJobRoleIdentifier) {
            this.resourceSnapshotJobRoleIdentifier = resourceSnapshotJobRoleIdentifier;
        }

        @Override
        public final Builder resourceSnapshotJobRoleIdentifier(String resourceSnapshotJobRoleIdentifier) {
            this.resourceSnapshotJobRoleIdentifier = resourceSnapshotJobRoleIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutSellingSystemSettingsRequest build() {
            return new PutSellingSystemSettingsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
