/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the entity that received the Engagement Invitation, including account and company details. This field is
 * essential for tracking the partner who is being invited to collaborate.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Receiver implements SdkPojo, Serializable, ToCopyableBuilder<Receiver.Builder, Receiver> {
    private static final SdkField<AccountReceiver> ACCOUNT_FIELD = SdkField.<AccountReceiver> builder(MarshallingType.SDK_POJO)
            .memberName("Account").getter(getter(Receiver::account)).setter(setter(Builder::account))
            .constructor(AccountReceiver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final AccountReceiver account;

    private final Type type;

    private Receiver(BuilderImpl builder) {
        this.account = builder.account;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to track the
     * invitation recipient within the AWS ecosystem.
     * </p>
     * 
     * @return Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to
     *         track the invitation recipient within the AWS ecosystem.
     */
    public final AccountReceiver account() {
        return account;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Receiver)) {
            return false;
        }
        Receiver other = (Receiver) obj;
        return Objects.equals(account(), other.account());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Receiver").add("Account", account()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #account()} initialized to the given value.
     *
     * <p>
     * Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to track the
     * invitation recipient within the AWS ecosystem.
     * </p>
     * 
     * @param account
     *        Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to
     *        track the invitation recipient within the AWS ecosystem.
     */
    public static Receiver fromAccount(AccountReceiver account) {
        return builder().account(account).build();
    }

    /**
     * Create an instance of this class with {@link #account()} initialized to the given value.
     *
     * <p>
     * Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to track the
     * invitation recipient within the AWS ecosystem.
     * </p>
     * 
     * @param account
     *        Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to
     *        track the invitation recipient within the AWS ecosystem.
     */
    public static Receiver fromAccount(Consumer<AccountReceiver.Builder> account) {
        AccountReceiver.Builder builder = AccountReceiver.builder();
        account.accept(builder);
        return fromAccount(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Account", ACCOUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Receiver, T> g) {
        return obj -> g.apply((Receiver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Receiver> {
        /**
         * <p>
         * Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to track
         * the invitation recipient within the AWS ecosystem.
         * </p>
         * 
         * @param account
         *        Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to
         *        track the invitation recipient within the AWS ecosystem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(AccountReceiver account);

        /**
         * <p>
         * Specifies the AWS account of the partner who received the Engagement Invitation. This field is used to track
         * the invitation recipient within the AWS ecosystem.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountReceiver.Builder} avoiding the
         * need to create one manually via {@link AccountReceiver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountReceiver.Builder#build()} is called immediately and its
         * result is passed to {@link #account(AccountReceiver)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link AccountReceiver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(AccountReceiver)
         */
        default Builder account(Consumer<AccountReceiver.Builder> account) {
            return account(AccountReceiver.builder().applyMutation(account).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AccountReceiver account;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Receiver model) {
            account(model.account);
        }

        public final AccountReceiver.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(AccountReceiver.BuilderImpl account) {
            Object oldValue = this.account;
            this.account = account != null ? account.build() : null;
            handleUnionValueChange(Type.ACCOUNT, oldValue, this.account);
        }

        @Override
        public final Builder account(AccountReceiver account) {
            Object oldValue = this.account;
            this.account = account;
            handleUnionValueChange(Type.ACCOUNT, oldValue, this.account);
            return this;
        }

        @Override
        public Receiver build() {
            return new Receiver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see Receiver#type()
     */
    public enum Type {
        ACCOUNT,

        UNKNOWN_TO_SDK_VERSION
    }
}
