/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains a <code>Resource Snapshot Job</code>'s subset of fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSnapshotJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSnapshotJobSummary.Builder, ResourceSnapshotJobSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ResourceSnapshotJobSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> ENGAGEMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementId").getter(getter(ResourceSnapshotJobSummary::engagementId))
            .setter(setter(Builder::engagementId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementId").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ResourceSnapshotJobSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ResourceSnapshotJobSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD,
            ENGAGEMENT_ID_FIELD, ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String engagementId;

    private final String id;

    private final String status;

    private ResourceSnapshotJobSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.engagementId = builder.engagementId;
        this.id = builder.id;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the resource snapshot job.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the resource snapshot job.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The unique identifier of the Engagement.
     * </p>
     * 
     * @return The unique identifier of the Engagement.
     */
    public final String engagementId() {
        return engagementId;
    }

    /**
     * <p>
     * The unique identifier for the resource snapshot job within the AWS Partner Central system. This ID is used for
     * direct references to the job within the service.
     * </p>
     * 
     * @return The unique identifier for the resource snapshot job within the AWS Partner Central system. This ID is
     *         used for direct references to the job within the service.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The current status of the snapshot job.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STOPPED: The job is not currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: The job is actively executing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the snapshot job.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STOPPED: The job is not currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: The job is actively executing.
     *         </p>
     *         </li>
     * @see ResourceSnapshotJobStatus
     */
    public final ResourceSnapshotJobStatus status() {
        return ResourceSnapshotJobStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the snapshot job.
     * </p>
     * <p>
     * Valid values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * STOPPED: The job is not currently running.
     * </p>
     * </li>
     * <li>
     * <p>
     * RUNNING: The job is actively executing.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ResourceSnapshotJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the snapshot job.</p>
     *         <p>
     *         Valid values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         STOPPED: The job is not currently running.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         RUNNING: The job is actively executing.
     *         </p>
     *         </li>
     * @see ResourceSnapshotJobStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(engagementId());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSnapshotJobSummary)) {
            return false;
        }
        ResourceSnapshotJobSummary other = (ResourceSnapshotJobSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(engagementId(), other.engagementId())
                && Objects.equals(id(), other.id()) && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSnapshotJobSummary").add("Arn", arn()).add("EngagementId", engagementId())
                .add("Id", id()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "EngagementId":
            return Optional.ofNullable(clazz.cast(engagementId()));
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("EngagementId", ENGAGEMENT_ID_FIELD);
        map.put("Id", ID_FIELD);
        map.put("Status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSnapshotJobSummary, T> g) {
        return obj -> g.apply((ResourceSnapshotJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSnapshotJobSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the resource snapshot job.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the resource snapshot job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The unique identifier of the Engagement.
         * </p>
         * 
         * @param engagementId
         *        The unique identifier of the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementId(String engagementId);

        /**
         * <p>
         * The unique identifier for the resource snapshot job within the AWS Partner Central system. This ID is used
         * for direct references to the job within the service.
         * </p>
         * 
         * @param id
         *        The unique identifier for the resource snapshot job within the AWS Partner Central system. This ID is
         *        used for direct references to the job within the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The current status of the snapshot job.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STOPPED: The job is not currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: The job is actively executing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the snapshot job.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STOPPED: The job is not currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: The job is actively executing.
         *        </p>
         *        </li>
         * @see ResourceSnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSnapshotJobStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the snapshot job.
         * </p>
         * <p>
         * Valid values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * STOPPED: The job is not currently running.
         * </p>
         * </li>
         * <li>
         * <p>
         * RUNNING: The job is actively executing.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The current status of the snapshot job.</p>
         *        <p>
         *        Valid values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        STOPPED: The job is not currently running.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        RUNNING: The job is actively executing.
         *        </p>
         *        </li>
         * @see ResourceSnapshotJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceSnapshotJobStatus
         */
        Builder status(ResourceSnapshotJobStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String engagementId;

        private String id;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSnapshotJobSummary model) {
            arn(model.arn);
            engagementId(model.engagementId);
            id(model.id);
            status(model.status);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getEngagementId() {
            return engagementId;
        }

        public final void setEngagementId(String engagementId) {
            this.engagementId = engagementId;
        }

        @Override
        public final Builder engagementId(String engagementId) {
            this.engagementId = engagementId;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ResourceSnapshotJobStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ResourceSnapshotJobSummary build() {
            return new ResourceSnapshotJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
