/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a customer's procurement terms details. Required only for partners in eligible programs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SoftwareRevenue implements SdkPojo, Serializable, ToCopyableBuilder<SoftwareRevenue.Builder, SoftwareRevenue> {
    private static final SdkField<String> DELIVERY_MODEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DeliveryModel").getter(getter(SoftwareRevenue::deliveryModelAsString))
            .setter(setter(Builder::deliveryModel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DeliveryModel").build()).build();

    private static final SdkField<String> EFFECTIVE_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EffectiveDate").getter(getter(SoftwareRevenue::effectiveDate)).setter(setter(Builder::effectiveDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EffectiveDate").build()).build();

    private static final SdkField<String> EXPIRATION_DATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ExpirationDate").getter(getter(SoftwareRevenue::expirationDate)).setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build()).build();

    private static final SdkField<MonetaryValue> VALUE_FIELD = SdkField.<MonetaryValue> builder(MarshallingType.SDK_POJO)
            .memberName("Value").getter(getter(SoftwareRevenue::value)).setter(setter(Builder::value))
            .constructor(MonetaryValue::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DELIVERY_MODEL_FIELD,
            EFFECTIVE_DATE_FIELD, EXPIRATION_DATE_FIELD, VALUE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String deliveryModel;

    private final String effectiveDate;

    private final String expirationDate;

    private final MonetaryValue value;

    private SoftwareRevenue(BuilderImpl builder) {
        this.deliveryModel = builder.deliveryModel;
        this.effectiveDate = builder.effectiveDate;
        this.expirationDate = builder.expirationDate;
        this.value = builder.value;
    }

    /**
     * <p>
     * Specifies the customer's intended payment type agreement or procurement method to acquire the solution or service
     * outlined in the <code>Opportunity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryModel}
     * will return {@link RevenueModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deliveryModelAsString}.
     * </p>
     * 
     * @return Specifies the customer's intended payment type agreement or procurement method to acquire the solution or
     *         service outlined in the <code>Opportunity</code>.
     * @see RevenueModel
     */
    public final RevenueModel deliveryModel() {
        return RevenueModel.fromValue(deliveryModel);
    }

    /**
     * <p>
     * Specifies the customer's intended payment type agreement or procurement method to acquire the solution or service
     * outlined in the <code>Opportunity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #deliveryModel}
     * will return {@link RevenueModel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #deliveryModelAsString}.
     * </p>
     * 
     * @return Specifies the customer's intended payment type agreement or procurement method to acquire the solution or
     *         service outlined in the <code>Opportunity</code>.
     * @see RevenueModel
     */
    public final String deliveryModelAsString() {
        return deliveryModel;
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s customer engagement start date for the contract's effectiveness.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s customer engagement start date for the contract's effectiveness.
     */
    public final String effectiveDate() {
        return effectiveDate;
    }

    /**
     * <p>
     * Specifies the expiration date for the contract between the customer and Amazon Web Services partner. It signifies
     * the termination date of the agreed-upon engagement period between both parties.
     * </p>
     * 
     * @return Specifies the expiration date for the contract between the customer and Amazon Web Services partner. It
     *         signifies the termination date of the agreed-upon engagement period between both parties.
     */
    public final String expirationDate() {
        return expirationDate;
    }

    /**
     * <p>
     * Specifies the payment value (amount and currency).
     * </p>
     * 
     * @return Specifies the payment value (amount and currency).
     */
    public final MonetaryValue value() {
        return value;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(deliveryModelAsString());
        hashCode = 31 * hashCode + Objects.hashCode(effectiveDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SoftwareRevenue)) {
            return false;
        }
        SoftwareRevenue other = (SoftwareRevenue) obj;
        return Objects.equals(deliveryModelAsString(), other.deliveryModelAsString())
                && Objects.equals(effectiveDate(), other.effectiveDate())
                && Objects.equals(expirationDate(), other.expirationDate()) && Objects.equals(value(), other.value());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SoftwareRevenue").add("DeliveryModel", deliveryModelAsString())
                .add("EffectiveDate", effectiveDate()).add("ExpirationDate", expirationDate()).add("Value", value()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DeliveryModel":
            return Optional.ofNullable(clazz.cast(deliveryModelAsString()));
        case "EffectiveDate":
            return Optional.ofNullable(clazz.cast(effectiveDate()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DeliveryModel", DELIVERY_MODEL_FIELD);
        map.put("EffectiveDate", EFFECTIVE_DATE_FIELD);
        map.put("ExpirationDate", EXPIRATION_DATE_FIELD);
        map.put("Value", VALUE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SoftwareRevenue, T> g) {
        return obj -> g.apply((SoftwareRevenue) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SoftwareRevenue> {
        /**
         * <p>
         * Specifies the customer's intended payment type agreement or procurement method to acquire the solution or
         * service outlined in the <code>Opportunity</code>.
         * </p>
         * 
         * @param deliveryModel
         *        Specifies the customer's intended payment type agreement or procurement method to acquire the solution
         *        or service outlined in the <code>Opportunity</code>.
         * @see RevenueModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevenueModel
         */
        Builder deliveryModel(String deliveryModel);

        /**
         * <p>
         * Specifies the customer's intended payment type agreement or procurement method to acquire the solution or
         * service outlined in the <code>Opportunity</code>.
         * </p>
         * 
         * @param deliveryModel
         *        Specifies the customer's intended payment type agreement or procurement method to acquire the solution
         *        or service outlined in the <code>Opportunity</code>.
         * @see RevenueModel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RevenueModel
         */
        Builder deliveryModel(RevenueModel deliveryModel);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s customer engagement start date for the contract's effectiveness.
         * </p>
         * 
         * @param effectiveDate
         *        Specifies the <code>Opportunity</code>'s customer engagement start date for the contract's
         *        effectiveness.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveDate(String effectiveDate);

        /**
         * <p>
         * Specifies the expiration date for the contract between the customer and Amazon Web Services partner. It
         * signifies the termination date of the agreed-upon engagement period between both parties.
         * </p>
         * 
         * @param expirationDate
         *        Specifies the expiration date for the contract between the customer and Amazon Web Services partner.
         *        It signifies the termination date of the agreed-upon engagement period between both parties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(String expirationDate);

        /**
         * <p>
         * Specifies the payment value (amount and currency).
         * </p>
         * 
         * @param value
         *        Specifies the payment value (amount and currency).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(MonetaryValue value);

        /**
         * <p>
         * Specifies the payment value (amount and currency).
         * </p>
         * This is a convenience method that creates an instance of the {@link MonetaryValue.Builder} avoiding the need
         * to create one manually via {@link MonetaryValue#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MonetaryValue.Builder#build()} is called immediately and its
         * result is passed to {@link #value(MonetaryValue)}.
         * 
         * @param value
         *        a consumer that will call methods on {@link MonetaryValue.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #value(MonetaryValue)
         */
        default Builder value(Consumer<MonetaryValue.Builder> value) {
            return value(MonetaryValue.builder().applyMutation(value).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String deliveryModel;

        private String effectiveDate;

        private String expirationDate;

        private MonetaryValue value;

        private BuilderImpl() {
        }

        private BuilderImpl(SoftwareRevenue model) {
            deliveryModel(model.deliveryModel);
            effectiveDate(model.effectiveDate);
            expirationDate(model.expirationDate);
            value(model.value);
        }

        public final String getDeliveryModel() {
            return deliveryModel;
        }

        public final void setDeliveryModel(String deliveryModel) {
            this.deliveryModel = deliveryModel;
        }

        @Override
        public final Builder deliveryModel(String deliveryModel) {
            this.deliveryModel = deliveryModel;
            return this;
        }

        @Override
        public final Builder deliveryModel(RevenueModel deliveryModel) {
            this.deliveryModel(deliveryModel == null ? null : deliveryModel.toString());
            return this;
        }

        public final String getEffectiveDate() {
            return effectiveDate;
        }

        public final void setEffectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
        }

        @Override
        public final Builder effectiveDate(String effectiveDate) {
            this.effectiveDate = effectiveDate;
            return this;
        }

        public final String getExpirationDate() {
            return expirationDate;
        }

        public final void setExpirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public final Builder expirationDate(String expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final MonetaryValue.Builder getValue() {
            return value != null ? value.toBuilder() : null;
        }

        public final void setValue(MonetaryValue.BuilderImpl value) {
            this.value = value != null ? value.build() : null;
        }

        @Override
        public final Builder value(MonetaryValue value) {
            this.value = value;
            return this;
        }

        @Override
        public SoftwareRevenue build() {
            return new SoftwareRevenue(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
