/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartEngagementFromOpportunityTaskRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<StartEngagementFromOpportunityTaskRequest.Builder, StartEngagementFromOpportunityTaskRequest> {
    private static final SdkField<AwsSubmission> AWS_SUBMISSION_FIELD = SdkField
            .<AwsSubmission> builder(MarshallingType.SDK_POJO).memberName("AwsSubmission")
            .getter(getter(StartEngagementFromOpportunityTaskRequest::awsSubmission)).setter(setter(Builder::awsSubmission))
            .constructor(AwsSubmission::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsSubmission").build()).build();

    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(StartEngagementFromOpportunityTaskRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ClientToken")
            .getter(getter(StartEngagementFromOpportunityTaskRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Identifier").getter(getter(StartEngagementFromOpportunityTaskRequest::identifier))
            .setter(setter(Builder::identifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(StartEngagementFromOpportunityTaskRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_SUBMISSION_FIELD,
            CATALOG_FIELD, CLIENT_TOKEN_FIELD, IDENTIFIER_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AwsSubmission awsSubmission;

    private final String catalog;

    private final String clientToken;

    private final String identifier;

    private final List<Tag> tags;

    private StartEngagementFromOpportunityTaskRequest(BuilderImpl builder) {
        super(builder);
        this.awsSubmission = builder.awsSubmission;
        this.catalog = builder.catalog;
        this.clientToken = builder.clientToken;
        this.identifier = builder.identifier;
        this.tags = builder.tags;
    }

    /**
     * Returns the value of the AwsSubmission property for this object.
     * 
     * @return The value of the AwsSubmission property for this object.
     */
    public final AwsSubmission awsSubmission() {
        return awsSubmission;
    }

    /**
     * <p>
     * Specifies the catalog in which the engagement is tracked. Acceptable values include <code>AWS</code> for
     * production and <code>Sandbox</code> for testing environments.
     * </p>
     * 
     * @return Specifies the catalog in which the engagement is tracked. Acceptable values include <code>AWS</code> for
     *         production and <code>Sandbox</code> for testing environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * A unique token provided by the client to help ensure the idempotency of the request. It helps prevent the same
     * task from being performed multiple times.
     * </p>
     * 
     * @return A unique token provided by the client to help ensure the idempotency of the request. It helps prevent the
     *         same task from being performed multiple times.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique identifier of the opportunity from which the engagement task is to be initiated. This helps ensure
     * that the task is applied to the correct opportunity.
     * </p>
     * 
     * @return The unique identifier of the opportunity from which the engagement task is to be initiated. This helps
     *         ensure that the task is applied to the correct opportunity.
     */
    public final String identifier() {
        return identifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of objects specifying each tag name and value.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return A list of objects specifying each tag name and value.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsSubmission());
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(identifier());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartEngagementFromOpportunityTaskRequest)) {
            return false;
        }
        StartEngagementFromOpportunityTaskRequest other = (StartEngagementFromOpportunityTaskRequest) obj;
        return Objects.equals(awsSubmission(), other.awsSubmission()) && Objects.equals(catalog(), other.catalog())
                && Objects.equals(clientToken(), other.clientToken()) && Objects.equals(identifier(), other.identifier())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartEngagementFromOpportunityTaskRequest").add("AwsSubmission", awsSubmission())
                .add("Catalog", catalog()).add("ClientToken", clientToken()).add("Identifier", identifier())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsSubmission":
            return Optional.ofNullable(clazz.cast(awsSubmission()));
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ClientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "Identifier":
            return Optional.ofNullable(clazz.cast(identifier()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsSubmission", AWS_SUBMISSION_FIELD);
        map.put("Catalog", CATALOG_FIELD);
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartEngagementFromOpportunityTaskRequest, T> g) {
        return obj -> g.apply((StartEngagementFromOpportunityTaskRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartEngagementFromOpportunityTaskRequest> {
        /**
         * Sets the value of the AwsSubmission property for this object.
         *
         * @param awsSubmission
         *        The new value for the AwsSubmission property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsSubmission(AwsSubmission awsSubmission);

        /**
         * Sets the value of the AwsSubmission property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AwsSubmission.Builder} avoiding the need
         * to create one manually via {@link AwsSubmission#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsSubmission.Builder#build()} is called immediately and its
         * result is passed to {@link #awsSubmission(AwsSubmission)}.
         * 
         * @param awsSubmission
         *        a consumer that will call methods on {@link AwsSubmission.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsSubmission(AwsSubmission)
         */
        default Builder awsSubmission(Consumer<AwsSubmission.Builder> awsSubmission) {
            return awsSubmission(AwsSubmission.builder().applyMutation(awsSubmission).build());
        }

        /**
         * <p>
         * Specifies the catalog in which the engagement is tracked. Acceptable values include <code>AWS</code> for
         * production and <code>Sandbox</code> for testing environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog in which the engagement is tracked. Acceptable values include <code>AWS</code>
         *        for production and <code>Sandbox</code> for testing environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * A unique token provided by the client to help ensure the idempotency of the request. It helps prevent the
         * same task from being performed multiple times.
         * </p>
         * 
         * @param clientToken
         *        A unique token provided by the client to help ensure the idempotency of the request. It helps prevent
         *        the same task from being performed multiple times.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique identifier of the opportunity from which the engagement task is to be initiated. This helps ensure
         * that the task is applied to the correct opportunity.
         * </p>
         * 
         * @param identifier
         *        The unique identifier of the opportunity from which the engagement task is to be initiated. This helps
         *        ensure that the task is applied to the correct opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identifier(String identifier);

        /**
         * <p>
         * A list of objects specifying each tag name and value.
         * </p>
         * 
         * @param tags
         *        A list of objects specifying each tag name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * A list of objects specifying each tag name and value.
         * </p>
         * 
         * @param tags
         *        A list of objects specifying each tag name and value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * A list of objects specifying each tag name and value.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.partnercentralselling.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private AwsSubmission awsSubmission;

        private String catalog;

        private String clientToken;

        private String identifier;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartEngagementFromOpportunityTaskRequest model) {
            super(model);
            awsSubmission(model.awsSubmission);
            catalog(model.catalog);
            clientToken(model.clientToken);
            identifier(model.identifier);
            tags(model.tags);
        }

        public final AwsSubmission.Builder getAwsSubmission() {
            return awsSubmission != null ? awsSubmission.toBuilder() : null;
        }

        public final void setAwsSubmission(AwsSubmission.BuilderImpl awsSubmission) {
            this.awsSubmission = awsSubmission != null ? awsSubmission.build() : null;
        }

        @Override
        public final Builder awsSubmission(AwsSubmission awsSubmission) {
            this.awsSubmission = awsSubmission;
            return this;
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getIdentifier() {
            return identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartEngagementFromOpportunityTaskRequest build() {
            return new StartEngagementFromOpportunityTaskRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
