/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The input fails to satisfy the constraints specified by the service or business validation rules.
 * </p>
 * <p>
 * Suggested action: Review the error message, including the failed fields and reasons, to correct the request payload.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationException extends PartnerCentralSellingException implements
        ToCopyableBuilder<ValidationException.Builder, ValidationException> {
    private static final SdkField<List<ValidationExceptionError>> ERROR_LIST_FIELD = SdkField
            .<List<ValidationExceptionError>> builder(MarshallingType.LIST)
            .memberName("ErrorList")
            .getter(getter(ValidationException::errorList))
            .setter(setter(Builder::errorList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ValidationExceptionError> builder(MarshallingType.SDK_POJO)
                                            .constructor(ValidationExceptionError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Reason")
            .getter(getter(ValidationException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Reason").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ERROR_LIST_FIELD, REASON_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ValidationExceptionError> errorList;

    private final String reason;

    private ValidationException(BuilderImpl builder) {
        super(builder);
        this.errorList = builder.errorList;
        this.reason = builder.reason;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * For responses, this returns true if the service returned a value for the ErrorList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public boolean hasErrorList() {
        return errorList != null && !(errorList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of issues that were discovered in the submitted request or the resource state.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasErrorList} method.
     * </p>
     * 
     * @return A list of issues that were discovered in the submitted request or the resource state.
     */
    public List<ValidationExceptionError> errorList() {
        return errorList;
    }

    /**
     * <p>
     * The primary reason for this validation exception to occur.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
     * </p>
     * <p>
     * Fix: Verify your request payload includes all required fields, uses correct data types and string formats.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
     * </p>
     * <p>
     * Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The primary reason for this validation exception to occur.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
     *         </p>
     *         <p>
     *         Fix: Verify your request payload includes all required fields, uses correct data types and string
     *         formats.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
     *         </p>
     *         <p>
     *         Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
     *         </p>
     *         </li>
     * @see ValidationExceptionReason
     */
    public ValidationExceptionReason reason() {
        return ValidationExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * The primary reason for this validation exception to occur.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
     * </p>
     * <p>
     * Fix: Verify your request payload includes all required fields, uses correct data types and string formats.
     * </p>
     * </li>
     * <li>
     * <p>
     * <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
     * </p>
     * <p>
     * Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ValidationExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #reasonAsString}.
     * </p>
     * 
     * @return The primary reason for this validation exception to occur.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
     *         </p>
     *         <p>
     *         Fix: Verify your request payload includes all required fields, uses correct data types and string
     *         formats.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
     *         </p>
     *         <p>
     *         Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
     *         </p>
     *         </li>
     * @see ValidationExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ErrorList", ERROR_LIST_FIELD);
        map.put("Reason", REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationException, T> g) {
        return obj -> g.apply((ValidationException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationException>,
            PartnerCentralSellingException.Builder {
        /**
         * <p>
         * A list of issues that were discovered in the submitted request or the resource state.
         * </p>
         * 
         * @param errorList
         *        A list of issues that were discovered in the submitted request or the resource state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(Collection<ValidationExceptionError> errorList);

        /**
         * <p>
         * A list of issues that were discovered in the submitted request or the resource state.
         * </p>
         * 
         * @param errorList
         *        A list of issues that were discovered in the submitted request or the resource state.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorList(ValidationExceptionError... errorList);

        /**
         * <p>
         * A list of issues that were discovered in the submitted request or the resource state.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ValidationExceptionError.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ValidationExceptionError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.ValidationExceptionError.Builder#build()}
         * is called immediately and its result is passed to {@link #errorList(List<ValidationExceptionError>)}.
         * 
         * @param errorList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.ValidationExceptionError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorList(java.util.Collection<ValidationExceptionError>)
         */
        Builder errorList(Consumer<ValidationExceptionError.Builder>... errorList);

        /**
         * <p>
         * The primary reason for this validation exception to occur.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
         * </p>
         * <p>
         * Fix: Verify your request payload includes all required fields, uses correct data types and string formats.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
         * </p>
         * <p>
         * Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        The primary reason for this validation exception to occur.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
         *        </p>
         *        <p>
         *        Fix: Verify your request payload includes all required fields, uses correct data types and string
         *        formats.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
         *        </p>
         *        <p>
         *        Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
         *        </p>
         *        </li>
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * The primary reason for this validation exception to occur.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
         * </p>
         * <p>
         * Fix: Verify your request payload includes all required fields, uses correct data types and string formats.
         * </p>
         * </li>
         * <li>
         * <p>
         * <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
         * </p>
         * <p>
         * Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
         * </p>
         * </li>
         * </ul>
         * 
         * @param reason
         *        The primary reason for this validation exception to occur.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <i>REQUEST_VALIDATION_FAILED:</i> The request format is not valid.
         *        </p>
         *        <p>
         *        Fix: Verify your request payload includes all required fields, uses correct data types and string
         *        formats.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <i>BUSINESS_VALIDATION_FAILED:</i> The requested change doesn't pass the business validation rules.
         *        </p>
         *        <p>
         *        Fix: Check that your change aligns with the business rules defined by AWS Partner Central.
         *        </p>
         *        </li>
         * @see ValidationExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionReason
         */
        Builder reason(ValidationExceptionReason reason);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends PartnerCentralSellingException.BuilderImpl implements Builder {
        private List<ValidationExceptionError> errorList = DefaultSdkAutoConstructList.getInstance();

        private String reason;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationException model) {
            super(model);
            errorList(model.errorList);
            reason(model.reason);
        }

        public final List<ValidationExceptionError.Builder> getErrorList() {
            List<ValidationExceptionError.Builder> result = ValidationExceptionErrorListCopier.copyToBuilder(this.errorList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrorList(Collection<ValidationExceptionError.BuilderImpl> errorList) {
            this.errorList = ValidationExceptionErrorListCopier.copyFromBuilder(errorList);
        }

        @Override
        public final Builder errorList(Collection<ValidationExceptionError> errorList) {
            this.errorList = ValidationExceptionErrorListCopier.copy(errorList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(ValidationExceptionError... errorList) {
            errorList(Arrays.asList(errorList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errorList(Consumer<ValidationExceptionError.Builder>... errorList) {
            errorList(Stream.of(errorList).map(c -> ValidationExceptionError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ValidationExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ValidationException build() {
            return new ValidationException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
