/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates an invalid value for a field.
 * </p>
 * <ul>
 * <li>
 * <p>
 * <i>REQUIRED_FIELD_MISSING:</i> The request is missing a required field.
 * </p>
 * <p>
 * Fix: Verify your request payload includes all required fields.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>INVALID_ENUM_VALUE:</i> The enum field value isn't an accepted values.
 * </p>
 * <p>
 * Fix: Check the documentation for the list of valid enum values, and update your request with a valid value.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>INVALID_STRING_FORMAT:</i> The string format is invalid.
 * </p>
 * <p>
 * Fix: Confirm that the string is in the expected format (For example: email address, date).
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>INVALID_VALUE:</i> The value isn't valid.
 * </p>
 * <p>
 * Fix: Confirm that the value meets the expected criteria and is within the allowable range or set.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>TOO_MANY_VALUES:</i> There are too many values in a field that expects fewer entries.
 * </p>
 * <p>
 * Fix: Reduce the number of values to match the expected limit.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>ACTION_NOT_PERMITTED:</i> The action isn't permitted due to current state or permissions.
 * </p>
 * <p>
 * Fix: Verify that the action is appropriate for the current state, and that you have the necessary permissions to
 * perform it.
 * </p>
 * </li>
 * <li>
 * <p>
 * <i>DUPLICATE_KEY_VALUE:</i> The value in a field duplicates a value that must be unique.
 * </p>
 * <p>
 * Fix: Verify that the value is unique and doesn't duplicate an existing value in the system.
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ValidationExceptionError implements SdkPojo, Serializable,
        ToCopyableBuilder<ValidationExceptionError.Builder, ValidationExceptionError> {
    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Code")
            .getter(getter(ValidationExceptionError::codeAsString)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Code").build()).build();

    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(ValidationExceptionError::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(ValidationExceptionError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CODE_FIELD, FIELD_NAME_FIELD,
            MESSAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String code;

    private final String fieldName;

    private final String message;

    private ValidationExceptionError(BuilderImpl builder) {
        this.code = builder.code;
        this.fieldName = builder.fieldName;
        this.message = builder.message;
    }

    /**
     * <p>
     * Specifies the error code for the invalid field value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ValidationExceptionErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return Specifies the error code for the invalid field value.
     * @see ValidationExceptionErrorCode
     */
    public final ValidationExceptionErrorCode code() {
        return ValidationExceptionErrorCode.fromValue(code);
    }

    /**
     * <p>
     * Specifies the error code for the invalid field value.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #code} will return
     * {@link ValidationExceptionErrorCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #codeAsString}.
     * </p>
     * 
     * @return Specifies the error code for the invalid field value.
     * @see ValidationExceptionErrorCode
     */
    public final String codeAsString() {
        return code;
    }

    /**
     * <p>
     * Specifies the field name with the invalid value.
     * </p>
     * 
     * @return Specifies the field name with the invalid value.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * Specifies the detailed error message for the invalid field value.
     * </p>
     * 
     * @return Specifies the detailed error message for the invalid field value.
     */
    public final String message() {
        return message;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(codeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ValidationExceptionError)) {
            return false;
        }
        ValidationExceptionError other = (ValidationExceptionError) obj;
        return Objects.equals(codeAsString(), other.codeAsString()) && Objects.equals(fieldName(), other.fieldName())
                && Objects.equals(message(), other.message());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ValidationExceptionError").add("Code", codeAsString()).add("FieldName", fieldName())
                .add("Message", message()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Code":
            return Optional.ofNullable(clazz.cast(codeAsString()));
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Code", CODE_FIELD);
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Message", MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ValidationExceptionError, T> g) {
        return obj -> g.apply((ValidationExceptionError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ValidationExceptionError> {
        /**
         * <p>
         * Specifies the error code for the invalid field value.
         * </p>
         * 
         * @param code
         *        Specifies the error code for the invalid field value.
         * @see ValidationExceptionErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionErrorCode
         */
        Builder code(String code);

        /**
         * <p>
         * Specifies the error code for the invalid field value.
         * </p>
         * 
         * @param code
         *        Specifies the error code for the invalid field value.
         * @see ValidationExceptionErrorCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ValidationExceptionErrorCode
         */
        Builder code(ValidationExceptionErrorCode code);

        /**
         * <p>
         * Specifies the field name with the invalid value.
         * </p>
         * 
         * @param fieldName
         *        Specifies the field name with the invalid value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * Specifies the detailed error message for the invalid field value.
         * </p>
         * 
         * @param message
         *        Specifies the detailed error message for the invalid field value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);
    }

    static final class BuilderImpl implements Builder {
        private String code;

        private String fieldName;

        private String message;

        private BuilderImpl() {
        }

        private BuilderImpl(ValidationExceptionError model) {
            code(model.code);
            fieldName(model.fieldName);
            message(model.message);
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public final Builder code(ValidationExceptionErrorCode code) {
            this.code(code == null ? null : code.toString());
            return this;
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public ValidationExceptionError build() {
            return new ValidationExceptionError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
