/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.LastModifiedDate;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequestCustomerCompanyNameListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequestIdentifierListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequestLifeCycleReviewStatusListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequestLifeCycleStageListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.OpportunitySort;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ReviewStatus;
import software.amazon.awssdk.services.partnercentralselling.model.Stage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListOpportunitiesRequest
extends PartnerCentralSellingRequest
implements ToCopyableBuilder<Builder, ListOpportunitiesRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Catalog").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::catalog)).setter(ListOpportunitiesRequest.setter(Builder::catalog)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()}).build();
    private static final SdkField<List<String>> CUSTOMER_COMPANY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("CustomerCompanyName").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::customerCompanyName)).setter(ListOpportunitiesRequest.setter(Builder::customerCompanyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomerCompanyName").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Identifier").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::identifier)).setter(ListOpportunitiesRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identifier").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LastModifiedDate> LAST_MODIFIED_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastModifiedDate").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::lastModifiedDate)).setter(ListOpportunitiesRequest.setter(Builder::lastModifiedDate)).constructor(LastModifiedDate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedDate").build()}).build();
    private static final SdkField<List<String>> LIFE_CYCLE_REVIEW_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifeCycleReviewStatus").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::lifeCycleReviewStatusAsStrings)).setter(ListOpportunitiesRequest.setter(Builder::lifeCycleReviewStatusWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleReviewStatus").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIFE_CYCLE_STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("LifeCycleStage").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::lifeCycleStageAsStrings)).setter(ListOpportunitiesRequest.setter(Builder::lifeCycleStageWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifeCycleStage").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::maxResults)).setter(ListOpportunitiesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::nextToken)).setter(ListOpportunitiesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<OpportunitySort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Sort").getter(ListOpportunitiesRequest.getter(ListOpportunitiesRequest::sort)).setter(ListOpportunitiesRequest.setter(Builder::sort)).constructor(OpportunitySort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD, CUSTOMER_COMPANY_NAME_FIELD, IDENTIFIER_FIELD, LAST_MODIFIED_DATE_FIELD, LIFE_CYCLE_REVIEW_STATUS_FIELD, LIFE_CYCLE_STAGE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListOpportunitiesRequest.memberNameToFieldInitializer();
    private final String catalog;
    private final List<String> customerCompanyName;
    private final List<String> identifier;
    private final LastModifiedDate lastModifiedDate;
    private final List<String> lifeCycleReviewStatus;
    private final List<String> lifeCycleStage;
    private final Integer maxResults;
    private final String nextToken;
    private final OpportunitySort sort;

    private ListOpportunitiesRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.customerCompanyName = builder.customerCompanyName;
        this.identifier = builder.identifier;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.lifeCycleReviewStatus = builder.lifeCycleReviewStatus;
        this.lifeCycleStage = builder.lifeCycleStage;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
    }

    public final String catalog() {
        return this.catalog;
    }

    public final boolean hasCustomerCompanyName() {
        return this.customerCompanyName != null && !(this.customerCompanyName instanceof SdkAutoConstructList);
    }

    public final List<String> customerCompanyName() {
        return this.customerCompanyName;
    }

    public final boolean hasIdentifier() {
        return this.identifier != null && !(this.identifier instanceof SdkAutoConstructList);
    }

    public final List<String> identifier() {
        return this.identifier;
    }

    public final LastModifiedDate lastModifiedDate() {
        return this.lastModifiedDate;
    }

    public final List<ReviewStatus> lifeCycleReviewStatus() {
        return ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copyStringToEnum(this.lifeCycleReviewStatus);
    }

    public final boolean hasLifeCycleReviewStatus() {
        return this.lifeCycleReviewStatus != null && !(this.lifeCycleReviewStatus instanceof SdkAutoConstructList);
    }

    public final List<String> lifeCycleReviewStatusAsStrings() {
        return this.lifeCycleReviewStatus;
    }

    public final List<Stage> lifeCycleStage() {
        return ListOpportunitiesRequestLifeCycleStageListCopier.copyStringToEnum(this.lifeCycleStage);
    }

    public final boolean hasLifeCycleStage() {
        return this.lifeCycleStage != null && !(this.lifeCycleStage instanceof SdkAutoConstructList);
    }

    public final List<String> lifeCycleStageAsStrings() {
        return this.lifeCycleStage;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final OpportunitySort sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalog());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomerCompanyName() ? this.customerCompanyName() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasIdentifier() ? this.identifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifeCycleReviewStatus() ? this.lifeCycleReviewStatusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifeCycleStage() ? this.lifeCycleStageAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListOpportunitiesRequest)) {
            return false;
        }
        ListOpportunitiesRequest other = (ListOpportunitiesRequest)((Object)obj);
        return Objects.equals(this.catalog(), other.catalog()) && this.hasCustomerCompanyName() == other.hasCustomerCompanyName() && Objects.equals(this.customerCompanyName(), other.customerCompanyName()) && this.hasIdentifier() == other.hasIdentifier() && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.lastModifiedDate(), other.lastModifiedDate()) && this.hasLifeCycleReviewStatus() == other.hasLifeCycleReviewStatus() && Objects.equals(this.lifeCycleReviewStatusAsStrings(), other.lifeCycleReviewStatusAsStrings()) && this.hasLifeCycleStage() == other.hasLifeCycleStage() && Objects.equals(this.lifeCycleStageAsStrings(), other.lifeCycleStageAsStrings()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder((String)"ListOpportunitiesRequest").add("Catalog", (Object)this.catalog()).add("CustomerCompanyName", this.hasCustomerCompanyName() ? this.customerCompanyName() : null).add("Identifier", this.hasIdentifier() ? this.identifier() : null).add("LastModifiedDate", (Object)this.lastModifiedDate()).add("LifeCycleReviewStatus", this.hasLifeCycleReviewStatus() ? this.lifeCycleReviewStatusAsStrings() : null).add("LifeCycleStage", this.hasLifeCycleStage() ? this.lifeCycleStageAsStrings() : null).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("Sort", (Object)this.sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Catalog": {
                return Optional.ofNullable(clazz.cast(this.catalog()));
            }
            case "CustomerCompanyName": {
                return Optional.ofNullable(clazz.cast(this.customerCompanyName()));
            }
            case "Identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "LastModifiedDate": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedDate()));
            }
            case "LifeCycleReviewStatus": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleReviewStatusAsStrings()));
            }
            case "LifeCycleStage": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStageAsStrings()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("CustomerCompanyName", CUSTOMER_COMPANY_NAME_FIELD);
        map.put("Identifier", IDENTIFIER_FIELD);
        map.put("LastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("LifeCycleReviewStatus", LIFE_CYCLE_REVIEW_STATUS_FIELD);
        map.put("LifeCycleStage", LIFE_CYCLE_STAGE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListOpportunitiesRequest, T> g) {
        return obj -> g.apply((ListOpportunitiesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingRequest.BuilderImpl
    implements Builder {
        private String catalog;
        private List<String> customerCompanyName = DefaultSdkAutoConstructList.getInstance();
        private List<String> identifier = DefaultSdkAutoConstructList.getInstance();
        private LastModifiedDate lastModifiedDate;
        private List<String> lifeCycleReviewStatus = DefaultSdkAutoConstructList.getInstance();
        private List<String> lifeCycleStage = DefaultSdkAutoConstructList.getInstance();
        private Integer maxResults;
        private String nextToken;
        private OpportunitySort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(ListOpportunitiesRequest model) {
            super(model);
            this.catalog(model.catalog);
            this.customerCompanyName(model.customerCompanyName);
            this.identifier(model.identifier);
            this.lastModifiedDate(model.lastModifiedDate);
            this.lifeCycleReviewStatusWithStrings(model.lifeCycleReviewStatus);
            this.lifeCycleStageWithStrings(model.lifeCycleStage);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.sort(model.sort);
        }

        public final String getCatalog() {
            return this.catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCustomerCompanyName() {
            if (this.customerCompanyName instanceof SdkAutoConstructList) {
                return null;
            }
            return this.customerCompanyName;
        }

        public final void setCustomerCompanyName(Collection<String> customerCompanyName) {
            this.customerCompanyName = ListOpportunitiesRequestCustomerCompanyNameListCopier.copy(customerCompanyName);
        }

        @Override
        public final Builder customerCompanyName(Collection<String> customerCompanyName) {
            this.customerCompanyName = ListOpportunitiesRequestCustomerCompanyNameListCopier.copy(customerCompanyName);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customerCompanyName(String ... customerCompanyName) {
            this.customerCompanyName(Arrays.asList(customerCompanyName));
            return this;
        }

        public final Collection<String> getIdentifier() {
            if (this.identifier instanceof SdkAutoConstructList) {
                return null;
            }
            return this.identifier;
        }

        public final void setIdentifier(Collection<String> identifier) {
            this.identifier = ListOpportunitiesRequestIdentifierListCopier.copy(identifier);
        }

        @Override
        public final Builder identifier(Collection<String> identifier) {
            this.identifier = ListOpportunitiesRequestIdentifierListCopier.copy(identifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder identifier(String ... identifier) {
            this.identifier(Arrays.asList(identifier));
            return this;
        }

        public final LastModifiedDate.Builder getLastModifiedDate() {
            return this.lastModifiedDate != null ? this.lastModifiedDate.toBuilder() : null;
        }

        public final void setLastModifiedDate(LastModifiedDate.BuilderImpl lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate != null ? lastModifiedDate.build() : null;
        }

        @Override
        public final Builder lastModifiedDate(LastModifiedDate lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final Collection<String> getLifeCycleReviewStatus() {
            if (this.lifeCycleReviewStatus instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifeCycleReviewStatus;
        }

        public final void setLifeCycleReviewStatus(Collection<String> lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus = ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copy(lifeCycleReviewStatus);
        }

        @Override
        public final Builder lifeCycleReviewStatusWithStrings(Collection<String> lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus = ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copy(lifeCycleReviewStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleReviewStatusWithStrings(String ... lifeCycleReviewStatus) {
            this.lifeCycleReviewStatusWithStrings(Arrays.asList(lifeCycleReviewStatus));
            return this;
        }

        @Override
        public final Builder lifeCycleReviewStatus(Collection<ReviewStatus> lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus = ListOpportunitiesRequestLifeCycleReviewStatusListCopier.copyEnumToString(lifeCycleReviewStatus);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleReviewStatus(ReviewStatus ... lifeCycleReviewStatus) {
            this.lifeCycleReviewStatus(Arrays.asList(lifeCycleReviewStatus));
            return this;
        }

        public final Collection<String> getLifeCycleStage() {
            if (this.lifeCycleStage instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifeCycleStage;
        }

        public final void setLifeCycleStage(Collection<String> lifeCycleStage) {
            this.lifeCycleStage = ListOpportunitiesRequestLifeCycleStageListCopier.copy(lifeCycleStage);
        }

        @Override
        public final Builder lifeCycleStageWithStrings(Collection<String> lifeCycleStage) {
            this.lifeCycleStage = ListOpportunitiesRequestLifeCycleStageListCopier.copy(lifeCycleStage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStageWithStrings(String ... lifeCycleStage) {
            this.lifeCycleStageWithStrings(Arrays.asList(lifeCycleStage));
            return this;
        }

        @Override
        public final Builder lifeCycleStage(Collection<Stage> lifeCycleStage) {
            this.lifeCycleStage = ListOpportunitiesRequestLifeCycleStageListCopier.copyEnumToString(lifeCycleStage);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStage(Stage ... lifeCycleStage) {
            this.lifeCycleStage(Arrays.asList(lifeCycleStage));
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final OpportunitySort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(OpportunitySort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(OpportunitySort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListOpportunitiesRequest build() {
            return new ListOpportunitiesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListOpportunitiesRequest> {
        public Builder catalog(String var1);

        public Builder customerCompanyName(Collection<String> var1);

        public Builder customerCompanyName(String ... var1);

        public Builder identifier(Collection<String> var1);

        public Builder identifier(String ... var1);

        public Builder lastModifiedDate(LastModifiedDate var1);

        default public Builder lastModifiedDate(Consumer<LastModifiedDate.Builder> lastModifiedDate) {
            return this.lastModifiedDate((LastModifiedDate)((LastModifiedDate.Builder)LastModifiedDate.builder().applyMutation(lastModifiedDate)).build());
        }

        public Builder lifeCycleReviewStatusWithStrings(Collection<String> var1);

        public Builder lifeCycleReviewStatusWithStrings(String ... var1);

        public Builder lifeCycleReviewStatus(Collection<ReviewStatus> var1);

        public Builder lifeCycleReviewStatus(ReviewStatus ... var1);

        public Builder lifeCycleStageWithStrings(Collection<String> var1);

        public Builder lifeCycleStageWithStrings(String ... var1);

        public Builder lifeCycleStage(Collection<Stage> var1);

        public Builder lifeCycleStage(Stage ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder sort(OpportunitySort var1);

        default public Builder sort(Consumer<OpportunitySort.Builder> sort) {
            return this.sort((OpportunitySort)((OpportunitySort.Builder)OpportunitySort.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

