/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.awscore.retry.AwsRetryStrategy;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.services.partnercentralselling.internal.PartnerCentralSellingServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.partnercentralselling.internal.ServiceVersionInfo;
import software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ConflictException;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingException;
import software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralselling.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralselling.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ValidationException;
import software.amazon.awssdk.services.partnercentralselling.transform.AcceptEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.AssignOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.AssociateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateEngagementRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.CreateResourceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.DeleteResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.DisassociateOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetAwsOpportunitySummaryRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetEngagementRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetResourceSnapshotRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.GetSellingSystemSettingsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementByAcceptingInvitationTasksRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementFromOpportunityTasksRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementInvitationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementMembersRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementResourceAssociationsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListEngagementsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListOpportunitiesRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListResourceSnapshotJobsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListResourceSnapshotsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListSolutionsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.PutSellingSystemSettingsRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.RejectEngagementInvitationRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartEngagementByAcceptingInvitationTaskRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartEngagementFromOpportunityTaskRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StartResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.StopResourceSnapshotJobRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.SubmitOpportunityRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.partnercentralselling.transform.UpdateOpportunityRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link PartnerCentralSellingClient}.
 *
 * @see PartnerCentralSellingClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultPartnerCentralSellingClient implements PartnerCentralSellingClient {
    private static final Logger log = Logger.loggerFor(DefaultPartnerCentralSellingClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.AWS_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultPartnerCentralSellingClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this)
                .option(SdkClientOption.API_METADATA, "PartnerCentral_Selling" + "#" + ServiceVersionInfo.VERSION).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Use the <code>AcceptEngagementInvitation</code> action to accept an engagement invitation shared by AWS.
     * Accepting the invitation indicates your willingness to participate in the engagement, granting you access to all
     * engagement-related data.
     * </p>
     *
     * @param acceptEngagementInvitationRequest
     * @return Result of the AcceptEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AcceptEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AcceptEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AcceptEngagementInvitationResponse acceptEngagementInvitation(
            AcceptEngagementInvitationRequest acceptEngagementInvitationRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AcceptEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AcceptEngagementInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(acceptEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, acceptEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AcceptEngagementInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<AcceptEngagementInvitationRequest, AcceptEngagementInvitationResponse>()
                            .withOperationName("AcceptEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(acceptEngagementInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AcceptEngagementInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables you to reassign an existing <code>Opportunity</code> to another user within your Partner Central account.
     * The specified user receives the opportunity, and it appears on their Partner Central dashboard, allowing them to
     * take necessary actions or proceed with the opportunity.
     * </p>
     * <p>
     * This is useful for distributing opportunities to the appropriate team members or departments within your
     * organization, ensuring that each opportunity is handled by the right person. By default, the opportunity owner is
     * the one who creates it. Currently, there's no API to enumerate the list of available users.
     * </p>
     *
     * @param assignOpportunityRequest
     * @return Result of the AssignOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AssignOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssignOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssignOpportunityResponse assignOpportunity(AssignOpportunityRequest assignOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssignOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssignOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(assignOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, assignOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssignOpportunity");

            return clientHandler.execute(new ClientExecutionParams<AssignOpportunityRequest, AssignOpportunityResponse>()
                    .withOperationName("AssignOpportunity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(assignOpportunityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssignOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Enables you to create a formal association between an <code>Opportunity</code> and various related entities,
     * enriching the context and details of the opportunity for better collaboration and decision making. You can
     * associate an opportunity with the following entity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Partner Solution: A software product or consulting practice created and delivered by Partners. Partner Solutions
     * help customers address business challenges using Amazon Web Services services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Products: Amazon Web Services offers many products and services that provide scalable,
     * reliable, and cost-effective infrastructure solutions. For the latest list of Amazon Web Services products, see
     * <a href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
     * Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Allows Amazon Web Services Marketplace sellers to extend custom
     * pricing and terms to individual Amazon Web Services customers. Sellers can negotiate custom prices, payment
     * schedules, and end user license terms through private offers, enabling Amazon Web Services customers to acquire
     * software solutions tailored to their specific needs. For more information, see <a
     * href="https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-private-offers.html">Private offers in
     * Amazon Web Services Marketplace</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain identifiers for these entities, use the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Solution: Use the <code>ListSolutions</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Products: For the latest list of Amazon Web Services products, see <a
     * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json"
     * >Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Use the <a
     * href="https://docs.aws.amazon.com/marketplace/latest/APIReference/catalog-apis.html">Using the Amazon Web
     * Services Marketplace Catalog API</a> to list entities. Specifically, use the <code>ListEntities</code> operation
     * to retrieve a list of private offers. The request returns the details of available private offers. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
     * >ListEntities</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateOpportunityRequest
     * @return Result of the AssociateOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AssociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateOpportunityResponse associateOpportunity(AssociateOpportunityRequest associateOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateOpportunity");

            return clientHandler.execute(new ClientExecutionParams<AssociateOpportunityRequest, AssociateOpportunityResponse>()
                    .withOperationName("AssociateOpportunity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateOpportunityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * The <code>CreateEngagement</code> action allows you to create an <code>Engagement</code>, which serves as a
     * collaborative space between different parties such as AWS Partners and AWS Sellers. This action automatically
     * adds the caller's AWS account as an active member of the newly created <code>Engagement</code>.
     * </p>
     *
     * @param createEngagementRequest
     * @return Result of the CreateEngagement operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEngagementResponse createEngagement(CreateEngagementRequest createEngagementRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEngagementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateEngagementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEngagementRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEngagementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEngagement");

            return clientHandler.execute(new ClientExecutionParams<CreateEngagementRequest, CreateEngagementResponse>()
                    .withOperationName("CreateEngagement").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createEngagementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateEngagementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action creates an invitation from a sender to a single receiver to join an engagement.
     * </p>
     *
     * @param createEngagementInvitationRequest
     * @return Result of the CreateEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateEngagementInvitationResponse createEngagementInvitation(
            CreateEngagementInvitationRequest createEngagementInvitationRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateEngagementInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateEngagementInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateEngagementInvitationRequest, CreateEngagementInvitationResponse>()
                            .withOperationName("CreateEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createEngagementInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateEngagementInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an <code>Opportunity</code> record in Partner Central. Use this operation to create a potential business
     * opportunity for submission to Amazon Web Services. Creating an opportunity sets
     * <code>Lifecycle.ReviewStatus</code> to <code>Pending Submission</code>.
     * </p>
     * <p>
     * To submit an opportunity, follow these steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * To create the opportunity, use <code>CreateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To associate a solution with the opportunity, use <code>AssociateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To start the engagement with AWS, use <code>StartEngagementFromOpportunity</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After submission, you can't edit the opportunity until the review is complete. But opportunities in the
     * <code>Pending Submission</code> state must have complete details. You can update the opportunity while it's in
     * the <code>Pending Submission</code> state.
     * </p>
     * <p>
     * There's a set of mandatory fields to create opportunities, but consider providing optional fields to enrich the
     * opportunity record.
     * </p>
     *
     * @param createOpportunityRequest
     * @return Result of the CreateOpportunity operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateOpportunityResponse createOpportunity(CreateOpportunityRequest createOpportunityRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateOpportunity");

            return clientHandler.execute(new ClientExecutionParams<CreateOpportunityRequest, CreateOpportunityResponse>()
                    .withOperationName("CreateOpportunity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createOpportunityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action allows you to create an immutable snapshot of a specific resource, such as an opportunity, within the
     * context of an engagement. The snapshot captures a subset of the resource's data based on the schema defined by
     * the provided template.
     * </p>
     *
     * @param createResourceSnapshotRequest
     * @return Result of the CreateResourceSnapshot operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourceSnapshotResponse createResourceSnapshot(CreateResourceSnapshotRequest createResourceSnapshotRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceSnapshot");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourceSnapshotRequest, CreateResourceSnapshotResponse>()
                            .withOperationName("CreateResourceSnapshot").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createResourceSnapshotRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResourceSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to create a job to generate a snapshot of the specified resource within an engagement. It
     * initiates an asynchronous process to create a resource snapshot. The job creates a new snapshot only if the
     * resource state has changed, adhering to the same access control and immutability rules as direct snapshot
     * creation.
     * </p>
     *
     * @param createResourceSnapshotJobRequest
     * @return Result of the CreateResourceSnapshotJob operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateResourceSnapshotJobResponse createResourceSnapshotJob(
            CreateResourceSnapshotJobRequest createResourceSnapshotJobRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateResourceSnapshotJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResourceSnapshotJob");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateResourceSnapshotJobRequest, CreateResourceSnapshotJobResponse>()
                            .withOperationName("CreateResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(createResourceSnapshotJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateResourceSnapshotJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to deletes a previously created resource snapshot job. The job must be in a stopped state before
     * it can be deleted.
     * </p>
     *
     * @param deleteResourceSnapshotJobRequest
     * @return Result of the DeleteResourceSnapshotJob operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.DeleteResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DeleteResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteResourceSnapshotJobResponse deleteResourceSnapshotJob(
            DeleteResourceSnapshotJobRequest deleteResourceSnapshotJobRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteResourceSnapshotJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResourceSnapshotJob");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteResourceSnapshotJobRequest, DeleteResourceSnapshotJobResponse>()
                            .withOperationName("DeleteResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(deleteResourceSnapshotJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteResourceSnapshotJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Allows you to remove an existing association between an <code>Opportunity</code> and related entities, such as a
     * Partner Solution, Amazon Web Services product, or an Amazon Web Services Marketplace offer. This operation is the
     * counterpart to <code>AssociateOpportunity</code>, and it provides flexibility to manage associations as business
     * needs change.
     * </p>
     * <p>
     * Use this operation to update the associations of an <code>Opportunity</code> due to changes in the related
     * entities, or if an association was made in error. Ensuring accurate associations helps maintain clarity and
     * accuracy to track and manage business opportunities. When you replace an entity, first attach the new entity and
     * then disassociate the one to be removed, especially if it's the last remaining entity that's required.
     * </p>
     *
     * @param disassociateOpportunityRequest
     * @return Result of the DisassociateOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.DisassociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DisassociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateOpportunityResponse disassociateOpportunity(DisassociateOpportunityRequest disassociateOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateOpportunity");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateOpportunityRequest, DisassociateOpportunityResponse>()
                            .withOperationName("DisassociateOpportunity").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateOpportunityRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a summary of an AWS Opportunity. This summary includes high-level details about the opportunity sourced
     * from AWS, such as lifecycle information, customer details, and involvement type. It is useful for tracking
     * updates on the AWS opportunity corresponding to an opportunity in the partner's account.
     * </p>
     *
     * @param getAwsOpportunitySummaryRequest
     * @return Result of the GetAwsOpportunitySummary operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetAwsOpportunitySummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetAwsOpportunitySummary"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetAwsOpportunitySummaryResponse getAwsOpportunitySummary(
            GetAwsOpportunitySummaryRequest getAwsOpportunitySummaryRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetAwsOpportunitySummaryResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetAwsOpportunitySummaryResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getAwsOpportunitySummaryRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getAwsOpportunitySummaryRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetAwsOpportunitySummary");

            return clientHandler
                    .execute(new ClientExecutionParams<GetAwsOpportunitySummaryRequest, GetAwsOpportunitySummaryResponse>()
                            .withOperationName("GetAwsOpportunitySummary").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getAwsOpportunitySummaryRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetAwsOpportunitySummaryRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to retrieve the engagement record for a given <code>EngagementIdentifier</code>.
     * </p>
     *
     * @param getEngagementRequest
     * @return Result of the GetEngagement operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEngagementResponse getEngagement(GetEngagementRequest getEngagementRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEngagementResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetEngagementResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEngagementRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEngagementRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEngagement");

            return clientHandler.execute(new ClientExecutionParams<GetEngagementRequest, GetEngagementResponse>()
                    .withOperationName("GetEngagement").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getEngagementRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetEngagementRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the details of an engagement invitation shared by AWS with a partner. The information includes aspects
     * such as customer, project details, and lifecycle information. To connect an engagement invitation with an
     * opportunity, match the invitation’s <code>Payload.Project.Title</code> with opportunity
     * <code>Project.Title</code>.
     * </p>
     *
     * @param getEngagementInvitationRequest
     * @return Result of the GetEngagementInvitation operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetEngagementInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetEngagementInvitationResponse getEngagementInvitation(GetEngagementInvitationRequest getEngagementInvitationRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetEngagementInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetEngagementInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetEngagementInvitationRequest, GetEngagementInvitationResponse>()
                            .withOperationName("GetEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getEngagementInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetEngagementInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Fetches the <code>Opportunity</code> record from Partner Central by a given <code>Identifier</code>.
     * </p>
     * <p>
     * Use the <code>ListOpportunities</code> action or the event notification (from Amazon EventBridge) to obtain this
     * identifier.
     * </p>
     *
     * @param getOpportunityRequest
     * @return Result of the GetOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetOpportunityResponse getOpportunity(GetOpportunityRequest getOpportunityRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getOpportunityRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetOpportunity");

            return clientHandler.execute(new ClientExecutionParams<GetOpportunityRequest, GetOpportunityResponse>()
                    .withOperationName("GetOpportunity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getOpportunityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to retrieve a specific snapshot record.
     * </p>
     *
     * @param getResourceSnapshotRequest
     * @return Result of the GetResourceSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceSnapshotResponse getResourceSnapshot(GetResourceSnapshotRequest getResourceSnapshotRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceSnapshotResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetResourceSnapshotResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceSnapshotRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceSnapshotRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceSnapshot");

            return clientHandler.execute(new ClientExecutionParams<GetResourceSnapshotRequest, GetResourceSnapshotResponse>()
                    .withOperationName("GetResourceSnapshot").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getResourceSnapshotRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResourceSnapshotRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to retrieves information about a specific resource snapshot job.
     * </p>
     *
     * @param getResourceSnapshotJobRequest
     * @return Result of the GetResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetResourceSnapshotJobResponse getResourceSnapshotJob(GetResourceSnapshotJobRequest getResourceSnapshotJobRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetResourceSnapshotJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResourceSnapshotJob");

            return clientHandler
                    .execute(new ClientExecutionParams<GetResourceSnapshotJobRequest, GetResourceSnapshotJobResponse>()
                            .withOperationName("GetResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getResourceSnapshotJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetResourceSnapshotJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     *
     * @param getSellingSystemSettingsRequest
     * @return Result of the GetSellingSystemSettings operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSellingSystemSettingsResponse getSellingSystemSettings(
            GetSellingSystemSettingsRequest getSellingSystemSettingsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSellingSystemSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSellingSystemSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSellingSystemSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSellingSystemSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSellingSystemSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSellingSystemSettingsRequest, GetSellingSystemSettingsResponse>()
                            .withOperationName("GetSellingSystemSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getSellingSystemSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSellingSystemSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed StartEngagementByAcceptingInvitationTask tasks that were initiated by
     * the caller's account.
     * </p>
     *
     * @param listEngagementByAcceptingInvitationTasksRequest
     * @return Result of the ListEngagementByAcceptingInvitationTasks operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementByAcceptingInvitationTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementByAcceptingInvitationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEngagementByAcceptingInvitationTasksResponse listEngagementByAcceptingInvitationTasks(
            ListEngagementByAcceptingInvitationTasksRequest listEngagementByAcceptingInvitationTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngagementByAcceptingInvitationTasksResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, ListEngagementByAcceptingInvitationTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                listEngagementByAcceptingInvitationTasksRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEngagementByAcceptingInvitationTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementByAcceptingInvitationTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEngagementByAcceptingInvitationTasksRequest, ListEngagementByAcceptingInvitationTasksResponse>()
                            .withOperationName("ListEngagementByAcceptingInvitationTasks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(listEngagementByAcceptingInvitationTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEngagementByAcceptingInvitationTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed <code>EngagementFromOpportunity</code> tasks that were initiated by
     * the caller's account.
     * </p>
     *
     * @param listEngagementFromOpportunityTasksRequest
     * @return Result of the ListEngagementFromOpportunityTasks operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementFromOpportunityTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementFromOpportunityTasks"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEngagementFromOpportunityTasksResponse listEngagementFromOpportunityTasks(
            ListEngagementFromOpportunityTasksRequest listEngagementFromOpportunityTasksRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngagementFromOpportunityTasksResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEngagementFromOpportunityTasksResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementFromOpportunityTasksRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEngagementFromOpportunityTasksRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementFromOpportunityTasks");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEngagementFromOpportunityTasksRequest, ListEngagementFromOpportunityTasksResponse>()
                            .withOperationName("ListEngagementFromOpportunityTasks").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEngagementFromOpportunityTasksRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEngagementFromOpportunityTasksRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of engagement invitations sent to the partner. This allows partners to view all pending or past
     * engagement invitations, helping them track opportunities shared by AWS.
     * </p>
     *
     * @param listEngagementInvitationsRequest
     * @return Result of the ListEngagementInvitations operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementInvitations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEngagementInvitationsResponse listEngagementInvitations(
            ListEngagementInvitationsRequest listEngagementInvitationsRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngagementInvitationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEngagementInvitationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementInvitationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngagementInvitationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementInvitations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEngagementInvitationsRequest, ListEngagementInvitationsResponse>()
                            .withOperationName("ListEngagementInvitations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEngagementInvitationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEngagementInvitationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the details of member partners in an Engagement. This operation can only be invoked by members of the
     * Engagement. The <code>ListEngagementMembers</code> operation allows you to fetch information about the members of
     * a specific Engagement. This action is restricted to members of the Engagement being queried.
     * </p>
     *
     * @param listEngagementMembersRequest
     * @return Result of the ListEngagementMembers operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementMembers"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEngagementMembersResponse listEngagementMembers(ListEngagementMembersRequest listEngagementMembersRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngagementMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEngagementMembersResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementMembersRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngagementMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementMembers");

            return clientHandler.execute(new ClientExecutionParams<ListEngagementMembersRequest, ListEngagementMembersResponse>()
                    .withOperationName("ListEngagementMembers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listEngagementMembersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEngagementMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the associations between resources and engagements where the caller is a member and has at least one
     * snapshot in the engagement.
     * </p>
     *
     * @param listEngagementResourceAssociationsRequest
     * @return Result of the ListEngagementResourceAssociations operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEngagementResourceAssociationsResponse listEngagementResourceAssociations(
            ListEngagementResourceAssociationsRequest listEngagementResourceAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngagementResourceAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListEngagementResourceAssociationsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementResourceAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listEngagementResourceAssociationsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagementResourceAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListEngagementResourceAssociationsRequest, ListEngagementResourceAssociationsResponse>()
                            .withOperationName("ListEngagementResourceAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listEngagementResourceAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListEngagementResourceAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action allows users to retrieve a list of Engagement records from Partner Central. This action can be used
     * to manage and track various engagements across different stages of the partner selling process.
     * </p>
     *
     * @param listEngagementsRequest
     * @return Result of the ListEngagements operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagements"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListEngagementsResponse listEngagements(ListEngagementsRequest listEngagementsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListEngagementsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListEngagementsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listEngagementsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listEngagementsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListEngagements");

            return clientHandler.execute(new ClientExecutionParams<ListEngagementsRequest, ListEngagementsResponse>()
                    .withOperationName("ListEngagements").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listEngagementsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListEngagementsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This request accepts a list of filters that retrieve opportunity subsets as well as sort options. This feature is
     * available to partners from <a href="https://partnercentral.awspartner.com/">Partner Central</a> using the
     * <code>ListOpportunities</code> API action.
     * </p>
     * <p>
     * To synchronize your system with Amazon Web Services, list only the opportunities that were newly created or
     * updated. We recommend you rely on events emitted by the service into your Amazon Web Services account’s Amazon
     * EventBridge default event bus. You can also use the <code>ListOpportunities</code> action.
     * </p>
     * <p>
     * We recommend the following approach:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Find the latest <code>LastModifiedDate</code> that you stored, and only use the values that came from Amazon Web
     * Services. Don’t use values generated by your system.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you send a <code>ListOpportunities</code> request, submit the date in ISO 8601 format in the
     * <code>AfterLastModifiedDate</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services only returns opportunities created or updated on or after that date and time. Use
     * <code>NextToken</code> to iterate over all pages.
     * </p>
     * </li>
     * </ol>
     *
     * @param listOpportunitiesRequest
     * @return Result of the ListOpportunities operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListOpportunities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListOpportunities"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListOpportunitiesResponse listOpportunities(ListOpportunitiesRequest listOpportunitiesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListOpportunitiesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListOpportunitiesResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listOpportunitiesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listOpportunitiesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListOpportunities");

            return clientHandler.execute(new ClientExecutionParams<ListOpportunitiesRequest, ListOpportunitiesResponse>()
                    .withOperationName("ListOpportunities").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listOpportunitiesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListOpportunitiesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists resource snapshot jobs owned by the customer. This operation supports various filtering scenarios,
     * including listing all jobs owned by the caller, jobs for a specific engagement, jobs with a specific status, or
     * any combination of these filters.
     * </p>
     *
     * @param listResourceSnapshotJobsRequest
     * @return Result of the ListResourceSnapshotJobs operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshotJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshotJobs"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceSnapshotJobsResponse listResourceSnapshotJobs(
            ListResourceSnapshotJobsRequest listResourceSnapshotJobsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceSnapshotJobsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceSnapshotJobsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceSnapshotJobsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceSnapshotJobsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceSnapshotJobs");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResourceSnapshotJobsRequest, ListResourceSnapshotJobsResponse>()
                            .withOperationName("ListResourceSnapshotJobs").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listResourceSnapshotJobsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResourceSnapshotJobsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of resource view snapshots based on specified criteria. This operation supports various use
     * cases, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fetching all snapshots associated with an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieving snapshots of a specific resource type within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Obtaining snapshots for a particular resource using a specified template.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accessing the latest snapshot of a resource within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Filtering snapshots by resource owner.
     * </p>
     * </li>
     * </ul>
     *
     * @param listResourceSnapshotsRequest
     * @return Result of the ListResourceSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResourceSnapshotsResponse listResourceSnapshots(ListResourceSnapshotsRequest listResourceSnapshotsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResourceSnapshotsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResourceSnapshotsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResourceSnapshotsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResourceSnapshotsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResourceSnapshots");

            return clientHandler.execute(new ClientExecutionParams<ListResourceSnapshotsRequest, ListResourceSnapshotsResponse>()
                    .withOperationName("ListResourceSnapshots").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listResourceSnapshotsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListResourceSnapshotsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a list of Partner Solutions that the partner registered on Partner Central. This API is used to
     * generate a list of solutions that an end user selects from for association with an opportunity.
     * </p>
     *
     * @param listSolutionsRequest
     * @return Result of the ListSolutions operation returned by the service.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListSolutions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSolutionsResponse listSolutions(ListSolutionsRequest listSolutionsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSolutionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListSolutionsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSolutionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSolutionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSolutions");

            return clientHandler.execute(new ClientExecutionParams<ListSolutionsRequest, ListSolutionsResponse>()
                    .withOperationName("ListSolutions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listSolutionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListSolutionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     *
     * @param putSellingSystemSettingsRequest
     * @return Result of the PutSellingSystemSettings operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.PutSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/PutSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutSellingSystemSettingsResponse putSellingSystemSettings(
            PutSellingSystemSettingsRequest putSellingSystemSettingsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutSellingSystemSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutSellingSystemSettingsResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putSellingSystemSettingsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, putSellingSystemSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutSellingSystemSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<PutSellingSystemSettingsRequest, PutSellingSystemSettingsResponse>()
                            .withOperationName("PutSellingSystemSettings").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putSellingSystemSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutSellingSystemSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action rejects an <code>EngagementInvitation</code> that AWS shared. Rejecting an invitation indicates that
     * the partner doesn't want to pursue the opportunity, and all related data will become inaccessible thereafter.
     * </p>
     *
     * @param rejectEngagementInvitationRequest
     * @return Result of the RejectEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.RejectEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/RejectEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public RejectEngagementInvitationResponse rejectEngagementInvitation(
            RejectEngagementInvitationRequest rejectEngagementInvitationRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RejectEngagementInvitationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, RejectEngagementInvitationResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(rejectEngagementInvitationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, rejectEngagementInvitationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RejectEngagementInvitation");

            return clientHandler
                    .execute(new ClientExecutionParams<RejectEngagementInvitationRequest, RejectEngagementInvitationResponse>()
                            .withOperationName("RejectEngagementInvitation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(rejectEngagementInvitationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new RejectEngagementInvitationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * This action starts the engagement by accepting an <code>EngagementInvitation</code>. The task is asynchronous and
     * involves the following steps: accepting the invitation, creating an opportunity in the partner’s account from the
     * AWS opportunity, and copying details for tracking. When completed, an <code>Opportunity Created</code> event is
     * generated, indicating that the opportunity has been successfully created in the partner's account.
     * </p>
     *
     * @param startEngagementByAcceptingInvitationTaskRequest
     * @return Result of the StartEngagementByAcceptingInvitationTask operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartEngagementByAcceptingInvitationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementByAcceptingInvitationTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartEngagementByAcceptingInvitationTaskResponse startEngagementByAcceptingInvitationTask(
            StartEngagementByAcceptingInvitationTaskRequest startEngagementByAcceptingInvitationTaskRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartEngagementByAcceptingInvitationTaskResponse> responseHandler = protocolFactory
                .createResponseHandler(operationMetadata, StartEngagementByAcceptingInvitationTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(
                startEngagementByAcceptingInvitationTaskRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startEngagementByAcceptingInvitationTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEngagementByAcceptingInvitationTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartEngagementByAcceptingInvitationTaskRequest, StartEngagementByAcceptingInvitationTaskResponse>()
                            .withOperationName("StartEngagementByAcceptingInvitationTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration)
                            .withInput(startEngagementByAcceptingInvitationTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartEngagementByAcceptingInvitationTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Similar to <code>StartEngagementByAcceptingInvitationTask</code>, this action is asynchronous and performs
     * multiple steps before completion. This action orchestrates a comprehensive workflow that combines multiple API
     * operations into a single task to create and initiate an engagement from an existing opportunity. It automatically
     * executes a sequence of operations including <code>GetOpportunity</code>, <code>CreateEngagement</code> (if it
     * doesn't exist), <code>CreateResourceSnapshot</code>, <code>CreateResourceSnapshotJob</code>,
     * <code>CreateEngagementInvitation</code> (if not already invited/accepted), and <code>SubmitOpportunity</code>.
     * </p>
     *
     * @param startEngagementFromOpportunityTaskRequest
     * @return Result of the StartEngagementFromOpportunityTask operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartEngagementFromOpportunityTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementFromOpportunityTask"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartEngagementFromOpportunityTaskResponse startEngagementFromOpportunityTask(
            StartEngagementFromOpportunityTaskRequest startEngagementFromOpportunityTaskRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartEngagementFromOpportunityTaskResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartEngagementFromOpportunityTaskResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startEngagementFromOpportunityTaskRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                startEngagementFromOpportunityTaskRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartEngagementFromOpportunityTask");

            return clientHandler
                    .execute(new ClientExecutionParams<StartEngagementFromOpportunityTaskRequest, StartEngagementFromOpportunityTaskResponse>()
                            .withOperationName("StartEngagementFromOpportunityTask").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startEngagementFromOpportunityTaskRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartEngagementFromOpportunityTaskRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Starts a resource snapshot job that has been previously created.
     * </p>
     *
     * @param startResourceSnapshotJobRequest
     * @return Result of the StartResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartResourceSnapshotJobResponse startResourceSnapshotJob(
            StartResourceSnapshotJobRequest startResourceSnapshotJobRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartResourceSnapshotJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartResourceSnapshotJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StartResourceSnapshotJobRequest, StartResourceSnapshotJobResponse>()
                            .withOperationName("StartResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startResourceSnapshotJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartResourceSnapshotJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Stops a resource snapshot job. The job must be started prior to being stopped.
     * </p>
     *
     * @param stopResourceSnapshotJobRequest
     * @return Result of the StopResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StopResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StopResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StopResourceSnapshotJobResponse stopResourceSnapshotJob(StopResourceSnapshotJobRequest stopResourceSnapshotJobRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StopResourceSnapshotJobResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StopResourceSnapshotJobResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(stopResourceSnapshotJobRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, stopResourceSnapshotJobRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StopResourceSnapshotJob");

            return clientHandler
                    .execute(new ClientExecutionParams<StopResourceSnapshotJobRequest, StopResourceSnapshotJobResponse>()
                            .withOperationName("StopResourceSnapshotJob").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(stopResourceSnapshotJobRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StopResourceSnapshotJobRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use this action to submit an Opportunity that was previously created by partner for AWS review. After you perform
     * this action, the Opportunity becomes non-editable until it is reviewed by AWS and has
     * <code> LifeCycle.ReviewStatus </code> as either <code>Approved</code> or <code>Action Required</code>.
     * </p>
     *
     * @param submitOpportunityRequest
     * @return Result of the SubmitOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.SubmitOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/SubmitOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public SubmitOpportunityResponse submitOpportunity(SubmitOpportunityRequest submitOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SubmitOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SubmitOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(submitOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, submitOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SubmitOpportunity");

            return clientHandler.execute(new ClientExecutionParams<SubmitOpportunityRequest, SubmitOpportunityResponse>()
                    .withOperationName("SubmitOpportunity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(submitOpportunityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SubmitOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the <code>Opportunity</code> record identified by a given <code>Identifier</code>. This operation allows
     * you to modify the details of an existing opportunity to reflect the latest information and progress. Use this
     * action to keep the opportunity record up-to-date and accurate.
     * </p>
     * <p>
     * When you perform updates, include the entire payload with each request. If any field is omitted, the API assumes
     * that the field is set to <code>null</code>. The best practice is to always perform a <code>GetOpportunity</code>
     * to retrieve the latest values, then send the complete payload with the updated values to be changed.
     * </p>
     *
     * @param updateOpportunityRequest
     * @return Result of the UpdateOpportunity operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.UpdateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UpdateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateOpportunityResponse updateOpportunity(UpdateOpportunityRequest updateOpportunityRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateOpportunityResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateOpportunityResponse::builder);
        Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper = errorCode -> {
            if (errorCode == null) {
                return Optional.empty();
            }
            switch (errorCode) {
            case "ThrottlingException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ThrottlingException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ThrottlingException::builder).build());
            case "ServiceQuotaExceededException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ServiceQuotaExceededException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ServiceQuotaExceededException::builder).build());
            case "InternalServerException":
                return Optional.of(ExceptionMetadata.builder().errorCode("InternalServerException").httpStatusCode(500)
                        .exceptionBuilderSupplier(InternalServerException::builder).build());
            case "AccessDeniedException":
                return Optional.of(ExceptionMetadata.builder().errorCode("AccessDeniedException").httpStatusCode(400)
                        .exceptionBuilderSupplier(AccessDeniedException::builder).build());
            case "ConflictException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ConflictException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ConflictException::builder).build());
            case "ResourceNotFoundException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ResourceNotFoundException::builder).build());
            case "ValidationException":
                return Optional.of(ExceptionMetadata.builder().errorCode("ValidationException").httpStatusCode(400)
                        .exceptionBuilderSupplier(ValidationException::builder).build());
            default:
                return Optional.empty();
            }
        };
        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata, exceptionMetadataMapper);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateOpportunityRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateOpportunityRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "PartnerCentral Selling");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateOpportunity");

            return clientHandler.execute(new ClientExecutionParams<UpdateOpportunityRequest, UpdateOpportunityResponse>()
                    .withOperationName("UpdateOpportunity").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateOpportunityRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateOpportunityRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata, Function<String, Optional<ExceptionMetadata>> exceptionMetadataMapper) {
        return protocolFactory.createErrorResponseHandler(operationMetadata, exceptionMetadataMapper);
    }

    private void updateRetryStrategyClientConfiguration(SdkClientConfiguration.Builder configuration) {
        ClientOverrideConfiguration.Builder builder = configuration.asOverrideConfigurationBuilder();
        RetryMode retryMode = builder.retryMode();
        if (retryMode != null) {
            configuration.option(SdkClientOption.RETRY_STRATEGY, AwsRetryStrategy.forRetryMode(retryMode));
        } else {
            Consumer<RetryStrategy.Builder<?, ?>> configurator = builder.retryStrategyConfigurator();
            if (configurator != null) {
                RetryStrategy.Builder<?, ?> defaultBuilder = AwsRetryStrategy.defaultRetryStrategy().toBuilder();
                configurator.accept(defaultBuilder);
                configuration.option(SdkClientOption.RETRY_STRATEGY, defaultBuilder.build());
            } else {
                RetryStrategy retryStrategy = builder.retryStrategy();
                if (retryStrategy != null) {
                    configuration.option(SdkClientOption.RETRY_STRATEGY, retryStrategy);
                }
            }
        }
        configuration.option(SdkClientOption.CONFIGURED_RETRY_MODE, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_STRATEGY, null);
        configuration.option(SdkClientOption.CONFIGURED_RETRY_CONFIGURATOR, null);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        if (plugins.isEmpty()) {
            return clientConfiguration;
        }
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        PartnerCentralSellingServiceClientConfigurationBuilder serviceConfigBuilder = new PartnerCentralSellingServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        updateRetryStrategyClientConfiguration(configuration);
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder.clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(PartnerCentralSellingException::builder).protocol(AwsJsonProtocol.AWS_JSON)
                .protocolVersion("1.0");
    }

    @Override
    public final PartnerCentralSellingServiceClientConfiguration serviceClientConfiguration() {
        return new PartnerCentralSellingServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
