/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AccessDeniedException;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ConflictException;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotRequest;
import software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetEngagementResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotResponse;
import software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.InternalServerException;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingException;
import software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsRequest;
import software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsResponse;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationRequest;
import software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ResourceNotFoundException;
import software.amazon.awssdk.services.partnercentralselling.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobRequest;
import software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobResponse;
import software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.TagResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.TagResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ThrottlingException;
import software.amazon.awssdk.services.partnercentralselling.model.UntagResourceRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UntagResourceResponse;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityRequest;
import software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityResponse;
import software.amazon.awssdk.services.partnercentralselling.model.ValidationException;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable;
import software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable;

/**
 * Service client for accessing Partner Central Selling API. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * <fullname>AWS Partner Central API for Selling</fullname>
 * <p>
 * <b>AWS Partner Central API for Selling Reference Guide</b>
 * </p>
 * <p>
 * This Amazon Web Services (AWS) Partner Central API reference is designed to help <a
 * href="http://aws.amazon.com/partners/programs/">AWS Partners</a> integrate Customer Relationship Management (CRM)
 * systems with AWS Partner Central. Partners can automate interactions with AWS Partner Central, which helps to ensure
 * effective engagements in joint business activities.
 * </p>
 * <p>
 * The API provides standard AWS API functionality. Access it by either using API <a
 * href="https://docs.aws.amazon.com/partner-central/latest/selling-api/API_Operations.html">Actions</a> or by using an
 * AWS SDK that's tailored to your programming language or platform. For more information, see <a
 * href="http://aws.amazon.com/getting-started">Getting Started with AWS</a> and <a
 * href="http://aws.amazon.com/developer/tools/">Tools to Build on AWS</a>.
 * </p>
 * <p class="title">
 * <b>Features offered by AWS Partner Central API</b>
 * </p>
 * <ol>
 * <li>
 * <p>
 * <b>Opportunity management:</b> Manages coselling opportunities through API actions such as
 * <code>CreateOpportunity</code>, <code>UpdateOpportunity</code>, <code>ListOpportunities</code>,
 * <code>GetOpportunity</code>, and <code>AssignOpportunity</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>AWS referral management:</b> Manages referrals shared by AWS using actions such as
 * <code>ListEngagementInvitations</code>, <code>GetEngagementInvitation</code>,
 * <code>StartEngagementByAcceptingInvitation</code>, and <code>RejectEngagementInvitation</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Entity association:</b> Associates related entities such as <i>AWS Products</i>, <i>Partner Solutions</i>, and
 * <i>AWS Marketplace Private Offers</i> with opportunities using the actions <code>AssociateOpportunity</code>, and
 * <code>DisassociateOpportunity</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>View AWS opportunity details:</b> Retrieves real-time summaries of AWS opportunities using the
 * <code>GetAWSOpportunitySummary</code> action.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>List solutions:</b> Provides list APIs for listing partner offers using <code>ListSolutions</code>.
 * </p>
 * </li>
 * <li>
 * <p>
 * <b>Event subscription:</b> Subscribe to real-time opportunity updates through AWS EventBridge by using actions such
 * as <i>Opportunity Created</i>, <i>Opportunity Updated</i>, <i>Engagement Invitation Accepted</i>, <i>Engagement
 * Invitation Rejected</i>, and <i>Engagement Invitation Created</i>.
 * </p>
 * </li>
 * </ol>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface PartnerCentralSellingClient extends AwsClient {
    String SERVICE_NAME = "partnercentral-selling";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "partnercentral-selling";

    /**
     * <p>
     * Use the <code>AcceptEngagementInvitation</code> action to accept an engagement invitation shared by AWS.
     * Accepting the invitation indicates your willingness to participate in the engagement, granting you access to all
     * engagement-related data.
     * </p>
     *
     * @param acceptEngagementInvitationRequest
     * @return Result of the AcceptEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AcceptEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AcceptEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptEngagementInvitationResponse acceptEngagementInvitation(
            AcceptEngagementInvitationRequest acceptEngagementInvitationRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use the <code>AcceptEngagementInvitation</code> action to accept an engagement invitation shared by AWS.
     * Accepting the invitation indicates your willingness to participate in the engagement, granting you access to all
     * engagement-related data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AcceptEngagementInvitationRequest.Builder} avoiding
     * the need to create one manually via {@link AcceptEngagementInvitationRequest#builder()}
     * </p>
     *
     * @param acceptEngagementInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.AcceptEngagementInvitationRequest.Builder}
     *        to create a request.
     * @return Result of the AcceptEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AcceptEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AcceptEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default AcceptEngagementInvitationResponse acceptEngagementInvitation(
            Consumer<AcceptEngagementInvitationRequest.Builder> acceptEngagementInvitationRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return acceptEngagementInvitation(AcceptEngagementInvitationRequest.builder()
                .applyMutation(acceptEngagementInvitationRequest).build());
    }

    /**
     * <p>
     * Enables you to reassign an existing <code>Opportunity</code> to another user within your Partner Central account.
     * The specified user receives the opportunity, and it appears on their Partner Central dashboard, allowing them to
     * take necessary actions or proceed with the opportunity.
     * </p>
     * <p>
     * This is useful for distributing opportunities to the appropriate team members or departments within your
     * organization, ensuring that each opportunity is handled by the right person. By default, the opportunity owner is
     * the one who creates it. Currently, there's no API to enumerate the list of available users.
     * </p>
     *
     * @param assignOpportunityRequest
     * @return Result of the AssignOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AssignOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssignOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default AssignOpportunityResponse assignOpportunity(AssignOpportunityRequest assignOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to reassign an existing <code>Opportunity</code> to another user within your Partner Central account.
     * The specified user receives the opportunity, and it appears on their Partner Central dashboard, allowing them to
     * take necessary actions or proceed with the opportunity.
     * </p>
     * <p>
     * This is useful for distributing opportunities to the appropriate team members or departments within your
     * organization, ensuring that each opportunity is handled by the right person. By default, the opportunity owner is
     * the one who creates it. Currently, there's no API to enumerate the list of available users.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssignOpportunityRequest.Builder} avoiding the need
     * to create one manually via {@link AssignOpportunityRequest#builder()}
     * </p>
     *
     * @param assignOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.AssignOpportunityRequest.Builder} to
     *        create a request.
     * @return Result of the AssignOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AssignOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssignOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default AssignOpportunityResponse assignOpportunity(Consumer<AssignOpportunityRequest.Builder> assignOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return assignOpportunity(AssignOpportunityRequest.builder().applyMutation(assignOpportunityRequest).build());
    }

    /**
     * <p>
     * Enables you to create a formal association between an <code>Opportunity</code> and various related entities,
     * enriching the context and details of the opportunity for better collaboration and decision making. You can
     * associate an opportunity with the following entity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Partner Solution: A software product or consulting practice created and delivered by Partners. Partner Solutions
     * help customers address business challenges using Amazon Web Services services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Products: Amazon Web Services offers many products and services that provide scalable,
     * reliable, and cost-effective infrastructure solutions. For the latest list of Amazon Web Services products, see
     * <a href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
     * Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Allows Amazon Web Services Marketplace sellers to extend custom
     * pricing and terms to individual Amazon Web Services customers. Sellers can negotiate custom prices, payment
     * schedules, and end user license terms through private offers, enabling Amazon Web Services customers to acquire
     * software solutions tailored to their specific needs. For more information, see <a
     * href="https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-private-offers.html">Private offers in
     * Amazon Web Services Marketplace</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain identifiers for these entities, use the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Solution: Use the <code>ListSolutions</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Products: For the latest list of Amazon Web Services products, see <a
     * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json"
     * >Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Use the <a
     * href="https://docs.aws.amazon.com/marketplace/latest/APIReference/catalog-apis.html">Using the Amazon Web
     * Services Marketplace Catalog API</a> to list entities. Specifically, use the <code>ListEntities</code> operation
     * to retrieve a list of private offers. The request returns the details of available private offers. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
     * >ListEntities</a>.
     * </p>
     * </li>
     * </ul>
     *
     * @param associateOpportunityRequest
     * @return Result of the AssociateOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AssociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateOpportunityResponse associateOpportunity(AssociateOpportunityRequest associateOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables you to create a formal association between an <code>Opportunity</code> and various related entities,
     * enriching the context and details of the opportunity for better collaboration and decision making. You can
     * associate an opportunity with the following entity types:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Partner Solution: A software product or consulting practice created and delivered by Partners. Partner Solutions
     * help customers address business challenges using Amazon Web Services services.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Products: Amazon Web Services offers many products and services that provide scalable,
     * reliable, and cost-effective infrastructure solutions. For the latest list of Amazon Web Services products, see
     * <a href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
     * Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Allows Amazon Web Services Marketplace sellers to extend custom
     * pricing and terms to individual Amazon Web Services customers. Sellers can negotiate custom prices, payment
     * schedules, and end user license terms through private offers, enabling Amazon Web Services customers to acquire
     * software solutions tailored to their specific needs. For more information, see <a
     * href="https://docs.aws.amazon.com/marketplace/latest/buyerguide/buyer-private-offers.html">Private offers in
     * Amazon Web Services Marketplace</a>.
     * </p>
     * </li>
     * </ul>
     * <p>
     * To obtain identifiers for these entities, use the following methods:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Solution: Use the <code>ListSolutions</code> operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * AWS Products: For the latest list of Amazon Web Services products, see <a
     * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json"
     * >Amazon Web Services products</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services Marketplace private offer: Use the <a
     * href="https://docs.aws.amazon.com/marketplace/latest/APIReference/catalog-apis.html">Using the Amazon Web
     * Services Marketplace Catalog API</a> to list entities. Specifically, use the <code>ListEntities</code> operation
     * to retrieve a list of private offers. The request returns the details of available private offers. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
     * >ListEntities</a>.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateOpportunityRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateOpportunityRequest#builder()}
     * </p>
     *
     * @param associateOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.AssociateOpportunityRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.AssociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/AssociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateOpportunityResponse associateOpportunity(
            Consumer<AssociateOpportunityRequest.Builder> associateOpportunityRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return associateOpportunity(AssociateOpportunityRequest.builder().applyMutation(associateOpportunityRequest).build());
    }

    /**
     * <p>
     * The <code>CreateEngagement</code> action allows you to create an <code>Engagement</code>, which serves as a
     * collaborative space between different parties such as AWS Partners and AWS Sellers. This action automatically
     * adds the caller's AWS account as an active member of the newly created <code>Engagement</code>.
     * </p>
     *
     * @param createEngagementRequest
     * @return Result of the CreateEngagement operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEngagementResponse createEngagement(CreateEngagementRequest createEngagementRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * The <code>CreateEngagement</code> action allows you to create an <code>Engagement</code>, which serves as a
     * collaborative space between different parties such as AWS Partners and AWS Sellers. This action automatically
     * adds the caller's AWS account as an active member of the newly created <code>Engagement</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEngagementRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEngagementRequest#builder()}
     * </p>
     *
     * @param createEngagementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementRequest.Builder} to
     *        create a request.
     * @return Result of the CreateEngagement operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEngagementResponse createEngagement(Consumer<CreateEngagementRequest.Builder> createEngagementRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return createEngagement(CreateEngagementRequest.builder().applyMutation(createEngagementRequest).build());
    }

    /**
     * <p>
     * This action creates an invitation from a sender to a single receiver to join an engagement.
     * </p>
     *
     * @param createEngagementInvitationRequest
     * @return Result of the CreateEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEngagementInvitationResponse createEngagementInvitation(
            CreateEngagementInvitationRequest createEngagementInvitationRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action creates an invitation from a sender to a single receiver to join an engagement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEngagementInvitationRequest.Builder} avoiding
     * the need to create one manually via {@link CreateEngagementInvitationRequest#builder()}
     * </p>
     *
     * @param createEngagementInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.CreateEngagementInvitationRequest.Builder}
     *        to create a request.
     * @return Result of the CreateEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateEngagementInvitationResponse createEngagementInvitation(
            Consumer<CreateEngagementInvitationRequest.Builder> createEngagementInvitationRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return createEngagementInvitation(CreateEngagementInvitationRequest.builder()
                .applyMutation(createEngagementInvitationRequest).build());
    }

    /**
     * <p>
     * Creates an <code>Opportunity</code> record in Partner Central. Use this operation to create a potential business
     * opportunity for submission to Amazon Web Services. Creating an opportunity sets
     * <code>Lifecycle.ReviewStatus</code> to <code>Pending Submission</code>.
     * </p>
     * <p>
     * To submit an opportunity, follow these steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * To create the opportunity, use <code>CreateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To associate a solution with the opportunity, use <code>AssociateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To start the engagement with AWS, use <code>StartEngagementFromOpportunity</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After submission, you can't edit the opportunity until the review is complete. But opportunities in the
     * <code>Pending Submission</code> state must have complete details. You can update the opportunity while it's in
     * the <code>Pending Submission</code> state.
     * </p>
     * <p>
     * There's a set of mandatory fields to create opportunities, but consider providing optional fields to enrich the
     * opportunity record.
     * </p>
     *
     * @param createOpportunityRequest
     * @return Result of the CreateOpportunity operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOpportunityResponse createOpportunity(CreateOpportunityRequest createOpportunityRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an <code>Opportunity</code> record in Partner Central. Use this operation to create a potential business
     * opportunity for submission to Amazon Web Services. Creating an opportunity sets
     * <code>Lifecycle.ReviewStatus</code> to <code>Pending Submission</code>.
     * </p>
     * <p>
     * To submit an opportunity, follow these steps:
     * </p>
     * <ol>
     * <li>
     * <p>
     * To create the opportunity, use <code>CreateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To associate a solution with the opportunity, use <code>AssociateOpportunity</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * To start the engagement with AWS, use <code>StartEngagementFromOpportunity</code>.
     * </p>
     * </li>
     * </ol>
     * <p>
     * After submission, you can't edit the opportunity until the review is complete. But opportunities in the
     * <code>Pending Submission</code> state must have complete details. You can update the opportunity while it's in
     * the <code>Pending Submission</code> state.
     * </p>
     * <p>
     * There's a set of mandatory fields to create opportunities, but consider providing optional fields to enrich the
     * opportunity record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateOpportunityRequest.Builder} avoiding the need
     * to create one manually via {@link CreateOpportunityRequest#builder()}
     * </p>
     *
     * @param createOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.CreateOpportunityRequest.Builder} to
     *        create a request.
     * @return Result of the CreateOpportunity operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateOpportunityResponse createOpportunity(Consumer<CreateOpportunityRequest.Builder> createOpportunityRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return createOpportunity(CreateOpportunityRequest.builder().applyMutation(createOpportunityRequest).build());
    }

    /**
     * <p>
     * This action allows you to create an immutable snapshot of a specific resource, such as an opportunity, within the
     * context of an engagement. The snapshot captures a subset of the resource's data based on the schema defined by
     * the provided template.
     * </p>
     *
     * @param createResourceSnapshotRequest
     * @return Result of the CreateResourceSnapshot operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceSnapshotResponse createResourceSnapshot(CreateResourceSnapshotRequest createResourceSnapshotRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action allows you to create an immutable snapshot of a specific resource, such as an opportunity, within the
     * context of an engagement. The snapshot captures a subset of the resource's data based on the schema defined by
     * the provided template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link CreateResourceSnapshotRequest#builder()}
     * </p>
     *
     * @param createResourceSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotRequest.Builder}
     *        to create a request.
     * @return Result of the CreateResourceSnapshot operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceSnapshotResponse createResourceSnapshot(
            Consumer<CreateResourceSnapshotRequest.Builder> createResourceSnapshotRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return createResourceSnapshot(CreateResourceSnapshotRequest.builder().applyMutation(createResourceSnapshotRequest)
                .build());
    }

    /**
     * <p>
     * Use this action to create a job to generate a snapshot of the specified resource within an engagement. It
     * initiates an asynchronous process to create a resource snapshot. The job creates a new snapshot only if the
     * resource state has changed, adhering to the same access control and immutability rules as direct snapshot
     * creation.
     * </p>
     *
     * @param createResourceSnapshotJobRequest
     * @return Result of the CreateResourceSnapshotJob operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceSnapshotJobResponse createResourceSnapshotJob(
            CreateResourceSnapshotJobRequest createResourceSnapshotJobRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, ServiceQuotaExceededException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to create a job to generate a snapshot of the specified resource within an engagement. It
     * initiates an asynchronous process to create a resource snapshot. The job creates a new snapshot only if the
     * resource state has changed, adhering to the same access control and immutability rules as direct snapshot
     * creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResourceSnapshotJobRequest.Builder} avoiding
     * the need to create one manually via {@link CreateResourceSnapshotJobRequest#builder()}
     * </p>
     *
     * @param createResourceSnapshotJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.CreateResourceSnapshotJobRequest.Builder}
     *        to create a request.
     * @return Result of the CreateResourceSnapshotJob operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.CreateResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/CreateResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateResourceSnapshotJobResponse createResourceSnapshotJob(
            Consumer<CreateResourceSnapshotJobRequest.Builder> createResourceSnapshotJobRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, ValidationException, ServiceQuotaExceededException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return createResourceSnapshotJob(CreateResourceSnapshotJobRequest.builder()
                .applyMutation(createResourceSnapshotJobRequest).build());
    }

    /**
     * <p>
     * Use this action to deletes a previously created resource snapshot job. The job must be in a stopped state before
     * it can be deleted.
     * </p>
     *
     * @param deleteResourceSnapshotJobRequest
     * @return Result of the DeleteResourceSnapshotJob operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.DeleteResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DeleteResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceSnapshotJobResponse deleteResourceSnapshotJob(
            DeleteResourceSnapshotJobRequest deleteResourceSnapshotJobRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to deletes a previously created resource snapshot job. The job must be in a stopped state before
     * it can be deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResourceSnapshotJobRequest.Builder} avoiding
     * the need to create one manually via {@link DeleteResourceSnapshotJobRequest#builder()}
     * </p>
     *
     * @param deleteResourceSnapshotJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.DeleteResourceSnapshotJobRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteResourceSnapshotJob operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.DeleteResourceSnapshotJob
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DeleteResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteResourceSnapshotJobResponse deleteResourceSnapshotJob(
            Consumer<DeleteResourceSnapshotJobRequest.Builder> deleteResourceSnapshotJobRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return deleteResourceSnapshotJob(DeleteResourceSnapshotJobRequest.builder()
                .applyMutation(deleteResourceSnapshotJobRequest).build());
    }

    /**
     * <p>
     * Allows you to remove an existing association between an <code>Opportunity</code> and related entities, such as a
     * Partner Solution, Amazon Web Services product, or an Amazon Web Services Marketplace offer. This operation is the
     * counterpart to <code>AssociateOpportunity</code>, and it provides flexibility to manage associations as business
     * needs change.
     * </p>
     * <p>
     * Use this operation to update the associations of an <code>Opportunity</code> due to changes in the related
     * entities, or if an association was made in error. Ensuring accurate associations helps maintain clarity and
     * accuracy to track and manage business opportunities. When you replace an entity, first attach the new entity and
     * then disassociate the one to be removed, especially if it's the last remaining entity that's required.
     * </p>
     *
     * @param disassociateOpportunityRequest
     * @return Result of the DisassociateOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.DisassociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DisassociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateOpportunityResponse disassociateOpportunity(DisassociateOpportunityRequest disassociateOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to remove an existing association between an <code>Opportunity</code> and related entities, such as a
     * Partner Solution, Amazon Web Services product, or an Amazon Web Services Marketplace offer. This operation is the
     * counterpart to <code>AssociateOpportunity</code>, and it provides flexibility to manage associations as business
     * needs change.
     * </p>
     * <p>
     * Use this operation to update the associations of an <code>Opportunity</code> due to changes in the related
     * entities, or if an association was made in error. Ensuring accurate associations helps maintain clarity and
     * accuracy to track and manage business opportunities. When you replace an entity, first attach the new entity and
     * then disassociate the one to be removed, especially if it's the last remaining entity that's required.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateOpportunityRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateOpportunityRequest#builder()}
     * </p>
     *
     * @param disassociateOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.DisassociateOpportunityRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.DisassociateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/DisassociateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateOpportunityResponse disassociateOpportunity(
            Consumer<DisassociateOpportunityRequest.Builder> disassociateOpportunityRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return disassociateOpportunity(DisassociateOpportunityRequest.builder().applyMutation(disassociateOpportunityRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a summary of an AWS Opportunity. This summary includes high-level details about the opportunity sourced
     * from AWS, such as lifecycle information, customer details, and involvement type. It is useful for tracking
     * updates on the AWS opportunity corresponding to an opportunity in the partner's account.
     * </p>
     *
     * @param getAwsOpportunitySummaryRequest
     * @return Result of the GetAwsOpportunitySummary operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetAwsOpportunitySummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetAwsOpportunitySummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsOpportunitySummaryResponse getAwsOpportunitySummary(
            GetAwsOpportunitySummaryRequest getAwsOpportunitySummaryRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a summary of an AWS Opportunity. This summary includes high-level details about the opportunity sourced
     * from AWS, such as lifecycle information, customer details, and involvement type. It is useful for tracking
     * updates on the AWS opportunity corresponding to an opportunity in the partner's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAwsOpportunitySummaryRequest.Builder} avoiding
     * the need to create one manually via {@link GetAwsOpportunitySummaryRequest#builder()}
     * </p>
     *
     * @param getAwsOpportunitySummaryRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetAwsOpportunitySummaryRequest.Builder}
     *        to create a request.
     * @return Result of the GetAwsOpportunitySummary operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetAwsOpportunitySummary
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetAwsOpportunitySummary"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAwsOpportunitySummaryResponse getAwsOpportunitySummary(
            Consumer<GetAwsOpportunitySummaryRequest.Builder> getAwsOpportunitySummaryRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return getAwsOpportunitySummary(GetAwsOpportunitySummaryRequest.builder().applyMutation(getAwsOpportunitySummaryRequest)
                .build());
    }

    /**
     * <p>
     * Use this action to retrieve the engagement record for a given <code>EngagementIdentifier</code>.
     * </p>
     *
     * @param getEngagementRequest
     * @return Result of the GetEngagement operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEngagementResponse getEngagement(GetEngagementRequest getEngagementRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to retrieve the engagement record for a given <code>EngagementIdentifier</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEngagementRequest.Builder} avoiding the need to
     * create one manually via {@link GetEngagementRequest#builder()}
     * </p>
     *
     * @param getEngagementRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetEngagementRequest.Builder} to create
     *        a request.
     * @return Result of the GetEngagement operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetEngagement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagement"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEngagementResponse getEngagement(Consumer<GetEngagementRequest.Builder> getEngagementRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return getEngagement(GetEngagementRequest.builder().applyMutation(getEngagementRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of an engagement invitation shared by AWS with a partner. The information includes aspects
     * such as customer, project details, and lifecycle information. To connect an engagement invitation with an
     * opportunity, match the invitation’s <code>Payload.Project.Title</code> with opportunity
     * <code>Project.Title</code>.
     * </p>
     *
     * @param getEngagementInvitationRequest
     * @return Result of the GetEngagementInvitation operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetEngagementInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEngagementInvitationResponse getEngagementInvitation(GetEngagementInvitationRequest getEngagementInvitationRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of an engagement invitation shared by AWS with a partner. The information includes aspects
     * such as customer, project details, and lifecycle information. To connect an engagement invitation with an
     * opportunity, match the invitation’s <code>Payload.Project.Title</code> with opportunity
     * <code>Project.Title</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetEngagementInvitationRequest.Builder} avoiding
     * the need to create one manually via {@link GetEngagementInvitationRequest#builder()}
     * </p>
     *
     * @param getEngagementInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetEngagementInvitationRequest.Builder}
     *        to create a request.
     * @return Result of the GetEngagementInvitation operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetEngagementInvitation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetEngagementInvitationResponse getEngagementInvitation(
            Consumer<GetEngagementInvitationRequest.Builder> getEngagementInvitationRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return getEngagementInvitation(GetEngagementInvitationRequest.builder().applyMutation(getEngagementInvitationRequest)
                .build());
    }

    /**
     * <p>
     * Fetches the <code>Opportunity</code> record from Partner Central by a given <code>Identifier</code>.
     * </p>
     * <p>
     * Use the <code>ListOpportunities</code> action or the event notification (from Amazon EventBridge) to obtain this
     * identifier.
     * </p>
     *
     * @param getOpportunityRequest
     * @return Result of the GetOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOpportunityResponse getOpportunity(GetOpportunityRequest getOpportunityRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Fetches the <code>Opportunity</code> record from Partner Central by a given <code>Identifier</code>.
     * </p>
     * <p>
     * Use the <code>ListOpportunities</code> action or the event notification (from Amazon EventBridge) to obtain this
     * identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetOpportunityRequest.Builder} avoiding the need to
     * create one manually via {@link GetOpportunityRequest#builder()}
     * </p>
     *
     * @param getOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetOpportunityRequest.Builder} to
     *        create a request.
     * @return Result of the GetOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default GetOpportunityResponse getOpportunity(Consumer<GetOpportunityRequest.Builder> getOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return getOpportunity(GetOpportunityRequest.builder().applyMutation(getOpportunityRequest).build());
    }

    /**
     * <p>
     * Use this action to retrieve a specific snapshot record.
     * </p>
     *
     * @param getResourceSnapshotRequest
     * @return Result of the GetResourceSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceSnapshotResponse getResourceSnapshot(GetResourceSnapshotRequest getResourceSnapshotRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to retrieve a specific snapshot record.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSnapshotRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceSnapshotRequest#builder()}
     * </p>
     *
     * @param getResourceSnapshotRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotRequest.Builder} to
     *        create a request.
     * @return Result of the GetResourceSnapshot operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetResourceSnapshot
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshot"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceSnapshotResponse getResourceSnapshot(
            Consumer<GetResourceSnapshotRequest.Builder> getResourceSnapshotRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return getResourceSnapshot(GetResourceSnapshotRequest.builder().applyMutation(getResourceSnapshotRequest).build());
    }

    /**
     * <p>
     * Use this action to retrieves information about a specific resource snapshot job.
     * </p>
     *
     * @param getResourceSnapshotJobRequest
     * @return Result of the GetResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceSnapshotJobResponse getResourceSnapshotJob(GetResourceSnapshotJobRequest getResourceSnapshotJobRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to retrieves information about a specific resource snapshot job.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResourceSnapshotJobRequest.Builder} avoiding the
     * need to create one manually via {@link GetResourceSnapshotJobRequest#builder()}
     * </p>
     *
     * @param getResourceSnapshotJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetResourceSnapshotJobRequest.Builder}
     *        to create a request.
     * @return Result of the GetResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default GetResourceSnapshotJobResponse getResourceSnapshotJob(
            Consumer<GetResourceSnapshotJobRequest.Builder> getResourceSnapshotJobRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return getResourceSnapshotJob(GetResourceSnapshotJobRequest.builder().applyMutation(getResourceSnapshotJobRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     *
     * @param getSellingSystemSettingsRequest
     * @return Result of the GetSellingSystemSettings operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSellingSystemSettingsResponse getSellingSystemSettings(
            GetSellingSystemSettingsRequest getSellingSystemSettingsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSellingSystemSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link GetSellingSystemSettingsRequest#builder()}
     * </p>
     *
     * @param getSellingSystemSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.GetSellingSystemSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the GetSellingSystemSettings operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.GetSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/GetSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSellingSystemSettingsResponse getSellingSystemSettings(
            Consumer<GetSellingSystemSettingsRequest.Builder> getSellingSystemSettingsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return getSellingSystemSettings(GetSellingSystemSettingsRequest.builder().applyMutation(getSellingSystemSettingsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed StartEngagementByAcceptingInvitationTask tasks that were initiated by
     * the caller's account.
     * </p>
     *
     * @param listEngagementByAcceptingInvitationTasksRequest
     * @return Result of the ListEngagementByAcceptingInvitationTasks operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementByAcceptingInvitationTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementByAcceptingInvitationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementByAcceptingInvitationTasksResponse listEngagementByAcceptingInvitationTasks(
            ListEngagementByAcceptingInvitationTasksRequest listEngagementByAcceptingInvitationTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed StartEngagementByAcceptingInvitationTask tasks that were initiated by
     * the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEngagementByAcceptingInvitationTasksRequest.Builder} avoiding the need to create one manually via
     * {@link ListEngagementByAcceptingInvitationTasksRequest#builder()}
     * </p>
     *
     * @param listEngagementByAcceptingInvitationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest.Builder}
     *        to create a request.
     * @return Result of the ListEngagementByAcceptingInvitationTasks operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementByAcceptingInvitationTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementByAcceptingInvitationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementByAcceptingInvitationTasksResponse listEngagementByAcceptingInvitationTasks(
            Consumer<ListEngagementByAcceptingInvitationTasksRequest.Builder> listEngagementByAcceptingInvitationTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementByAcceptingInvitationTasks(ListEngagementByAcceptingInvitationTasksRequest.builder()
                .applyMutation(listEngagementByAcceptingInvitationTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementByAcceptingInvitationTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable responses = client.listEngagementByAcceptingInvitationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable responses = client
     *             .listEngagementByAcceptingInvitationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable responses = client.listEngagementByAcceptingInvitationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementByAcceptingInvitationTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngagementByAcceptingInvitationTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementByAcceptingInvitationTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementByAcceptingInvitationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementByAcceptingInvitationTasksIterable listEngagementByAcceptingInvitationTasksPaginator(
            ListEngagementByAcceptingInvitationTasksRequest listEngagementByAcceptingInvitationTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return new ListEngagementByAcceptingInvitationTasksIterable(this, listEngagementByAcceptingInvitationTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementByAcceptingInvitationTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable responses = client.listEngagementByAcceptingInvitationTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable responses = client
     *             .listEngagementByAcceptingInvitationTasksPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementByAcceptingInvitationTasksIterable responses = client.listEngagementByAcceptingInvitationTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementByAcceptingInvitationTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link ListEngagementByAcceptingInvitationTasksRequest.Builder} avoiding the need to create one manually via
     * {@link ListEngagementByAcceptingInvitationTasksRequest#builder()}
     * </p>
     *
     * @param listEngagementByAcceptingInvitationTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementByAcceptingInvitationTasksRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementByAcceptingInvitationTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementByAcceptingInvitationTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementByAcceptingInvitationTasksIterable listEngagementByAcceptingInvitationTasksPaginator(
            Consumer<ListEngagementByAcceptingInvitationTasksRequest.Builder> listEngagementByAcceptingInvitationTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementByAcceptingInvitationTasksPaginator(ListEngagementByAcceptingInvitationTasksRequest.builder()
                .applyMutation(listEngagementByAcceptingInvitationTasksRequest).build());
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed <code>EngagementFromOpportunity</code> tasks that were initiated by
     * the caller's account.
     * </p>
     *
     * @param listEngagementFromOpportunityTasksRequest
     * @return Result of the ListEngagementFromOpportunityTasks operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementFromOpportunityTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementFromOpportunityTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementFromOpportunityTasksResponse listEngagementFromOpportunityTasks(
            ListEngagementFromOpportunityTasksRequest listEngagementFromOpportunityTasksRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all in-progress, completed, or failed <code>EngagementFromOpportunity</code> tasks that were initiated by
     * the caller's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementFromOpportunityTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListEngagementFromOpportunityTasksRequest#builder()}
     * </p>
     *
     * @param listEngagementFromOpportunityTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest.Builder}
     *        to create a request.
     * @return Result of the ListEngagementFromOpportunityTasks operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementFromOpportunityTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementFromOpportunityTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementFromOpportunityTasksResponse listEngagementFromOpportunityTasks(
            Consumer<ListEngagementFromOpportunityTasksRequest.Builder> listEngagementFromOpportunityTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementFromOpportunityTasks(ListEngagementFromOpportunityTasksRequest.builder()
                .applyMutation(listEngagementFromOpportunityTasksRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementFromOpportunityTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable responses = client.listEngagementFromOpportunityTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable responses = client
     *             .listEngagementFromOpportunityTasksPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable responses = client.listEngagementFromOpportunityTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementFromOpportunityTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngagementFromOpportunityTasksRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementFromOpportunityTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementFromOpportunityTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementFromOpportunityTasksIterable listEngagementFromOpportunityTasksPaginator(
            ListEngagementFromOpportunityTasksRequest listEngagementFromOpportunityTasksRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return new ListEngagementFromOpportunityTasksIterable(this, listEngagementFromOpportunityTasksRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementFromOpportunityTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable responses = client.listEngagementFromOpportunityTasksPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable responses = client
     *             .listEngagementFromOpportunityTasksPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementFromOpportunityTasksIterable responses = client.listEngagementFromOpportunityTasksPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementFromOpportunityTasks(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementFromOpportunityTasksRequest.Builder}
     * avoiding the need to create one manually via {@link ListEngagementFromOpportunityTasksRequest#builder()}
     * </p>
     *
     * @param listEngagementFromOpportunityTasksRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementFromOpportunityTasksRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementFromOpportunityTasks
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementFromOpportunityTasks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementFromOpportunityTasksIterable listEngagementFromOpportunityTasksPaginator(
            Consumer<ListEngagementFromOpportunityTasksRequest.Builder> listEngagementFromOpportunityTasksRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementFromOpportunityTasksPaginator(ListEngagementFromOpportunityTasksRequest.builder()
                .applyMutation(listEngagementFromOpportunityTasksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of engagement invitations sent to the partner. This allows partners to view all pending or past
     * engagement invitations, helping them track opportunities shared by AWS.
     * </p>
     *
     * @param listEngagementInvitationsRequest
     * @return Result of the ListEngagementInvitations operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementInvitations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementInvitationsResponse listEngagementInvitations(
            ListEngagementInvitationsRequest listEngagementInvitationsRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of engagement invitations sent to the partner. This allows partners to view all pending or past
     * engagement invitations, helping them track opportunities shared by AWS.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementInvitationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEngagementInvitationsRequest#builder()}
     * </p>
     *
     * @param listEngagementInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListEngagementInvitations operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementInvitations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementInvitationsResponse listEngagementInvitations(
            Consumer<ListEngagementInvitationsRequest.Builder> listEngagementInvitationsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return listEngagementInvitations(ListEngagementInvitationsRequest.builder()
                .applyMutation(listEngagementInvitationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementInvitations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable responses = client.listEngagementInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable responses = client
     *             .listEngagementInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable responses = client.listEngagementInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementInvitations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngagementInvitationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementInvitations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementInvitationsIterable listEngagementInvitationsPaginator(
            ListEngagementInvitationsRequest listEngagementInvitationsRequest) throws ThrottlingException, AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return new ListEngagementInvitationsIterable(this, listEngagementInvitationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementInvitations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable responses = client.listEngagementInvitationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable responses = client
     *             .listEngagementInvitationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementInvitationsIterable responses = client.listEngagementInvitationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementInvitations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementInvitationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEngagementInvitationsRequest#builder()}
     * </p>
     *
     * @param listEngagementInvitationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementInvitationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementInvitations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementInvitations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementInvitationsIterable listEngagementInvitationsPaginator(
            Consumer<ListEngagementInvitationsRequest.Builder> listEngagementInvitationsRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return listEngagementInvitationsPaginator(ListEngagementInvitationsRequest.builder()
                .applyMutation(listEngagementInvitationsRequest).build());
    }

    /**
     * <p>
     * Retrieves the details of member partners in an Engagement. This operation can only be invoked by members of the
     * Engagement. The <code>ListEngagementMembers</code> operation allows you to fetch information about the members of
     * a specific Engagement. This action is restricted to members of the Engagement being queried.
     * </p>
     *
     * @param listEngagementMembersRequest
     * @return Result of the ListEngagementMembers operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementMembersResponse listEngagementMembers(ListEngagementMembersRequest listEngagementMembersRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the details of member partners in an Engagement. This operation can only be invoked by members of the
     * Engagement. The <code>ListEngagementMembers</code> operation allows you to fetch information about the members of
     * a specific Engagement. This action is restricted to members of the Engagement being queried.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementMembersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEngagementMembersRequest#builder()}
     * </p>
     *
     * @param listEngagementMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest.Builder}
     *        to create a request.
     * @return Result of the ListEngagementMembers operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementMembersResponse listEngagementMembers(
            Consumer<ListEngagementMembersRequest.Builder> listEngagementMembersRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return listEngagementMembers(ListEngagementMembersRequest.builder().applyMutation(listEngagementMembersRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementMembers(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable responses = client.listEngagementMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable responses = client
     *             .listEngagementMembersPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable responses = client.listEngagementMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementMembers(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngagementMembersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementMembersIterable listEngagementMembersPaginator(ListEngagementMembersRequest listEngagementMembersRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return new ListEngagementMembersIterable(this, listEngagementMembersRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementMembers(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable responses = client.listEngagementMembersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable responses = client
     *             .listEngagementMembersPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementMembersIterable responses = client.listEngagementMembersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementMembers(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementMembersRequest.Builder} avoiding the
     * need to create one manually via {@link ListEngagementMembersRequest#builder()}
     * </p>
     *
     * @param listEngagementMembersRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementMembersRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementMembers"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementMembersIterable listEngagementMembersPaginator(
            Consumer<ListEngagementMembersRequest.Builder> listEngagementMembersRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return listEngagementMembersPaginator(ListEngagementMembersRequest.builder().applyMutation(listEngagementMembersRequest)
                .build());
    }

    /**
     * <p>
     * Lists the associations between resources and engagements where the caller is a member and has at least one
     * snapshot in the engagement.
     * </p>
     *
     * @param listEngagementResourceAssociationsRequest
     * @return Result of the ListEngagementResourceAssociations operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementResourceAssociationsResponse listEngagementResourceAssociations(
            ListEngagementResourceAssociationsRequest listEngagementResourceAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the associations between resources and engagements where the caller is a member and has at least one
     * snapshot in the engagement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementResourceAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEngagementResourceAssociationsRequest#builder()}
     * </p>
     *
     * @param listEngagementResourceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the ListEngagementResourceAssociations operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementResourceAssociationsResponse listEngagementResourceAssociations(
            Consumer<ListEngagementResourceAssociationsRequest.Builder> listEngagementResourceAssociationsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementResourceAssociations(ListEngagementResourceAssociationsRequest.builder()
                .applyMutation(listEngagementResourceAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementResourceAssociations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable responses = client.listEngagementResourceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable responses = client
     *             .listEngagementResourceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable responses = client.listEngagementResourceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementResourceAssociations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngagementResourceAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementResourceAssociationsIterable listEngagementResourceAssociationsPaginator(
            ListEngagementResourceAssociationsRequest listEngagementResourceAssociationsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return new ListEngagementResourceAssociationsIterable(this, listEngagementResourceAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagementResourceAssociations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable responses = client.listEngagementResourceAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable responses = client
     *             .listEngagementResourceAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementResourceAssociationsIterable responses = client.listEngagementResourceAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagementResourceAssociations(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementResourceAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link ListEngagementResourceAssociationsRequest#builder()}
     * </p>
     *
     * @param listEngagementResourceAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementResourceAssociationsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagementResourceAssociations
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagementResourceAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementResourceAssociationsIterable listEngagementResourceAssociationsPaginator(
            Consumer<ListEngagementResourceAssociationsRequest.Builder> listEngagementResourceAssociationsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementResourceAssociationsPaginator(ListEngagementResourceAssociationsRequest.builder()
                .applyMutation(listEngagementResourceAssociationsRequest).build());
    }

    /**
     * <p>
     * This action allows users to retrieve a list of Engagement records from Partner Central. This action can be used
     * to manage and track various engagements across different stages of the partner selling process.
     * </p>
     *
     * @param listEngagementsRequest
     * @return Result of the ListEngagements operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementsResponse listEngagements(ListEngagementsRequest listEngagementsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action allows users to retrieve a list of Engagement records from Partner Central. This action can be used
     * to manage and track various engagements across different stages of the partner selling process.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEngagementsRequest#builder()}
     * </p>
     *
     * @param listEngagementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest.Builder} to
     *        create a request.
     * @return Result of the ListEngagements operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementsResponse listEngagements(Consumer<ListEngagementsRequest.Builder> listEngagementsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagements(ListEngagementsRequest.builder().applyMutation(listEngagementsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagements(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable responses = client.listEngagementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable responses = client
     *             .listEngagementsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable responses = client.listEngagementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagements(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listEngagementsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementsIterable listEngagementsPaginator(ListEngagementsRequest listEngagementsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return new ListEngagementsIterable(this, listEngagementsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listEngagements(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable responses = client.listEngagementsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable responses = client
     *             .listEngagementsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListEngagementsIterable responses = client.listEngagementsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listEngagements(software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEngagementsRequest.Builder} avoiding the need
     * to create one manually via {@link ListEngagementsRequest#builder()}
     * </p>
     *
     * @param listEngagementsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListEngagementsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListEngagements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListEngagements"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEngagementsIterable listEngagementsPaginator(Consumer<ListEngagementsRequest.Builder> listEngagementsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listEngagementsPaginator(ListEngagementsRequest.builder().applyMutation(listEngagementsRequest).build());
    }

    /**
     * <p>
     * This request accepts a list of filters that retrieve opportunity subsets as well as sort options. This feature is
     * available to partners from <a href="https://partnercentral.awspartner.com/">Partner Central</a> using the
     * <code>ListOpportunities</code> API action.
     * </p>
     * <p>
     * To synchronize your system with Amazon Web Services, list only the opportunities that were newly created or
     * updated. We recommend you rely on events emitted by the service into your Amazon Web Services account’s Amazon
     * EventBridge default event bus. You can also use the <code>ListOpportunities</code> action.
     * </p>
     * <p>
     * We recommend the following approach:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Find the latest <code>LastModifiedDate</code> that you stored, and only use the values that came from Amazon Web
     * Services. Don’t use values generated by your system.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you send a <code>ListOpportunities</code> request, submit the date in ISO 8601 format in the
     * <code>AfterLastModifiedDate</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services only returns opportunities created or updated on or after that date and time. Use
     * <code>NextToken</code> to iterate over all pages.
     * </p>
     * </li>
     * </ol>
     *
     * @param listOpportunitiesRequest
     * @return Result of the ListOpportunities operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListOpportunities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListOpportunities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpportunitiesResponse listOpportunities(ListOpportunitiesRequest listOpportunitiesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This request accepts a list of filters that retrieve opportunity subsets as well as sort options. This feature is
     * available to partners from <a href="https://partnercentral.awspartner.com/">Partner Central</a> using the
     * <code>ListOpportunities</code> API action.
     * </p>
     * <p>
     * To synchronize your system with Amazon Web Services, list only the opportunities that were newly created or
     * updated. We recommend you rely on events emitted by the service into your Amazon Web Services account’s Amazon
     * EventBridge default event bus. You can also use the <code>ListOpportunities</code> action.
     * </p>
     * <p>
     * We recommend the following approach:
     * </p>
     * <ol>
     * <li>
     * <p>
     * Find the latest <code>LastModifiedDate</code> that you stored, and only use the values that came from Amazon Web
     * Services. Don’t use values generated by your system.
     * </p>
     * </li>
     * <li>
     * <p>
     * When you send a <code>ListOpportunities</code> request, submit the date in ISO 8601 format in the
     * <code>AfterLastModifiedDate</code> filter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon Web Services only returns opportunities created or updated on or after that date and time. Use
     * <code>NextToken</code> to iterate over all pages.
     * </p>
     * </li>
     * </ol>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpportunitiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpportunitiesRequest#builder()}
     * </p>
     *
     * @param listOpportunitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest.Builder} to
     *        create a request.
     * @return Result of the ListOpportunities operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListOpportunities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListOpportunities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpportunitiesResponse listOpportunities(Consumer<ListOpportunitiesRequest.Builder> listOpportunitiesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listOpportunities(ListOpportunitiesRequest.builder().applyMutation(listOpportunitiesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOpportunities(software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable responses = client.listOpportunitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable responses = client
     *             .listOpportunitiesPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable responses = client.listOpportunitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpportunities(software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listOpportunitiesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListOpportunities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListOpportunities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpportunitiesIterable listOpportunitiesPaginator(ListOpportunitiesRequest listOpportunitiesRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return new ListOpportunitiesIterable(this, listOpportunitiesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listOpportunities(software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable responses = client.listOpportunitiesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable responses = client
     *             .listOpportunitiesPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListOpportunitiesIterable responses = client.listOpportunitiesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listOpportunities(software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListOpportunitiesRequest.Builder} avoiding the need
     * to create one manually via {@link ListOpportunitiesRequest#builder()}
     * </p>
     *
     * @param listOpportunitiesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListOpportunitiesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListOpportunities
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListOpportunities"
     *      target="_top">AWS API Documentation</a>
     */
    default ListOpportunitiesIterable listOpportunitiesPaginator(
            Consumer<ListOpportunitiesRequest.Builder> listOpportunitiesRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return listOpportunitiesPaginator(ListOpportunitiesRequest.builder().applyMutation(listOpportunitiesRequest).build());
    }

    /**
     * <p>
     * Lists resource snapshot jobs owned by the customer. This operation supports various filtering scenarios,
     * including listing all jobs owned by the caller, jobs for a specific engagement, jobs with a specific status, or
     * any combination of these filters.
     * </p>
     *
     * @param listResourceSnapshotJobsRequest
     * @return Result of the ListResourceSnapshotJobs operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshotJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshotJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotJobsResponse listResourceSnapshotJobs(
            ListResourceSnapshotJobsRequest listResourceSnapshotJobsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists resource snapshot jobs owned by the customer. This operation supports various filtering scenarios,
     * including listing all jobs owned by the caller, jobs for a specific engagement, jobs with a specific status, or
     * any combination of these filters.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSnapshotJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceSnapshotJobsRequest#builder()}
     * </p>
     *
     * @param listResourceSnapshotJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest.Builder}
     *        to create a request.
     * @return Result of the ListResourceSnapshotJobs operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshotJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshotJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotJobsResponse listResourceSnapshotJobs(
            Consumer<ListResourceSnapshotJobsRequest.Builder> listResourceSnapshotJobsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return listResourceSnapshotJobs(ListResourceSnapshotJobsRequest.builder().applyMutation(listResourceSnapshotJobsRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceSnapshotJobs(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable responses = client.listResourceSnapshotJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable responses = client
     *             .listResourceSnapshotJobsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable responses = client.listResourceSnapshotJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSnapshotJobs(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceSnapshotJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshotJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshotJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotJobsIterable listResourceSnapshotJobsPaginator(
            ListResourceSnapshotJobsRequest listResourceSnapshotJobsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return new ListResourceSnapshotJobsIterable(this, listResourceSnapshotJobsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceSnapshotJobs(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable responses = client.listResourceSnapshotJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable responses = client
     *             .listResourceSnapshotJobsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotJobsIterable responses = client.listResourceSnapshotJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSnapshotJobs(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSnapshotJobsRequest.Builder} avoiding
     * the need to create one manually via {@link ListResourceSnapshotJobsRequest#builder()}
     * </p>
     *
     * @param listResourceSnapshotJobsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotJobsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshotJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshotJobs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotJobsIterable listResourceSnapshotJobsPaginator(
            Consumer<ListResourceSnapshotJobsRequest.Builder> listResourceSnapshotJobsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return listResourceSnapshotJobsPaginator(ListResourceSnapshotJobsRequest.builder()
                .applyMutation(listResourceSnapshotJobsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of resource view snapshots based on specified criteria. This operation supports various use
     * cases, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fetching all snapshots associated with an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieving snapshots of a specific resource type within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Obtaining snapshots for a particular resource using a specified template.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accessing the latest snapshot of a resource within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Filtering snapshots by resource owner.
     * </p>
     * </li>
     * </ul>
     *
     * @param listResourceSnapshotsRequest
     * @return Result of the ListResourceSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotsResponse listResourceSnapshots(ListResourceSnapshotsRequest listResourceSnapshotsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of resource view snapshots based on specified criteria. This operation supports various use
     * cases, including:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Fetching all snapshots associated with an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Retrieving snapshots of a specific resource type within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Obtaining snapshots for a particular resource using a specified template.
     * </p>
     * </li>
     * <li>
     * <p>
     * Accessing the latest snapshot of a resource within an engagement.
     * </p>
     * </li>
     * <li>
     * <p>
     * Filtering snapshots by resource owner.
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceSnapshotsRequest#builder()}
     * </p>
     *
     * @param listResourceSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest.Builder}
     *        to create a request.
     * @return Result of the ListResourceSnapshots operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotsResponse listResourceSnapshots(
            Consumer<ListResourceSnapshotsRequest.Builder> listResourceSnapshotsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return listResourceSnapshots(ListResourceSnapshotsRequest.builder().applyMutation(listResourceSnapshotsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceSnapshots(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable responses = client.listResourceSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable responses = client
     *             .listResourceSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable responses = client.listResourceSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSnapshots(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResourceSnapshotsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotsIterable listResourceSnapshotsPaginator(ListResourceSnapshotsRequest listResourceSnapshotsRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return new ListResourceSnapshotsIterable(this, listResourceSnapshotsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResourceSnapshots(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable responses = client.listResourceSnapshotsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable responses = client
     *             .listResourceSnapshotsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListResourceSnapshotsIterable responses = client.listResourceSnapshotsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResourceSnapshots(software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResourceSnapshotsRequest.Builder} avoiding the
     * need to create one manually via {@link ListResourceSnapshotsRequest#builder()}
     * </p>
     *
     * @param listResourceSnapshotsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListResourceSnapshotsRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListResourceSnapshots
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListResourceSnapshots"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResourceSnapshotsIterable listResourceSnapshotsPaginator(
            Consumer<ListResourceSnapshotsRequest.Builder> listResourceSnapshotsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return listResourceSnapshotsPaginator(ListResourceSnapshotsRequest.builder().applyMutation(listResourceSnapshotsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of Partner Solutions that the partner registered on Partner Central. This API is used to
     * generate a list of solutions that an end user selects from for association with an opportunity.
     * </p>
     *
     * @param listSolutionsRequest
     * @return Result of the ListSolutions operation returned by the service.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListSolutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionsResponse listSolutions(ListSolutionsRequest listSolutionsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of Partner Solutions that the partner registered on Partner Central. This API is used to
     * generate a list of solutions that an end user selects from for association with an opportunity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSolutionsRequest#builder()}
     * </p>
     *
     * @param listSolutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest.Builder} to create
     *        a request.
     * @return Result of the ListSolutions operation returned by the service.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListSolutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionsResponse listSolutions(Consumer<ListSolutionsRequest.Builder> listSolutionsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listSolutions(ListSolutionsRequest.builder().applyMutation(listSolutionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolutions(software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable responses = client
     *             .listSolutionsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolutions(software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSolutionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListSolutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionsIterable listSolutionsPaginator(ListSolutionsRequest listSolutionsRequest) throws AccessDeniedException,
            InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return new ListSolutionsIterable(this, listSolutionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSolutions(software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable responses = client
     *             .listSolutionsPaginator(request);
     *     for (software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.partnercentralselling.paginators.ListSolutionsIterable responses = client.listSolutionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSolutions(software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSolutionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListSolutionsRequest#builder()}
     * </p>
     *
     * @param listSolutionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListSolutionsRequest.Builder} to create
     *        a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.</p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListSolutions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListSolutions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSolutionsIterable listSolutionsPaginator(Consumer<ListSolutionsRequest.Builder> listSolutionsRequest)
            throws AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return listSolutionsPaginator(ListSolutionsRequest.builder().applyMutation(listSolutionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Updates the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     *
     * @param putSellingSystemSettingsRequest
     * @return Result of the PutSellingSystemSettings operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.PutSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/PutSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSellingSystemSettingsResponse putSellingSystemSettings(
            PutSellingSystemSettingsRequest putSellingSystemSettingsRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the currently set system settings, which include the IAM Role used for resource snapshot jobs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSellingSystemSettingsRequest.Builder} avoiding
     * the need to create one manually via {@link PutSellingSystemSettingsRequest#builder()}
     * </p>
     *
     * @param putSellingSystemSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.PutSellingSystemSettingsRequest.Builder}
     *        to create a request.
     * @return Result of the PutSellingSystemSettings operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.PutSellingSystemSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/PutSellingSystemSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default PutSellingSystemSettingsResponse putSellingSystemSettings(
            Consumer<PutSellingSystemSettingsRequest.Builder> putSellingSystemSettingsRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return putSellingSystemSettings(PutSellingSystemSettingsRequest.builder().applyMutation(putSellingSystemSettingsRequest)
                .build());
    }

    /**
     * <p>
     * This action rejects an <code>EngagementInvitation</code> that AWS shared. Rejecting an invitation indicates that
     * the partner doesn't want to pursue the opportunity, and all related data will become inaccessible thereafter.
     * </p>
     *
     * @param rejectEngagementInvitationRequest
     * @return Result of the RejectEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.RejectEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/RejectEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectEngagementInvitationResponse rejectEngagementInvitation(
            RejectEngagementInvitationRequest rejectEngagementInvitationRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action rejects an <code>EngagementInvitation</code> that AWS shared. Rejecting an invitation indicates that
     * the partner doesn't want to pursue the opportunity, and all related data will become inaccessible thereafter.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RejectEngagementInvitationRequest.Builder} avoiding
     * the need to create one manually via {@link RejectEngagementInvitationRequest#builder()}
     * </p>
     *
     * @param rejectEngagementInvitationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.RejectEngagementInvitationRequest.Builder}
     *        to create a request.
     * @return Result of the RejectEngagementInvitation operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.RejectEngagementInvitation
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/RejectEngagementInvitation"
     *      target="_top">AWS API Documentation</a>
     */
    default RejectEngagementInvitationResponse rejectEngagementInvitation(
            Consumer<RejectEngagementInvitationRequest.Builder> rejectEngagementInvitationRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return rejectEngagementInvitation(RejectEngagementInvitationRequest.builder()
                .applyMutation(rejectEngagementInvitationRequest).build());
    }

    /**
     * <p>
     * This action starts the engagement by accepting an <code>EngagementInvitation</code>. The task is asynchronous and
     * involves the following steps: accepting the invitation, creating an opportunity in the partner’s account from the
     * AWS opportunity, and copying details for tracking. When completed, an <code>Opportunity Created</code> event is
     * generated, indicating that the opportunity has been successfully created in the partner's account.
     * </p>
     *
     * @param startEngagementByAcceptingInvitationTaskRequest
     * @return Result of the StartEngagementByAcceptingInvitationTask operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartEngagementByAcceptingInvitationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementByAcceptingInvitationTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEngagementByAcceptingInvitationTaskResponse startEngagementByAcceptingInvitationTask(
            StartEngagementByAcceptingInvitationTaskRequest startEngagementByAcceptingInvitationTaskRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action starts the engagement by accepting an <code>EngagementInvitation</code>. The task is asynchronous and
     * involves the following steps: accepting the invitation, creating an opportunity in the partner’s account from the
     * AWS opportunity, and copying details for tracking. When completed, an <code>Opportunity Created</code> event is
     * generated, indicating that the opportunity has been successfully created in the partner's account.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link StartEngagementByAcceptingInvitationTaskRequest.Builder} avoiding the need to create one manually via
     * {@link StartEngagementByAcceptingInvitationTaskRequest#builder()}
     * </p>
     *
     * @param startEngagementByAcceptingInvitationTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.StartEngagementByAcceptingInvitationTaskRequest.Builder}
     *        to create a request.
     * @return Result of the StartEngagementByAcceptingInvitationTask operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartEngagementByAcceptingInvitationTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementByAcceptingInvitationTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEngagementByAcceptingInvitationTaskResponse startEngagementByAcceptingInvitationTask(
            Consumer<StartEngagementByAcceptingInvitationTaskRequest.Builder> startEngagementByAcceptingInvitationTaskRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return startEngagementByAcceptingInvitationTask(StartEngagementByAcceptingInvitationTaskRequest.builder()
                .applyMutation(startEngagementByAcceptingInvitationTaskRequest).build());
    }

    /**
     * <p>
     * Similar to <code>StartEngagementByAcceptingInvitationTask</code>, this action is asynchronous and performs
     * multiple steps before completion. This action orchestrates a comprehensive workflow that combines multiple API
     * operations into a single task to create and initiate an engagement from an existing opportunity. It automatically
     * executes a sequence of operations including <code>GetOpportunity</code>, <code>CreateEngagement</code> (if it
     * doesn't exist), <code>CreateResourceSnapshot</code>, <code>CreateResourceSnapshotJob</code>,
     * <code>CreateEngagementInvitation</code> (if not already invited/accepted), and <code>SubmitOpportunity</code>.
     * </p>
     *
     * @param startEngagementFromOpportunityTaskRequest
     * @return Result of the StartEngagementFromOpportunityTask operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartEngagementFromOpportunityTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementFromOpportunityTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEngagementFromOpportunityTaskResponse startEngagementFromOpportunityTask(
            StartEngagementFromOpportunityTaskRequest startEngagementFromOpportunityTaskRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Similar to <code>StartEngagementByAcceptingInvitationTask</code>, this action is asynchronous and performs
     * multiple steps before completion. This action orchestrates a comprehensive workflow that combines multiple API
     * operations into a single task to create and initiate an engagement from an existing opportunity. It automatically
     * executes a sequence of operations including <code>GetOpportunity</code>, <code>CreateEngagement</code> (if it
     * doesn't exist), <code>CreateResourceSnapshot</code>, <code>CreateResourceSnapshotJob</code>,
     * <code>CreateEngagementInvitation</code> (if not already invited/accepted), and <code>SubmitOpportunity</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartEngagementFromOpportunityTaskRequest.Builder}
     * avoiding the need to create one manually via {@link StartEngagementFromOpportunityTaskRequest#builder()}
     * </p>
     *
     * @param startEngagementFromOpportunityTaskRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.StartEngagementFromOpportunityTaskRequest.Builder}
     *        to create a request.
     * @return Result of the StartEngagementFromOpportunityTask operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ServiceQuotaExceededException
     *         This error occurs when the request would cause a service quota to be exceeded. Service quotas represent
     *         the maximum allowed use of a specific resource, and this error indicates that the request would surpass
     *         that limit.
     *         </p>
     *         <p>
     *         Suggested action: Review the <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> for the
     *         resource, and either reduce usage or request a quota increase.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartEngagementFromOpportunityTask
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartEngagementFromOpportunityTask"
     *      target="_top">AWS API Documentation</a>
     */
    default StartEngagementFromOpportunityTaskResponse startEngagementFromOpportunityTask(
            Consumer<StartEngagementFromOpportunityTaskRequest.Builder> startEngagementFromOpportunityTaskRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ServiceQuotaExceededException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return startEngagementFromOpportunityTask(StartEngagementFromOpportunityTaskRequest.builder()
                .applyMutation(startEngagementFromOpportunityTaskRequest).build());
    }

    /**
     * <p>
     * Starts a resource snapshot job that has been previously created.
     * </p>
     *
     * @param startResourceSnapshotJobRequest
     * @return Result of the StartResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartResourceSnapshotJobResponse startResourceSnapshotJob(
            StartResourceSnapshotJobRequest startResourceSnapshotJobRequest) throws ThrottlingException, AccessDeniedException,
            ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a resource snapshot job that has been previously created.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartResourceSnapshotJobRequest.Builder} avoiding
     * the need to create one manually via {@link StartResourceSnapshotJobRequest#builder()}
     * </p>
     *
     * @param startResourceSnapshotJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.StartResourceSnapshotJobRequest.Builder}
     *        to create a request.
     * @return Result of the StartResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StartResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StartResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StartResourceSnapshotJobResponse startResourceSnapshotJob(
            Consumer<StartResourceSnapshotJobRequest.Builder> startResourceSnapshotJobRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return startResourceSnapshotJob(StartResourceSnapshotJobRequest.builder().applyMutation(startResourceSnapshotJobRequest)
                .build());
    }

    /**
     * <p>
     * Stops a resource snapshot job. The job must be started prior to being stopped.
     * </p>
     *
     * @param stopResourceSnapshotJobRequest
     * @return Result of the StopResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StopResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StopResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopResourceSnapshotJobResponse stopResourceSnapshotJob(StopResourceSnapshotJobRequest stopResourceSnapshotJobRequest)
            throws ThrottlingException, AccessDeniedException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops a resource snapshot job. The job must be started prior to being stopped.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopResourceSnapshotJobRequest.Builder} avoiding
     * the need to create one manually via {@link StopResourceSnapshotJobRequest#builder()}
     * </p>
     *
     * @param stopResourceSnapshotJobRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.StopResourceSnapshotJobRequest.Builder}
     *        to create a request.
     * @return Result of the StopResourceSnapshotJob operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.StopResourceSnapshotJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/StopResourceSnapshotJob"
     *      target="_top">AWS API Documentation</a>
     */
    default StopResourceSnapshotJobResponse stopResourceSnapshotJob(
            Consumer<StopResourceSnapshotJobRequest.Builder> stopResourceSnapshotJobRequest) throws ThrottlingException,
            AccessDeniedException, ValidationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            PartnerCentralSellingException {
        return stopResourceSnapshotJob(StopResourceSnapshotJobRequest.builder().applyMutation(stopResourceSnapshotJobRequest)
                .build());
    }

    /**
     * <p>
     * Use this action to submit an Opportunity that was previously created by partner for AWS review. After you perform
     * this action, the Opportunity becomes non-editable until it is reviewed by AWS and has
     * <code> LifeCycle.ReviewStatus </code> as either <code>Approved</code> or <code>Action Required</code>.
     * </p>
     *
     * @param submitOpportunityRequest
     * @return Result of the SubmitOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.SubmitOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/SubmitOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitOpportunityResponse submitOpportunity(SubmitOpportunityRequest submitOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Use this action to submit an Opportunity that was previously created by partner for AWS review. After you perform
     * this action, the Opportunity becomes non-editable until it is reviewed by AWS and has
     * <code> LifeCycle.ReviewStatus </code> as either <code>Approved</code> or <code>Action Required</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link SubmitOpportunityRequest.Builder} avoiding the need
     * to create one manually via {@link SubmitOpportunityRequest#builder()}
     * </p>
     *
     * @param submitOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.SubmitOpportunityRequest.Builder} to
     *        create a request.
     * @return Result of the SubmitOpportunity operation returned by the service.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.</p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.SubmitOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/SubmitOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default SubmitOpportunityResponse submitOpportunity(Consumer<SubmitOpportunityRequest.Builder> submitOpportunityRequest)
            throws ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return submitOpportunity(SubmitOpportunityRequest.builder().applyMutation(submitOpportunityRequest).build());
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ConflictException, ThrottlingException,
            AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ConflictException,
            ThrottlingException, AccessDeniedException, InternalServerException, ValidationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the <code>Opportunity</code> record identified by a given <code>Identifier</code>. This operation allows
     * you to modify the details of an existing opportunity to reflect the latest information and progress. Use this
     * action to keep the opportunity record up-to-date and accurate.
     * </p>
     * <p>
     * When you perform updates, include the entire payload with each request. If any field is omitted, the API assumes
     * that the field is set to <code>null</code>. The best practice is to always perform a <code>GetOpportunity</code>
     * to retrieve the latest values, then send the complete payload with the updated values to be changed.
     * </p>
     *
     * @param updateOpportunityRequest
     * @return Result of the UpdateOpportunity operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.UpdateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UpdateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOpportunityResponse updateOpportunity(UpdateOpportunityRequest updateOpportunityRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the <code>Opportunity</code> record identified by a given <code>Identifier</code>. This operation allows
     * you to modify the details of an existing opportunity to reflect the latest information and progress. Use this
     * action to keep the opportunity record up-to-date and accurate.
     * </p>
     * <p>
     * When you perform updates, include the entire payload with each request. If any field is omitted, the API assumes
     * that the field is set to <code>null</code>. The best practice is to always perform a <code>GetOpportunity</code>
     * to retrieve the latest values, then send the complete payload with the updated values to be changed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateOpportunityRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateOpportunityRequest#builder()}
     * </p>
     *
     * @param updateOpportunityRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.partnercentralselling.model.UpdateOpportunityRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateOpportunity operation returned by the service.
     * @throws ConflictException
     *         This error occurs when the request can’t be processed due to a conflict with the target resource's
     *         current state, which could result from updating or deleting the resource.</p>
     *         <p>
     *         Suggested action: Fetch the latest state of the resource, verify the state, and retry the request.
     * @throws ThrottlingException
     *         This error occurs when there are too many requests sent. Review the provided quotas and adapt your usage
     *         to avoid throttling.
     *         </p>
     *         <p>
     *         This error occurs when there are too many requests sent. Review the provided <a
     *         href="https://docs.aws.amazon.com/partner-central/latest/selling-api/quotas.html">Quotas</a> and retry
     *         after the provided delay.
     * @throws AccessDeniedException
     *         This error occurs when you don't have permission to perform the requested action.
     *         </p>
     *         <p>
     *         You don’t have access to this action or resource. Review IAM policies or contact your AWS administrator
     *         for assistance.
     * @throws InternalServerException
     *         This error occurs when the specified resource can’t be found or doesn't exist. Resource ID and type might
     *         be incorrect.
     *         </p>
     *         <p>
     *         Suggested action: This is usually a transient error. Retry after the provided retry delay or a short
     *         interval. If the problem persists, contact AWS support.
     * @throws ValidationException
     *         The input fails to satisfy the constraints specified by the service or business validation rules.
     *         </p>
     *         <p>
     *         Suggested action: Review the error message, including the failed fields and reasons, to correct the
     *         request payload.
     * @throws ResourceNotFoundException
     *         This error occurs when the specified resource can't be found. The resource might not exist, or isn't
     *         visible with the current credentials.
     *         </p>
     *         <p>
     *         Suggested action: Verify that the resource ID is correct and the resource is in the expected AWS region.
     *         Check IAM permissions for accessing the resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws PartnerCentralSellingException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample PartnerCentralSellingClient.UpdateOpportunity
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/partnercentral-selling-2022-07-26/UpdateOpportunity"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateOpportunityResponse updateOpportunity(Consumer<UpdateOpportunityRequest.Builder> updateOpportunityRequest)
            throws ConflictException, ThrottlingException, AccessDeniedException, InternalServerException, ValidationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, PartnerCentralSellingException {
        return updateOpportunity(UpdateOpportunityRequest.builder().applyMutation(updateOpportunityRequest).build());
    }

    /**
     * Create a {@link PartnerCentralSellingClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static PartnerCentralSellingClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link PartnerCentralSellingClient}.
     */
    static PartnerCentralSellingClientBuilder builder() {
        return new DefaultPartnerCentralSellingClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default PartnerCentralSellingServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
