/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains an <code>Account</code>'s subset of fields.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSummary implements SdkPojo, Serializable, ToCopyableBuilder<AccountSummary.Builder, AccountSummary> {
    private static final SdkField<String> INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Industry").getter(getter(AccountSummary::industryAsString)).setter(setter(Builder::industry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Industry").build()).build();

    private static final SdkField<String> OTHER_INDUSTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OtherIndustry").getter(getter(AccountSummary::otherIndustry)).setter(setter(Builder::otherIndustry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherIndustry").build()).build();

    private static final SdkField<String> COMPANY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CompanyName").getter(getter(AccountSummary::companyName)).setter(setter(Builder::companyName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompanyName").build()).build();

    private static final SdkField<String> WEBSITE_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("WebsiteUrl").getter(getter(AccountSummary::websiteUrl)).setter(setter(Builder::websiteUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("WebsiteUrl").build()).build();

    private static final SdkField<AddressSummary> ADDRESS_FIELD = SdkField.<AddressSummary> builder(MarshallingType.SDK_POJO)
            .memberName("Address").getter(getter(AccountSummary::address)).setter(setter(Builder::address))
            .constructor(AddressSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Address").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDUSTRY_FIELD,
            OTHER_INDUSTRY_FIELD, COMPANY_NAME_FIELD, WEBSITE_URL_FIELD, ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String industry;

    private final String otherIndustry;

    private final String companyName;

    private final String websiteUrl;

    private final AddressSummary address;

    private AccountSummary(BuilderImpl builder) {
        this.industry = builder.industry;
        this.otherIndustry = builder.otherIndustry;
        this.companyName = builder.companyName;
        this.websiteUrl = builder.websiteUrl;
        this.address = builder.address;
    }

    /**
     * <p>
     * Specifies which industry the end <code>Customer</code> belongs to associated with the <code>Opportunity</code>.
     * It refers to the category or sector that the customer's business operates in.
     * </p>
     * <p>
     * To submit a value outside the picklist, use <code>Other</code>.
     * </p>
     * <p>
     * Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industry} will
     * return {@link Industry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industryAsString}.
     * </p>
     * 
     * @return Specifies which industry the end <code>Customer</code> belongs to associated with the
     *         <code>Opportunity</code>. It refers to the category or sector that the customer's business operates
     *         in.</p>
     *         <p>
     *         To submit a value outside the picklist, use <code>Other</code>.
     *         </p>
     *         <p>
     *         Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
     * @see Industry
     */
    public final Industry industry() {
        return Industry.fromValue(industry);
    }

    /**
     * <p>
     * Specifies which industry the end <code>Customer</code> belongs to associated with the <code>Opportunity</code>.
     * It refers to the category or sector that the customer's business operates in.
     * </p>
     * <p>
     * To submit a value outside the picklist, use <code>Other</code>.
     * </p>
     * <p>
     * Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #industry} will
     * return {@link Industry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #industryAsString}.
     * </p>
     * 
     * @return Specifies which industry the end <code>Customer</code> belongs to associated with the
     *         <code>Opportunity</code>. It refers to the category or sector that the customer's business operates
     *         in.</p>
     *         <p>
     *         To submit a value outside the picklist, use <code>Other</code>.
     *         </p>
     *         <p>
     *         Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
     * @see Industry
     */
    public final String industryAsString() {
        return industry;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s industry associated with the <code> Opportunity</code>, when the
     * selected value in the <code>Industry</code> field is <code>Other</code>. This field is relevant when the
     * customer's industry doesn't fall under the predefined picklist values and requires a custom description.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s industry associated with the <code> Opportunity</code>, when
     *         the selected value in the <code>Industry</code> field is <code>Other</code>. This field is relevant when
     *         the customer's industry doesn't fall under the predefined picklist values and requires a custom
     *         description.
     */
    public final String otherIndustry() {
        return otherIndustry;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
     */
    public final String companyName() {
        return companyName;
    }

    /**
     * <p>
     * Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This value is
     * crucial to map the customer within the Amazon Web Services CRM system.
     * </p>
     * 
     * @return Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This value
     *         is crucial to map the customer within the Amazon Web Services CRM system.
     */
    public final String websiteUrl() {
        return websiteUrl;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
     */
    public final AddressSummary address() {
        return address;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(industryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(otherIndustry());
        hashCode = 31 * hashCode + Objects.hashCode(companyName());
        hashCode = 31 * hashCode + Objects.hashCode(websiteUrl());
        hashCode = 31 * hashCode + Objects.hashCode(address());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSummary)) {
            return false;
        }
        AccountSummary other = (AccountSummary) obj;
        return Objects.equals(industryAsString(), other.industryAsString())
                && Objects.equals(otherIndustry(), other.otherIndustry()) && Objects.equals(companyName(), other.companyName())
                && Objects.equals(websiteUrl(), other.websiteUrl()) && Objects.equals(address(), other.address());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSummary").add("Industry", industryAsString()).add("OtherIndustry", otherIndustry())
                .add("CompanyName", companyName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("WebsiteUrl", websiteUrl() == null ? null : "*** Sensitive Data Redacted ***").add("Address", address())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Industry":
            return Optional.ofNullable(clazz.cast(industryAsString()));
        case "OtherIndustry":
            return Optional.ofNullable(clazz.cast(otherIndustry()));
        case "CompanyName":
            return Optional.ofNullable(clazz.cast(companyName()));
        case "WebsiteUrl":
            return Optional.ofNullable(clazz.cast(websiteUrl()));
        case "Address":
            return Optional.ofNullable(clazz.cast(address()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Industry", INDUSTRY_FIELD);
        map.put("OtherIndustry", OTHER_INDUSTRY_FIELD);
        map.put("CompanyName", COMPANY_NAME_FIELD);
        map.put("WebsiteUrl", WEBSITE_URL_FIELD);
        map.put("Address", ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSummary, T> g) {
        return obj -> g.apply((AccountSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSummary> {
        /**
         * <p>
         * Specifies which industry the end <code>Customer</code> belongs to associated with the
         * <code>Opportunity</code>. It refers to the category or sector that the customer's business operates in.
         * </p>
         * <p>
         * To submit a value outside the picklist, use <code>Other</code>.
         * </p>
         * <p>
         * Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
         * </p>
         * 
         * @param industry
         *        Specifies which industry the end <code>Customer</code> belongs to associated with the
         *        <code>Opportunity</code>. It refers to the category or sector that the customer's business operates
         *        in.</p>
         *        <p>
         *        To submit a value outside the picklist, use <code>Other</code>.
         *        </p>
         *        <p>
         *        Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
         * @see Industry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industry
         */
        Builder industry(String industry);

        /**
         * <p>
         * Specifies which industry the end <code>Customer</code> belongs to associated with the
         * <code>Opportunity</code>. It refers to the category or sector that the customer's business operates in.
         * </p>
         * <p>
         * To submit a value outside the picklist, use <code>Other</code>.
         * </p>
         * <p>
         * Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
         * </p>
         * 
         * @param industry
         *        Specifies which industry the end <code>Customer</code> belongs to associated with the
         *        <code>Opportunity</code>. It refers to the category or sector that the customer's business operates
         *        in.</p>
         *        <p>
         *        To submit a value outside the picklist, use <code>Other</code>.
         *        </p>
         *        <p>
         *        Conditionally mandatory if <code>Other</code> is selected for Industry Vertical in LOVs.
         * @see Industry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Industry
         */
        Builder industry(Industry industry);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s industry associated with the <code> Opportunity</code>, when the
         * selected value in the <code>Industry</code> field is <code>Other</code>. This field is relevant when the
         * customer's industry doesn't fall under the predefined picklist values and requires a custom description.
         * </p>
         * 
         * @param otherIndustry
         *        Specifies the end <code>Customer</code>'s industry associated with the <code> Opportunity</code>, when
         *        the selected value in the <code>Industry</code> field is <code>Other</code>. This field is relevant
         *        when the customer's industry doesn't fall under the predefined picklist values and requires a custom
         *        description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder otherIndustry(String otherIndustry);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param companyName
         *        Specifies the end <code>Customer</code>'s company name associated with the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder companyName(String companyName);

        /**
         * <p>
         * Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This value is
         * crucial to map the customer within the Amazon Web Services CRM system.
         * </p>
         * 
         * @param websiteUrl
         *        Specifies the end customer's company website URL associated with the <code>Opportunity</code>. This
         *        value is crucial to map the customer within the Amazon Web Services CRM system.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder websiteUrl(String websiteUrl);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param address
         *        Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>
         *        .
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(AddressSummary address);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressSummary.Builder} avoiding the need
         * to create one manually via {@link AddressSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #address(AddressSummary)}.
         * 
         * @param address
         *        a consumer that will call methods on {@link AddressSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #address(AddressSummary)
         */
        default Builder address(Consumer<AddressSummary.Builder> address) {
            return address(AddressSummary.builder().applyMutation(address).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String industry;

        private String otherIndustry;

        private String companyName;

        private String websiteUrl;

        private AddressSummary address;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSummary model) {
            industry(model.industry);
            otherIndustry(model.otherIndustry);
            companyName(model.companyName);
            websiteUrl(model.websiteUrl);
            address(model.address);
        }

        public final String getIndustry() {
            return industry;
        }

        public final void setIndustry(String industry) {
            this.industry = industry;
        }

        @Override
        public final Builder industry(String industry) {
            this.industry = industry;
            return this;
        }

        @Override
        public final Builder industry(Industry industry) {
            this.industry(industry == null ? null : industry.toString());
            return this;
        }

        public final String getOtherIndustry() {
            return otherIndustry;
        }

        public final void setOtherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
        }

        @Override
        public final Builder otherIndustry(String otherIndustry) {
            this.otherIndustry = otherIndustry;
            return this;
        }

        public final String getCompanyName() {
            return companyName;
        }

        public final void setCompanyName(String companyName) {
            this.companyName = companyName;
        }

        @Override
        public final Builder companyName(String companyName) {
            this.companyName = companyName;
            return this;
        }

        public final String getWebsiteUrl() {
            return websiteUrl;
        }

        public final void setWebsiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
        }

        @Override
        public final Builder websiteUrl(String websiteUrl) {
            this.websiteUrl = websiteUrl;
            return this;
        }

        public final AddressSummary.Builder getAddress() {
            return address != null ? address.toBuilder() : null;
        }

        public final void setAddress(AddressSummary.BuilderImpl address) {
            this.address = address != null ? address.build() : null;
        }

        @Override
        public final Builder address(AddressSummary address) {
            this.address = address;
            return this;
        }

        @Override
        public AccountSummary build() {
            return new AccountSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
