/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the end <code>Customer</code>'s address details associated with the <code>Opportunity</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Address implements SdkPojo, Serializable, ToCopyableBuilder<Address.Builder, Address> {
    private static final SdkField<String> CITY_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("City")
            .getter(getter(Address::city)).setter(setter(Builder::city))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("City").build()).build();

    private static final SdkField<String> POSTAL_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PostalCode").getter(getter(Address::postalCode)).setter(setter(Builder::postalCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PostalCode").build()).build();

    private static final SdkField<String> STATE_OR_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateOrRegion").getter(getter(Address::stateOrRegion)).setter(setter(Builder::stateOrRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateOrRegion").build()).build();

    private static final SdkField<String> COUNTRY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CountryCode").getter(getter(Address::countryCodeAsString)).setter(setter(Builder::countryCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CountryCode").build()).build();

    private static final SdkField<String> STREET_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreetAddress").getter(getter(Address::streetAddress)).setter(setter(Builder::streetAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreetAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CITY_FIELD, POSTAL_CODE_FIELD,
            STATE_OR_REGION_FIELD, COUNTRY_CODE_FIELD, STREET_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String city;

    private final String postalCode;

    private final String stateOrRegion;

    private final String countryCode;

    private final String streetAddress;

    private Address(BuilderImpl builder) {
        this.city = builder.city;
        this.postalCode = builder.postalCode;
        this.stateOrRegion = builder.stateOrRegion;
        this.countryCode = builder.countryCode;
        this.streetAddress = builder.streetAddress;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s city associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s city associated with the <code>Opportunity</code>.
     */
    public final String city() {
        return city;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s postal code associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s postal code associated with the <code>Opportunity</code>.
     */
    public final String postalCode() {
        return postalCode;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s state or region associated with the <code>Opportunity</code>.
     * </p>
     * <p>
     * Valid values:
     * <code>Alabama | Alaska | American Samoa | Arizona | Arkansas | California | Colorado | Connecticut | Delaware | Dist. of Columbia | Federated States of Micronesia | Florida | Georgia | Guam | Hawaii | Idaho | Illinois | Indiana | Iowa | Kansas | Kentucky | Louisiana | Maine | Marshall Islands | Maryland | Massachusetts | Michigan | Minnesota | Mississippi | Missouri | Montana | Nebraska | Nevada | New Hampshire | New Jersey | New Mexico | New York | North Carolina | North Dakota | Northern Mariana Islands | Ohio | Oklahoma | Oregon | Palau | Pennsylvania | Puerto Rico | Rhode Island | South Carolina | South Dakota | Tennessee | Texas | Utah | Vermont | Virginia | Virgin Islands | Washington | West Virginia | Wisconsin | Wyoming | APO/AE | AFO/FPO | FPO, AP</code>
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s state or region associated with the <code>Opportunity</code>
     *         .</p>
     *         <p>
     *         Valid values:
     *         <code>Alabama | Alaska | American Samoa | Arizona | Arkansas | California | Colorado | Connecticut | Delaware | Dist. of Columbia | Federated States of Micronesia | Florida | Georgia | Guam | Hawaii | Idaho | Illinois | Indiana | Iowa | Kansas | Kentucky | Louisiana | Maine | Marshall Islands | Maryland | Massachusetts | Michigan | Minnesota | Mississippi | Missouri | Montana | Nebraska | Nevada | New Hampshire | New Jersey | New Mexico | New York | North Carolina | North Dakota | Northern Mariana Islands | Ohio | Oklahoma | Oregon | Palau | Pennsylvania | Puerto Rico | Rhode Island | South Carolina | South Dakota | Tennessee | Texas | Utah | Vermont | Virginia | Virgin Islands | Washington | West Virginia | Wisconsin | Wyoming | APO/AE | AFO/FPO | FPO, AP</code>
     */
    public final String stateOrRegion() {
        return stateOrRegion;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link CountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
     * @see CountryCode
     */
    public final CountryCode countryCode() {
        return CountryCode.fromValue(countryCode);
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #countryCode} will
     * return {@link CountryCode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #countryCodeAsString}.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
     * @see CountryCode
     */
    public final String countryCodeAsString() {
        return countryCode;
    }

    /**
     * <p>
     * Specifies the end <code>Customer</code>'s street address associated with the <code>Opportunity</code>.
     * </p>
     * 
     * @return Specifies the end <code>Customer</code>'s street address associated with the <code>Opportunity</code>.
     */
    public final String streetAddress() {
        return streetAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(city());
        hashCode = 31 * hashCode + Objects.hashCode(postalCode());
        hashCode = 31 * hashCode + Objects.hashCode(stateOrRegion());
        hashCode = 31 * hashCode + Objects.hashCode(countryCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(streetAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Address)) {
            return false;
        }
        Address other = (Address) obj;
        return Objects.equals(city(), other.city()) && Objects.equals(postalCode(), other.postalCode())
                && Objects.equals(stateOrRegion(), other.stateOrRegion())
                && Objects.equals(countryCodeAsString(), other.countryCodeAsString())
                && Objects.equals(streetAddress(), other.streetAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Address").add("City", city() == null ? null : "*** Sensitive Data Redacted ***")
                .add("PostalCode", postalCode() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StateOrRegion", stateOrRegion() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CountryCode", countryCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("StreetAddress", streetAddress() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "City":
            return Optional.ofNullable(clazz.cast(city()));
        case "PostalCode":
            return Optional.ofNullable(clazz.cast(postalCode()));
        case "StateOrRegion":
            return Optional.ofNullable(clazz.cast(stateOrRegion()));
        case "CountryCode":
            return Optional.ofNullable(clazz.cast(countryCodeAsString()));
        case "StreetAddress":
            return Optional.ofNullable(clazz.cast(streetAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("City", CITY_FIELD);
        map.put("PostalCode", POSTAL_CODE_FIELD);
        map.put("StateOrRegion", STATE_OR_REGION_FIELD);
        map.put("CountryCode", COUNTRY_CODE_FIELD);
        map.put("StreetAddress", STREET_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Address, T> g) {
        return obj -> g.apply((Address) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Address> {
        /**
         * <p>
         * Specifies the end <code>Customer</code>'s city associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param city
         *        Specifies the end <code>Customer</code>'s city associated with the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder city(String city);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s postal code associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param postalCode
         *        Specifies the end <code>Customer</code>'s postal code associated with the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder postalCode(String postalCode);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s state or region associated with the <code>Opportunity</code>.
         * </p>
         * <p>
         * Valid values:
         * <code>Alabama | Alaska | American Samoa | Arizona | Arkansas | California | Colorado | Connecticut | Delaware | Dist. of Columbia | Federated States of Micronesia | Florida | Georgia | Guam | Hawaii | Idaho | Illinois | Indiana | Iowa | Kansas | Kentucky | Louisiana | Maine | Marshall Islands | Maryland | Massachusetts | Michigan | Minnesota | Mississippi | Missouri | Montana | Nebraska | Nevada | New Hampshire | New Jersey | New Mexico | New York | North Carolina | North Dakota | Northern Mariana Islands | Ohio | Oklahoma | Oregon | Palau | Pennsylvania | Puerto Rico | Rhode Island | South Carolina | South Dakota | Tennessee | Texas | Utah | Vermont | Virginia | Virgin Islands | Washington | West Virginia | Wisconsin | Wyoming | APO/AE | AFO/FPO | FPO, AP</code>
         * </p>
         * 
         * @param stateOrRegion
         *        Specifies the end <code>Customer</code>'s state or region associated with the <code>Opportunity</code>
         *        .</p>
         *        <p>
         *        Valid values:
         *        <code>Alabama | Alaska | American Samoa | Arizona | Arkansas | California | Colorado | Connecticut | Delaware | Dist. of Columbia | Federated States of Micronesia | Florida | Georgia | Guam | Hawaii | Idaho | Illinois | Indiana | Iowa | Kansas | Kentucky | Louisiana | Maine | Marshall Islands | Maryland | Massachusetts | Michigan | Minnesota | Mississippi | Missouri | Montana | Nebraska | Nevada | New Hampshire | New Jersey | New Mexico | New York | North Carolina | North Dakota | Northern Mariana Islands | Ohio | Oklahoma | Oregon | Palau | Pennsylvania | Puerto Rico | Rhode Island | South Carolina | South Dakota | Tennessee | Texas | Utah | Vermont | Virginia | Virgin Islands | Washington | West Virginia | Wisconsin | Wyoming | APO/AE | AFO/FPO | FPO, AP</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stateOrRegion(String stateOrRegion);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param countryCode
         *        Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(String countryCode);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param countryCode
         *        Specifies the end <code>Customer</code>'s country associated with the <code>Opportunity</code>.
         * @see CountryCode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CountryCode
         */
        Builder countryCode(CountryCode countryCode);

        /**
         * <p>
         * Specifies the end <code>Customer</code>'s street address associated with the <code>Opportunity</code>.
         * </p>
         * 
         * @param streetAddress
         *        Specifies the end <code>Customer</code>'s street address associated with the <code>Opportunity</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder streetAddress(String streetAddress);
    }

    static final class BuilderImpl implements Builder {
        private String city;

        private String postalCode;

        private String stateOrRegion;

        private String countryCode;

        private String streetAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(Address model) {
            city(model.city);
            postalCode(model.postalCode);
            stateOrRegion(model.stateOrRegion);
            countryCode(model.countryCode);
            streetAddress(model.streetAddress);
        }

        public final String getCity() {
            return city;
        }

        public final void setCity(String city) {
            this.city = city;
        }

        @Override
        public final Builder city(String city) {
            this.city = city;
            return this;
        }

        public final String getPostalCode() {
            return postalCode;
        }

        public final void setPostalCode(String postalCode) {
            this.postalCode = postalCode;
        }

        @Override
        public final Builder postalCode(String postalCode) {
            this.postalCode = postalCode;
            return this;
        }

        public final String getStateOrRegion() {
            return stateOrRegion;
        }

        public final void setStateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
        }

        @Override
        public final Builder stateOrRegion(String stateOrRegion) {
            this.stateOrRegion = stateOrRegion;
            return this;
        }

        public final String getCountryCode() {
            return countryCode;
        }

        public final void setCountryCode(String countryCode) {
            this.countryCode = countryCode;
        }

        @Override
        public final Builder countryCode(String countryCode) {
            this.countryCode = countryCode;
            return this;
        }

        @Override
        public final Builder countryCode(CountryCode countryCode) {
            this.countryCode(countryCode == null ? null : countryCode.toString());
            return this;
        }

        public final String getStreetAddress() {
            return streetAddress;
        }

        public final void setStreetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
        }

        @Override
        public final Builder streetAddress(String streetAddress) {
            this.streetAddress = streetAddress;
            return this;
        }

        @Override
        public Address build() {
            return new Address(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
