/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the customer associated with the AWS opportunity. This field captures key details about the customer that
 * are necessary for managing the opportunity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AwsOpportunityCustomer implements SdkPojo, Serializable,
        ToCopyableBuilder<AwsOpportunityCustomer.Builder, AwsOpportunityCustomer> {
    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(AwsOpportunityCustomer::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Contact> contacts;

    private AwsOpportunityCustomer(BuilderImpl builder) {
        this.contacts = builder.contacts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Provides a list of customer contacts involved in the opportunity. These contacts may include decision makers,
     * influencers, and other stakeholders within the customer's organization.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContacts} method.
     * </p>
     * 
     * @return Provides a list of customer contacts involved in the opportunity. These contacts may include decision
     *         makers, influencers, and other stakeholders within the customer's organization.
     */
    public final List<Contact> contacts() {
        return contacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityCustomer)) {
            return false;
        }
        AwsOpportunityCustomer other = (AwsOpportunityCustomer) obj;
        return hasContacts() == other.hasContacts() && Objects.equals(contacts(), other.contacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AwsOpportunityCustomer").add("Contacts", hasContacts() ? contacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Contacts", CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityCustomer, T> g) {
        return obj -> g.apply((AwsOpportunityCustomer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AwsOpportunityCustomer> {
        /**
         * <p>
         * Provides a list of customer contacts involved in the opportunity. These contacts may include decision makers,
         * influencers, and other stakeholders within the customer's organization.
         * </p>
         * 
         * @param contacts
         *        Provides a list of customer contacts involved in the opportunity. These contacts may include decision
         *        makers, influencers, and other stakeholders within the customer's organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<Contact> contacts);

        /**
         * <p>
         * Provides a list of customer contacts involved in the opportunity. These contacts may include decision makers,
         * influencers, and other stakeholders within the customer's organization.
         * </p>
         * 
         * @param contacts
         *        Provides a list of customer contacts involved in the opportunity. These contacts may include decision
         *        makers, influencers, and other stakeholders within the customer's organization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Contact... contacts);

        /**
         * <p>
         * Provides a list of customer contacts involved in the opportunity. These contacts may include decision makers,
         * influencers, and other stakeholders within the customer's organization.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.partnercentralselling.model.Contact#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #contacts(List<Contact>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(java.util.Collection<Contact>)
         */
        Builder contacts(Consumer<Contact.Builder>... contacts);
    }

    static final class BuilderImpl implements Builder {
        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityCustomer model) {
            contacts(model.contacts);
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = CustomerContactsListCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = CustomerContactsListCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = CustomerContactsListCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> Contact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public AwsOpportunityCustomer build() {
            return new AwsOpportunityCustomer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
