/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ClosedLostReason {
    CUSTOMER_DEFICIENCY("Customer Deficiency"),

    DELAY_CANCELLATION_OF_PROJECT("Delay / Cancellation of Project"),

    LEGAL_TAX_REGULATORY("Legal / Tax / Regulatory"),

    LOST_TO_COMPETITOR_GOOGLE("Lost to Competitor - Google"),

    LOST_TO_COMPETITOR_MICROSOFT("Lost to Competitor - Microsoft"),

    LOST_TO_COMPETITOR_SOFT_LAYER("Lost to Competitor - SoftLayer"),

    LOST_TO_COMPETITOR_VM_WARE("Lost to Competitor - VMWare"),

    LOST_TO_COMPETITOR_OTHER("Lost to Competitor - Other"),

    NO_OPPORTUNITY("No Opportunity"),

    ON_PREMISES_DEPLOYMENT("On Premises Deployment"),

    PARTNER_GAP("Partner Gap"),

    PRICE("Price"),

    SECURITY_COMPLIANCE("Security / Compliance"),

    TECHNICAL_LIMITATIONS("Technical Limitations"),

    CUSTOMER_EXPERIENCE("Customer Experience"),

    OTHER("Other"),

    PEOPLE_RELATIONSHIP_GOVERNANCE("People/Relationship/Governance"),

    PRODUCT_TECHNOLOGY("Product/Technology"),

    FINANCIAL_COMMERCIAL("Financial/Commercial"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ClosedLostReason> VALUE_MAP = EnumUtils.uniqueIndex(ClosedLostReason.class,
            ClosedLostReason::toString);

    private final String value;

    private ClosedLostReason(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ClosedLostReason corresponding to the value
     */
    public static ClosedLostReason fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ClosedLostReason}s
     */
    public static Set<ClosedLostReason> knownValues() {
        Set<ClosedLostReason> knownValues = EnumSet.allOf(ClosedLostReason.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
