/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the customer's <code>Account</code> and <code>Contact</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Customer implements SdkPojo, Serializable, ToCopyableBuilder<Customer.Builder, Customer> {
    private static final SdkField<Account> ACCOUNT_FIELD = SdkField.<Account> builder(MarshallingType.SDK_POJO)
            .memberName("Account").getter(getter(Customer::account)).setter(setter(Builder::account))
            .constructor(Account::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Account").build()).build();

    private static final SdkField<List<Contact>> CONTACTS_FIELD = SdkField
            .<List<Contact>> builder(MarshallingType.LIST)
            .memberName("Contacts")
            .getter(getter(Customer::contacts))
            .setter(setter(Builder::contacts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contacts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Contact> builder(MarshallingType.SDK_POJO)
                                            .constructor(Contact::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_FIELD, CONTACTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Account account;

    private final List<Contact> contacts;

    private Customer(BuilderImpl builder) {
        this.account = builder.account;
        this.contacts = builder.contacts;
    }

    /**
     * <p>
     * An object that contains the customer's account details.
     * </p>
     * 
     * @return An object that contains the customer's account details.
     */
    public final Account account() {
        return account;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contacts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContacts() {
        return contacts != null && !(contacts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Represents the contact details for individuals associated with the customer of the <code>Opportunity</code>. This
     * field captures relevant contacts, including decision-makers, influencers, and technical stakeholders within the
     * customer organization. These contacts are key to progressing the opportunity.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContacts} method.
     * </p>
     * 
     * @return Represents the contact details for individuals associated with the customer of the
     *         <code>Opportunity</code>. This field captures relevant contacts, including decision-makers, influencers,
     *         and technical stakeholders within the customer organization. These contacts are key to progressing the
     *         opportunity.
     */
    public final List<Contact> contacts() {
        return contacts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(account());
        hashCode = 31 * hashCode + Objects.hashCode(hasContacts() ? contacts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Customer)) {
            return false;
        }
        Customer other = (Customer) obj;
        return Objects.equals(account(), other.account()) && hasContacts() == other.hasContacts()
                && Objects.equals(contacts(), other.contacts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Customer").add("Account", account()).add("Contacts", hasContacts() ? contacts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Account":
            return Optional.ofNullable(clazz.cast(account()));
        case "Contacts":
            return Optional.ofNullable(clazz.cast(contacts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Account", ACCOUNT_FIELD);
        map.put("Contacts", CONTACTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Customer, T> g) {
        return obj -> g.apply((Customer) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Customer> {
        /**
         * <p>
         * An object that contains the customer's account details.
         * </p>
         * 
         * @param account
         *        An object that contains the customer's account details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder account(Account account);

        /**
         * <p>
         * An object that contains the customer's account details.
         * </p>
         * This is a convenience method that creates an instance of the {@link Account.Builder} avoiding the need to
         * create one manually via {@link Account#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Account.Builder#build()} is called immediately and its result is
         * passed to {@link #account(Account)}.
         * 
         * @param account
         *        a consumer that will call methods on {@link Account.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #account(Account)
         */
        default Builder account(Consumer<Account.Builder> account) {
            return account(Account.builder().applyMutation(account).build());
        }

        /**
         * <p>
         * Represents the contact details for individuals associated with the customer of the <code>Opportunity</code>.
         * This field captures relevant contacts, including decision-makers, influencers, and technical stakeholders
         * within the customer organization. These contacts are key to progressing the opportunity.
         * </p>
         * 
         * @param contacts
         *        Represents the contact details for individuals associated with the customer of the
         *        <code>Opportunity</code>. This field captures relevant contacts, including decision-makers,
         *        influencers, and technical stakeholders within the customer organization. These contacts are key to
         *        progressing the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Collection<Contact> contacts);

        /**
         * <p>
         * Represents the contact details for individuals associated with the customer of the <code>Opportunity</code>.
         * This field captures relevant contacts, including decision-makers, influencers, and technical stakeholders
         * within the customer organization. These contacts are key to progressing the opportunity.
         * </p>
         * 
         * @param contacts
         *        Represents the contact details for individuals associated with the customer of the
         *        <code>Opportunity</code>. This field captures relevant contacts, including decision-makers,
         *        influencers, and technical stakeholders within the customer organization. These contacts are key to
         *        progressing the opportunity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contacts(Contact... contacts);

        /**
         * <p>
         * Represents the contact details for individuals associated with the customer of the <code>Opportunity</code>.
         * This field captures relevant contacts, including decision-makers, influencers, and technical stakeholders
         * within the customer organization. These contacts are key to progressing the opportunity.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.partnercentralselling.model.Contact#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder#build()} is called
         * immediately and its result is passed to {@link #contacts(List<Contact>)}.
         * 
         * @param contacts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.Contact.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contacts(java.util.Collection<Contact>)
         */
        Builder contacts(Consumer<Contact.Builder>... contacts);
    }

    static final class BuilderImpl implements Builder {
        private Account account;

        private List<Contact> contacts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Customer model) {
            account(model.account);
            contacts(model.contacts);
        }

        public final Account.Builder getAccount() {
            return account != null ? account.toBuilder() : null;
        }

        public final void setAccount(Account.BuilderImpl account) {
            this.account = account != null ? account.build() : null;
        }

        @Override
        public final Builder account(Account account) {
            this.account = account;
            return this;
        }

        public final List<Contact.Builder> getContacts() {
            List<Contact.Builder> result = CustomerContactsListCopier.copyToBuilder(this.contacts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContacts(Collection<Contact.BuilderImpl> contacts) {
            this.contacts = CustomerContactsListCopier.copyFromBuilder(contacts);
        }

        @Override
        public final Builder contacts(Collection<Contact> contacts) {
            this.contacts = CustomerContactsListCopier.copy(contacts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Contact... contacts) {
            contacts(Arrays.asList(contacts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contacts(Consumer<Contact.Builder>... contacts) {
            contacts(Stream.of(contacts).map(c -> Contact.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Customer build() {
            return new Customer(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
