/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The CustomerProjects structure in Engagements offers a flexible framework for managing customer-project
 * relationships. It supports multiple customers per Engagement and multiple projects per customer, while also allowing
 * for customers without projects and projects without specific customers.
 * </p>
 * <p>
 * All Engagement members have full visibility of customers and their associated projects, enabling the capture of
 * relevant context even when project details are not fully defined. This structure also facilitates targeted
 * invitations, allowing partners to focus on specific customers and their business problems when sending Engagement
 * invitations.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerProjectsContext implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerProjectsContext.Builder, CustomerProjectsContext> {
    private static final SdkField<EngagementCustomer> CUSTOMER_FIELD = SdkField
            .<EngagementCustomer> builder(MarshallingType.SDK_POJO).memberName("Customer")
            .getter(getter(CustomerProjectsContext::customer)).setter(setter(Builder::customer))
            .constructor(EngagementCustomer::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Customer").build()).build();

    private static final SdkField<EngagementCustomerProjectDetails> PROJECT_FIELD = SdkField
            .<EngagementCustomerProjectDetails> builder(MarshallingType.SDK_POJO).memberName("Project")
            .getter(getter(CustomerProjectsContext::project)).setter(setter(Builder::project))
            .constructor(EngagementCustomerProjectDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Project").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(CUSTOMER_FIELD, PROJECT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final EngagementCustomer customer;

    private final EngagementCustomerProjectDetails project;

    private CustomerProjectsContext(BuilderImpl builder) {
        this.customer = builder.customer;
        this.project = builder.project;
    }

    /**
     * Returns the value of the Customer property for this object.
     * 
     * @return The value of the Customer property for this object.
     */
    public final EngagementCustomer customer() {
        return customer;
    }

    /**
     * <p>
     * Information about the customer project associated with the Engagement.
     * </p>
     * 
     * @return Information about the customer project associated with the Engagement.
     */
    public final EngagementCustomerProjectDetails project() {
        return project;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customer());
        hashCode = 31 * hashCode + Objects.hashCode(project());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerProjectsContext)) {
            return false;
        }
        CustomerProjectsContext other = (CustomerProjectsContext) obj;
        return Objects.equals(customer(), other.customer()) && Objects.equals(project(), other.project());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerProjectsContext").add("Customer", customer()).add("Project", project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Customer":
            return Optional.ofNullable(clazz.cast(customer()));
        case "Project":
            return Optional.ofNullable(clazz.cast(project()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Customer", CUSTOMER_FIELD);
        map.put("Project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerProjectsContext, T> g) {
        return obj -> g.apply((CustomerProjectsContext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerProjectsContext> {
        /**
         * Sets the value of the Customer property for this object.
         *
         * @param customer
         *        The new value for the Customer property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customer(EngagementCustomer customer);

        /**
         * Sets the value of the Customer property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EngagementCustomer.Builder} avoiding the
         * need to create one manually via {@link EngagementCustomer#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngagementCustomer.Builder#build()} is called immediately and its
         * result is passed to {@link #customer(EngagementCustomer)}.
         * 
         * @param customer
         *        a consumer that will call methods on {@link EngagementCustomer.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customer(EngagementCustomer)
         */
        default Builder customer(Consumer<EngagementCustomer.Builder> customer) {
            return customer(EngagementCustomer.builder().applyMutation(customer).build());
        }

        /**
         * <p>
         * Information about the customer project associated with the Engagement.
         * </p>
         * 
         * @param project
         *        Information about the customer project associated with the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder project(EngagementCustomerProjectDetails project);

        /**
         * <p>
         * Information about the customer project associated with the Engagement.
         * </p>
         * This is a convenience method that creates an instance of the {@link EngagementCustomerProjectDetails.Builder}
         * avoiding the need to create one manually via {@link EngagementCustomerProjectDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngagementCustomerProjectDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #project(EngagementCustomerProjectDetails)}.
         * 
         * @param project
         *        a consumer that will call methods on {@link EngagementCustomerProjectDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #project(EngagementCustomerProjectDetails)
         */
        default Builder project(Consumer<EngagementCustomerProjectDetails.Builder> project) {
            return project(EngagementCustomerProjectDetails.builder().applyMutation(project).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private EngagementCustomer customer;

        private EngagementCustomerProjectDetails project;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerProjectsContext model) {
            customer(model.customer);
            project(model.project);
        }

        public final EngagementCustomer.Builder getCustomer() {
            return customer != null ? customer.toBuilder() : null;
        }

        public final void setCustomer(EngagementCustomer.BuilderImpl customer) {
            this.customer = customer != null ? customer.build() : null;
        }

        @Override
        public final Builder customer(EngagementCustomer customer) {
            this.customer = customer;
            return this;
        }

        public final EngagementCustomerProjectDetails.Builder getProject() {
            return project != null ? project.toBuilder() : null;
        }

        public final void setProject(EngagementCustomerProjectDetails.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(EngagementCustomerProjectDetails project) {
            this.project = project;
            return this;
        }

        @Override
        public CustomerProjectsContext build() {
            return new CustomerProjectsContext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
