/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteResourceSnapshotJobRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<DeleteResourceSnapshotJobRequest.Builder, DeleteResourceSnapshotJobRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(DeleteResourceSnapshotJobRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_JOB_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotJobIdentifier")
            .getter(getter(DeleteResourceSnapshotJobRequest::resourceSnapshotJobIdentifier))
            .setter(setter(Builder::resourceSnapshotJobIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotJobIdentifier")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            RESOURCE_SNAPSHOT_JOB_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String resourceSnapshotJobIdentifier;

    private DeleteResourceSnapshotJobRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.resourceSnapshotJobIdentifier = builder.resourceSnapshotJobIdentifier;
    }

    /**
     * <p>
     * Specifies the catalog from which to delete the snapshot job. Valid values are <code>AWS</code> and
     * <code>Sandbox</code>.
     * </p>
     * 
     * @return Specifies the catalog from which to delete the snapshot job. Valid values are <code>AWS</code> and
     *         <code>Sandbox</code>.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The unique identifier of the resource snapshot job to be deleted.
     * </p>
     * 
     * @return The unique identifier of the resource snapshot job to be deleted.
     */
    public final String resourceSnapshotJobIdentifier() {
        return resourceSnapshotJobIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotJobIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteResourceSnapshotJobRequest)) {
            return false;
        }
        DeleteResourceSnapshotJobRequest other = (DeleteResourceSnapshotJobRequest) obj;
        return Objects.equals(catalog(), other.catalog())
                && Objects.equals(resourceSnapshotJobIdentifier(), other.resourceSnapshotJobIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteResourceSnapshotJobRequest").add("Catalog", catalog())
                .add("ResourceSnapshotJobIdentifier", resourceSnapshotJobIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "ResourceSnapshotJobIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSnapshotJobIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("ResourceSnapshotJobIdentifier", RESOURCE_SNAPSHOT_JOB_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteResourceSnapshotJobRequest, T> g) {
        return obj -> g.apply((DeleteResourceSnapshotJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteResourceSnapshotJobRequest> {
        /**
         * <p>
         * Specifies the catalog from which to delete the snapshot job. Valid values are <code>AWS</code> and
         * <code>Sandbox</code>.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog from which to delete the snapshot job. Valid values are <code>AWS</code> and
         *        <code>Sandbox</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The unique identifier of the resource snapshot job to be deleted.
         * </p>
         * 
         * @param resourceSnapshotJobIdentifier
         *        The unique identifier of the resource snapshot job to be deleted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotJobIdentifier(String resourceSnapshotJobIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String resourceSnapshotJobIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteResourceSnapshotJobRequest model) {
            super(model);
            catalog(model.catalog);
            resourceSnapshotJobIdentifier(model.resourceSnapshotJobIdentifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getResourceSnapshotJobIdentifier() {
            return resourceSnapshotJobIdentifier;
        }

        public final void setResourceSnapshotJobIdentifier(String resourceSnapshotJobIdentifier) {
            this.resourceSnapshotJobIdentifier = resourceSnapshotJobIdentifier;
        }

        @Override
        public final Builder resourceSnapshotJobIdentifier(String resourceSnapshotJobIdentifier) {
            this.resourceSnapshotJobIdentifier = resourceSnapshotJobIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteResourceSnapshotJobRequest build() {
            return new DeleteResourceSnapshotJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
