/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides an estimate of the revenue that the partner is expected to generate from the opportunity. This information
 * helps partners assess the financial value of the project.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpectedCustomerSpend implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpectedCustomerSpend.Builder, ExpectedCustomerSpend> {
    private static final SdkField<String> AMOUNT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Amount")
            .getter(getter(ExpectedCustomerSpend::amount)).setter(setter(Builder::amount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Amount").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrencyCode").getter(getter(ExpectedCustomerSpend::currencyCodeAsString))
            .setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrencyCode").build()).build();

    private static final SdkField<String> FREQUENCY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Frequency").getter(getter(ExpectedCustomerSpend::frequencyAsString)).setter(setter(Builder::frequency))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Frequency").build()).build();

    private static final SdkField<String> TARGET_COMPANY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetCompany").getter(getter(ExpectedCustomerSpend::targetCompany))
            .setter(setter(Builder::targetCompany))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCompany").build()).build();

    private static final SdkField<String> ESTIMATION_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EstimationUrl").getter(getter(ExpectedCustomerSpend::estimationUrl))
            .setter(setter(Builder::estimationUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EstimationUrl").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNT_FIELD,
            CURRENCY_CODE_FIELD, FREQUENCY_FIELD, TARGET_COMPANY_FIELD, ESTIMATION_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String amount;

    private final String currencyCode;

    private final String frequency;

    private final String targetCompany;

    private final String estimationUrl;

    private ExpectedCustomerSpend(BuilderImpl builder) {
        this.amount = builder.amount;
        this.currencyCode = builder.currencyCode;
        this.frequency = builder.frequency;
        this.targetCompany = builder.targetCompany;
        this.estimationUrl = builder.estimationUrl;
    }

    /**
     * <p>
     * Represents the estimated monthly revenue that the partner expects to earn from the opportunity. This helps in
     * forecasting financial returns.
     * </p>
     * 
     * @return Represents the estimated monthly revenue that the partner expects to earn from the opportunity. This
     *         helps in forecasting financial returns.
     */
    public final String amount() {
        return amount;
    }

    /**
     * <p>
     * Indicates the currency in which the revenue estimate is provided. This helps in understanding the financial
     * impact across different markets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link ExpectedCustomerSpendCurrencyCodeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return Indicates the currency in which the revenue estimate is provided. This helps in understanding the
     *         financial impact across different markets.
     * @see ExpectedCustomerSpendCurrencyCodeEnum
     */
    public final ExpectedCustomerSpendCurrencyCodeEnum currencyCode() {
        return ExpectedCustomerSpendCurrencyCodeEnum.fromValue(currencyCode);
    }

    /**
     * <p>
     * Indicates the currency in which the revenue estimate is provided. This helps in understanding the financial
     * impact across different markets.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currencyCode} will
     * return {@link ExpectedCustomerSpendCurrencyCodeEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #currencyCodeAsString}.
     * </p>
     * 
     * @return Indicates the currency in which the revenue estimate is provided. This helps in understanding the
     *         financial impact across different markets.
     * @see ExpectedCustomerSpendCurrencyCodeEnum
     */
    public final String currencyCodeAsString() {
        return currencyCode;
    }

    /**
     * <p>
     * Indicates how frequently the customer is expected to spend the projected amount. Only the value
     * <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly spend.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link PaymentFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return Indicates how frequently the customer is expected to spend the projected amount. Only the value
     *         <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly
     *         spend.
     * @see PaymentFrequency
     */
    public final PaymentFrequency frequency() {
        return PaymentFrequency.fromValue(frequency);
    }

    /**
     * <p>
     * Indicates how frequently the customer is expected to spend the projected amount. Only the value
     * <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly spend.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #frequency} will
     * return {@link PaymentFrequency#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #frequencyAsString}.
     * </p>
     * 
     * @return Indicates how frequently the customer is expected to spend the projected amount. Only the value
     *         <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly
     *         spend.
     * @see PaymentFrequency
     */
    public final String frequencyAsString() {
        return frequency;
    }

    /**
     * <p>
     * Specifies the name of the partner company that is expected to generate revenue from the opportunity. This field
     * helps track the partner’s involvement in the opportunity. This field only accepts the value <code>AWS</code>. If
     * any other value is provided, the system will automatically set it to <code>AWS</code>.
     * </p>
     * 
     * @return Specifies the name of the partner company that is expected to generate revenue from the opportunity. This
     *         field helps track the partner’s involvement in the opportunity. This field only accepts the value
     *         <code>AWS</code>. If any other value is provided, the system will automatically set it to
     *         <code>AWS</code>.
     */
    public final String targetCompany() {
        return targetCompany;
    }

    /**
     * <p>
     * A URL providing additional information or context about the spend estimation.
     * </p>
     * 
     * @return A URL providing additional information or context about the spend estimation.
     */
    public final String estimationUrl() {
        return estimationUrl;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(amount());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCodeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(frequencyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetCompany());
        hashCode = 31 * hashCode + Objects.hashCode(estimationUrl());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpectedCustomerSpend)) {
            return false;
        }
        ExpectedCustomerSpend other = (ExpectedCustomerSpend) obj;
        return Objects.equals(amount(), other.amount()) && Objects.equals(currencyCodeAsString(), other.currencyCodeAsString())
                && Objects.equals(frequencyAsString(), other.frequencyAsString())
                && Objects.equals(targetCompany(), other.targetCompany())
                && Objects.equals(estimationUrl(), other.estimationUrl());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExpectedCustomerSpend")
                .add("Amount", amount() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CurrencyCode", currencyCodeAsString() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Frequency", frequencyAsString()).add("TargetCompany", targetCompany())
                .add("EstimationUrl", estimationUrl() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Amount":
            return Optional.ofNullable(clazz.cast(amount()));
        case "CurrencyCode":
            return Optional.ofNullable(clazz.cast(currencyCodeAsString()));
        case "Frequency":
            return Optional.ofNullable(clazz.cast(frequencyAsString()));
        case "TargetCompany":
            return Optional.ofNullable(clazz.cast(targetCompany()));
        case "EstimationUrl":
            return Optional.ofNullable(clazz.cast(estimationUrl()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Amount", AMOUNT_FIELD);
        map.put("CurrencyCode", CURRENCY_CODE_FIELD);
        map.put("Frequency", FREQUENCY_FIELD);
        map.put("TargetCompany", TARGET_COMPANY_FIELD);
        map.put("EstimationUrl", ESTIMATION_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExpectedCustomerSpend, T> g) {
        return obj -> g.apply((ExpectedCustomerSpend) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpectedCustomerSpend> {
        /**
         * <p>
         * Represents the estimated monthly revenue that the partner expects to earn from the opportunity. This helps in
         * forecasting financial returns.
         * </p>
         * 
         * @param amount
         *        Represents the estimated monthly revenue that the partner expects to earn from the opportunity. This
         *        helps in forecasting financial returns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amount(String amount);

        /**
         * <p>
         * Indicates the currency in which the revenue estimate is provided. This helps in understanding the financial
         * impact across different markets.
         * </p>
         * 
         * @param currencyCode
         *        Indicates the currency in which the revenue estimate is provided. This helps in understanding the
         *        financial impact across different markets.
         * @see ExpectedCustomerSpendCurrencyCodeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpectedCustomerSpendCurrencyCodeEnum
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Indicates the currency in which the revenue estimate is provided. This helps in understanding the financial
         * impact across different markets.
         * </p>
         * 
         * @param currencyCode
         *        Indicates the currency in which the revenue estimate is provided. This helps in understanding the
         *        financial impact across different markets.
         * @see ExpectedCustomerSpendCurrencyCodeEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExpectedCustomerSpendCurrencyCodeEnum
         */
        Builder currencyCode(ExpectedCustomerSpendCurrencyCodeEnum currencyCode);

        /**
         * <p>
         * Indicates how frequently the customer is expected to spend the projected amount. Only the value
         * <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly spend.
         * </p>
         * 
         * @param frequency
         *        Indicates how frequently the customer is expected to spend the projected amount. Only the value
         *        <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly
         *        spend.
         * @see PaymentFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentFrequency
         */
        Builder frequency(String frequency);

        /**
         * <p>
         * Indicates how frequently the customer is expected to spend the projected amount. Only the value
         * <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly spend.
         * </p>
         * 
         * @param frequency
         *        Indicates how frequently the customer is expected to spend the projected amount. Only the value
         *        <code>Monthly</code> is allowed for the <code>Frequency</code> field, representing recurring monthly
         *        spend.
         * @see PaymentFrequency
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PaymentFrequency
         */
        Builder frequency(PaymentFrequency frequency);

        /**
         * <p>
         * Specifies the name of the partner company that is expected to generate revenue from the opportunity. This
         * field helps track the partner’s involvement in the opportunity. This field only accepts the value
         * <code>AWS</code>. If any other value is provided, the system will automatically set it to <code>AWS</code>.
         * </p>
         * 
         * @param targetCompany
         *        Specifies the name of the partner company that is expected to generate revenue from the opportunity.
         *        This field helps track the partner’s involvement in the opportunity. This field only accepts the value
         *        <code>AWS</code>. If any other value is provided, the system will automatically set it to
         *        <code>AWS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetCompany(String targetCompany);

        /**
         * <p>
         * A URL providing additional information or context about the spend estimation.
         * </p>
         * 
         * @param estimationUrl
         *        A URL providing additional information or context about the spend estimation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder estimationUrl(String estimationUrl);
    }

    static final class BuilderImpl implements Builder {
        private String amount;

        private String currencyCode;

        private String frequency;

        private String targetCompany;

        private String estimationUrl;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpectedCustomerSpend model) {
            amount(model.amount);
            currencyCode(model.currencyCode);
            frequency(model.frequency);
            targetCompany(model.targetCompany);
            estimationUrl(model.estimationUrl);
        }

        public final String getAmount() {
            return amount;
        }

        public final void setAmount(String amount) {
            this.amount = amount;
        }

        @Override
        public final Builder amount(String amount) {
            this.amount = amount;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        @Override
        public final Builder currencyCode(ExpectedCustomerSpendCurrencyCodeEnum currencyCode) {
            this.currencyCode(currencyCode == null ? null : currencyCode.toString());
            return this;
        }

        public final String getFrequency() {
            return frequency;
        }

        public final void setFrequency(String frequency) {
            this.frequency = frequency;
        }

        @Override
        public final Builder frequency(String frequency) {
            this.frequency = frequency;
            return this;
        }

        @Override
        public final Builder frequency(PaymentFrequency frequency) {
            this.frequency(frequency == null ? null : frequency.toString());
            return this;
        }

        public final String getTargetCompany() {
            return targetCompany;
        }

        public final void setTargetCompany(String targetCompany) {
            this.targetCompany = targetCompany;
        }

        @Override
        public final Builder targetCompany(String targetCompany) {
            this.targetCompany = targetCompany;
            return this;
        }

        public final String getEstimationUrl() {
            return estimationUrl;
        }

        public final void setEstimationUrl(String estimationUrl) {
            this.estimationUrl = estimationUrl;
        }

        @Override
        public final Builder estimationUrl(String estimationUrl) {
            this.estimationUrl = estimationUrl;
            return this;
        }

        @Override
        public ExpectedCustomerSpend build() {
            return new ExpectedCustomerSpend(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
