/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetEngagementResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<GetEngagementResponse.Builder, GetEngagementResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(GetEngagementResponse::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(GetEngagementResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Title")
            .getter(getter(GetEngagementResponse::title)).setter(setter(Builder::title))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(GetEngagementResponse::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt")
            .getter(getter(GetEngagementResponse::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(GetEngagementResponse::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final SdkField<Integer> MEMBER_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MemberCount").getter(getter(GetEngagementResponse::memberCount)).setter(setter(Builder::memberCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberCount").build()).build();

    private static final SdkField<List<EngagementContextDetails>> CONTEXTS_FIELD = SdkField
            .<List<EngagementContextDetails>> builder(MarshallingType.LIST)
            .memberName("Contexts")
            .getter(getter(GetEngagementResponse::contexts))
            .setter(setter(Builder::contexts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contexts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngagementContextDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngagementContextDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD,
            TITLE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, MEMBER_COUNT_FIELD, CONTEXTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String id;

    private final String arn;

    private final String title;

    private final String description;

    private final Instant createdAt;

    private final String createdBy;

    private final Integer memberCount;

    private final List<EngagementContextDetails> contexts;

    private GetEngagementResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.title = builder.title;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.memberCount = builder.memberCount;
        this.contexts = builder.contexts;
    }

    /**
     * <p>
     * The unique resource identifier of the engagement retrieved.
     * </p>
     * 
     * @return The unique resource identifier of the engagement retrieved.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the engagement retrieved.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the engagement retrieved.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The title of the engagement. It provides a brief, descriptive name for the engagement that is meaningful and
     * easily recognizable.
     * </p>
     * 
     * @return The title of the engagement. It provides a brief, descriptive name for the engagement that is meaningful
     *         and easily recognizable.
     */
    public final String title() {
        return title;
    }

    /**
     * <p>
     * A more detailed description of the engagement. This provides additional context or information about the
     * engagement's purpose or scope.
     * </p>
     * 
     * @return A more detailed description of the engagement. This provides additional context or information about the
     *         engagement's purpose or scope.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The date and time when the Engagement was created, presented in ISO 8601 format (UTC). For example:
     * "2023-05-01T20:37:46Z". This timestamp helps track the lifecycle of the Engagement.
     * </p>
     * 
     * @return The date and time when the Engagement was created, presented in ISO 8601 format (UTC). For example:
     *         "2023-05-01T20:37:46Z". This timestamp helps track the lifecycle of the Engagement.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The AWS account ID of the user who originally created the engagement. This field helps in tracking the origin of
     * the engagement.
     * </p>
     * 
     * @return The AWS account ID of the user who originally created the engagement. This field helps in tracking the
     *         origin of the engagement.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * Specifies the current count of members participating in the Engagement. This count includes all active members
     * regardless of their roles or permissions within the Engagement.
     * </p>
     * 
     * @return Specifies the current count of members participating in the Engagement. This count includes all active
     *         members regardless of their roles or permissions within the Engagement.
     */
    public final Integer memberCount() {
        return memberCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the Contexts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContexts() {
        return contexts != null && !(contexts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of context objects associated with the engagement. Each context provides additional information related to
     * the Engagement, such as customer projects or documents.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContexts} method.
     * </p>
     * 
     * @return A list of context objects associated with the engagement. Each context provides additional information
     *         related to the Engagement, such as customer projects or documents.
     */
    public final List<EngagementContextDetails> contexts() {
        return contexts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(title());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(memberCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasContexts() ? contexts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEngagementResponse)) {
            return false;
        }
        GetEngagementResponse other = (GetEngagementResponse) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(arn(), other.arn()) && Objects.equals(title(), other.title())
                && Objects.equals(description(), other.description()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(memberCount(), other.memberCount())
                && hasContexts() == other.hasContexts() && Objects.equals(contexts(), other.contexts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetEngagementResponse").add("Id", id()).add("Arn", arn()).add("Title", title())
                .add("Description", description()).add("CreatedAt", createdAt())
                .add("CreatedBy", createdBy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("MemberCount", memberCount()).add("Contexts", hasContexts() ? contexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Title":
            return Optional.ofNullable(clazz.cast(title()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "MemberCount":
            return Optional.ofNullable(clazz.cast(memberCount()));
        case "Contexts":
            return Optional.ofNullable(clazz.cast(contexts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("MemberCount", MEMBER_COUNT_FIELD);
        map.put("Contexts", CONTEXTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEngagementResponse, T> g) {
        return obj -> g.apply((GetEngagementResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetEngagementResponse> {
        /**
         * <p>
         * The unique resource identifier of the engagement retrieved.
         * </p>
         * 
         * @param id
         *        The unique resource identifier of the engagement retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the engagement retrieved.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the engagement retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The title of the engagement. It provides a brief, descriptive name for the engagement that is meaningful and
         * easily recognizable.
         * </p>
         * 
         * @param title
         *        The title of the engagement. It provides a brief, descriptive name for the engagement that is
         *        meaningful and easily recognizable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder title(String title);

        /**
         * <p>
         * A more detailed description of the engagement. This provides additional context or information about the
         * engagement's purpose or scope.
         * </p>
         * 
         * @param description
         *        A more detailed description of the engagement. This provides additional context or information about
         *        the engagement's purpose or scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The date and time when the Engagement was created, presented in ISO 8601 format (UTC). For example:
         * "2023-05-01T20:37:46Z". This timestamp helps track the lifecycle of the Engagement.
         * </p>
         * 
         * @param createdAt
         *        The date and time when the Engagement was created, presented in ISO 8601 format (UTC). For example:
         *        "2023-05-01T20:37:46Z". This timestamp helps track the lifecycle of the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The AWS account ID of the user who originally created the engagement. This field helps in tracking the origin
         * of the engagement.
         * </p>
         * 
         * @param createdBy
         *        The AWS account ID of the user who originally created the engagement. This field helps in tracking the
         *        origin of the engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * Specifies the current count of members participating in the Engagement. This count includes all active
         * members regardless of their roles or permissions within the Engagement.
         * </p>
         * 
         * @param memberCount
         *        Specifies the current count of members participating in the Engagement. This count includes all active
         *        members regardless of their roles or permissions within the Engagement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberCount(Integer memberCount);

        /**
         * <p>
         * A list of context objects associated with the engagement. Each context provides additional information
         * related to the Engagement, such as customer projects or documents.
         * </p>
         * 
         * @param contexts
         *        A list of context objects associated with the engagement. Each context provides additional information
         *        related to the Engagement, such as customer projects or documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(Collection<EngagementContextDetails> contexts);

        /**
         * <p>
         * A list of context objects associated with the engagement. Each context provides additional information
         * related to the Engagement, such as customer projects or documents.
         * </p>
         * 
         * @param contexts
         *        A list of context objects associated with the engagement. Each context provides additional information
         *        related to the Engagement, such as customer projects or documents.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contexts(EngagementContextDetails... contexts);

        /**
         * <p>
         * A list of context objects associated with the engagement. Each context provides additional information
         * related to the Engagement, such as customer projects or documents.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails.Builder#build()}
         * is called immediately and its result is passed to {@link #contexts(List<EngagementContextDetails>)}.
         * 
         * @param contexts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contexts(java.util.Collection<EngagementContextDetails>)
         */
        Builder contexts(Consumer<EngagementContextDetails.Builder>... contexts);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private String id;

        private String arn;

        private String title;

        private String description;

        private Instant createdAt;

        private String createdBy;

        private Integer memberCount;

        private List<EngagementContextDetails> contexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEngagementResponse model) {
            super(model);
            id(model.id);
            arn(model.arn);
            title(model.title);
            description(model.description);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            memberCount(model.memberCount);
            contexts(model.contexts);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTitle() {
            return title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Integer getMemberCount() {
            return memberCount;
        }

        public final void setMemberCount(Integer memberCount) {
            this.memberCount = memberCount;
        }

        @Override
        public final Builder memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        public final List<EngagementContextDetails.Builder> getContexts() {
            List<EngagementContextDetails.Builder> result = EngagementContextsCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<EngagementContextDetails.BuilderImpl> contexts) {
            this.contexts = EngagementContextsCopier.copyFromBuilder(contexts);
        }

        @Override
        public final Builder contexts(Collection<EngagementContextDetails> contexts) {
            this.contexts = EngagementContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(EngagementContextDetails... contexts) {
            contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<EngagementContextDetails.Builder>... contexts) {
            contexts(Stream.of(contexts).map(c -> EngagementContextDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEngagementResponse build() {
            return new GetEngagementResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
