/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetResourceSnapshotRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<GetResourceSnapshotRequest.Builder, GetResourceSnapshotRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(GetResourceSnapshotRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<String> ENGAGEMENT_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngagementIdentifier").getter(getter(GetResourceSnapshotRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(GetResourceSnapshotRequest::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceIdentifier").getter(getter(GetResourceSnapshotRequest::resourceIdentifier))
            .setter(setter(Builder::resourceIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceIdentifier").build())
            .build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotTemplateIdentifier")
            .getter(getter(GetResourceSnapshotRequest::resourceSnapshotTemplateIdentifier))
            .setter(setter(Builder::resourceSnapshotTemplateIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateIdentifier")
                    .build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Revision").getter(getter(GetResourceSnapshotRequest::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            ENGAGEMENT_IDENTIFIER_FIELD, RESOURCE_TYPE_FIELD, RESOURCE_IDENTIFIER_FIELD,
            RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD, REVISION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final String engagementIdentifier;

    private final String resourceType;

    private final String resourceIdentifier;

    private final String resourceSnapshotTemplateIdentifier;

    private final Integer revision;

    private GetResourceSnapshotRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.resourceType = builder.resourceType;
        this.resourceIdentifier = builder.resourceIdentifier;
        this.resourceSnapshotTemplateIdentifier = builder.resourceSnapshotTemplateIdentifier;
        this.revision = builder.revision;
    }

    /**
     * <p>
     * Specifies the catalog related to the request. Valid values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * AWS: Retrieves the snapshot from the production AWS environment.
     * </p>
     * </li>
     * <li>
     * <p>
     * Sandbox: Retrieves the snapshot from a sandbox environment used for testing or development purposes.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the catalog related to the request. Valid values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         AWS: Retrieves the snapshot from the production AWS environment.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Sandbox: Retrieves the snapshot from a sandbox environment used for testing or development purposes.
     *         </p>
     *         </li>
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * The unique identifier of the engagement associated with the snapshot. This field links the snapshot to a specific
     * engagement context.
     * </p>
     * 
     * @return The unique identifier of the engagement associated with the snapshot. This field links the snapshot to a
     *         specific engagement context.
     */
    public final String engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * <p>
     * Specifies the type of resource that was snapshotted. This field determines the structure and content of the
     * snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource that was snapshotted. This field determines the structure and content of
     *         the snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * Specifies the type of resource that was snapshotted. This field determines the structure and content of the
     * snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of resource that was snapshotted. This field determines the structure and content of
     *         the snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The unique identifier of the specific resource that was snapshotted. The format and constraints of this
     * identifier depend on the ResourceType specified. For <code>Opportunity</code> type, it will be an
     * <code>opportunity ID</code>
     * </p>
     * 
     * @return The unique identifier of the specific resource that was snapshotted. The format and constraints of this
     *         identifier depend on the ResourceType specified. For <code>Opportunity</code> type, it will be an
     *         <code>opportunity ID</code>
     */
    public final String resourceIdentifier() {
        return resourceIdentifier;
    }

    /**
     * <p>
     * he name of the template that defines the schema for the snapshot. This template determines which subset of the
     * resource data is included in the snapshot and must correspond to an existing and valid template for the specified
     * <code>ResourceType</code>.
     * </p>
     * 
     * @return he name of the template that defines the schema for the snapshot. This template determines which subset
     *         of the resource data is included in the snapshot and must correspond to an existing and valid template
     *         for the specified <code>ResourceType</code>.
     */
    public final String resourceSnapshotTemplateIdentifier() {
        return resourceSnapshotTemplateIdentifier;
    }

    /**
     * <p>
     * Specifies which revision of the snapshot to retrieve. If omitted returns the latest revision.
     * </p>
     * 
     * @return Specifies which revision of the snapshot to retrieve. If omitted returns the latest revision.
     */
    public final Integer revision() {
        return revision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(engagementIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotTemplateIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetResourceSnapshotRequest)) {
            return false;
        }
        GetResourceSnapshotRequest other = (GetResourceSnapshotRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceIdentifier(), other.resourceIdentifier())
                && Objects.equals(resourceSnapshotTemplateIdentifier(), other.resourceSnapshotTemplateIdentifier())
                && Objects.equals(revision(), other.revision());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetResourceSnapshotRequest").add("Catalog", catalog())
                .add("EngagementIdentifier", engagementIdentifier()).add("ResourceType", resourceTypeAsString())
                .add("ResourceIdentifier", resourceIdentifier())
                .add("ResourceSnapshotTemplateIdentifier", resourceSnapshotTemplateIdentifier()).add("Revision", revision())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceIdentifier":
            return Optional.ofNullable(clazz.cast(resourceIdentifier()));
        case "ResourceSnapshotTemplateIdentifier":
            return Optional.ofNullable(clazz.cast(resourceSnapshotTemplateIdentifier()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("ResourceSnapshotTemplateIdentifier", RESOURCE_SNAPSHOT_TEMPLATE_IDENTIFIER_FIELD);
        map.put("Revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetResourceSnapshotRequest, T> g) {
        return obj -> g.apply((GetResourceSnapshotRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetResourceSnapshotRequest> {
        /**
         * <p>
         * Specifies the catalog related to the request. Valid values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * AWS: Retrieves the snapshot from the production AWS environment.
         * </p>
         * </li>
         * <li>
         * <p>
         * Sandbox: Retrieves the snapshot from a sandbox environment used for testing or development purposes.
         * </p>
         * </li>
         * </ul>
         * 
         * @param catalog
         *        Specifies the catalog related to the request. Valid values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        AWS: Retrieves the snapshot from the production AWS environment.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Sandbox: Retrieves the snapshot from a sandbox environment used for testing or development purposes.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * The unique identifier of the engagement associated with the snapshot. This field links the snapshot to a
         * specific engagement context.
         * </p>
         * 
         * @param engagementIdentifier
         *        The unique identifier of the engagement associated with the snapshot. This field links the snapshot to
         *        a specific engagement context.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String engagementIdentifier);

        /**
         * <p>
         * Specifies the type of resource that was snapshotted. This field determines the structure and content of the
         * snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource that was snapshotted. This field determines the structure and content
         *        of the snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Specifies the type of resource that was snapshotted. This field determines the structure and content of the
         * snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
         * </p>
         * 
         * @param resourceType
         *        Specifies the type of resource that was snapshotted. This field determines the structure and content
         *        of the snapshot payload. Valid value includes:<code>Opportunity</code>: For opportunity-related data.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The unique identifier of the specific resource that was snapshotted. The format and constraints of this
         * identifier depend on the ResourceType specified. For <code>Opportunity</code> type, it will be an
         * <code>opportunity ID</code>
         * </p>
         * 
         * @param resourceIdentifier
         *        The unique identifier of the specific resource that was snapshotted. The format and constraints of
         *        this identifier depend on the ResourceType specified. For <code>Opportunity</code> type, it will be an
         *        <code>opportunity ID</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIdentifier(String resourceIdentifier);

        /**
         * <p>
         * he name of the template that defines the schema for the snapshot. This template determines which subset of
         * the resource data is included in the snapshot and must correspond to an existing and valid template for the
         * specified <code>ResourceType</code>.
         * </p>
         * 
         * @param resourceSnapshotTemplateIdentifier
         *        he name of the template that defines the schema for the snapshot. This template determines which
         *        subset of the resource data is included in the snapshot and must correspond to an existing and valid
         *        template for the specified <code>ResourceType</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier);

        /**
         * <p>
         * Specifies which revision of the snapshot to retrieve. If omitted returns the latest revision.
         * </p>
         * 
         * @param revision
         *        Specifies which revision of the snapshot to retrieve. If omitted returns the latest revision.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private String engagementIdentifier;

        private String resourceType;

        private String resourceIdentifier;

        private String resourceSnapshotTemplateIdentifier;

        private Integer revision;

        private BuilderImpl() {
        }

        private BuilderImpl(GetResourceSnapshotRequest model) {
            super(model);
            catalog(model.catalog);
            engagementIdentifier(model.engagementIdentifier);
            resourceType(model.resourceType);
            resourceIdentifier(model.resourceIdentifier);
            resourceSnapshotTemplateIdentifier(model.resourceSnapshotTemplateIdentifier);
            revision(model.revision);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final String getEngagementIdentifier() {
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
        }

        @Override
        public final Builder engagementIdentifier(String engagementIdentifier) {
            this.engagementIdentifier = engagementIdentifier;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceIdentifier() {
            return resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final String getResourceSnapshotTemplateIdentifier() {
            return resourceSnapshotTemplateIdentifier;
        }

        public final void setResourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
        }

        @Override
        public final Builder resourceSnapshotTemplateIdentifier(String resourceSnapshotTemplateIdentifier) {
            this.resourceSnapshotTemplateIdentifier = resourceSnapshotTemplateIdentifier;
            return this;
        }

        public final Integer getRevision() {
            return revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetResourceSnapshotRequest build() {
            return new GetResourceSnapshotRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
