/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum Industry {
    AEROSPACE("Aerospace"),

    AGRICULTURE("Agriculture"),

    AUTOMOTIVE("Automotive"),

    COMPUTERS_AND_ELECTRONICS("Computers and Electronics"),

    CONSUMER_GOODS("Consumer Goods"),

    EDUCATION("Education"),

    ENERGY_OIL_AND_GAS("Energy - Oil and Gas"),

    ENERGY_POWER_AND_UTILITIES("Energy - Power and Utilities"),

    FINANCIAL_SERVICES("Financial Services"),

    GAMING("Gaming"),

    GOVERNMENT("Government"),

    HEALTHCARE("Healthcare"),

    HOSPITALITY("Hospitality"),

    LIFE_SCIENCES("Life Sciences"),

    MANUFACTURING("Manufacturing"),

    MARKETING_AND_ADVERTISING("Marketing and Advertising"),

    MEDIA_AND_ENTERTAINMENT("Media and Entertainment"),

    MINING("Mining"),

    NON_PROFIT_ORGANIZATION("Non-Profit Organization"),

    PROFESSIONAL_SERVICES("Professional Services"),

    REAL_ESTATE_AND_CONSTRUCTION("Real Estate and Construction"),

    RETAIL("Retail"),

    SOFTWARE_AND_INTERNET("Software and Internet"),

    TELECOMMUNICATIONS("Telecommunications"),

    TRANSPORTATION_AND_LOGISTICS("Transportation and Logistics"),

    TRAVEL("Travel"),

    WHOLESALE_AND_DISTRIBUTION("Wholesale and Distribution"),

    OTHER("Other"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, Industry> VALUE_MAP = EnumUtils.uniqueIndex(Industry.class, Industry::toString);

    private final String value;

    private Industry(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return Industry corresponding to the value
     */
    public static Industry fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link Industry}s
     */
    public static Set<Industry> knownValues() {
        Set<Industry> knownValues = EnumSet.allOf(Industry.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
