/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Invitation structure represents an invitation exchanged between partners and AWS. It includes a message, receiver
 * information, and a payload providing context for the invitation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Invitation implements SdkPojo, Serializable, ToCopyableBuilder<Invitation.Builder, Invitation> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(Invitation::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<Receiver> RECEIVER_FIELD = SdkField.<Receiver> builder(MarshallingType.SDK_POJO)
            .memberName("Receiver").getter(getter(Invitation::receiver)).setter(setter(Builder::receiver))
            .constructor(Receiver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Receiver").build()).build();

    private static final SdkField<Payload> PAYLOAD_FIELD = SdkField.<Payload> builder(MarshallingType.SDK_POJO)
            .memberName("Payload").getter(getter(Invitation::payload)).setter(setter(Builder::payload))
            .constructor(Payload::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Payload").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, RECEIVER_FIELD,
            PAYLOAD_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String message;

    private final Receiver receiver;

    private final Payload payload;

    private Invitation(BuilderImpl builder) {
        this.message = builder.message;
        this.receiver = builder.receiver;
        this.payload = builder.payload;
    }

    /**
     * <p>
     * A message accompanying the invitation.
     * </p>
     * 
     * @return A message accompanying the invitation.
     */
    public final String message() {
        return message;
    }

    /**
     * Returns the value of the Receiver property for this object.
     * 
     * @return The value of the Receiver property for this object.
     */
    public final Receiver receiver() {
        return receiver;
    }

    /**
     * Returns the value of the Payload property for this object.
     * 
     * @return The value of the Payload property for this object.
     */
    public final Payload payload() {
        return payload;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(receiver());
        hashCode = 31 * hashCode + Objects.hashCode(payload());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Invitation)) {
            return false;
        }
        Invitation other = (Invitation) obj;
        return Objects.equals(message(), other.message()) && Objects.equals(receiver(), other.receiver())
                && Objects.equals(payload(), other.payload());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Invitation").add("Message", message() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Receiver", receiver()).add("Payload", payload()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "Receiver":
            return Optional.ofNullable(clazz.cast(receiver()));
        case "Payload":
            return Optional.ofNullable(clazz.cast(payload()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Message", MESSAGE_FIELD);
        map.put("Receiver", RECEIVER_FIELD);
        map.put("Payload", PAYLOAD_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Invitation, T> g) {
        return obj -> g.apply((Invitation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Invitation> {
        /**
         * <p>
         * A message accompanying the invitation.
         * </p>
         * 
         * @param message
         *        A message accompanying the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * Sets the value of the Receiver property for this object.
         *
         * @param receiver
         *        The new value for the Receiver property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder receiver(Receiver receiver);

        /**
         * Sets the value of the Receiver property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Receiver.Builder} avoiding the need to
         * create one manually via {@link Receiver#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Receiver.Builder#build()} is called immediately and its result is
         * passed to {@link #receiver(Receiver)}.
         * 
         * @param receiver
         *        a consumer that will call methods on {@link Receiver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #receiver(Receiver)
         */
        default Builder receiver(Consumer<Receiver.Builder> receiver) {
            return receiver(Receiver.builder().applyMutation(receiver).build());
        }

        /**
         * Sets the value of the Payload property for this object.
         *
         * @param payload
         *        The new value for the Payload property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payload(Payload payload);

        /**
         * Sets the value of the Payload property for this object.
         *
         * This is a convenience method that creates an instance of the {@link Payload.Builder} avoiding the need to
         * create one manually via {@link Payload#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Payload.Builder#build()} is called immediately and its result is
         * passed to {@link #payload(Payload)}.
         * 
         * @param payload
         *        a consumer that will call methods on {@link Payload.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #payload(Payload)
         */
        default Builder payload(Consumer<Payload.Builder> payload) {
            return payload(Payload.builder().applyMutation(payload).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String message;

        private Receiver receiver;

        private Payload payload;

        private BuilderImpl() {
        }

        private BuilderImpl(Invitation model) {
            message(model.message);
            receiver(model.receiver);
            payload(model.payload);
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final Receiver.Builder getReceiver() {
            return receiver != null ? receiver.toBuilder() : null;
        }

        public final void setReceiver(Receiver.BuilderImpl receiver) {
            this.receiver = receiver != null ? receiver.build() : null;
        }

        @Override
        public final Builder receiver(Receiver receiver) {
            this.receiver = receiver;
            return this;
        }

        public final Payload.Builder getPayload() {
            return payload != null ? payload.toBuilder() : null;
        }

        public final void setPayload(Payload.BuilderImpl payload) {
            this.payload = payload != null ? payload.build() : null;
        }

        @Override
        public final Builder payload(Payload payload) {
            this.payload = payload;
            return this;
        }

        @Override
        public Invitation build() {
            return new Invitation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
