/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementInvitationsRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<ListEngagementInvitationsRequest.Builder, ListEngagementInvitationsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListEngagementInvitationsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEngagementInvitationsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementInvitationsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<OpportunityEngagementInvitationSort> SORT_FIELD = SdkField
            .<OpportunityEngagementInvitationSort> builder(MarshallingType.SDK_POJO).memberName("Sort")
            .getter(getter(ListEngagementInvitationsRequest::sort)).setter(setter(Builder::sort))
            .constructor(OpportunityEngagementInvitationSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<List<String>> PAYLOAD_TYPE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PayloadType")
            .getter(getter(ListEngagementInvitationsRequest::payloadTypeAsStrings))
            .setter(setter(Builder::payloadTypeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PayloadType").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARTICIPANT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParticipantType").getter(getter(ListEngagementInvitationsRequest::participantTypeAsString))
            .setter(setter(Builder::participantType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParticipantType").build()).build();

    private static final SdkField<List<String>> STATUS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Status")
            .getter(getter(ListEngagementInvitationsRequest::statusAsStrings))
            .setter(setter(Builder::statusWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EngagementIdentifier")
            .getter(getter(ListEngagementInvitationsRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SENDER_AWS_ACCOUNT_ID_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SenderAwsAccountId")
            .getter(getter(ListEngagementInvitationsRequest::senderAwsAccountId))
            .setter(setter(Builder::senderAwsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SenderAwsAccountId").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SORT_FIELD, PAYLOAD_TYPE_FIELD, PARTICIPANT_TYPE_FIELD, STATUS_FIELD,
            ENGAGEMENT_IDENTIFIER_FIELD, SENDER_AWS_ACCOUNT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final Integer maxResults;

    private final String nextToken;

    private final OpportunityEngagementInvitationSort sort;

    private final List<String> payloadType;

    private final String participantType;

    private final List<String> status;

    private final List<String> engagementIdentifier;

    private final List<String> senderAwsAccountId;

    private ListEngagementInvitationsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.sort = builder.sort;
        this.payloadType = builder.payloadType;
        this.participantType = builder.participantType;
        this.status = builder.status;
        this.engagementIdentifier = builder.engagementIdentifier;
        this.senderAwsAccountId = builder.senderAwsAccountId;
    }

    /**
     * <p>
     * Specifies the catalog from which to list the engagement invitations. Use <code>AWS</code> for production
     * invitations or <code>Sandbox</code> for testing environments.
     * </p>
     * 
     * @return Specifies the catalog from which to list the engagement invitations. Use <code>AWS</code> for production
     *         invitations or <code>Sandbox</code> for testing environments.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * <p>
     * Specifies the maximum number of engagement invitations to return in the response. If more results are available,
     * a pagination token will be provided.
     * </p>
     * 
     * @return Specifies the maximum number of engagement invitations to return in the response. If more results are
     *         available, a pagination token will be provided.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A pagination token used to retrieve additional pages of results when the response to a previous request was
     * truncated. Pass this token to continue listing invitations from where the previous call left off.
     * </p>
     * 
     * @return A pagination token used to retrieve additional pages of results when the response to a previous request
     *         was truncated. Pass this token to continue listing invitations from where the previous call left off.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * Specifies the sorting options for listing engagement invitations. Invitations can be sorted by fields such as
     * <code>InvitationDate</code> or <code>Status</code> to help partners view results in their preferred order.
     * </p>
     * 
     * @return Specifies the sorting options for listing engagement invitations. Invitations can be sorted by fields
     *         such as <code>InvitationDate</code> or <code>Status</code> to help partners view results in their
     *         preferred order.
     */
    public final OpportunityEngagementInvitationSort sort() {
        return sort;
    }

    /**
     * <p>
     * Defines the type of payload associated with the engagement invitations to be listed. The attributes in this
     * payload help decide on acceptance or rejection of the invitation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPayloadType} method.
     * </p>
     * 
     * @return Defines the type of payload associated with the engagement invitations to be listed. The attributes in
     *         this payload help decide on acceptance or rejection of the invitation.
     */
    public final List<EngagementInvitationPayloadType> payloadType() {
        return EngagementInvitationsPayloadTypeCopier.copyStringToEnum(payloadType);
    }

    /**
     * For responses, this returns true if the service returned a value for the PayloadType property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPayloadType() {
        return payloadType != null && !(payloadType instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Defines the type of payload associated with the engagement invitations to be listed. The attributes in this
     * payload help decide on acceptance or rejection of the invitation.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPayloadType} method.
     * </p>
     * 
     * @return Defines the type of payload associated with the engagement invitations to be listed. The attributes in
     *         this payload help decide on acceptance or rejection of the invitation.
     */
    public final List<String> payloadTypeAsStrings() {
        return payloadType;
    }

    /**
     * <p>
     * Specifies the type of participant for which to list engagement invitations. Identifies the role of the
     * participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of participant for which to list engagement invitations. Identifies the role of the
     *         participant.
     * @see ParticipantType
     */
    public final ParticipantType participantType() {
        return ParticipantType.fromValue(participantType);
    }

    /**
     * <p>
     * Specifies the type of participant for which to list engagement invitations. Identifies the role of the
     * participant.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #participantType}
     * will return {@link ParticipantType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #participantTypeAsString}.
     * </p>
     * 
     * @return Specifies the type of participant for which to list engagement invitations. Identifies the role of the
     *         participant.
     * @see ParticipantType
     */
    public final String participantTypeAsString() {
        return participantType;
    }

    /**
     * <p>
     * Status values to filter the invitations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Status values to filter the invitations.
     */
    public final List<InvitationStatus> status() {
        return InvitationStatusListCopier.copyStringToEnum(status);
    }

    /**
     * For responses, this returns true if the service returned a value for the Status property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatus() {
        return status != null && !(status instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Status values to filter the invitations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatus} method.
     * </p>
     * 
     * @return Status values to filter the invitations.
     */
    public final List<String> statusAsStrings() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngagementIdentifier property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngagementIdentifier() {
        return engagementIdentifier != null && !(engagementIdentifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Retrieves a list of engagement invitation summaries based on specified filters. The ListEngagementInvitations
     * operation allows you to view all invitations that you have sent or received. You must specify the ParticipantType
     * to filter invitations where you are either the SENDER or the RECEIVER. Invitations will automatically expire if
     * not accepted within 15 days.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagementIdentifier} method.
     * </p>
     * 
     * @return Retrieves a list of engagement invitation summaries based on specified filters. The
     *         ListEngagementInvitations operation allows you to view all invitations that you have sent or received.
     *         You must specify the ParticipantType to filter invitations where you are either the SENDER or the
     *         RECEIVER. Invitations will automatically expire if not accepted within 15 days.
     */
    public final List<String> engagementIdentifier() {
        return engagementIdentifier;
    }

    /**
     * For responses, this returns true if the service returned a value for the SenderAwsAccountId property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSenderAwsAccountId() {
        return senderAwsAccountId != null && !(senderAwsAccountId instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of sender AWS account IDs to filter the invitations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSenderAwsAccountId} method.
     * </p>
     * 
     * @return List of sender AWS account IDs to filter the invitations.
     */
    public final List<String> senderAwsAccountId() {
        return senderAwsAccountId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(hasPayloadType() ? payloadTypeAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(participantTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasStatus() ? statusAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagementIdentifier() ? engagementIdentifier() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSenderAwsAccountId() ? senderAwsAccountId() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementInvitationsRequest)) {
            return false;
        }
        ListEngagementInvitationsRequest other = (ListEngagementInvitationsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(sort(), other.sort())
                && hasPayloadType() == other.hasPayloadType()
                && Objects.equals(payloadTypeAsStrings(), other.payloadTypeAsStrings())
                && Objects.equals(participantTypeAsString(), other.participantTypeAsString()) && hasStatus() == other.hasStatus()
                && Objects.equals(statusAsStrings(), other.statusAsStrings())
                && hasEngagementIdentifier() == other.hasEngagementIdentifier()
                && Objects.equals(engagementIdentifier(), other.engagementIdentifier())
                && hasSenderAwsAccountId() == other.hasSenderAwsAccountId()
                && Objects.equals(senderAwsAccountId(), other.senderAwsAccountId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementInvitationsRequest").add("Catalog", catalog()).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).add("Sort", sort())
                .add("PayloadType", hasPayloadType() ? payloadTypeAsStrings() : null)
                .add("ParticipantType", participantTypeAsString()).add("Status", hasStatus() ? statusAsStrings() : null)
                .add("EngagementIdentifier", hasEngagementIdentifier() ? engagementIdentifier() : null)
                .add("SenderAwsAccountId", senderAwsAccountId() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "PayloadType":
            return Optional.ofNullable(clazz.cast(payloadTypeAsStrings()));
        case "ParticipantType":
            return Optional.ofNullable(clazz.cast(participantTypeAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsStrings()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        case "SenderAwsAccountId":
            return Optional.ofNullable(clazz.cast(senderAwsAccountId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("PayloadType", PAYLOAD_TYPE_FIELD);
        map.put("ParticipantType", PARTICIPANT_TYPE_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        map.put("SenderAwsAccountId", SENDER_AWS_ACCOUNT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementInvitationsRequest, T> g) {
        return obj -> g.apply((ListEngagementInvitationsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementInvitationsRequest> {
        /**
         * <p>
         * Specifies the catalog from which to list the engagement invitations. Use <code>AWS</code> for production
         * invitations or <code>Sandbox</code> for testing environments.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog from which to list the engagement invitations. Use <code>AWS</code> for
         *        production invitations or <code>Sandbox</code> for testing environments.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * Specifies the maximum number of engagement invitations to return in the response. If more results are
         * available, a pagination token will be provided.
         * </p>
         * 
         * @param maxResults
         *        Specifies the maximum number of engagement invitations to return in the response. If more results are
         *        available, a pagination token will be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A pagination token used to retrieve additional pages of results when the response to a previous request was
         * truncated. Pass this token to continue listing invitations from where the previous call left off.
         * </p>
         * 
         * @param nextToken
         *        A pagination token used to retrieve additional pages of results when the response to a previous
         *        request was truncated. Pass this token to continue listing invitations from where the previous call
         *        left off.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Specifies the sorting options for listing engagement invitations. Invitations can be sorted by fields such as
         * <code>InvitationDate</code> or <code>Status</code> to help partners view results in their preferred order.
         * </p>
         * 
         * @param sort
         *        Specifies the sorting options for listing engagement invitations. Invitations can be sorted by fields
         *        such as <code>InvitationDate</code> or <code>Status</code> to help partners view results in their
         *        preferred order.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(OpportunityEngagementInvitationSort sort);

        /**
         * <p>
         * Specifies the sorting options for listing engagement invitations. Invitations can be sorted by fields such as
         * <code>InvitationDate</code> or <code>Status</code> to help partners view results in their preferred order.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link OpportunityEngagementInvitationSort.Builder} avoiding the need to create one manually via
         * {@link OpportunityEngagementInvitationSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OpportunityEngagementInvitationSort.Builder#build()} is called
         * immediately and its result is passed to {@link #sort(OpportunityEngagementInvitationSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link OpportunityEngagementInvitationSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(OpportunityEngagementInvitationSort)
         */
        default Builder sort(Consumer<OpportunityEngagementInvitationSort.Builder> sort) {
            return sort(OpportunityEngagementInvitationSort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * Defines the type of payload associated with the engagement invitations to be listed. The attributes in this
         * payload help decide on acceptance or rejection of the invitation.
         * </p>
         * 
         * @param payloadType
         *        Defines the type of payload associated with the engagement invitations to be listed. The attributes in
         *        this payload help decide on acceptance or rejection of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadTypeWithStrings(Collection<String> payloadType);

        /**
         * <p>
         * Defines the type of payload associated with the engagement invitations to be listed. The attributes in this
         * payload help decide on acceptance or rejection of the invitation.
         * </p>
         * 
         * @param payloadType
         *        Defines the type of payload associated with the engagement invitations to be listed. The attributes in
         *        this payload help decide on acceptance or rejection of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadTypeWithStrings(String... payloadType);

        /**
         * <p>
         * Defines the type of payload associated with the engagement invitations to be listed. The attributes in this
         * payload help decide on acceptance or rejection of the invitation.
         * </p>
         * 
         * @param payloadType
         *        Defines the type of payload associated with the engagement invitations to be listed. The attributes in
         *        this payload help decide on acceptance or rejection of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadType(Collection<EngagementInvitationPayloadType> payloadType);

        /**
         * <p>
         * Defines the type of payload associated with the engagement invitations to be listed. The attributes in this
         * payload help decide on acceptance or rejection of the invitation.
         * </p>
         * 
         * @param payloadType
         *        Defines the type of payload associated with the engagement invitations to be listed. The attributes in
         *        this payload help decide on acceptance or rejection of the invitation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder payloadType(EngagementInvitationPayloadType... payloadType);

        /**
         * <p>
         * Specifies the type of participant for which to list engagement invitations. Identifies the role of the
         * participant.
         * </p>
         * 
         * @param participantType
         *        Specifies the type of participant for which to list engagement invitations. Identifies the role of the
         *        participant.
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(String participantType);

        /**
         * <p>
         * Specifies the type of participant for which to list engagement invitations. Identifies the role of the
         * participant.
         * </p>
         * 
         * @param participantType
         *        Specifies the type of participant for which to list engagement invitations. Identifies the role of the
         *        participant.
         * @see ParticipantType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParticipantType
         */
        Builder participantType(ParticipantType participantType);

        /**
         * <p>
         * Status values to filter the invitations.
         * </p>
         * 
         * @param status
         *        Status values to filter the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(Collection<String> status);

        /**
         * <p>
         * Status values to filter the invitations.
         * </p>
         * 
         * @param status
         *        Status values to filter the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusWithStrings(String... status);

        /**
         * <p>
         * Status values to filter the invitations.
         * </p>
         * 
         * @param status
         *        Status values to filter the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Collection<InvitationStatus> status);

        /**
         * <p>
         * Status values to filter the invitations.
         * </p>
         * 
         * @param status
         *        Status values to filter the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(InvitationStatus... status);

        /**
         * <p>
         * Retrieves a list of engagement invitation summaries based on specified filters. The ListEngagementInvitations
         * operation allows you to view all invitations that you have sent or received. You must specify the
         * ParticipantType to filter invitations where you are either the SENDER or the RECEIVER. Invitations will
         * automatically expire if not accepted within 15 days.
         * </p>
         * 
         * @param engagementIdentifier
         *        Retrieves a list of engagement invitation summaries based on specified filters. The
         *        ListEngagementInvitations operation allows you to view all invitations that you have sent or received.
         *        You must specify the ParticipantType to filter invitations where you are either the SENDER or the
         *        RECEIVER. Invitations will automatically expire if not accepted within 15 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(Collection<String> engagementIdentifier);

        /**
         * <p>
         * Retrieves a list of engagement invitation summaries based on specified filters. The ListEngagementInvitations
         * operation allows you to view all invitations that you have sent or received. You must specify the
         * ParticipantType to filter invitations where you are either the SENDER or the RECEIVER. Invitations will
         * automatically expire if not accepted within 15 days.
         * </p>
         * 
         * @param engagementIdentifier
         *        Retrieves a list of engagement invitation summaries based on specified filters. The
         *        ListEngagementInvitations operation allows you to view all invitations that you have sent or received.
         *        You must specify the ParticipantType to filter invitations where you are either the SENDER or the
         *        RECEIVER. Invitations will automatically expire if not accepted within 15 days.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String... engagementIdentifier);

        /**
         * <p>
         * List of sender AWS account IDs to filter the invitations.
         * </p>
         * 
         * @param senderAwsAccountId
         *        List of sender AWS account IDs to filter the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderAwsAccountId(Collection<String> senderAwsAccountId);

        /**
         * <p>
         * List of sender AWS account IDs to filter the invitations.
         * </p>
         * 
         * @param senderAwsAccountId
         *        List of sender AWS account IDs to filter the invitations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder senderAwsAccountId(String... senderAwsAccountId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private Integer maxResults;

        private String nextToken;

        private OpportunityEngagementInvitationSort sort;

        private List<String> payloadType = DefaultSdkAutoConstructList.getInstance();

        private String participantType;

        private List<String> status = DefaultSdkAutoConstructList.getInstance();

        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();

        private List<String> senderAwsAccountId = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementInvitationsRequest model) {
            super(model);
            catalog(model.catalog);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            sort(model.sort);
            payloadTypeWithStrings(model.payloadType);
            participantType(model.participantType);
            statusWithStrings(model.status);
            engagementIdentifier(model.engagementIdentifier);
            senderAwsAccountId(model.senderAwsAccountId);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final OpportunityEngagementInvitationSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(OpportunityEngagementInvitationSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(OpportunityEngagementInvitationSort sort) {
            this.sort = sort;
            return this;
        }

        public final Collection<String> getPayloadType() {
            if (payloadType instanceof SdkAutoConstructList) {
                return null;
            }
            return payloadType;
        }

        public final void setPayloadType(Collection<String> payloadType) {
            this.payloadType = EngagementInvitationsPayloadTypeCopier.copy(payloadType);
        }

        @Override
        public final Builder payloadTypeWithStrings(Collection<String> payloadType) {
            this.payloadType = EngagementInvitationsPayloadTypeCopier.copy(payloadType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloadTypeWithStrings(String... payloadType) {
            payloadTypeWithStrings(Arrays.asList(payloadType));
            return this;
        }

        @Override
        public final Builder payloadType(Collection<EngagementInvitationPayloadType> payloadType) {
            this.payloadType = EngagementInvitationsPayloadTypeCopier.copyEnumToString(payloadType);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder payloadType(EngagementInvitationPayloadType... payloadType) {
            payloadType(Arrays.asList(payloadType));
            return this;
        }

        public final String getParticipantType() {
            return participantType;
        }

        public final void setParticipantType(String participantType) {
            this.participantType = participantType;
        }

        @Override
        public final Builder participantType(String participantType) {
            this.participantType = participantType;
            return this;
        }

        @Override
        public final Builder participantType(ParticipantType participantType) {
            this.participantType(participantType == null ? null : participantType.toString());
            return this;
        }

        public final Collection<String> getStatus() {
            if (status instanceof SdkAutoConstructList) {
                return null;
            }
            return status;
        }

        public final void setStatus(Collection<String> status) {
            this.status = InvitationStatusListCopier.copy(status);
        }

        @Override
        public final Builder statusWithStrings(Collection<String> status) {
            this.status = InvitationStatusListCopier.copy(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statusWithStrings(String... status) {
            statusWithStrings(Arrays.asList(status));
            return this;
        }

        @Override
        public final Builder status(Collection<InvitationStatus> status) {
            this.status = InvitationStatusListCopier.copyEnumToString(status);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder status(InvitationStatus... status) {
            status(Arrays.asList(status));
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String... engagementIdentifier) {
            engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        public final Collection<String> getSenderAwsAccountId() {
            if (senderAwsAccountId instanceof SdkAutoConstructList) {
                return null;
            }
            return senderAwsAccountId;
        }

        public final void setSenderAwsAccountId(Collection<String> senderAwsAccountId) {
            this.senderAwsAccountId = AwsAccountIdOrAliasListCopier.copy(senderAwsAccountId);
        }

        @Override
        public final Builder senderAwsAccountId(Collection<String> senderAwsAccountId) {
            this.senderAwsAccountId = AwsAccountIdOrAliasListCopier.copy(senderAwsAccountId);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder senderAwsAccountId(String... senderAwsAccountId) {
            senderAwsAccountId(Arrays.asList(senderAwsAccountId));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementInvitationsRequest build() {
            return new ListEngagementInvitationsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
