/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementResourceAssociationsResponse extends PartnerCentralSellingResponse implements
        ToCopyableBuilder<ListEngagementResourceAssociationsResponse.Builder, ListEngagementResourceAssociationsResponse> {
    private static final SdkField<List<EngagementResourceAssociationSummary>> ENGAGEMENT_RESOURCE_ASSOCIATION_SUMMARIES_FIELD = SdkField
            .<List<EngagementResourceAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("EngagementResourceAssociationSummaries")
            .getter(getter(ListEngagementResourceAssociationsResponse::engagementResourceAssociationSummaries))
            .setter(setter(Builder::engagementResourceAssociationSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("EngagementResourceAssociationSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EngagementResourceAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(EngagementResourceAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementResourceAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ENGAGEMENT_RESOURCE_ASSOCIATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries;

    private final String nextToken;

    private ListEngagementResourceAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.engagementResourceAssociationSummaries = builder.engagementResourceAssociationSummaries;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngagementResourceAssociationSummaries
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEngagementResourceAssociationSummaries() {
        return engagementResourceAssociationSummaries != null
                && !(engagementResourceAssociationSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of engagement-resource association summaries.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagementResourceAssociationSummaries}
     * method.
     * </p>
     * 
     * @return A list of engagement-resource association summaries.
     */
    public final List<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries() {
        return engagementResourceAssociationSummaries;
    }

    /**
     * <p>
     * A token to retrieve the next set of results. Use this token in a subsequent request to retrieve additional
     * results if the response was truncated.
     * </p>
     * 
     * @return A token to retrieve the next set of results. Use this token in a subsequent request to retrieve
     *         additional results if the response was truncated.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEngagementResourceAssociationSummaries() ? engagementResourceAssociationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementResourceAssociationsResponse)) {
            return false;
        }
        ListEngagementResourceAssociationsResponse other = (ListEngagementResourceAssociationsResponse) obj;
        return hasEngagementResourceAssociationSummaries() == other.hasEngagementResourceAssociationSummaries()
                && Objects.equals(engagementResourceAssociationSummaries(), other.engagementResourceAssociationSummaries())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("ListEngagementResourceAssociationsResponse")
                .add("EngagementResourceAssociationSummaries",
                        hasEngagementResourceAssociationSummaries() ? engagementResourceAssociationSummaries() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EngagementResourceAssociationSummaries":
            return Optional.ofNullable(clazz.cast(engagementResourceAssociationSummaries()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EngagementResourceAssociationSummaries", ENGAGEMENT_RESOURCE_ASSOCIATION_SUMMARIES_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementResourceAssociationsResponse, T> g) {
        return obj -> g.apply((ListEngagementResourceAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementResourceAssociationsResponse> {
        /**
         * <p>
         * A list of engagement-resource association summaries.
         * </p>
         * 
         * @param engagementResourceAssociationSummaries
         *        A list of engagement-resource association summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementResourceAssociationSummaries(
                Collection<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries);

        /**
         * <p>
         * A list of engagement-resource association summaries.
         * </p>
         * 
         * @param engagementResourceAssociationSummaries
         *        A list of engagement-resource association summaries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementResourceAssociationSummaries(
                EngagementResourceAssociationSummary... engagementResourceAssociationSummaries);

        /**
         * <p>
         * A list of engagement-resource association summaries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementResourceAssociationSummary.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementResourceAssociationSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementResourceAssociationSummary.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #engagementResourceAssociationSummaries(List<EngagementResourceAssociationSummary>)}.
         * 
         * @param engagementResourceAssociationSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.partnercentralselling.model.EngagementResourceAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #engagementResourceAssociationSummaries(java.util.Collection<EngagementResourceAssociationSummary>)
         */
        Builder engagementResourceAssociationSummaries(
                Consumer<EngagementResourceAssociationSummary.Builder>... engagementResourceAssociationSummaries);

        /**
         * <p>
         * A token to retrieve the next set of results. Use this token in a subsequent request to retrieve additional
         * results if the response was truncated.
         * </p>
         * 
         * @param nextToken
         *        A token to retrieve the next set of results. Use this token in a subsequent request to retrieve
         *        additional results if the response was truncated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends PartnerCentralSellingResponse.BuilderImpl implements Builder {
        private List<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries = DefaultSdkAutoConstructList
                .getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementResourceAssociationsResponse model) {
            super(model);
            engagementResourceAssociationSummaries(model.engagementResourceAssociationSummaries);
            nextToken(model.nextToken);
        }

        public final List<EngagementResourceAssociationSummary.Builder> getEngagementResourceAssociationSummaries() {
            List<EngagementResourceAssociationSummary.Builder> result = EngagementResourceAssociationSummaryListCopier
                    .copyToBuilder(this.engagementResourceAssociationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEngagementResourceAssociationSummaries(
                Collection<EngagementResourceAssociationSummary.BuilderImpl> engagementResourceAssociationSummaries) {
            this.engagementResourceAssociationSummaries = EngagementResourceAssociationSummaryListCopier
                    .copyFromBuilder(engagementResourceAssociationSummaries);
        }

        @Override
        public final Builder engagementResourceAssociationSummaries(
                Collection<EngagementResourceAssociationSummary> engagementResourceAssociationSummaries) {
            this.engagementResourceAssociationSummaries = EngagementResourceAssociationSummaryListCopier
                    .copy(engagementResourceAssociationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementResourceAssociationSummaries(
                EngagementResourceAssociationSummary... engagementResourceAssociationSummaries) {
            engagementResourceAssociationSummaries(Arrays.asList(engagementResourceAssociationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementResourceAssociationSummaries(
                Consumer<EngagementResourceAssociationSummary.Builder>... engagementResourceAssociationSummaries) {
            engagementResourceAssociationSummaries(Stream.of(engagementResourceAssociationSummaries)
                    .map(c -> EngagementResourceAssociationSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEngagementResourceAssociationsResponse build() {
            return new ListEngagementResourceAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
