/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListEngagementsRequest extends PartnerCentralSellingRequest implements
        ToCopyableBuilder<ListEngagementsRequest.Builder, ListEngagementsRequest> {
    private static final SdkField<String> CATALOG_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Catalog")
            .getter(getter(ListEngagementsRequest::catalog)).setter(setter(Builder::catalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Catalog").build()).build();

    private static final SdkField<List<String>> CREATED_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CreatedBy")
            .getter(getter(ListEngagementsRequest::createdBy))
            .setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDE_CREATED_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ExcludeCreatedBy")
            .getter(getter(ListEngagementsRequest::excludeCreatedBy))
            .setter(setter(Builder::excludeCreatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExcludeCreatedBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<EngagementSort> SORT_FIELD = SdkField.<EngagementSort> builder(MarshallingType.SDK_POJO)
            .memberName("Sort").getter(getter(ListEngagementsRequest::sort)).setter(setter(Builder::sort))
            .constructor(EngagementSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Sort").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListEngagementsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListEngagementsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<List<String>> ENGAGEMENT_IDENTIFIER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("EngagementIdentifier")
            .getter(getter(ListEngagementsRequest::engagementIdentifier))
            .setter(setter(Builder::engagementIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngagementIdentifier").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_FIELD,
            CREATED_BY_FIELD, EXCLUDE_CREATED_BY_FIELD, SORT_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD,
            ENGAGEMENT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String catalog;

    private final List<String> createdBy;

    private final List<String> excludeCreatedBy;

    private final EngagementSort sort;

    private final Integer maxResults;

    private final String nextToken;

    private final List<String> engagementIdentifier;

    private ListEngagementsRequest(BuilderImpl builder) {
        super(builder);
        this.catalog = builder.catalog;
        this.createdBy = builder.createdBy;
        this.excludeCreatedBy = builder.excludeCreatedBy;
        this.sort = builder.sort;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.engagementIdentifier = builder.engagementIdentifier;
    }

    /**
     * <p>
     * Specifies the catalog related to the request.
     * </p>
     * 
     * @return Specifies the catalog related to the request.
     */
    public final String catalog() {
        return catalog;
    }

    /**
     * For responses, this returns true if the service returned a value for the CreatedBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCreatedBy() {
        return createdBy != null && !(createdBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of AWS account IDs. When specified, the response includes engagements created by these accounts. This
     * filter is useful for finding engagements created by specific team members.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCreatedBy} method.
     * </p>
     * 
     * @return A list of AWS account IDs. When specified, the response includes engagements created by these accounts.
     *         This filter is useful for finding engagements created by specific team members.
     */
    public final List<String> createdBy() {
        return createdBy;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludeCreatedBy property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasExcludeCreatedBy() {
        return excludeCreatedBy != null && !(excludeCreatedBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings representing AWS Account IDs. Use this to exclude engagements created by specific users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludeCreatedBy} method.
     * </p>
     * 
     * @return An array of strings representing AWS Account IDs. Use this to exclude engagements created by specific
     *         users.
     */
    public final List<String> excludeCreatedBy() {
        return excludeCreatedBy;
    }

    /**
     * Returns the value of the Sort property for this object.
     * 
     * @return The value of the Sort property for this object.
     */
    public final EngagementSort sort() {
        return sort;
    }

    /**
     * <p>
     * The maximum number of results to return in a single call.
     * </p>
     * 
     * @return The maximum number of results to return in a single call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The token for the next set of results. This value is returned from a previous call.
     * </p>
     * 
     * @return The token for the next set of results. This value is returned from a previous call.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the EngagementIdentifier property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasEngagementIdentifier() {
        return engagementIdentifier != null && !(engagementIdentifier instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of strings representing engagement identifiers to retrieve.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEngagementIdentifier} method.
     * </p>
     * 
     * @return An array of strings representing engagement identifiers to retrieve.
     */
    public final List<String> engagementIdentifier() {
        return engagementIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(catalog());
        hashCode = 31 * hashCode + Objects.hashCode(hasCreatedBy() ? createdBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludeCreatedBy() ? excludeCreatedBy() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasEngagementIdentifier() ? engagementIdentifier() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEngagementsRequest)) {
            return false;
        }
        ListEngagementsRequest other = (ListEngagementsRequest) obj;
        return Objects.equals(catalog(), other.catalog()) && hasCreatedBy() == other.hasCreatedBy()
                && Objects.equals(createdBy(), other.createdBy()) && hasExcludeCreatedBy() == other.hasExcludeCreatedBy()
                && Objects.equals(excludeCreatedBy(), other.excludeCreatedBy()) && Objects.equals(sort(), other.sort())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && hasEngagementIdentifier() == other.hasEngagementIdentifier()
                && Objects.equals(engagementIdentifier(), other.engagementIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListEngagementsRequest").add("Catalog", catalog())
                .add("CreatedBy", createdBy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("ExcludeCreatedBy", excludeCreatedBy() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Sort", sort()).add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("EngagementIdentifier", hasEngagementIdentifier() ? engagementIdentifier() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Catalog":
            return Optional.ofNullable(clazz.cast(catalog()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "ExcludeCreatedBy":
            return Optional.ofNullable(clazz.cast(excludeCreatedBy()));
        case "Sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "EngagementIdentifier":
            return Optional.ofNullable(clazz.cast(engagementIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Catalog", CATALOG_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("ExcludeCreatedBy", EXCLUDE_CREATED_BY_FIELD);
        map.put("Sort", SORT_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        map.put("EngagementIdentifier", ENGAGEMENT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEngagementsRequest, T> g) {
        return obj -> g.apply((ListEngagementsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends PartnerCentralSellingRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListEngagementsRequest> {
        /**
         * <p>
         * Specifies the catalog related to the request.
         * </p>
         * 
         * @param catalog
         *        Specifies the catalog related to the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder catalog(String catalog);

        /**
         * <p>
         * A list of AWS account IDs. When specified, the response includes engagements created by these accounts. This
         * filter is useful for finding engagements created by specific team members.
         * </p>
         * 
         * @param createdBy
         *        A list of AWS account IDs. When specified, the response includes engagements created by these
         *        accounts. This filter is useful for finding engagements created by specific team members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(Collection<String> createdBy);

        /**
         * <p>
         * A list of AWS account IDs. When specified, the response includes engagements created by these accounts. This
         * filter is useful for finding engagements created by specific team members.
         * </p>
         * 
         * @param createdBy
         *        A list of AWS account IDs. When specified, the response includes engagements created by these
         *        accounts. This filter is useful for finding engagements created by specific team members.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String... createdBy);

        /**
         * <p>
         * An array of strings representing AWS Account IDs. Use this to exclude engagements created by specific users.
         * </p>
         * 
         * @param excludeCreatedBy
         *        An array of strings representing AWS Account IDs. Use this to exclude engagements created by specific
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCreatedBy(Collection<String> excludeCreatedBy);

        /**
         * <p>
         * An array of strings representing AWS Account IDs. Use this to exclude engagements created by specific users.
         * </p>
         * 
         * @param excludeCreatedBy
         *        An array of strings representing AWS Account IDs. Use this to exclude engagements created by specific
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludeCreatedBy(String... excludeCreatedBy);

        /**
         * Sets the value of the Sort property for this object.
         *
         * @param sort
         *        The new value for the Sort property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(EngagementSort sort);

        /**
         * Sets the value of the Sort property for this object.
         *
         * This is a convenience method that creates an instance of the {@link EngagementSort.Builder} avoiding the need
         * to create one manually via {@link EngagementSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EngagementSort.Builder#build()} is called immediately and its
         * result is passed to {@link #sort(EngagementSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link EngagementSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(EngagementSort)
         */
        default Builder sort(Consumer<EngagementSort.Builder> sort) {
            return sort(EngagementSort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The maximum number of results to return in a single call.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of results to return in a single call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The token for the next set of results. This value is returned from a previous call.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results. This value is returned from a previous call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * An array of strings representing engagement identifiers to retrieve.
         * </p>
         * 
         * @param engagementIdentifier
         *        An array of strings representing engagement identifiers to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(Collection<String> engagementIdentifier);

        /**
         * <p>
         * An array of strings representing engagement identifiers to retrieve.
         * </p>
         * 
         * @param engagementIdentifier
         *        An array of strings representing engagement identifiers to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engagementIdentifier(String... engagementIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends PartnerCentralSellingRequest.BuilderImpl implements Builder {
        private String catalog;

        private List<String> createdBy = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludeCreatedBy = DefaultSdkAutoConstructList.getInstance();

        private EngagementSort sort;

        private Integer maxResults;

        private String nextToken;

        private List<String> engagementIdentifier = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEngagementsRequest model) {
            super(model);
            catalog(model.catalog);
            createdBy(model.createdBy);
            excludeCreatedBy(model.excludeCreatedBy);
            sort(model.sort);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            engagementIdentifier(model.engagementIdentifier);
        }

        public final String getCatalog() {
            return catalog;
        }

        public final void setCatalog(String catalog) {
            this.catalog = catalog;
        }

        @Override
        public final Builder catalog(String catalog) {
            this.catalog = catalog;
            return this;
        }

        public final Collection<String> getCreatedBy() {
            if (createdBy instanceof SdkAutoConstructList) {
                return null;
            }
            return createdBy;
        }

        public final void setCreatedBy(Collection<String> createdBy) {
            this.createdBy = AwsAccountListCopier.copy(createdBy);
        }

        @Override
        public final Builder createdBy(Collection<String> createdBy) {
            this.createdBy = AwsAccountListCopier.copy(createdBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdBy(String... createdBy) {
            createdBy(Arrays.asList(createdBy));
            return this;
        }

        public final Collection<String> getExcludeCreatedBy() {
            if (excludeCreatedBy instanceof SdkAutoConstructList) {
                return null;
            }
            return excludeCreatedBy;
        }

        public final void setExcludeCreatedBy(Collection<String> excludeCreatedBy) {
            this.excludeCreatedBy = AwsAccountListCopier.copy(excludeCreatedBy);
        }

        @Override
        public final Builder excludeCreatedBy(Collection<String> excludeCreatedBy) {
            this.excludeCreatedBy = AwsAccountListCopier.copy(excludeCreatedBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludeCreatedBy(String... excludeCreatedBy) {
            excludeCreatedBy(Arrays.asList(excludeCreatedBy));
            return this;
        }

        public final EngagementSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(EngagementSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(EngagementSort sort) {
            this.sort = sort;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Collection<String> getEngagementIdentifier() {
            if (engagementIdentifier instanceof SdkAutoConstructList) {
                return null;
            }
            return engagementIdentifier;
        }

        public final void setEngagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
        }

        @Override
        public final Builder engagementIdentifier(Collection<String> engagementIdentifier) {
            this.engagementIdentifier = EngagementIdentifiersCopier.copy(engagementIdentifier);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder engagementIdentifier(String... engagementIdentifier) {
            engagementIdentifier(Arrays.asList(engagementIdentifier));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListEngagementsRequest build() {
            return new ListEngagementsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
