/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains marketing details for the <code>Opportunity</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Marketing implements SdkPojo, Serializable, ToCopyableBuilder<Marketing.Builder, Marketing> {
    private static final SdkField<String> CAMPAIGN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CampaignName").getter(getter(Marketing::campaignName)).setter(setter(Builder::campaignName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CampaignName").build()).build();

    private static final SdkField<String> SOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Source")
            .getter(getter(Marketing::sourceAsString)).setter(setter(Builder::source))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Source").build()).build();

    private static final SdkField<List<String>> USE_CASES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UseCases")
            .getter(getter(Marketing::useCases))
            .setter(setter(Builder::useCases))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseCases").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> CHANNELS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Channels")
            .getter(getter(Marketing::channelsAsStrings))
            .setter(setter(Builder::channelsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Channels").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> AWS_FUNDING_USED_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsFundingUsed").getter(getter(Marketing::awsFundingUsedAsString))
            .setter(setter(Builder::awsFundingUsed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsFundingUsed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAMPAIGN_NAME_FIELD,
            SOURCE_FIELD, USE_CASES_FIELD, CHANNELS_FIELD, AWS_FUNDING_USED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String campaignName;

    private final String source;

    private final List<String> useCases;

    private final List<String> channels;

    private final String awsFundingUsed;

    private Marketing(BuilderImpl builder) {
        this.campaignName = builder.campaignName;
        this.source = builder.source;
        this.useCases = builder.useCases;
        this.channels = builder.channels;
        this.awsFundingUsed = builder.awsFundingUsed;
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code> marketing campaign code. The Amazon Web Services campaign code is a
     * reference to specific marketing initiatives, promotions, or activities. This field captures the identifier used
     * to track and categorize the <code>Opportunity</code> within marketing campaigns. If you don't have a campaign
     * code, contact your Amazon Web Services point of contact to obtain one.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code> marketing campaign code. The Amazon Web Services campaign code is
     *         a reference to specific marketing initiatives, promotions, or activities. This field captures the
     *         identifier used to track and categorize the <code>Opportunity</code> within marketing campaigns. If you
     *         don't have a campaign code, contact your Amazon Web Services point of contact to obtain one.
     */
    public final String campaignName() {
        return campaignName;
    }

    /**
     * <p>
     * Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity. Use the
     * value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an Amazon Web Services
     * marketing activity. This field helps Amazon Web Services track the return on marketing investments and enables
     * better distribution of marketing budgets among partners.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link MarketingSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity. Use
     *         the value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an Amazon
     *         Web Services marketing activity. This field helps Amazon Web Services track the return on marketing
     *         investments and enables better distribution of marketing budgets among partners.
     * @see MarketingSource
     */
    public final MarketingSource source() {
        return MarketingSource.fromValue(source);
    }

    /**
     * <p>
     * Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity. Use the
     * value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an Amazon Web Services
     * marketing activity. This field helps Amazon Web Services track the return on marketing investments and enables
     * better distribution of marketing budgets among partners.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #source} will
     * return {@link MarketingSource#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourceAsString}.
     * </p>
     * 
     * @return Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity. Use
     *         the value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an Amazon
     *         Web Services marketing activity. This field helps Amazon Web Services track the return on marketing
     *         investments and enables better distribution of marketing budgets among partners.
     * @see MarketingSource
     */
    public final String sourceAsString() {
        return source;
    }

    /**
     * For responses, this returns true if the service returned a value for the UseCases property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUseCases() {
        return useCases != null && !(useCases instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the marketing activity use case or purpose that led to the <code>Opportunity</code>'s creation or
     * contact. This field captures the context or marketing activity's execution's intention and the direct correlation
     * to the generated opportunity or contact. Must be empty when <code>Marketing.AWSFundingUsed = No</code>.
     * </p>
     * <p>
     * Valid values:
     * <code>AI/ML | Analytics | Application Integration | Blockchain | Business Applications | Cloud Financial Management | Compute | Containers | Customer Engagement | Databases | Developer Tools | End User Computing | Front End Web &amp; Mobile | Game Tech | IoT | Management &amp; Governance | Media Services | Migration &amp; Transfer | Networking &amp; Content Delivery | Quantum Technologies | Robotics | Satellite | Security | Serverless | Storage | VR &amp; AR</code>
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUseCases} method.
     * </p>
     * 
     * @return Specifies the marketing activity use case or purpose that led to the <code>Opportunity</code>'s creation
     *         or contact. This field captures the context or marketing activity's execution's intention and the direct
     *         correlation to the generated opportunity or contact. Must be empty when
     *         <code>Marketing.AWSFundingUsed = No</code>.</p>
     *         <p>
     *         Valid values:
     *         <code>AI/ML | Analytics | Application Integration | Blockchain | Business Applications | Cloud Financial Management | Compute | Containers | Customer Engagement | Databases | Developer Tools | End User Computing | Front End Web &amp; Mobile | Game Tech | IoT | Management &amp; Governance | Media Services | Migration &amp; Transfer | Networking &amp; Content Delivery | Quantum Technologies | Robotics | Satellite | Security | Serverless | Storage | VR &amp; AR</code>
     */
    public final List<String> useCases() {
        return useCases;
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was contacted
     * through. This field provides information about the specific marketing channel that contributed to the generation
     * of the lead or contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
     *         contacted through. This field provides information about the specific marketing channel that contributed
     *         to the generation of the lead or contact.
     */
    public final List<Channel> channels() {
        return ChannelsCopier.copyStringToEnum(channels);
    }

    /**
     * For responses, this returns true if the service returned a value for the Channels property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasChannels() {
        return channels != null && !(channels instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was contacted
     * through. This field provides information about the specific marketing channel that contributed to the generation
     * of the lead or contact.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChannels} method.
     * </p>
     * 
     * @return Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
     *         contacted through. This field provides information about the specific marketing channel that contributed
     *         to the generation of the lead or contact.
     */
    public final List<String> channelsAsStrings() {
        return channels;
    }

    /**
     * <p>
     * Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsFundingUsed}
     * will return {@link AwsFundingUsed#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsFundingUsedAsString}.
     * </p>
     * 
     * @return Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
     * @see AwsFundingUsed
     */
    public final AwsFundingUsed awsFundingUsed() {
        return AwsFundingUsed.fromValue(awsFundingUsed);
    }

    /**
     * <p>
     * Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #awsFundingUsed}
     * will return {@link AwsFundingUsed#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #awsFundingUsedAsString}.
     * </p>
     * 
     * @return Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
     * @see AwsFundingUsed
     */
    public final String awsFundingUsedAsString() {
        return awsFundingUsed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(campaignName());
        hashCode = 31 * hashCode + Objects.hashCode(sourceAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasUseCases() ? useCases() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasChannels() ? channelsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(awsFundingUsedAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Marketing)) {
            return false;
        }
        Marketing other = (Marketing) obj;
        return Objects.equals(campaignName(), other.campaignName()) && Objects.equals(sourceAsString(), other.sourceAsString())
                && hasUseCases() == other.hasUseCases() && Objects.equals(useCases(), other.useCases())
                && hasChannels() == other.hasChannels() && Objects.equals(channelsAsStrings(), other.channelsAsStrings())
                && Objects.equals(awsFundingUsedAsString(), other.awsFundingUsedAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Marketing").add("CampaignName", campaignName()).add("Source", sourceAsString())
                .add("UseCases", hasUseCases() ? useCases() : null).add("Channels", hasChannels() ? channelsAsStrings() : null)
                .add("AwsFundingUsed", awsFundingUsedAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CampaignName":
            return Optional.ofNullable(clazz.cast(campaignName()));
        case "Source":
            return Optional.ofNullable(clazz.cast(sourceAsString()));
        case "UseCases":
            return Optional.ofNullable(clazz.cast(useCases()));
        case "Channels":
            return Optional.ofNullable(clazz.cast(channelsAsStrings()));
        case "AwsFundingUsed":
            return Optional.ofNullable(clazz.cast(awsFundingUsedAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CampaignName", CAMPAIGN_NAME_FIELD);
        map.put("Source", SOURCE_FIELD);
        map.put("UseCases", USE_CASES_FIELD);
        map.put("Channels", CHANNELS_FIELD);
        map.put("AwsFundingUsed", AWS_FUNDING_USED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Marketing, T> g) {
        return obj -> g.apply((Marketing) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Marketing> {
        /**
         * <p>
         * Specifies the <code>Opportunity</code> marketing campaign code. The Amazon Web Services campaign code is a
         * reference to specific marketing initiatives, promotions, or activities. This field captures the identifier
         * used to track and categorize the <code>Opportunity</code> within marketing campaigns. If you don't have a
         * campaign code, contact your Amazon Web Services point of contact to obtain one.
         * </p>
         * 
         * @param campaignName
         *        Specifies the <code>Opportunity</code> marketing campaign code. The Amazon Web Services campaign code
         *        is a reference to specific marketing initiatives, promotions, or activities. This field captures the
         *        identifier used to track and categorize the <code>Opportunity</code> within marketing campaigns. If
         *        you don't have a campaign code, contact your Amazon Web Services point of contact to obtain one.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder campaignName(String campaignName);

        /**
         * <p>
         * Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity. Use the
         * value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an Amazon Web
         * Services marketing activity. This field helps Amazon Web Services track the return on marketing investments
         * and enables better distribution of marketing budgets among partners.
         * </p>
         * 
         * @param source
         *        Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity.
         *        Use the value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an
         *        Amazon Web Services marketing activity. This field helps Amazon Web Services track the return on
         *        marketing investments and enables better distribution of marketing budgets among partners.
         * @see MarketingSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketingSource
         */
        Builder source(String source);

        /**
         * <p>
         * Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity. Use the
         * value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an Amazon Web
         * Services marketing activity. This field helps Amazon Web Services track the return on marketing investments
         * and enables better distribution of marketing budgets among partners.
         * </p>
         * 
         * @param source
         *        Indicates if the <code>Opportunity</code> was sourced from an Amazon Web Services marketing activity.
         *        Use the value <code>Marketing Activity</code>. Use <code>None</code> if it's not associated with an
         *        Amazon Web Services marketing activity. This field helps Amazon Web Services track the return on
         *        marketing investments and enables better distribution of marketing budgets among partners.
         * @see MarketingSource
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MarketingSource
         */
        Builder source(MarketingSource source);

        /**
         * <p>
         * Specifies the marketing activity use case or purpose that led to the <code>Opportunity</code>'s creation or
         * contact. This field captures the context or marketing activity's execution's intention and the direct
         * correlation to the generated opportunity or contact. Must be empty when
         * <code>Marketing.AWSFundingUsed = No</code>.
         * </p>
         * <p>
         * Valid values:
         * <code>AI/ML | Analytics | Application Integration | Blockchain | Business Applications | Cloud Financial Management | Compute | Containers | Customer Engagement | Databases | Developer Tools | End User Computing | Front End Web &amp; Mobile | Game Tech | IoT | Management &amp; Governance | Media Services | Migration &amp; Transfer | Networking &amp; Content Delivery | Quantum Technologies | Robotics | Satellite | Security | Serverless | Storage | VR &amp; AR</code>
         * </p>
         * 
         * @param useCases
         *        Specifies the marketing activity use case or purpose that led to the <code>Opportunity</code>'s
         *        creation or contact. This field captures the context or marketing activity's execution's intention and
         *        the direct correlation to the generated opportunity or contact. Must be empty when
         *        <code>Marketing.AWSFundingUsed = No</code>.</p>
         *        <p>
         *        Valid values:
         *        <code>AI/ML | Analytics | Application Integration | Blockchain | Business Applications | Cloud Financial Management | Compute | Containers | Customer Engagement | Databases | Developer Tools | End User Computing | Front End Web &amp; Mobile | Game Tech | IoT | Management &amp; Governance | Media Services | Migration &amp; Transfer | Networking &amp; Content Delivery | Quantum Technologies | Robotics | Satellite | Security | Serverless | Storage | VR &amp; AR</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCases(Collection<String> useCases);

        /**
         * <p>
         * Specifies the marketing activity use case or purpose that led to the <code>Opportunity</code>'s creation or
         * contact. This field captures the context or marketing activity's execution's intention and the direct
         * correlation to the generated opportunity or contact. Must be empty when
         * <code>Marketing.AWSFundingUsed = No</code>.
         * </p>
         * <p>
         * Valid values:
         * <code>AI/ML | Analytics | Application Integration | Blockchain | Business Applications | Cloud Financial Management | Compute | Containers | Customer Engagement | Databases | Developer Tools | End User Computing | Front End Web &amp; Mobile | Game Tech | IoT | Management &amp; Governance | Media Services | Migration &amp; Transfer | Networking &amp; Content Delivery | Quantum Technologies | Robotics | Satellite | Security | Serverless | Storage | VR &amp; AR</code>
         * </p>
         * 
         * @param useCases
         *        Specifies the marketing activity use case or purpose that led to the <code>Opportunity</code>'s
         *        creation or contact. This field captures the context or marketing activity's execution's intention and
         *        the direct correlation to the generated opportunity or contact. Must be empty when
         *        <code>Marketing.AWSFundingUsed = No</code>.</p>
         *        <p>
         *        Valid values:
         *        <code>AI/ML | Analytics | Application Integration | Blockchain | Business Applications | Cloud Financial Management | Compute | Containers | Customer Engagement | Databases | Developer Tools | End User Computing | Front End Web &amp; Mobile | Game Tech | IoT | Management &amp; Governance | Media Services | Migration &amp; Transfer | Networking &amp; Content Delivery | Quantum Technologies | Robotics | Satellite | Security | Serverless | Storage | VR &amp; AR</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder useCases(String... useCases);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         * contacted through. This field provides information about the specific marketing channel that contributed to
         * the generation of the lead or contact.
         * </p>
         * 
         * @param channels
         *        Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         *        contacted through. This field provides information about the specific marketing channel that
         *        contributed to the generation of the lead or contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(Collection<String> channels);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         * contacted through. This field provides information about the specific marketing channel that contributed to
         * the generation of the lead or contact.
         * </p>
         * 
         * @param channels
         *        Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         *        contacted through. This field provides information about the specific marketing channel that
         *        contributed to the generation of the lead or contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channelsWithStrings(String... channels);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         * contacted through. This field provides information about the specific marketing channel that contributed to
         * the generation of the lead or contact.
         * </p>
         * 
         * @param channels
         *        Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         *        contacted through. This field provides information about the specific marketing channel that
         *        contributed to the generation of the lead or contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Collection<Channel> channels);

        /**
         * <p>
         * Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         * contacted through. This field provides information about the specific marketing channel that contributed to
         * the generation of the lead or contact.
         * </p>
         * 
         * @param channels
         *        Specifies the <code>Opportunity</code>'s channel that the marketing activity is associated with or was
         *        contacted through. This field provides information about the specific marketing channel that
         *        contributed to the generation of the lead or contact.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder channels(Channel... channels);

        /**
         * <p>
         * Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
         * </p>
         * 
         * @param awsFundingUsed
         *        Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
         * @see AwsFundingUsed
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsFundingUsed
         */
        Builder awsFundingUsed(String awsFundingUsed);

        /**
         * <p>
         * Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
         * </p>
         * 
         * @param awsFundingUsed
         *        Indicates if the <code>Opportunity</code> is a marketing development fund (MDF) funded activity.
         * @see AwsFundingUsed
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AwsFundingUsed
         */
        Builder awsFundingUsed(AwsFundingUsed awsFundingUsed);
    }

    static final class BuilderImpl implements Builder {
        private String campaignName;

        private String source;

        private List<String> useCases = DefaultSdkAutoConstructList.getInstance();

        private List<String> channels = DefaultSdkAutoConstructList.getInstance();

        private String awsFundingUsed;

        private BuilderImpl() {
        }

        private BuilderImpl(Marketing model) {
            campaignName(model.campaignName);
            source(model.source);
            useCases(model.useCases);
            channelsWithStrings(model.channels);
            awsFundingUsed(model.awsFundingUsed);
        }

        public final String getCampaignName() {
            return campaignName;
        }

        public final void setCampaignName(String campaignName) {
            this.campaignName = campaignName;
        }

        @Override
        public final Builder campaignName(String campaignName) {
            this.campaignName = campaignName;
            return this;
        }

        public final String getSource() {
            return source;
        }

        public final void setSource(String source) {
            this.source = source;
        }

        @Override
        public final Builder source(String source) {
            this.source = source;
            return this;
        }

        @Override
        public final Builder source(MarketingSource source) {
            this.source(source == null ? null : source.toString());
            return this;
        }

        public final Collection<String> getUseCases() {
            if (useCases instanceof SdkAutoConstructList) {
                return null;
            }
            return useCases;
        }

        public final void setUseCases(Collection<String> useCases) {
            this.useCases = UseCasesCopier.copy(useCases);
        }

        @Override
        public final Builder useCases(Collection<String> useCases) {
            this.useCases = UseCasesCopier.copy(useCases);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder useCases(String... useCases) {
            useCases(Arrays.asList(useCases));
            return this;
        }

        public final Collection<String> getChannels() {
            if (channels instanceof SdkAutoConstructList) {
                return null;
            }
            return channels;
        }

        public final void setChannels(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
        }

        @Override
        public final Builder channelsWithStrings(Collection<String> channels) {
            this.channels = ChannelsCopier.copy(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channelsWithStrings(String... channels) {
            channelsWithStrings(Arrays.asList(channels));
            return this;
        }

        @Override
        public final Builder channels(Collection<Channel> channels) {
            this.channels = ChannelsCopier.copyEnumToString(channels);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder channels(Channel... channels) {
            channels(Arrays.asList(channels));
            return this;
        }

        public final String getAwsFundingUsed() {
            return awsFundingUsed;
        }

        public final void setAwsFundingUsed(String awsFundingUsed) {
            this.awsFundingUsed = awsFundingUsed;
        }

        @Override
        public final Builder awsFundingUsed(String awsFundingUsed) {
            this.awsFundingUsed = awsFundingUsed;
            return this;
        }

        @Override
        public final Builder awsFundingUsed(AwsFundingUsed awsFundingUsed) {
            this.awsFundingUsed(awsFundingUsed == null ? null : awsFundingUsed.toString());
            return this;
        }

        @Override
        public Marketing build() {
            return new Marketing(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
