/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum PrimaryNeedFromAws {
    CO_SELL_ARCHITECTURAL_VALIDATION("Co-Sell - Architectural Validation"),

    CO_SELL_BUSINESS_PRESENTATION("Co-Sell - Business Presentation"),

    CO_SELL_COMPETITIVE_INFORMATION("Co-Sell - Competitive Information"),

    CO_SELL_PRICING_ASSISTANCE("Co-Sell - Pricing Assistance"),

    CO_SELL_TECHNICAL_CONSULTATION("Co-Sell - Technical Consultation"),

    CO_SELL_TOTAL_COST_OF_OWNERSHIP_EVALUATION("Co-Sell - Total Cost of Ownership Evaluation"),

    CO_SELL_DEAL_SUPPORT("Co-Sell - Deal Support"),

    CO_SELL_SUPPORT_FOR_PUBLIC_TENDER_R_FX("Co-Sell - Support for Public Tender / RFx"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PrimaryNeedFromAws> VALUE_MAP = EnumUtils.uniqueIndex(PrimaryNeedFromAws.class,
            PrimaryNeedFromAws::toString);

    private final String value;

    private PrimaryNeedFromAws(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return PrimaryNeedFromAws corresponding to the value
     */
    public static PrimaryNeedFromAws fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link PrimaryNeedFromAws}s
     */
    public static Set<PrimaryNeedFromAws> knownValues() {
        Set<PrimaryNeedFromAws> knownValues = EnumSet.allOf(PrimaryNeedFromAws.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
