/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This field provides the associations' information for other entities with the opportunity. These entities include
 * identifiers for <code>AWSProducts</code>, <code>Partner Solutions</code>, and <code>AWSMarketplaceOffers</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RelatedEntityIdentifiers implements SdkPojo, Serializable,
        ToCopyableBuilder<RelatedEntityIdentifiers.Builder, RelatedEntityIdentifiers> {
    private static final SdkField<List<String>> AWS_MARKETPLACE_OFFERS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsMarketplaceOffers")
            .getter(getter(RelatedEntityIdentifiers::awsMarketplaceOffers))
            .setter(setter(Builder::awsMarketplaceOffers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsMarketplaceOffers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SOLUTIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Solutions")
            .getter(getter(RelatedEntityIdentifiers::solutions))
            .setter(setter(Builder::solutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Solutions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AWS_PRODUCTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AwsProducts")
            .getter(getter(RelatedEntityIdentifiers::awsProducts))
            .setter(setter(Builder::awsProducts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AwsProducts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_MARKETPLACE_OFFERS_FIELD,
            SOLUTIONS_FIELD, AWS_PRODUCTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> awsMarketplaceOffers;

    private final List<String> solutions;

    private final List<String> awsProducts;

    private RelatedEntityIdentifiers(BuilderImpl builder) {
        this.awsMarketplaceOffers = builder.awsMarketplaceOffers;
        this.solutions = builder.solutions;
        this.awsProducts = builder.awsProducts;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsMarketplaceOffers property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsMarketplaceOffers() {
        return awsMarketplaceOffers != null && !(awsMarketplaceOffers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Takes one value per opportunity. Each value is an Amazon Resource Name (ARN), in this format:
     * <code>"offers": ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]</code>
     * .
     * </p>
     * <p>
     * Use the <a
     * href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html">ListEntities
     * </a> action in the Marketplace Catalog APIs for a list of offers in the associated Marketplace seller account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsMarketplaceOffers} method.
     * </p>
     * 
     * @return Takes one value per opportunity. Each value is an Amazon Resource Name (ARN), in this format:
     *         <code>"offers": ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]</code>
     *         .</p>
     *         <p>
     *         Use the <a
     *         href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
     *         >ListEntities</a> action in the Marketplace Catalog APIs for a list of offers in the associated
     *         Marketplace seller account.
     */
    public final List<String> awsMarketplaceOffers() {
        return awsMarketplaceOffers;
    }

    /**
     * For responses, this returns true if the service returned a value for the Solutions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSolutions() {
        return solutions != null && !(solutions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables partner solutions or offerings' association with an opportunity. To associate a solution, provide the
     * solution's unique identifier, which you can obtain with the <code>ListSolutions</code> operation.
     * </p>
     * <p>
     * If the specific solution identifier is not available, you can use the value <code>Other</code> and provide
     * details about the solution in the <code>otherSolutionOffered</code> field. But when the opportunity reaches the
     * <code>Committed</code> stage or beyond, the <code>Other</code> value cannot be used, and a valid solution
     * identifier must be provided.
     * </p>
     * <p>
     * By associating the relevant solutions with the opportunity, you can communicate the offerings that are being
     * considered or implemented to address the customer's business problem.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSolutions} method.
     * </p>
     * 
     * @return Enables partner solutions or offerings' association with an opportunity. To associate a solution, provide
     *         the solution's unique identifier, which you can obtain with the <code>ListSolutions</code> operation.</p>
     *         <p>
     *         If the specific solution identifier is not available, you can use the value <code>Other</code> and
     *         provide details about the solution in the <code>otherSolutionOffered</code> field. But when the
     *         opportunity reaches the <code>Committed</code> stage or beyond, the <code>Other</code> value cannot be
     *         used, and a valid solution identifier must be provided.
     *         </p>
     *         <p>
     *         By associating the relevant solutions with the opportunity, you can communicate the offerings that are
     *         being considered or implemented to address the customer's business problem.
     */
    public final List<String> solutions() {
        return solutions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AwsProducts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAwsProducts() {
        return awsProducts != null && !(awsProducts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Enables the association of specific Amazon Web Services products with the <code>Opportunity</code>. Partners can
     * indicate the relevant Amazon Web Services products for the <code>Opportunity</code>'s solution and align with the
     * customer's needs. Returns multiple values separated by commas. For example,
     * <code>"AWSProducts" : ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"]</code>.
     * </p>
     * <p>
     * Use the file with the list of Amazon Web Services products hosted on GitHub: <a
     * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
     * Amazon Web Services products</a>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAwsProducts} method.
     * </p>
     * 
     * @return Enables the association of specific Amazon Web Services products with the <code>Opportunity</code>.
     *         Partners can indicate the relevant Amazon Web Services products for the <code>Opportunity</code>'s
     *         solution and align with the customer's needs. Returns multiple values separated by commas. For example,
     *         <code>"AWSProducts" : ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"]</code>.</p>
     *         <p>
     *         Use the file with the list of Amazon Web Services products hosted on GitHub: <a href=
     *         "https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
     *         Amazon Web Services products</a>.
     */
    public final List<String> awsProducts() {
        return awsProducts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsMarketplaceOffers() ? awsMarketplaceOffers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSolutions() ? solutions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAwsProducts() ? awsProducts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelatedEntityIdentifiers)) {
            return false;
        }
        RelatedEntityIdentifiers other = (RelatedEntityIdentifiers) obj;
        return hasAwsMarketplaceOffers() == other.hasAwsMarketplaceOffers()
                && Objects.equals(awsMarketplaceOffers(), other.awsMarketplaceOffers()) && hasSolutions() == other.hasSolutions()
                && Objects.equals(solutions(), other.solutions()) && hasAwsProducts() == other.hasAwsProducts()
                && Objects.equals(awsProducts(), other.awsProducts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RelatedEntityIdentifiers")
                .add("AwsMarketplaceOffers", hasAwsMarketplaceOffers() ? awsMarketplaceOffers() : null)
                .add("Solutions", hasSolutions() ? solutions() : null)
                .add("AwsProducts", hasAwsProducts() ? awsProducts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsMarketplaceOffers":
            return Optional.ofNullable(clazz.cast(awsMarketplaceOffers()));
        case "Solutions":
            return Optional.ofNullable(clazz.cast(solutions()));
        case "AwsProducts":
            return Optional.ofNullable(clazz.cast(awsProducts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AwsMarketplaceOffers", AWS_MARKETPLACE_OFFERS_FIELD);
        map.put("Solutions", SOLUTIONS_FIELD);
        map.put("AwsProducts", AWS_PRODUCTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RelatedEntityIdentifiers, T> g) {
        return obj -> g.apply((RelatedEntityIdentifiers) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RelatedEntityIdentifiers> {
        /**
         * <p>
         * Takes one value per opportunity. Each value is an Amazon Resource Name (ARN), in this format:
         * <code>"offers": ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]</code>
         * .
         * </p>
         * <p>
         * Use the <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html">
         * ListEntities</a> action in the Marketplace Catalog APIs for a list of offers in the associated Marketplace
         * seller account.
         * </p>
         * 
         * @param awsMarketplaceOffers
         *        Takes one value per opportunity. Each value is an Amazon Resource Name (ARN), in this format:
         *        <code>"offers": ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]</code>
         *        .</p>
         *        <p>
         *        Use the <a
         *        href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
         *        >ListEntities</a> action in the Marketplace Catalog APIs for a list of offers in the associated
         *        Marketplace seller account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsMarketplaceOffers(Collection<String> awsMarketplaceOffers);

        /**
         * <p>
         * Takes one value per opportunity. Each value is an Amazon Resource Name (ARN), in this format:
         * <code>"offers": ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]</code>
         * .
         * </p>
         * <p>
         * Use the <a href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html">
         * ListEntities</a> action in the Marketplace Catalog APIs for a list of offers in the associated Marketplace
         * seller account.
         * </p>
         * 
         * @param awsMarketplaceOffers
         *        Takes one value per opportunity. Each value is an Amazon Resource Name (ARN), in this format:
         *        <code>"offers": ["arn:aws:aws-marketplace:us-east-1:999999999999:AWSMarketplace/Offer/offer-sampleOffer32"]</code>
         *        .</p>
         *        <p>
         *        Use the <a
         *        href="https://docs.aws.amazon.com/marketplace-catalog/latest/api-reference/API_ListEntities.html"
         *        >ListEntities</a> action in the Marketplace Catalog APIs for a list of offers in the associated
         *        Marketplace seller account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsMarketplaceOffers(String... awsMarketplaceOffers);

        /**
         * <p>
         * Enables partner solutions or offerings' association with an opportunity. To associate a solution, provide the
         * solution's unique identifier, which you can obtain with the <code>ListSolutions</code> operation.
         * </p>
         * <p>
         * If the specific solution identifier is not available, you can use the value <code>Other</code> and provide
         * details about the solution in the <code>otherSolutionOffered</code> field. But when the opportunity reaches
         * the <code>Committed</code> stage or beyond, the <code>Other</code> value cannot be used, and a valid solution
         * identifier must be provided.
         * </p>
         * <p>
         * By associating the relevant solutions with the opportunity, you can communicate the offerings that are being
         * considered or implemented to address the customer's business problem.
         * </p>
         * 
         * @param solutions
         *        Enables partner solutions or offerings' association with an opportunity. To associate a solution,
         *        provide the solution's unique identifier, which you can obtain with the <code>ListSolutions</code>
         *        operation.</p>
         *        <p>
         *        If the specific solution identifier is not available, you can use the value <code>Other</code> and
         *        provide details about the solution in the <code>otherSolutionOffered</code> field. But when the
         *        opportunity reaches the <code>Committed</code> stage or beyond, the <code>Other</code> value cannot be
         *        used, and a valid solution identifier must be provided.
         *        </p>
         *        <p>
         *        By associating the relevant solutions with the opportunity, you can communicate the offerings that are
         *        being considered or implemented to address the customer's business problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutions(Collection<String> solutions);

        /**
         * <p>
         * Enables partner solutions or offerings' association with an opportunity. To associate a solution, provide the
         * solution's unique identifier, which you can obtain with the <code>ListSolutions</code> operation.
         * </p>
         * <p>
         * If the specific solution identifier is not available, you can use the value <code>Other</code> and provide
         * details about the solution in the <code>otherSolutionOffered</code> field. But when the opportunity reaches
         * the <code>Committed</code> stage or beyond, the <code>Other</code> value cannot be used, and a valid solution
         * identifier must be provided.
         * </p>
         * <p>
         * By associating the relevant solutions with the opportunity, you can communicate the offerings that are being
         * considered or implemented to address the customer's business problem.
         * </p>
         * 
         * @param solutions
         *        Enables partner solutions or offerings' association with an opportunity. To associate a solution,
         *        provide the solution's unique identifier, which you can obtain with the <code>ListSolutions</code>
         *        operation.</p>
         *        <p>
         *        If the specific solution identifier is not available, you can use the value <code>Other</code> and
         *        provide details about the solution in the <code>otherSolutionOffered</code> field. But when the
         *        opportunity reaches the <code>Committed</code> stage or beyond, the <code>Other</code> value cannot be
         *        used, and a valid solution identifier must be provided.
         *        </p>
         *        <p>
         *        By associating the relevant solutions with the opportunity, you can communicate the offerings that are
         *        being considered or implemented to address the customer's business problem.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder solutions(String... solutions);

        /**
         * <p>
         * Enables the association of specific Amazon Web Services products with the <code>Opportunity</code>. Partners
         * can indicate the relevant Amazon Web Services products for the <code>Opportunity</code>'s solution and align
         * with the customer's needs. Returns multiple values separated by commas. For example,
         * <code>"AWSProducts" : ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"]</code>.
         * </p>
         * <p>
         * Use the file with the list of Amazon Web Services products hosted on GitHub: <a
         * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
         * Amazon Web Services products</a>.
         * </p>
         * 
         * @param awsProducts
         *        Enables the association of specific Amazon Web Services products with the <code>Opportunity</code>.
         *        Partners can indicate the relevant Amazon Web Services products for the <code>Opportunity</code>'s
         *        solution and align with the customer's needs. Returns multiple values separated by commas. For
         *        example, <code>"AWSProducts" : ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"]</code>.</p>
         *        <p>
         *        Use the file with the list of Amazon Web Services products hosted on GitHub: <a href=
         *        "https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json"
         *        > Amazon Web Services products</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsProducts(Collection<String> awsProducts);

        /**
         * <p>
         * Enables the association of specific Amazon Web Services products with the <code>Opportunity</code>. Partners
         * can indicate the relevant Amazon Web Services products for the <code>Opportunity</code>'s solution and align
         * with the customer's needs. Returns multiple values separated by commas. For example,
         * <code>"AWSProducts" : ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"]</code>.
         * </p>
         * <p>
         * Use the file with the list of Amazon Web Services products hosted on GitHub: <a
         * href="https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json">
         * Amazon Web Services products</a>.
         * </p>
         * 
         * @param awsProducts
         *        Enables the association of specific Amazon Web Services products with the <code>Opportunity</code>.
         *        Partners can indicate the relevant Amazon Web Services products for the <code>Opportunity</code>'s
         *        solution and align with the customer's needs. Returns multiple values separated by commas. For
         *        example, <code>"AWSProducts" : ["AmazonRedshift", "AWSAppFabric", "AWSCleanRooms"]</code>.</p>
         *        <p>
         *        Use the file with the list of Amazon Web Services products hosted on GitHub: <a href=
         *        "https://github.com/aws-samples/partner-crm-integration-samples/blob/main/resources/aws_products.json"
         *        > Amazon Web Services products</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsProducts(String... awsProducts);
    }

    static final class BuilderImpl implements Builder {
        private List<String> awsMarketplaceOffers = DefaultSdkAutoConstructList.getInstance();

        private List<String> solutions = DefaultSdkAutoConstructList.getInstance();

        private List<String> awsProducts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RelatedEntityIdentifiers model) {
            awsMarketplaceOffers(model.awsMarketplaceOffers);
            solutions(model.solutions);
            awsProducts(model.awsProducts);
        }

        public final Collection<String> getAwsMarketplaceOffers() {
            if (awsMarketplaceOffers instanceof SdkAutoConstructList) {
                return null;
            }
            return awsMarketplaceOffers;
        }

        public final void setAwsMarketplaceOffers(Collection<String> awsMarketplaceOffers) {
            this.awsMarketplaceOffers = AwsMarketplaceOfferIdentifiersCopier.copy(awsMarketplaceOffers);
        }

        @Override
        public final Builder awsMarketplaceOffers(Collection<String> awsMarketplaceOffers) {
            this.awsMarketplaceOffers = AwsMarketplaceOfferIdentifiersCopier.copy(awsMarketplaceOffers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsMarketplaceOffers(String... awsMarketplaceOffers) {
            awsMarketplaceOffers(Arrays.asList(awsMarketplaceOffers));
            return this;
        }

        public final Collection<String> getSolutions() {
            if (solutions instanceof SdkAutoConstructList) {
                return null;
            }
            return solutions;
        }

        public final void setSolutions(Collection<String> solutions) {
            this.solutions = SolutionIdentifiersCopier.copy(solutions);
        }

        @Override
        public final Builder solutions(Collection<String> solutions) {
            this.solutions = SolutionIdentifiersCopier.copy(solutions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder solutions(String... solutions) {
            solutions(Arrays.asList(solutions));
            return this;
        }

        public final Collection<String> getAwsProducts() {
            if (awsProducts instanceof SdkAutoConstructList) {
                return null;
            }
            return awsProducts;
        }

        public final void setAwsProducts(Collection<String> awsProducts) {
            this.awsProducts = AwsProductIdentifiersCopier.copy(awsProducts);
        }

        @Override
        public final Builder awsProducts(Collection<String> awsProducts) {
            this.awsProducts = AwsProductIdentifiersCopier.copy(awsProducts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder awsProducts(String... awsProducts) {
            awsProducts(Arrays.asList(awsProducts));
            return this;
        }

        @Override
        public RelatedEntityIdentifiers build() {
            return new RelatedEntityIdentifiers(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
