/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides a concise summary of a resource snapshot, including its unique identifier and version information. This
 * structure is used to quickly reference and identify specific versions of resource snapshots.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ResourceSnapshotSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<ResourceSnapshotSummary.Builder, ResourceSnapshotSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ResourceSnapshotSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Integer> REVISION_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Revision").getter(getter(ResourceSnapshotSummary::revision)).setter(setter(Builder::revision))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Revision").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ResourceSnapshotSummary::resourceTypeAsString))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceId").getter(getter(ResourceSnapshotSummary::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceId").build()).build();

    private static final SdkField<String> RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ResourceSnapshotTemplateName")
            .getter(getter(ResourceSnapshotSummary::resourceSnapshotTemplateName))
            .setter(setter(Builder::resourceSnapshotTemplateName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceSnapshotTemplateName")
                    .build()).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CreatedBy").getter(getter(ResourceSnapshotSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, REVISION_FIELD,
            RESOURCE_TYPE_FIELD, RESOURCE_ID_FIELD, RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD, CREATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Integer revision;

    private final String resourceType;

    private final String resourceId;

    private final String resourceSnapshotTemplateName;

    private final String createdBy;

    private ResourceSnapshotSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.revision = builder.revision;
        this.resourceType = builder.resourceType;
        this.resourceId = builder.resourceId;
        this.resourceSnapshotTemplateName = builder.resourceSnapshotTemplateName;
        this.createdBy = builder.createdBy;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the snapshot. This globally unique identifier can be used for cross-service
     * references and in IAM policies.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the snapshot. This globally unique identifier can be used for
     *         cross-service references and in IAM policies.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The revision number of the snapshot. This integer value is incremented each time the snapshot is updated,
     * allowing for version tracking of the resource snapshot.
     * </p>
     * 
     * @return The revision number of the snapshot. This integer value is incremented each time the snapshot is updated,
     *         allowing for version tracking of the resource snapshot.
     */
    public final Integer revision() {
        return revision;
    }

    /**
     * <p>
     * The type of resource snapshotted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource snapshotted.
     * @see ResourceType
     */
    public final ResourceType resourceType() {
        return ResourceType.fromValue(resourceType);
    }

    /**
     * <p>
     * The type of resource snapshotted.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #resourceType} will
     * return {@link ResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #resourceTypeAsString}.
     * </p>
     * 
     * @return The type of resource snapshotted.
     * @see ResourceType
     */
    public final String resourceTypeAsString() {
        return resourceType;
    }

    /**
     * <p>
     * The identifier of the specific resource snapshotted. The format might vary depending on the ResourceType.
     * </p>
     * 
     * @return The identifier of the specific resource snapshotted. The format might vary depending on the ResourceType.
     */
    public final String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The name of the template used to create the snapshot.
     * </p>
     * 
     * @return The name of the template used to create the snapshot.
     */
    public final String resourceSnapshotTemplateName() {
        return resourceSnapshotTemplateName;
    }

    /**
     * <p>
     * The AWS account ID of the entity that owns the resource from which the snapshot was created.
     * </p>
     * 
     * @return The AWS account ID of the entity that owns the resource from which the snapshot was created.
     */
    public final String createdBy() {
        return createdBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(revision());
        hashCode = 31 * hashCode + Objects.hashCode(resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceSnapshotTemplateName());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceSnapshotSummary)) {
            return false;
        }
        ResourceSnapshotSummary other = (ResourceSnapshotSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(revision(), other.revision())
                && Objects.equals(resourceTypeAsString(), other.resourceTypeAsString())
                && Objects.equals(resourceId(), other.resourceId())
                && Objects.equals(resourceSnapshotTemplateName(), other.resourceSnapshotTemplateName())
                && Objects.equals(createdBy(), other.createdBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ResourceSnapshotSummary").add("Arn", arn()).add("Revision", revision())
                .add("ResourceType", resourceTypeAsString()).add("ResourceId", resourceId())
                .add("ResourceSnapshotTemplateName", resourceSnapshotTemplateName())
                .add("CreatedBy", createdBy() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Revision":
            return Optional.ofNullable(clazz.cast(revision()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceTypeAsString()));
        case "ResourceId":
            return Optional.ofNullable(clazz.cast(resourceId()));
        case "ResourceSnapshotTemplateName":
            return Optional.ofNullable(clazz.cast(resourceSnapshotTemplateName()));
        case "CreatedBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Revision", REVISION_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ResourceId", RESOURCE_ID_FIELD);
        map.put("ResourceSnapshotTemplateName", RESOURCE_SNAPSHOT_TEMPLATE_NAME_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceSnapshotSummary, T> g) {
        return obj -> g.apply((ResourceSnapshotSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ResourceSnapshotSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the snapshot. This globally unique identifier can be used for cross-service
         * references and in IAM policies.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the snapshot. This globally unique identifier can be used for
         *        cross-service references and in IAM policies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The revision number of the snapshot. This integer value is incremented each time the snapshot is updated,
         * allowing for version tracking of the resource snapshot.
         * </p>
         * 
         * @param revision
         *        The revision number of the snapshot. This integer value is incremented each time the snapshot is
         *        updated, allowing for version tracking of the resource snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revision(Integer revision);

        /**
         * <p>
         * The type of resource snapshotted.
         * </p>
         * 
         * @param resourceType
         *        The type of resource snapshotted.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The type of resource snapshotted.
         * </p>
         * 
         * @param resourceType
         *        The type of resource snapshotted.
         * @see ResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResourceType
         */
        Builder resourceType(ResourceType resourceType);

        /**
         * <p>
         * The identifier of the specific resource snapshotted. The format might vary depending on the ResourceType.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the specific resource snapshotted. The format might vary depending on the
         *        ResourceType.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The name of the template used to create the snapshot.
         * </p>
         * 
         * @param resourceSnapshotTemplateName
         *        The name of the template used to create the snapshot.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName);

        /**
         * <p>
         * The AWS account ID of the entity that owns the resource from which the snapshot was created.
         * </p>
         * 
         * @param createdBy
         *        The AWS account ID of the entity that owns the resource from which the snapshot was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Integer revision;

        private String resourceType;

        private String resourceId;

        private String resourceSnapshotTemplateName;

        private String createdBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceSnapshotSummary model) {
            arn(model.arn);
            revision(model.revision);
            resourceType(model.resourceType);
            resourceId(model.resourceId);
            resourceSnapshotTemplateName(model.resourceSnapshotTemplateName);
            createdBy(model.createdBy);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Integer getRevision() {
            return revision;
        }

        public final void setRevision(Integer revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(Integer revision) {
            this.revision = revision;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceSnapshotTemplateName() {
            return resourceSnapshotTemplateName;
        }

        public final void setResourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
        }

        @Override
        public final Builder resourceSnapshotTemplateName(String resourceSnapshotTemplateName) {
            this.resourceSnapshotTemplateName = resourceSnapshotTemplateName;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        @Override
        public ResourceSnapshotSummary build() {
            return new ResourceSnapshotSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
