/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that contains the details of the sender-provided contact person for the <code>EngagementInvitation</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SenderContact implements SdkPojo, Serializable, ToCopyableBuilder<SenderContact.Builder, SenderContact> {
    private static final SdkField<String> EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Email")
            .getter(getter(SenderContact::email)).setter(setter(Builder::email))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Email").build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(SenderContact::firstName)).setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(SenderContact::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> BUSINESS_TITLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BusinessTitle").getter(getter(SenderContact::businessTitle)).setter(setter(Builder::businessTitle))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BusinessTitle").build()).build();

    private static final SdkField<String> PHONE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Phone")
            .getter(getter(SenderContact::phone)).setter(setter(Builder::phone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Phone").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EMAIL_FIELD, FIRST_NAME_FIELD,
            LAST_NAME_FIELD, BUSINESS_TITLE_FIELD, PHONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String email;

    private final String firstName;

    private final String lastName;

    private final String businessTitle;

    private final String phone;

    private SenderContact(BuilderImpl builder) {
        this.email = builder.email;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.businessTitle = builder.businessTitle;
        this.phone = builder.phone;
    }

    /**
     * <p>
     * The sender-provided contact's email address associated with the <code>EngagementInvitation</code>.
     * </p>
     * 
     * @return The sender-provided contact's email address associated with the <code>EngagementInvitation</code>.
     */
    public final String email() {
        return email;
    }

    /**
     * <p>
     * The sender-provided contact's last name associated with the <code>EngagementInvitation</code>.
     * </p>
     * 
     * @return The sender-provided contact's last name associated with the <code>EngagementInvitation</code>.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The sender-provided contact's first name associated with the <code>EngagementInvitation</code>.
     * </p>
     * 
     * @return The sender-provided contact's first name associated with the <code>EngagementInvitation</code>.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The sender-provided contact's title (job title or role) associated with the <code>EngagementInvitation</code>.
     * </p>
     * 
     * @return The sender-provided contact's title (job title or role) associated with the
     *         <code>EngagementInvitation</code>.
     */
    public final String businessTitle() {
        return businessTitle;
    }

    /**
     * <p>
     * The sender-provided contact's phone number associated with the <code>EngagementInvitation</code>.
     * </p>
     * 
     * @return The sender-provided contact's phone number associated with the <code>EngagementInvitation</code>.
     */
    public final String phone() {
        return phone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(email());
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(businessTitle());
        hashCode = 31 * hashCode + Objects.hashCode(phone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SenderContact)) {
            return false;
        }
        SenderContact other = (SenderContact) obj;
        return Objects.equals(email(), other.email()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(businessTitle(), other.businessTitle())
                && Objects.equals(phone(), other.phone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SenderContact").add("Email", email() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FirstName", firstName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("LastName", lastName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("BusinessTitle", businessTitle() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Phone", phone() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Email":
            return Optional.ofNullable(clazz.cast(email()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "BusinessTitle":
            return Optional.ofNullable(clazz.cast(businessTitle()));
        case "Phone":
            return Optional.ofNullable(clazz.cast(phone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Email", EMAIL_FIELD);
        map.put("FirstName", FIRST_NAME_FIELD);
        map.put("LastName", LAST_NAME_FIELD);
        map.put("BusinessTitle", BUSINESS_TITLE_FIELD);
        map.put("Phone", PHONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SenderContact, T> g) {
        return obj -> g.apply((SenderContact) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SenderContact> {
        /**
         * <p>
         * The sender-provided contact's email address associated with the <code>EngagementInvitation</code>.
         * </p>
         * 
         * @param email
         *        The sender-provided contact's email address associated with the <code>EngagementInvitation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder email(String email);

        /**
         * <p>
         * The sender-provided contact's last name associated with the <code>EngagementInvitation</code>.
         * </p>
         * 
         * @param firstName
         *        The sender-provided contact's last name associated with the <code>EngagementInvitation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The sender-provided contact's first name associated with the <code>EngagementInvitation</code>.
         * </p>
         * 
         * @param lastName
         *        The sender-provided contact's first name associated with the <code>EngagementInvitation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The sender-provided contact's title (job title or role) associated with the <code>EngagementInvitation</code>
         * .
         * </p>
         * 
         * @param businessTitle
         *        The sender-provided contact's title (job title or role) associated with the
         *        <code>EngagementInvitation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder businessTitle(String businessTitle);

        /**
         * <p>
         * The sender-provided contact's phone number associated with the <code>EngagementInvitation</code>.
         * </p>
         * 
         * @param phone
         *        The sender-provided contact's phone number associated with the <code>EngagementInvitation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder phone(String phone);
    }

    static final class BuilderImpl implements Builder {
        private String email;

        private String firstName;

        private String lastName;

        private String businessTitle;

        private String phone;

        private BuilderImpl() {
        }

        private BuilderImpl(SenderContact model) {
            email(model.email);
            firstName(model.firstName);
            lastName(model.lastName);
            businessTitle(model.businessTitle);
            phone(model.phone);
        }

        public final String getEmail() {
            return email;
        }

        public final void setEmail(String email) {
            this.email = email;
        }

        @Override
        public final Builder email(String email) {
            this.email = email;
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getBusinessTitle() {
            return businessTitle;
        }

        public final void setBusinessTitle(String businessTitle) {
            this.businessTitle = businessTitle;
        }

        @Override
        public final Builder businessTitle(String businessTitle) {
            this.businessTitle = businessTitle;
            return this;
        }

        public final String getPhone() {
            return phone;
        }

        public final void setPhone(String phone) {
            this.phone = phone;
        }

        @Override
        public final Builder phone(String phone) {
            this.phone = phone;
            return this;
        }

        @Override
        public SenderContact build() {
            return new SenderContact(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
