/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextDetails;
import software.amazon.awssdk.services.partnercentralselling.model.EngagementContextsCopier;
import software.amazon.awssdk.services.partnercentralselling.model.PartnerCentralSellingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEngagementResponse
extends PartnerCentralSellingResponse
implements ToCopyableBuilder<Builder, GetEngagementResponse> {
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Id").getter(GetEngagementResponse.getter(GetEngagementResponse::id)).setter(GetEngagementResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Arn").getter(GetEngagementResponse.getter(GetEngagementResponse::arn)).setter(GetEngagementResponse.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()}).build();
    private static final SdkField<String> TITLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Title").getter(GetEngagementResponse.getter(GetEngagementResponse::title)).setter(GetEngagementResponse.setter(Builder::title)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Title").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetEngagementResponse.getter(GetEngagementResponse::description)).setter(GetEngagementResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedAt").getter(GetEngagementResponse.getter(GetEngagementResponse::createdAt)).setter(GetEngagementResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedBy").getter(GetEngagementResponse.getter(GetEngagementResponse::createdBy)).setter(GetEngagementResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Integer> MEMBER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MemberCount").getter(GetEngagementResponse.getter(GetEngagementResponse::memberCount)).setter(GetEngagementResponse.setter(Builder::memberCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberCount").build()}).build();
    private static final SdkField<List<EngagementContextDetails>> CONTEXTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Contexts").getter(GetEngagementResponse.getter(GetEngagementResponse::contexts)).setter(GetEngagementResponse.setter(Builder::contexts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Contexts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EngagementContextDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, ARN_FIELD, TITLE_FIELD, DESCRIPTION_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, MEMBER_COUNT_FIELD, CONTEXTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetEngagementResponse.memberNameToFieldInitializer();
    private final String id;
    private final String arn;
    private final String title;
    private final String description;
    private final Instant createdAt;
    private final String createdBy;
    private final Integer memberCount;
    private final List<EngagementContextDetails> contexts;

    private GetEngagementResponse(BuilderImpl builder) {
        super(builder);
        this.id = builder.id;
        this.arn = builder.arn;
        this.title = builder.title;
        this.description = builder.description;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.memberCount = builder.memberCount;
        this.contexts = builder.contexts;
    }

    public final String id() {
        return this.id;
    }

    public final String arn() {
        return this.arn;
    }

    public final String title() {
        return this.title;
    }

    public final String description() {
        return this.description;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Integer memberCount() {
        return this.memberCount;
    }

    public final boolean hasContexts() {
        return this.contexts != null && !(this.contexts instanceof SdkAutoConstructList);
    }

    public final List<EngagementContextDetails> contexts() {
        return this.contexts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.title());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContexts() ? this.contexts() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEngagementResponse)) {
            return false;
        }
        GetEngagementResponse other = (GetEngagementResponse)((Object)obj);
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.title(), other.title()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.memberCount(), other.memberCount()) && this.hasContexts() == other.hasContexts() && Objects.equals(this.contexts(), other.contexts());
    }

    public final String toString() {
        return ToString.builder((String)"GetEngagementResponse").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("Title", (Object)this.title()).add("Description", (Object)this.description()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)(this.createdBy() == null ? null : "*** Sensitive Data Redacted ***")).add("MemberCount", (Object)this.memberCount()).add("Contexts", this.hasContexts() ? this.contexts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "Title": {
                return Optional.ofNullable(clazz.cast(this.title()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "CreatedAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "MemberCount": {
                return Optional.ofNullable(clazz.cast(this.memberCount()));
            }
            case "Contexts": {
                return Optional.ofNullable(clazz.cast(this.contexts()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Id", ID_FIELD);
        map.put("Arn", ARN_FIELD);
        map.put("Title", TITLE_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("MemberCount", MEMBER_COUNT_FIELD);
        map.put("Contexts", CONTEXTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetEngagementResponse, T> g) {
        return obj -> g.apply((GetEngagementResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PartnerCentralSellingResponse.BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String title;
        private String description;
        private Instant createdAt;
        private String createdBy;
        private Integer memberCount;
        private List<EngagementContextDetails> contexts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEngagementResponse model) {
            super(model);
            this.id(model.id);
            this.arn(model.arn);
            this.title(model.title);
            this.description(model.description);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.memberCount(model.memberCount);
            this.contexts(model.contexts);
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getTitle() {
            return this.title;
        }

        public final void setTitle(String title) {
            this.title = title;
        }

        @Override
        public final Builder title(String title) {
            this.title = title;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Integer getMemberCount() {
            return this.memberCount;
        }

        public final void setMemberCount(Integer memberCount) {
            this.memberCount = memberCount;
        }

        @Override
        public final Builder memberCount(Integer memberCount) {
            this.memberCount = memberCount;
            return this;
        }

        public final List<EngagementContextDetails.Builder> getContexts() {
            List<EngagementContextDetails.Builder> result = EngagementContextsCopier.copyToBuilder(this.contexts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContexts(Collection<EngagementContextDetails.BuilderImpl> contexts) {
            this.contexts = EngagementContextsCopier.copyFromBuilder(contexts);
        }

        @Override
        public final Builder contexts(Collection<EngagementContextDetails> contexts) {
            this.contexts = EngagementContextsCopier.copy(contexts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(EngagementContextDetails ... contexts) {
            this.contexts(Arrays.asList(contexts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contexts(Consumer<EngagementContextDetails.Builder> ... contexts) {
            this.contexts(Stream.of(contexts).map(c -> (EngagementContextDetails)((EngagementContextDetails.Builder)EngagementContextDetails.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEngagementResponse build() {
            return new GetEngagementResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PartnerCentralSellingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEngagementResponse> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder title(String var1);

        public Builder description(String var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder memberCount(Integer var1);

        public Builder contexts(Collection<EngagementContextDetails> var1);

        public Builder contexts(EngagementContextDetails ... var1);

        public Builder contexts(Consumer<EngagementContextDetails.Builder> ... var1);
    }
}

