/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DeliveryModel {
    SAAS_OR_PAAS("SaaS or PaaS"),
    BYOL_OR_AMI("BYOL or AMI"),
    MANAGED_SERVICES("Managed Services"),
    PROFESSIONAL_SERVICES("Professional Services"),
    RESELL("Resell"),
    OTHER("Other"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DeliveryModel> VALUE_MAP;
    private final String value;

    private DeliveryModel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DeliveryModel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DeliveryModel> knownValues() {
        EnumSet<DeliveryModel> knownValues = EnumSet.allOf(DeliveryModel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DeliveryModel.class, DeliveryModel::toString);
    }
}

