/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.partnercentralselling.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.partnercentralselling.model.AwsClosedLostReason;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityLifeCycleNextStepsHistoryListCopier;
import software.amazon.awssdk.services.partnercentralselling.model.AwsOpportunityStage;
import software.amazon.awssdk.services.partnercentralselling.model.ProfileNextStepsHistory;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsOpportunityLifeCycle
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsOpportunityLifeCycle> {
    private static final SdkField<String> TARGET_CLOSE_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TargetCloseDate").getter(AwsOpportunityLifeCycle.getter(AwsOpportunityLifeCycle::targetCloseDate)).setter(AwsOpportunityLifeCycle.setter(Builder::targetCloseDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetCloseDate").build()}).build();
    private static final SdkField<String> CLOSED_LOST_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClosedLostReason").getter(AwsOpportunityLifeCycle.getter(AwsOpportunityLifeCycle::closedLostReasonAsString)).setter(AwsOpportunityLifeCycle.setter(Builder::closedLostReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClosedLostReason").build()}).build();
    private static final SdkField<String> STAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Stage").getter(AwsOpportunityLifeCycle.getter(AwsOpportunityLifeCycle::stageAsString)).setter(AwsOpportunityLifeCycle.setter(Builder::stage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stage").build()}).build();
    private static final SdkField<String> NEXT_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextSteps").getter(AwsOpportunityLifeCycle.getter(AwsOpportunityLifeCycle::nextSteps)).setter(AwsOpportunityLifeCycle.setter(Builder::nextSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextSteps").build()}).build();
    private static final SdkField<List<ProfileNextStepsHistory>> NEXT_STEPS_HISTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NextStepsHistory").getter(AwsOpportunityLifeCycle.getter(AwsOpportunityLifeCycle::nextStepsHistory)).setter(AwsOpportunityLifeCycle.setter(Builder::nextStepsHistory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextStepsHistory").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProfileNextStepsHistory::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_CLOSE_DATE_FIELD, CLOSED_LOST_REASON_FIELD, STAGE_FIELD, NEXT_STEPS_FIELD, NEXT_STEPS_HISTORY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsOpportunityLifeCycle.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String targetCloseDate;
    private final String closedLostReason;
    private final String stage;
    private final String nextSteps;
    private final List<ProfileNextStepsHistory> nextStepsHistory;

    private AwsOpportunityLifeCycle(BuilderImpl builder) {
        this.targetCloseDate = builder.targetCloseDate;
        this.closedLostReason = builder.closedLostReason;
        this.stage = builder.stage;
        this.nextSteps = builder.nextSteps;
        this.nextStepsHistory = builder.nextStepsHistory;
    }

    public final String targetCloseDate() {
        return this.targetCloseDate;
    }

    public final AwsClosedLostReason closedLostReason() {
        return AwsClosedLostReason.fromValue(this.closedLostReason);
    }

    public final String closedLostReasonAsString() {
        return this.closedLostReason;
    }

    public final AwsOpportunityStage stage() {
        return AwsOpportunityStage.fromValue(this.stage);
    }

    public final String stageAsString() {
        return this.stage;
    }

    public final String nextSteps() {
        return this.nextSteps;
    }

    public final boolean hasNextStepsHistory() {
        return this.nextStepsHistory != null && !(this.nextStepsHistory instanceof SdkAutoConstructList);
    }

    public final List<ProfileNextStepsHistory> nextStepsHistory() {
        return this.nextStepsHistory;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.targetCloseDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.closedLostReasonAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextSteps());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNextStepsHistory() ? this.nextStepsHistory() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsOpportunityLifeCycle)) {
            return false;
        }
        AwsOpportunityLifeCycle other = (AwsOpportunityLifeCycle)obj;
        return Objects.equals(this.targetCloseDate(), other.targetCloseDate()) && Objects.equals(this.closedLostReasonAsString(), other.closedLostReasonAsString()) && Objects.equals(this.stageAsString(), other.stageAsString()) && Objects.equals(this.nextSteps(), other.nextSteps()) && this.hasNextStepsHistory() == other.hasNextStepsHistory() && Objects.equals(this.nextStepsHistory(), other.nextStepsHistory());
    }

    public final String toString() {
        return ToString.builder((String)"AwsOpportunityLifeCycle").add("TargetCloseDate", (Object)this.targetCloseDate()).add("ClosedLostReason", (Object)this.closedLostReasonAsString()).add("Stage", (Object)this.stageAsString()).add("NextSteps", (Object)(this.nextSteps() == null ? null : "*** Sensitive Data Redacted ***")).add("NextStepsHistory", this.hasNextStepsHistory() ? this.nextStepsHistory() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TargetCloseDate": {
                return Optional.ofNullable(clazz.cast(this.targetCloseDate()));
            }
            case "ClosedLostReason": {
                return Optional.ofNullable(clazz.cast(this.closedLostReasonAsString()));
            }
            case "Stage": {
                return Optional.ofNullable(clazz.cast(this.stageAsString()));
            }
            case "NextSteps": {
                return Optional.ofNullable(clazz.cast(this.nextSteps()));
            }
            case "NextStepsHistory": {
                return Optional.ofNullable(clazz.cast(this.nextStepsHistory()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TargetCloseDate", TARGET_CLOSE_DATE_FIELD);
        map.put("ClosedLostReason", CLOSED_LOST_REASON_FIELD);
        map.put("Stage", STAGE_FIELD);
        map.put("NextSteps", NEXT_STEPS_FIELD);
        map.put("NextStepsHistory", NEXT_STEPS_HISTORY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsOpportunityLifeCycle, T> g) {
        return obj -> g.apply((AwsOpportunityLifeCycle)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String targetCloseDate;
        private String closedLostReason;
        private String stage;
        private String nextSteps;
        private List<ProfileNextStepsHistory> nextStepsHistory = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AwsOpportunityLifeCycle model) {
            this.targetCloseDate(model.targetCloseDate);
            this.closedLostReason(model.closedLostReason);
            this.stage(model.stage);
            this.nextSteps(model.nextSteps);
            this.nextStepsHistory(model.nextStepsHistory);
        }

        public final String getTargetCloseDate() {
            return this.targetCloseDate;
        }

        public final void setTargetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
        }

        @Override
        public final Builder targetCloseDate(String targetCloseDate) {
            this.targetCloseDate = targetCloseDate;
            return this;
        }

        public final String getClosedLostReason() {
            return this.closedLostReason;
        }

        public final void setClosedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
        }

        @Override
        public final Builder closedLostReason(String closedLostReason) {
            this.closedLostReason = closedLostReason;
            return this;
        }

        @Override
        public final Builder closedLostReason(AwsClosedLostReason closedLostReason) {
            this.closedLostReason(closedLostReason == null ? null : closedLostReason.toString());
            return this;
        }

        public final String getStage() {
            return this.stage;
        }

        public final void setStage(String stage) {
            this.stage = stage;
        }

        @Override
        public final Builder stage(String stage) {
            this.stage = stage;
            return this;
        }

        @Override
        public final Builder stage(AwsOpportunityStage stage) {
            this.stage(stage == null ? null : stage.toString());
            return this;
        }

        public final String getNextSteps() {
            return this.nextSteps;
        }

        public final void setNextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
        }

        @Override
        public final Builder nextSteps(String nextSteps) {
            this.nextSteps = nextSteps;
            return this;
        }

        public final List<ProfileNextStepsHistory.Builder> getNextStepsHistory() {
            List<ProfileNextStepsHistory.Builder> result = AwsOpportunityLifeCycleNextStepsHistoryListCopier.copyToBuilder(this.nextStepsHistory);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNextStepsHistory(Collection<ProfileNextStepsHistory.BuilderImpl> nextStepsHistory) {
            this.nextStepsHistory = AwsOpportunityLifeCycleNextStepsHistoryListCopier.copyFromBuilder(nextStepsHistory);
        }

        @Override
        public final Builder nextStepsHistory(Collection<ProfileNextStepsHistory> nextStepsHistory) {
            this.nextStepsHistory = AwsOpportunityLifeCycleNextStepsHistoryListCopier.copy(nextStepsHistory);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(ProfileNextStepsHistory ... nextStepsHistory) {
            this.nextStepsHistory(Arrays.asList(nextStepsHistory));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nextStepsHistory(Consumer<ProfileNextStepsHistory.Builder> ... nextStepsHistory) {
            this.nextStepsHistory(Stream.of(nextStepsHistory).map(c -> (ProfileNextStepsHistory)((ProfileNextStepsHistory.Builder)ProfileNextStepsHistory.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public AwsOpportunityLifeCycle build() {
            return new AwsOpportunityLifeCycle(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsOpportunityLifeCycle> {
        public Builder targetCloseDate(String var1);

        public Builder closedLostReason(String var1);

        public Builder closedLostReason(AwsClosedLostReason var1);

        public Builder stage(String var1);

        public Builder stage(AwsOpportunityStage var1);

        public Builder nextSteps(String var1);

        public Builder nextStepsHistory(Collection<ProfileNextStepsHistory> var1);

        public Builder nextStepsHistory(ProfileNextStepsHistory ... var1);

        public Builder nextStepsHistory(Consumer<ProfileNextStepsHistory.Builder> ... var1);
    }
}

